// third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* InspectorIssueCodeToStringHelper(InspectorIssueCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InspectorIssueCode::kCookieIssue:
      return "kCookieIssue";
    case InspectorIssueCode::kMixedContentIssue:
      return "kMixedContentIssue";
    case InspectorIssueCode::kBlockedByResponseIssue:
      return "kBlockedByResponseIssue";
    case InspectorIssueCode::kContentSecurityPolicyIssue:
      return "kContentSecurityPolicyIssue";
    case InspectorIssueCode::kSharedArrayBufferIssue:
      return "kSharedArrayBufferIssue";
    case InspectorIssueCode::kHeavyAdIssue:
      return "kHeavyAdIssue";
    case InspectorIssueCode::kAttributionReportingIssue:
      return "kAttributionReportingIssue";
    case InspectorIssueCode::kLowTextContrastIssue:
      return "kLowTextContrastIssue";
    case InspectorIssueCode::kFederatedAuthRequestIssue:
      return "kFederatedAuthRequestIssue";
    case InspectorIssueCode::kBounceTrackingIssue:
      return "kBounceTrackingIssue";
    case InspectorIssueCode::kCookieDeprecationMetadataIssue:
      return "kCookieDeprecationMetadataIssue";
    case InspectorIssueCode::kGenericIssue:
      return "kGenericIssue";
    case InspectorIssueCode::kDeprecationIssue:
      return "kDeprecationIssue";
    case InspectorIssueCode::kFederatedAuthUserInfoRequestIssue:
      return "kFederatedAuthUserInfoRequestIssue";
    case InspectorIssueCode::kPartitioningBlobURLIssue:
      return "kPartitioningBlobURLIssue";
    case InspectorIssueCode::kUserReidentificationIssue:
      return "kUserReidentificationIssue";
    default:
      return nullptr;
  }
}

std::string InspectorIssueCodeToString(InspectorIssueCode value) {
  const char *str = InspectorIssueCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InspectorIssueCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InspectorIssueCode value) {
  return os << InspectorIssueCodeToString(value);
}

NOINLINE static const char* HeavyAdResolutionStatusToStringHelper(HeavyAdResolutionStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HeavyAdResolutionStatus::kHeavyAdBlocked:
      return "kHeavyAdBlocked";
    case HeavyAdResolutionStatus::kHeavyAdWarning:
      return "kHeavyAdWarning";
    default:
      return nullptr;
  }
}

std::string HeavyAdResolutionStatusToString(HeavyAdResolutionStatus value) {
  const char *str = HeavyAdResolutionStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HeavyAdResolutionStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HeavyAdResolutionStatus value) {
  return os << HeavyAdResolutionStatusToString(value);
}

NOINLINE static const char* HeavyAdReasonToStringHelper(HeavyAdReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HeavyAdReason::kNetworkTotalLimit:
      return "kNetworkTotalLimit";
    case HeavyAdReason::kCpuTotalLimit:
      return "kCpuTotalLimit";
    case HeavyAdReason::kCpuPeakLimit:
      return "kCpuPeakLimit";
    default:
      return nullptr;
  }
}

std::string HeavyAdReasonToString(HeavyAdReason value) {
  const char *str = HeavyAdReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HeavyAdReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HeavyAdReason value) {
  return os << HeavyAdReasonToString(value);
}

NOINLINE static const char* AttributionReportingIssueTypeToStringHelper(AttributionReportingIssueType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AttributionReportingIssueType::kPermissionPolicyDisabled:
      return "kPermissionPolicyDisabled";
    case AttributionReportingIssueType::kUntrustworthyReportingOrigin:
      return "kUntrustworthyReportingOrigin";
    case AttributionReportingIssueType::kInsecureContext:
      return "kInsecureContext";
    case AttributionReportingIssueType::kInvalidRegisterSourceHeader:
      return "kInvalidRegisterSourceHeader";
    case AttributionReportingIssueType::kInvalidRegisterTriggerHeader:
      return "kInvalidRegisterTriggerHeader";
    case AttributionReportingIssueType::kSourceAndTriggerHeaders:
      return "kSourceAndTriggerHeaders";
    case AttributionReportingIssueType::kSourceIgnored:
      return "kSourceIgnored";
    case AttributionReportingIssueType::kTriggerIgnored:
      return "kTriggerIgnored";
    case AttributionReportingIssueType::kOsSourceIgnored:
      return "kOsSourceIgnored";
    case AttributionReportingIssueType::kOsTriggerIgnored:
      return "kOsTriggerIgnored";
    case AttributionReportingIssueType::kInvalidRegisterOsSourceHeader:
      return "kInvalidRegisterOsSourceHeader";
    case AttributionReportingIssueType::kInvalidRegisterOsTriggerHeader:
      return "kInvalidRegisterOsTriggerHeader";
    case AttributionReportingIssueType::kWebAndOsHeaders:
      return "kWebAndOsHeaders";
    case AttributionReportingIssueType::kNoWebOrOsSupport:
      return "kNoWebOrOsSupport";
    case AttributionReportingIssueType::kNavigationRegistrationWithoutTransientUserActivation:
      return "kNavigationRegistrationWithoutTransientUserActivation";
    case AttributionReportingIssueType::kInvalidInfoHeader:
      return "kInvalidInfoHeader";
    case AttributionReportingIssueType::kNoRegisterSourceHeader:
      return "kNoRegisterSourceHeader";
    case AttributionReportingIssueType::kNoRegisterTriggerHeader:
      return "kNoRegisterTriggerHeader";
    case AttributionReportingIssueType::kNoRegisterOsSourceHeader:
      return "kNoRegisterOsSourceHeader";
    case AttributionReportingIssueType::kNoRegisterOsTriggerHeader:
      return "kNoRegisterOsTriggerHeader";
    case AttributionReportingIssueType::kNavigationRegistrationUniqueScopeAlreadySet:
      return "kNavigationRegistrationUniqueScopeAlreadySet";
    default:
      return nullptr;
  }
}

std::string AttributionReportingIssueTypeToString(AttributionReportingIssueType value) {
  const char *str = AttributionReportingIssueTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AttributionReportingIssueType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AttributionReportingIssueType value) {
  return os << AttributionReportingIssueTypeToString(value);
}

NOINLINE static const char* MixedContentResolutionStatusToStringHelper(MixedContentResolutionStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MixedContentResolutionStatus::kMixedContentBlocked:
      return "kMixedContentBlocked";
    case MixedContentResolutionStatus::kMixedContentAutomaticallyUpgraded:
      return "kMixedContentAutomaticallyUpgraded";
    case MixedContentResolutionStatus::kMixedContentWarning:
      return "kMixedContentWarning";
    default:
      return nullptr;
  }
}

std::string MixedContentResolutionStatusToString(MixedContentResolutionStatus value) {
  const char *str = MixedContentResolutionStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MixedContentResolutionStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MixedContentResolutionStatus value) {
  return os << MixedContentResolutionStatusToString(value);
}

NOINLINE static const char* ContentSecurityPolicyViolationTypeToStringHelper(ContentSecurityPolicyViolationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ContentSecurityPolicyViolationType::kInlineViolation:
      return "kInlineViolation";
    case ContentSecurityPolicyViolationType::kEvalViolation:
      return "kEvalViolation";
    case ContentSecurityPolicyViolationType::kURLViolation:
      return "kURLViolation";
    case ContentSecurityPolicyViolationType::kSRIViolation:
      return "kSRIViolation";
    case ContentSecurityPolicyViolationType::kTrustedTypesSinkViolation:
      return "kTrustedTypesSinkViolation";
    case ContentSecurityPolicyViolationType::kTrustedTypesPolicyViolation:
      return "kTrustedTypesPolicyViolation";
    case ContentSecurityPolicyViolationType::kWasmEvalViolation:
      return "kWasmEvalViolation";
    default:
      return nullptr;
  }
}

std::string ContentSecurityPolicyViolationTypeToString(ContentSecurityPolicyViolationType value) {
  const char *str = ContentSecurityPolicyViolationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ContentSecurityPolicyViolationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ContentSecurityPolicyViolationType value) {
  return os << ContentSecurityPolicyViolationTypeToString(value);
}

NOINLINE static const char* CookieOperationToStringHelper(CookieOperation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieOperation::kSetCookie:
      return "kSetCookie";
    case CookieOperation::kReadCookie:
      return "kReadCookie";
    default:
      return nullptr;
  }
}

std::string CookieOperationToString(CookieOperation value) {
  const char *str = CookieOperationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieOperation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieOperation value) {
  return os << CookieOperationToString(value);
}

NOINLINE static const char* CookieExclusionReasonToStringHelper(CookieExclusionReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieExclusionReason::kExcludeSameSiteUnspecifiedTreatedAsLax:
      return "kExcludeSameSiteUnspecifiedTreatedAsLax";
    case CookieExclusionReason::kExcludeSameSiteNoneInsecure:
      return "kExcludeSameSiteNoneInsecure";
    case CookieExclusionReason::kExcludeSameSiteLax:
      return "kExcludeSameSiteLax";
    case CookieExclusionReason::kExcludeSameSiteStrict:
      return "kExcludeSameSiteStrict";
    case CookieExclusionReason::kExcludeDomainNonASCII:
      return "kExcludeDomainNonASCII";
    case CookieExclusionReason::kExcludeThirdPartyPhaseout:
      return "kExcludeThirdPartyPhaseout";
    case CookieExclusionReason::kExcludePortMismatch:
      return "kExcludePortMismatch";
    case CookieExclusionReason::kExcludeSchemeMismatch:
      return "kExcludeSchemeMismatch";
    default:
      return nullptr;
  }
}

std::string CookieExclusionReasonToString(CookieExclusionReason value) {
  const char *str = CookieExclusionReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieExclusionReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieExclusionReason value) {
  return os << CookieExclusionReasonToString(value);
}

NOINLINE static const char* CookieWarningReasonToStringHelper(CookieWarningReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieWarningReason::kWarnSameSiteUnspecifiedCrossSiteContext:
      return "kWarnSameSiteUnspecifiedCrossSiteContext";
    case CookieWarningReason::kWarnSameSiteNoneInsecure:
      return "kWarnSameSiteNoneInsecure";
    case CookieWarningReason::kWarnSameSiteUnspecifiedLaxAllowUnsafe:
      return "kWarnSameSiteUnspecifiedLaxAllowUnsafe";
    case CookieWarningReason::kWarnSameSiteStrictLaxDowngradeStrict:
      return "kWarnSameSiteStrictLaxDowngradeStrict";
    case CookieWarningReason::kWarnSameSiteStrictCrossDowngradeStrict:
      return "kWarnSameSiteStrictCrossDowngradeStrict";
    case CookieWarningReason::kWarnSameSiteStrictCrossDowngradeLax:
      return "kWarnSameSiteStrictCrossDowngradeLax";
    case CookieWarningReason::kWarnSameSiteLaxCrossDowngradeStrict:
      return "kWarnSameSiteLaxCrossDowngradeStrict";
    case CookieWarningReason::kWarnSameSiteLaxCrossDowngradeLax:
      return "kWarnSameSiteLaxCrossDowngradeLax";
    case CookieWarningReason::kWarnAttributeValueExceedsMaxSize:
      return "kWarnAttributeValueExceedsMaxSize";
    case CookieWarningReason::kWarnDomainNonASCII:
      return "kWarnDomainNonASCII";
    case CookieWarningReason::kWarnThirdPartyPhaseout:
      return "kWarnThirdPartyPhaseout";
    case CookieWarningReason::kWarnCrossSiteRedirectDowngradeChangesInclusion:
      return "kWarnCrossSiteRedirectDowngradeChangesInclusion";
    default:
      return nullptr;
  }
}

std::string CookieWarningReasonToString(CookieWarningReason value) {
  const char *str = CookieWarningReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieWarningReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieWarningReason value) {
  return os << CookieWarningReasonToString(value);
}

NOINLINE static const char* SharedArrayBufferIssueTypeToStringHelper(SharedArrayBufferIssueType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SharedArrayBufferIssueType::kTransferIssue:
      return "kTransferIssue";
    case SharedArrayBufferIssueType::kCreationIssue:
      return "kCreationIssue";
    default:
      return nullptr;
  }
}

std::string SharedArrayBufferIssueTypeToString(SharedArrayBufferIssueType value) {
  const char *str = SharedArrayBufferIssueTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SharedArrayBufferIssueType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SharedArrayBufferIssueType value) {
  return os << SharedArrayBufferIssueTypeToString(value);
}

NOINLINE static const char* FederatedAuthRequestResultToStringHelper(FederatedAuthRequestResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FederatedAuthRequestResult::kSuccess:
      return "kSuccess";
    case FederatedAuthRequestResult::kShouldEmbargo:
      return "kShouldEmbargo";
    case FederatedAuthRequestResult::kIdpNotPotentiallyTrustworthy:
      return "kIdpNotPotentiallyTrustworthy";
    case FederatedAuthRequestResult::kDisabledInSettings:
      return "kDisabledInSettings";
    case FederatedAuthRequestResult::kDisabledInFlags:
      return "kDisabledInFlags";
    case FederatedAuthRequestResult::kTooManyRequests:
      return "kTooManyRequests";
    case FederatedAuthRequestResult::kWellKnownHttpNotFound:
      return "kWellKnownHttpNotFound";
    case FederatedAuthRequestResult::kWellKnownNoResponse:
      return "kWellKnownNoResponse";
    case FederatedAuthRequestResult::kWellKnownInvalidResponse:
      return "kWellKnownInvalidResponse";
    case FederatedAuthRequestResult::kWellKnownListEmpty:
      return "kWellKnownListEmpty";
    case FederatedAuthRequestResult::kWellKnownInvalidContentType:
      return "kWellKnownInvalidContentType";
    case FederatedAuthRequestResult::kConfigNotInWellKnown:
      return "kConfigNotInWellKnown";
    case FederatedAuthRequestResult::kWellKnownTooBig:
      return "kWellKnownTooBig";
    case FederatedAuthRequestResult::kConfigHttpNotFound:
      return "kConfigHttpNotFound";
    case FederatedAuthRequestResult::kConfigNoResponse:
      return "kConfigNoResponse";
    case FederatedAuthRequestResult::kConfigInvalidResponse:
      return "kConfigInvalidResponse";
    case FederatedAuthRequestResult::kConfigInvalidContentType:
      return "kConfigInvalidContentType";
    case FederatedAuthRequestResult::kClientMetadataHttpNotFound:
      return "kClientMetadataHttpNotFound";
    case FederatedAuthRequestResult::kClientMetadataNoResponse:
      return "kClientMetadataNoResponse";
    case FederatedAuthRequestResult::kClientMetadataInvalidResponse:
      return "kClientMetadataInvalidResponse";
    case FederatedAuthRequestResult::kClientMetadataInvalidContentType:
      return "kClientMetadataInvalidContentType";
    case FederatedAuthRequestResult::kAccountsHttpNotFound:
      return "kAccountsHttpNotFound";
    case FederatedAuthRequestResult::kAccountsNoResponse:
      return "kAccountsNoResponse";
    case FederatedAuthRequestResult::kAccountsInvalidResponse:
      return "kAccountsInvalidResponse";
    case FederatedAuthRequestResult::kAccountsListEmpty:
      return "kAccountsListEmpty";
    case FederatedAuthRequestResult::kAccountsInvalidContentType:
      return "kAccountsInvalidContentType";
    case FederatedAuthRequestResult::kIdTokenHttpNotFound:
      return "kIdTokenHttpNotFound";
    case FederatedAuthRequestResult::kIdTokenNoResponse:
      return "kIdTokenNoResponse";
    case FederatedAuthRequestResult::kIdTokenInvalidResponse:
      return "kIdTokenInvalidResponse";
    case FederatedAuthRequestResult::kIdTokenIdpErrorResponse:
      return "kIdTokenIdpErrorResponse";
    case FederatedAuthRequestResult::kIdTokenCrossSiteIdpErrorResponse:
      return "kIdTokenCrossSiteIdpErrorResponse";
    case FederatedAuthRequestResult::kIdTokenInvalidContentType:
      return "kIdTokenInvalidContentType";
    case FederatedAuthRequestResult::kCanceled:
      return "kCanceled";
    case FederatedAuthRequestResult::kRpPageNotVisible:
      return "kRpPageNotVisible";
    case FederatedAuthRequestResult::kSilentMediationFailure:
      return "kSilentMediationFailure";
    case FederatedAuthRequestResult::kThirdPartyCookiesBlocked:
      return "kThirdPartyCookiesBlocked";
    case FederatedAuthRequestResult::kNotSignedInWithIdp:
      return "kNotSignedInWithIdp";
    case FederatedAuthRequestResult::kMissingTransientUserActivation:
      return "kMissingTransientUserActivation";
    case FederatedAuthRequestResult::kReplacedByActiveMode:
      return "kReplacedByActiveMode";
    case FederatedAuthRequestResult::kInvalidFieldsSpecified:
      return "kInvalidFieldsSpecified";
    case FederatedAuthRequestResult::kRelyingPartyOriginIsOpaque:
      return "kRelyingPartyOriginIsOpaque";
    case FederatedAuthRequestResult::kTypeNotMatching:
      return "kTypeNotMatching";
    case FederatedAuthRequestResult::kError:
      return "kError";
    case FederatedAuthRequestResult::kUiDismissedNoEmbargo:
      return "kUiDismissedNoEmbargo";
    case FederatedAuthRequestResult::kCorsError:
      return "kCorsError";
    case FederatedAuthRequestResult::kSuppressedBySegmentationPlatform:
      return "kSuppressedBySegmentationPlatform";
    default:
      return nullptr;
  }
}

std::string FederatedAuthRequestResultToString(FederatedAuthRequestResult value) {
  const char *str = FederatedAuthRequestResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FederatedAuthRequestResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FederatedAuthRequestResult value) {
  return os << FederatedAuthRequestResultToString(value);
}

NOINLINE static const char* FederatedAuthUserInfoRequestResultToStringHelper(FederatedAuthUserInfoRequestResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FederatedAuthUserInfoRequestResult::kSuccess:
      return "kSuccess";
    case FederatedAuthUserInfoRequestResult::kNotSameOrigin:
      return "kNotSameOrigin";
    case FederatedAuthUserInfoRequestResult::kNotIframe:
      return "kNotIframe";
    case FederatedAuthUserInfoRequestResult::kNotPotentiallyTrustworthy:
      return "kNotPotentiallyTrustworthy";
    case FederatedAuthUserInfoRequestResult::kNoApiPermission:
      return "kNoApiPermission";
    case FederatedAuthUserInfoRequestResult::kNotSignedInWithIdp:
      return "kNotSignedInWithIdp";
    case FederatedAuthUserInfoRequestResult::kNoAccountSharingPermission:
      return "kNoAccountSharingPermission";
    case FederatedAuthUserInfoRequestResult::kInvalidConfigOrWellKnown:
      return "kInvalidConfigOrWellKnown";
    case FederatedAuthUserInfoRequestResult::kInvalidAccountsResponse:
      return "kInvalidAccountsResponse";
    case FederatedAuthUserInfoRequestResult::kNoReturningUserFromFetchedAccounts:
      return "kNoReturningUserFromFetchedAccounts";
    case FederatedAuthUserInfoRequestResult::kUnhandledRequest:
      return "kUnhandledRequest";
    default:
      return nullptr;
  }
}

std::string FederatedAuthUserInfoRequestResultToString(FederatedAuthUserInfoRequestResult value) {
  const char *str = FederatedAuthUserInfoRequestResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FederatedAuthUserInfoRequestResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FederatedAuthUserInfoRequestResult value) {
  return os << FederatedAuthUserInfoRequestResultToString(value);
}

NOINLINE static const char* PartitioningBlobURLInfoToStringHelper(PartitioningBlobURLInfo value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PartitioningBlobURLInfo::kBlockedCrossPartitionFetching:
      return "kBlockedCrossPartitionFetching";
    case PartitioningBlobURLInfo::kEnforceNoopenerForNavigation:
      return "kEnforceNoopenerForNavigation";
    default:
      return nullptr;
  }
}

std::string PartitioningBlobURLInfoToString(PartitioningBlobURLInfo value) {
  const char *str = PartitioningBlobURLInfoToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PartitioningBlobURLInfo value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PartitioningBlobURLInfo value) {
  return os << PartitioningBlobURLInfoToString(value);
}

NOINLINE static const char* GenericIssueErrorTypeToStringHelper(GenericIssueErrorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GenericIssueErrorType::kFormLabelForNameError:
      return "kFormLabelForNameError";
    case GenericIssueErrorType::kFormDuplicateIdForInputError:
      return "kFormDuplicateIdForInputError";
    case GenericIssueErrorType::kFormInputWithNoLabelError:
      return "kFormInputWithNoLabelError";
    case GenericIssueErrorType::kFormAutocompleteAttributeEmptyError:
      return "kFormAutocompleteAttributeEmptyError";
    case GenericIssueErrorType::kFormEmptyIdAndNameAttributesForInputError:
      return "kFormEmptyIdAndNameAttributesForInputError";
    case GenericIssueErrorType::kFormAriaLabelledByToNonExistingId:
      return "kFormAriaLabelledByToNonExistingId";
    case GenericIssueErrorType::kFormInputAssignedAutocompleteValueToIdOrNameAttributeError:
      return "kFormInputAssignedAutocompleteValueToIdOrNameAttributeError";
    case GenericIssueErrorType::kFormLabelHasNeitherForNorNestedInput:
      return "kFormLabelHasNeitherForNorNestedInput";
    case GenericIssueErrorType::kFormLabelForMatchesNonExistingIdError:
      return "kFormLabelForMatchesNonExistingIdError";
    case GenericIssueErrorType::kFormInputHasWrongButWellIntendedAutocompleteValueError:
      return "kFormInputHasWrongButWellIntendedAutocompleteValueError";
    case GenericIssueErrorType::kResponseWasBlockedByORB:
      return "kResponseWasBlockedByORB";
    default:
      return nullptr;
  }
}

std::string GenericIssueErrorTypeToString(GenericIssueErrorType value) {
  const char *str = GenericIssueErrorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GenericIssueErrorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GenericIssueErrorType value) {
  return os << GenericIssueErrorTypeToString(value);
}

NOINLINE static const char* DeprecationIssueTypeToStringHelper(DeprecationIssueType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeprecationIssueType::kPrivacySandboxExtensionsAPI:
      return "kPrivacySandboxExtensionsAPI";
    default:
      return nullptr;
  }
}

std::string DeprecationIssueTypeToString(DeprecationIssueType value) {
  const char *str = DeprecationIssueTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeprecationIssueType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeprecationIssueType value) {
  return os << DeprecationIssueTypeToString(value);
}

NOINLINE static const char* UserReidentificationIssueTypeToStringHelper(UserReidentificationIssueType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserReidentificationIssueType::kBlockedFrameNavigation:
      return "kBlockedFrameNavigation";
    case UserReidentificationIssueType::kBlockedSubresource:
      return "kBlockedSubresource";
    case UserReidentificationIssueType::kNoisedCanvasReadback:
      return "kNoisedCanvasReadback";
    default:
      return nullptr;
  }
}

std::string UserReidentificationIssueTypeToString(UserReidentificationIssueType value) {
  const char *str = UserReidentificationIssueTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserReidentificationIssueType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserReidentificationIssueType value) {
  return os << UserReidentificationIssueTypeToString(value);
}

namespace internal {


// static
bool AffectedCookie_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AffectedCookie_Data* object =
      static_cast<const AffectedCookie_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->path, validation_context,
                                         &path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& domain_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->domain, validation_context,
                                         &domain_validate_params)) {
    return false;
  }

  return true;
}

AffectedCookie_Data::AffectedCookie_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AffectedRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AffectedRequest_Data* object =
      static_cast<const AffectedRequest_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->request_id, validation_context,
                                         &request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  return true;
}

AffectedRequest_Data::AffectedRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AffectedFrame_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AffectedFrame_Data* object =
      static_cast<const AffectedFrame_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& frame_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->frame_id, validation_context,
                                         &frame_id_validate_params)) {
    return false;
  }

  return true;
}

AffectedFrame_Data::AffectedFrame_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AffectedLocation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AffectedLocation_Data* object =
      static_cast<const AffectedLocation_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& script_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->script_id, validation_context,
                                         &script_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  return true;
}

AffectedLocation_Data::AffectedLocation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlockedByResponseIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlockedByResponseIssueDetails_Data* object =
      static_cast<const BlockedByResponseIssueDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parentFrame, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blockedFrame, validation_context))
    return false;


  if (!::network::mojom::internal::BlockedByResponseReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

BlockedByResponseIssueDetails_Data::BlockedByResponseIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HeavyAdIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HeavyAdIssueDetails_Data* object =
      static_cast<const HeavyAdIssueDetails_Data*>(data);


  if (!::blink::mojom::internal::HeavyAdResolutionStatus_Data
        ::Validate(object->resolution, validation_context))
    return false;


  if (!::blink::mojom::internal::HeavyAdReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  return true;
}

HeavyAdIssueDetails_Data::HeavyAdIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AttributionReportingIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AttributionReportingIssueDetails_Data* object =
      static_cast<const AttributionReportingIssueDetails_Data*>(data);


  if (!::blink::mojom::internal::AttributionReportingIssueType_Data
        ::Validate(object->violation_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& invalid_parameter_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->invalid_parameter, validation_context,
                                         &invalid_parameter_validate_params)) {
    return false;
  }

  return true;
}

AttributionReportingIssueDetails_Data::AttributionReportingIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MixedContentIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MixedContentIssueDetails_Data* object =
      static_cast<const MixedContentIssueDetails_Data*>(data);


  if (!::blink::mojom::internal::RequestContextType_Data
        ::Validate(object->request_context, validation_context))
    return false;


  if (!::blink::mojom::internal::MixedContentResolutionStatus_Data
        ::Validate(object->resolution_status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->insecure_url, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& insecure_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->insecure_url, validation_context,
                                         &insecure_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_resource_url, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& main_resource_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->main_resource_url, validation_context,
                                         &main_resource_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  return true;
}

MixedContentIssueDetails_Data::MixedContentIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentSecurityPolicyIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentSecurityPolicyIssueDetails_Data* object =
      static_cast<const ContentSecurityPolicyIssueDetails_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->blocked_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->violated_directive, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& violated_directive_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->violated_directive, validation_context,
                                         &violated_directive_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::ContentSecurityPolicyViolationType_Data
        ::Validate(object->content_security_policy_violation_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frame_ancestor, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->affected_location, validation_context))
    return false;

  return true;
}

ContentSecurityPolicyIssueDetails_Data::ContentSecurityPolicyIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CookieIssueDetails_Data* object =
      static_cast<const CookieIssueDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->exclusion_reason, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& exclusion_reason_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::CookieExclusionReason_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->exclusion_reason, validation_context,
                                         &exclusion_reason_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->warning_reason, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& warning_reason_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::CookieWarningReason_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->warning_reason, validation_context,
                                         &warning_reason_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::CookieOperation_Data
        ::Validate(object->operation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cookie_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

CookieIssueDetails_Data::CookieIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedArrayBufferIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedArrayBufferIssueDetails_Data* object =
      static_cast<const SharedArrayBufferIssueDetails_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->affected_location, validation_context))
    return false;


  if (!::blink::mojom::internal::SharedArrayBufferIssueType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

SharedArrayBufferIssueDetails_Data::SharedArrayBufferIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LowTextContrastIssue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LowTextContrastIssue_Data* object =
      static_cast<const LowTextContrastIssue_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->violating_node_selector, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& violating_node_selector_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->violating_node_selector, validation_context,
                                         &violating_node_selector_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->font_size, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& font_size_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->font_size, validation_context,
                                         &font_size_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->font_weight, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& font_weight_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->font_weight, validation_context,
                                         &font_weight_validate_params)) {
    return false;
  }

  return true;
}

LowTextContrastIssue_Data::LowTextContrastIssue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthRequestIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthRequestIssueDetails_Data* object =
      static_cast<const FederatedAuthRequestIssueDetails_Data*>(data);


  if (!::blink::mojom::internal::FederatedAuthRequestResult_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FederatedAuthRequestIssueDetails_Data::FederatedAuthRequestIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FederatedAuthUserInfoRequestIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FederatedAuthUserInfoRequestIssueDetails_Data* object =
      static_cast<const FederatedAuthUserInfoRequestIssueDetails_Data*>(data);


  if (!::blink::mojom::internal::FederatedAuthUserInfoRequestResult_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

FederatedAuthUserInfoRequestIssueDetails_Data::FederatedAuthUserInfoRequestIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BounceTrackingIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BounceTrackingIssueDetails_Data* object =
      static_cast<const BounceTrackingIssueDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tracking_sites, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tracking_sites_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->tracking_sites, validation_context,
                                         &tracking_sites_validate_params)) {
    return false;
  }

  return true;
}

BounceTrackingIssueDetails_Data::BounceTrackingIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PartitioningBlobURLIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PartitioningBlobURLIssueDetails_Data* object =
      static_cast<const PartitioningBlobURLIssueDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::blink::mojom::internal::PartitioningBlobURLInfo_Data
        ::Validate(object->partitioning_blob_url_info, validation_context))
    return false;

  return true;
}

PartitioningBlobURLIssueDetails_Data::PartitioningBlobURLIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieDeprecationMetadataIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CookieDeprecationMetadataIssueDetails_Data* object =
      static_cast<const CookieDeprecationMetadataIssueDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allowed_sites, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& allowed_sites_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->allowed_sites, validation_context,
                                         &allowed_sites_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::CookieOperation_Data
        ::Validate(object->operation, validation_context))
    return false;

  return true;
}

CookieDeprecationMetadataIssueDetails_Data::CookieDeprecationMetadataIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GenericIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GenericIssueDetails_Data* object =
      static_cast<const GenericIssueDetails_Data*>(data);


  if (!::blink::mojom::internal::GenericIssueErrorType_Data
        ::Validate(object->error_type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& frame_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->frame_id, validation_context,
                                         &frame_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& violating_node_attribute_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->violating_node_attribute, validation_context,
                                         &violating_node_attribute_validate_params)) {
    return false;
  }

  return true;
}

GenericIssueDetails_Data::GenericIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeprecationIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeprecationIssueDetails_Data* object =
      static_cast<const DeprecationIssueDetails_Data*>(data);


  if (!::blink::mojom::internal::DeprecationIssueType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->affected_location, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->affected_location, validation_context))
    return false;

  return true;
}

DeprecationIssueDetails_Data::DeprecationIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserReidentificationIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserReidentificationIssueDetails_Data* object =
      static_cast<const UserReidentificationIssueDetails_Data*>(data);


  if (!::blink::mojom::internal::UserReidentificationIssueType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->sourceCodeLocation, validation_context))
    return false;

  return true;
}

UserReidentificationIssueDetails_Data::UserReidentificationIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InspectorIssueDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 144, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InspectorIssueDetails_Data* object =
      static_cast<const InspectorIssueDetails_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->cookie_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mixed_content_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blocked_by_response_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->csp_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->sab_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->heavy_ad_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->attribution_reporting_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->low_text_contrast_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->federated_auth_request_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bounce_tracking_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->partitioning_blob_url_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cookie_deprecation_metadata_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->generic_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->deprecation_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->federated_auth_user_info_request_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->user_reidentification_issue_details, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->issue_id, validation_context))
    return false;

  return true;
}

InspectorIssueDetails_Data::InspectorIssueDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InspectorIssueInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InspectorIssueInfo_Data* object =
      static_cast<const InspectorIssueInfo_Data*>(data);


  if (!::blink::mojom::internal::InspectorIssueCode_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  return true;
}

InspectorIssueInfo_Data::InspectorIssueInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::InspectorIssueCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::InspectorIssueCode value) {
  return std::move(context).WriteString(::blink::mojom::InspectorIssueCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::HeavyAdResolutionStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::HeavyAdResolutionStatus value) {
  return std::move(context).WriteString(::blink::mojom::HeavyAdResolutionStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::HeavyAdReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::HeavyAdReason value) {
  return std::move(context).WriteString(::blink::mojom::HeavyAdReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AttributionReportingIssueType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AttributionReportingIssueType value) {
  return std::move(context).WriteString(::blink::mojom::AttributionReportingIssueTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::MixedContentResolutionStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::MixedContentResolutionStatus value) {
  return std::move(context).WriteString(::blink::mojom::MixedContentResolutionStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ContentSecurityPolicyViolationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ContentSecurityPolicyViolationType value) {
  return std::move(context).WriteString(::blink::mojom::ContentSecurityPolicyViolationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CookieOperation>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CookieOperation value) {
  return std::move(context).WriteString(::blink::mojom::CookieOperationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CookieExclusionReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CookieExclusionReason value) {
  return std::move(context).WriteString(::blink::mojom::CookieExclusionReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::CookieWarningReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::CookieWarningReason value) {
  return std::move(context).WriteString(::blink::mojom::CookieWarningReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SharedArrayBufferIssueType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SharedArrayBufferIssueType value) {
  return std::move(context).WriteString(::blink::mojom::SharedArrayBufferIssueTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FederatedAuthRequestResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FederatedAuthRequestResult value) {
  return std::move(context).WriteString(::blink::mojom::FederatedAuthRequestResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FederatedAuthUserInfoRequestResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FederatedAuthUserInfoRequestResult value) {
  return std::move(context).WriteString(::blink::mojom::FederatedAuthUserInfoRequestResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::PartitioningBlobURLInfo>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::PartitioningBlobURLInfo value) {
  return std::move(context).WriteString(::blink::mojom::PartitioningBlobURLInfoToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::GenericIssueErrorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::GenericIssueErrorType value) {
  return std::move(context).WriteString(::blink::mojom::GenericIssueErrorTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DeprecationIssueType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::DeprecationIssueType value) {
  return std::move(context).WriteString(::blink::mojom::DeprecationIssueTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::UserReidentificationIssueType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::UserReidentificationIssueType value) {
  return std::move(context).WriteString(::blink::mojom::UserReidentificationIssueTypeToString(value));
}

} // namespace perfetto