// third_party/blink/public/mojom/devtools/devtools_frontend.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  DictionaryValue as mojoBase_mojom_DictionaryValue,
  DictionaryValueSpec as mojoBase_mojom_DictionaryValueSpec
} from '../../../../../mojo/public/mojom/base/values.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DevToolsFrontendPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DevToolsFrontend', scope);
  }
}

/** @interface */
export class DevToolsFrontendInterface {
  
  /**
   * @param { !string } apiScript
   * @param { !Object } host
   */

  setupDevToolsFrontend(apiScript, host) {}
  
  /**
   * @param { !string } extensionApi
   */

  setupDevToolsExtensionAPI(extensionApi) {}
}

/**
 * @implements { DevToolsFrontendInterface }
 */
export class DevToolsFrontendRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DevToolsFrontendPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DevToolsFrontendPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DevToolsFrontendPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } apiScript
   * @param { !Object } host
   */

  setupDevToolsFrontend(
      apiScript,
      host) {
    this.proxy.sendMessage(
        0,
        DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec.$,
        null,
        [
          apiScript,
          host
        ],
        false);
  }

  
  /**
   * @param { !string } extensionApi
   */

  setupDevToolsExtensionAPI(
      extensionApi) {
    this.proxy.sendMessage(
        1,
        DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec.$,
        null,
        [
          extensionApi
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DevToolsFrontend
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevToolsFrontendReceiver {
  /**
   * @param {!DevToolsFrontendInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DevToolsFrontendRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DevToolsFrontendRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsFrontendRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec.$,
        null,
        impl.setupDevToolsFrontend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec.$,
        null,
        impl.setupDevToolsExtensionAPI.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DevToolsFrontend {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsFrontend";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DevToolsFrontendRemote}
   */
  static getRemote() {
    let remote = new DevToolsFrontendRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DevToolsFrontend
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevToolsFrontendCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DevToolsFrontendRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsFrontendRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setupDevToolsFrontend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec.$,
        null,
        this.setupDevToolsFrontend.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setupDevToolsExtensionAPI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec.$,
        null,
        this.setupDevToolsExtensionAPI.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DevToolsFrontendHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DevToolsFrontendHost', scope);
  }
}

/** @interface */
export class DevToolsFrontendHostInterface {
  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } message
   */

  dispatchEmbedderMessage(message) {}
}

/**
 * @implements { DevToolsFrontendHostInterface }
 */
export class DevToolsFrontendHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DevToolsFrontendHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DevToolsFrontendHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DevToolsFrontendHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } message
   */

  dispatchEmbedderMessage(
      message) {
    this.proxy.sendMessage(
        0,
        DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DevToolsFrontendHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevToolsFrontendHostReceiver {
  /**
   * @param {!DevToolsFrontendHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DevToolsFrontendHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DevToolsFrontendHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsFrontendHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec.$,
        null,
        impl.dispatchEmbedderMessage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DevToolsFrontendHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsFrontendHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DevToolsFrontendHostRemote}
   */
  static getRemote() {
    let remote = new DevToolsFrontendHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DevToolsFrontendHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevToolsFrontendHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DevToolsFrontendHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevToolsFrontendHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchEmbedderMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec.$,
        null,
        this.dispatchEmbedderMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec.$,
    'DevToolsFrontend_SetupDevToolsFrontend_Params',
    [
      mojo.internal.StructField(
        'apiScript', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'host', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(DevToolsFrontendHostRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DevToolsFrontend_SetupDevToolsFrontend_Params {
  constructor() {
    /** @type { !string } */
    this.apiScript;
    /** @type { !Object } */
    this.host;
  }
}



mojo.internal.Struct(
    DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec.$,
    'DevToolsFrontend_SetupDevToolsExtensionAPI_Params',
    [
      mojo.internal.StructField(
        'extensionApi', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DevToolsFrontend_SetupDevToolsExtensionAPI_Params {
  constructor() {
    /** @type { !string } */
    this.extensionApi;
  }
}



mojo.internal.Struct(
    DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec.$,
    'DevToolsFrontendHost_DispatchEmbedderMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DevToolsFrontendHost_DispatchEmbedderMessage_Params {
  constructor() {
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.message;
  }
}

