// third_party/blink/public/mojom/device_posture/device_posture_provider.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DevicePostureTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DevicePostureType = {
  
  kContinuous: 0,
  kFolded: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DevicePostureProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DevicePostureProvider', scope);
  }
}

/** @interface */
export class DevicePostureProviderInterface {
  
  /**
   * @param { !DevicePostureClientRemote } client
   * @return {!Promise<{
        posture: !DevicePostureType,
   *  }>}
   */

  addListenerAndGetCurrentPosture(client) {}
  
  /**
   * @param { !DevicePostureType } posture
   */

  overrideDevicePostureForEmulation(posture) {}
  
  /**
   */

  disableDevicePostureOverrideForEmulation() {}
}

/**
 * @implements { DevicePostureProviderInterface }
 */
export class DevicePostureProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DevicePostureProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DevicePostureProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DevicePostureProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DevicePostureClientRemote } client
   * @return {!Promise<{
        posture: !DevicePostureType,
   *  }>}
   */

  addListenerAndGetCurrentPosture(
      client) {
    return this.proxy.sendMessage(
        0,
        DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsSpec.$,
        DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsSpec.$,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !DevicePostureType } posture
   */

  overrideDevicePostureForEmulation(
      posture) {
    this.proxy.sendMessage(
        1,
        DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsSpec.$,
        null,
        [
          posture
        ],
        false);
  }

  
  /**
   */

  disableDevicePostureOverrideForEmulation() {
    this.proxy.sendMessage(
        2,
        DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DevicePostureProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevicePostureProviderReceiver {
  /**
   * @param {!DevicePostureProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DevicePostureProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DevicePostureProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevicePostureProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsSpec.$,
        DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsSpec.$,
        impl.addListenerAndGetCurrentPosture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsSpec.$,
        null,
        impl.overrideDevicePostureForEmulation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsSpec.$,
        null,
        impl.disableDevicePostureOverrideForEmulation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DevicePostureProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevicePostureProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DevicePostureProviderRemote}
   */
  static getRemote() {
    let remote = new DevicePostureProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DevicePostureProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevicePostureProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DevicePostureProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevicePostureProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addListenerAndGetCurrentPosture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsSpec.$,
        DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsSpec.$,
        this.addListenerAndGetCurrentPosture.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.overrideDevicePostureForEmulation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsSpec.$,
        null,
        this.overrideDevicePostureForEmulation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableDevicePostureOverrideForEmulation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsSpec.$,
        null,
        this.disableDevicePostureOverrideForEmulation.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DevicePostureClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DevicePostureClient', scope);
  }
}

/** @interface */
export class DevicePostureClientInterface {
  
  /**
   * @param { !DevicePostureType } posture
   */

  onPostureChanged(posture) {}
}

/**
 * @implements { DevicePostureClientInterface }
 */
export class DevicePostureClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DevicePostureClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DevicePostureClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DevicePostureClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DevicePostureType } posture
   */

  onPostureChanged(
      posture) {
    this.proxy.sendMessage(
        0,
        DevicePostureClient_OnPostureChanged_ParamsSpec.$,
        null,
        [
          posture
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DevicePostureClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DevicePostureClientReceiver {
  /**
   * @param {!DevicePostureClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DevicePostureClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DevicePostureClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevicePostureClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DevicePostureClient_OnPostureChanged_ParamsSpec.$,
        null,
        impl.onPostureChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DevicePostureClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevicePostureClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DevicePostureClientRemote}
   */
  static getRemote() {
    let remote = new DevicePostureClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DevicePostureClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DevicePostureClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DevicePostureClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DevicePostureClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPostureChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DevicePostureClient_OnPostureChanged_ParamsSpec.$,
        null,
        this.onPostureChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DevicePostureClient_OnPostureChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsSpec.$,
    'DevicePostureProvider_AddListenerAndGetCurrentPosture_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(DevicePostureClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DevicePostureProvider_AddListenerAndGetCurrentPosture_Params {
  constructor() {
    /** @type { !DevicePostureClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsSpec.$,
    'DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams',
    [
      mojo.internal.StructField(
        'posture', 0,
        0,
        DevicePostureTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams {
  constructor() {
    /** @type { !DevicePostureType } */
    this.posture;
  }
}



mojo.internal.Struct(
    DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsSpec.$,
    'DevicePostureProvider_OverrideDevicePostureForEmulation_Params',
    [
      mojo.internal.StructField(
        'posture', 0,
        0,
        DevicePostureTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DevicePostureProvider_OverrideDevicePostureForEmulation_Params {
  constructor() {
    /** @type { !DevicePostureType } */
    this.posture;
  }
}



mojo.internal.Struct(
    DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsSpec.$,
    'DevicePostureProvider_DisableDevicePostureOverrideForEmulation_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DevicePostureProvider_DisableDevicePostureOverrideForEmulation_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DevicePostureClient_OnPostureChanged_ParamsSpec.$,
    'DevicePostureClient_OnPostureChanged_Params',
    [
      mojo.internal.StructField(
        'posture', 0,
        0,
        DevicePostureTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DevicePostureClient_OnPostureChanged_Params {
  constructor() {
    /** @type { !DevicePostureType } */
    this.posture;
  }
}

