// third_party/blink/public/mojom/device/device.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/device/device.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function ManagedConfigurationObserver_OnConfigurationChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManagedConfigurationObserver_OnConfigurationChanged_Params.prototype.initDefaults_ = function() {
  };
  ManagedConfigurationObserver_OnConfigurationChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManagedConfigurationObserver_OnConfigurationChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManagedConfigurationObserver_OnConfigurationChanged_Params.encodedSize = codec.kStructHeaderSize + 0;

  ManagedConfigurationObserver_OnConfigurationChanged_Params.decode = function(decoder) {
    var packed;
    var val = new ManagedConfigurationObserver_OnConfigurationChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ManagedConfigurationObserver_OnConfigurationChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManagedConfigurationObserver_OnConfigurationChanged_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function DeviceAPIService_GetDirectoryId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceAPIService_GetDirectoryId_Params.prototype.initDefaults_ = function() {
  };
  DeviceAPIService_GetDirectoryId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceAPIService_GetDirectoryId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceAPIService_GetDirectoryId_Params.encodedSize = codec.kStructHeaderSize + 0;

  DeviceAPIService_GetDirectoryId_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceAPIService_GetDirectoryId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DeviceAPIService_GetDirectoryId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceAPIService_GetDirectoryId_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function DeviceAPIService_GetDirectoryId_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceAPIService_GetDirectoryId_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  DeviceAPIService_GetDirectoryId_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceAPIService_GetDirectoryId_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceAPIService_GetDirectoryId_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, DeviceAttributeResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceAPIService_GetDirectoryId_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  DeviceAPIService_GetDirectoryId_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DeviceAPIService_GetDirectoryId_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(DeviceAttributeResult);
    return val;
  };

  DeviceAPIService_GetDirectoryId_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceAPIService_GetDirectoryId_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(DeviceAttributeResult, val.result);
  };
  function DeviceAPIService_GetHostname_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceAPIService_GetHostname_Params.prototype.initDefaults_ = function() {
  };
  DeviceAPIService_GetHostname_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceAPIService_GetHostname_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceAPIService_GetHostname_Params.encodedSize = codec.kStructHeaderSize + 0;

  DeviceAPIService_GetHostname_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceAPIService_GetHostname_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DeviceAPIService_GetHostname_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceAPIService_GetHostname_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function DeviceAPIService_GetHostname_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceAPIService_GetHostname_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  DeviceAPIService_GetHostname_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceAPIService_GetHostname_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceAPIService_GetHostname_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, DeviceAttributeResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceAPIService_GetHostname_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  DeviceAPIService_GetHostname_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DeviceAPIService_GetHostname_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(DeviceAttributeResult);
    return val;
  };

  DeviceAPIService_GetHostname_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceAPIService_GetHostname_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(DeviceAttributeResult, val.result);
  };
  function DeviceAPIService_GetSerialNumber_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceAPIService_GetSerialNumber_Params.prototype.initDefaults_ = function() {
  };
  DeviceAPIService_GetSerialNumber_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceAPIService_GetSerialNumber_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceAPIService_GetSerialNumber_Params.encodedSize = codec.kStructHeaderSize + 0;

  DeviceAPIService_GetSerialNumber_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceAPIService_GetSerialNumber_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DeviceAPIService_GetSerialNumber_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceAPIService_GetSerialNumber_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function DeviceAPIService_GetSerialNumber_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceAPIService_GetSerialNumber_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  DeviceAPIService_GetSerialNumber_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceAPIService_GetSerialNumber_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceAPIService_GetSerialNumber_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, DeviceAttributeResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceAPIService_GetSerialNumber_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  DeviceAPIService_GetSerialNumber_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DeviceAPIService_GetSerialNumber_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(DeviceAttributeResult);
    return val;
  };

  DeviceAPIService_GetSerialNumber_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceAPIService_GetSerialNumber_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(DeviceAttributeResult, val.result);
  };
  function DeviceAPIService_GetAnnotatedAssetId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceAPIService_GetAnnotatedAssetId_Params.prototype.initDefaults_ = function() {
  };
  DeviceAPIService_GetAnnotatedAssetId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceAPIService_GetAnnotatedAssetId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceAPIService_GetAnnotatedAssetId_Params.encodedSize = codec.kStructHeaderSize + 0;

  DeviceAPIService_GetAnnotatedAssetId_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceAPIService_GetAnnotatedAssetId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DeviceAPIService_GetAnnotatedAssetId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceAPIService_GetAnnotatedAssetId_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function DeviceAPIService_GetAnnotatedAssetId_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceAPIService_GetAnnotatedAssetId_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  DeviceAPIService_GetAnnotatedAssetId_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceAPIService_GetAnnotatedAssetId_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceAPIService_GetAnnotatedAssetId_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, DeviceAttributeResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceAPIService_GetAnnotatedAssetId_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  DeviceAPIService_GetAnnotatedAssetId_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DeviceAPIService_GetAnnotatedAssetId_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(DeviceAttributeResult);
    return val;
  };

  DeviceAPIService_GetAnnotatedAssetId_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceAPIService_GetAnnotatedAssetId_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(DeviceAttributeResult, val.result);
  };
  function DeviceAPIService_GetAnnotatedLocation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceAPIService_GetAnnotatedLocation_Params.prototype.initDefaults_ = function() {
  };
  DeviceAPIService_GetAnnotatedLocation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceAPIService_GetAnnotatedLocation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceAPIService_GetAnnotatedLocation_Params.encodedSize = codec.kStructHeaderSize + 0;

  DeviceAPIService_GetAnnotatedLocation_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceAPIService_GetAnnotatedLocation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DeviceAPIService_GetAnnotatedLocation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceAPIService_GetAnnotatedLocation_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function DeviceAPIService_GetAnnotatedLocation_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceAPIService_GetAnnotatedLocation_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  DeviceAPIService_GetAnnotatedLocation_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceAPIService_GetAnnotatedLocation_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceAPIService_GetAnnotatedLocation_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, DeviceAttributeResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceAPIService_GetAnnotatedLocation_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  DeviceAPIService_GetAnnotatedLocation_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DeviceAPIService_GetAnnotatedLocation_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(DeviceAttributeResult);
    return val;
  };

  DeviceAPIService_GetAnnotatedLocation_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceAPIService_GetAnnotatedLocation_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(DeviceAttributeResult, val.result);
  };
  function ManagedConfigurationService_GetManagedConfiguration_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManagedConfigurationService_GetManagedConfiguration_Params.prototype.initDefaults_ = function() {
    this.keys = null;
  };
  ManagedConfigurationService_GetManagedConfiguration_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManagedConfigurationService_GetManagedConfiguration_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManagedConfigurationService_GetManagedConfiguration_Params.keys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManagedConfigurationService_GetManagedConfiguration_Params.encodedSize = codec.kStructHeaderSize + 8;

  ManagedConfigurationService_GetManagedConfiguration_Params.decode = function(decoder) {
    var packed;
    var val = new ManagedConfigurationService_GetManagedConfiguration_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keys =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  ManagedConfigurationService_GetManagedConfiguration_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManagedConfigurationService_GetManagedConfiguration_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.keys);
  };
  function ManagedConfigurationService_GetManagedConfiguration_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManagedConfigurationService_GetManagedConfiguration_ResponseParams.prototype.initDefaults_ = function() {
    this.configurations = null;
  };
  ManagedConfigurationService_GetManagedConfiguration_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManagedConfigurationService_GetManagedConfiguration_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManagedConfigurationService_GetManagedConfiguration_ResponseParams.configurations
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, true, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManagedConfigurationService_GetManagedConfiguration_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ManagedConfigurationService_GetManagedConfiguration_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ManagedConfigurationService_GetManagedConfiguration_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.configurations =
        decoder.decodeMapPointer(codec.String, codec.String);
    return val;
  };

  ManagedConfigurationService_GetManagedConfiguration_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManagedConfigurationService_GetManagedConfiguration_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, codec.String, val.configurations);
  };
  function ManagedConfigurationService_SubscribeToManagedConfiguration_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManagedConfigurationService_SubscribeToManagedConfiguration_Params.prototype.initDefaults_ = function() {
    this.observer = new ManagedConfigurationObserverPtr();
  };
  ManagedConfigurationService_SubscribeToManagedConfiguration_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManagedConfigurationService_SubscribeToManagedConfiguration_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManagedConfigurationService_SubscribeToManagedConfiguration_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManagedConfigurationService_SubscribeToManagedConfiguration_Params.encodedSize = codec.kStructHeaderSize + 8;

  ManagedConfigurationService_SubscribeToManagedConfiguration_Params.decode = function(decoder) {
    var packed;
    var val = new ManagedConfigurationService_SubscribeToManagedConfiguration_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(ManagedConfigurationObserverPtr));
    return val;
  };

  ManagedConfigurationService_SubscribeToManagedConfiguration_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManagedConfigurationService_SubscribeToManagedConfiguration_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(ManagedConfigurationObserverPtr), val.observer);
  };

  function DeviceAttributeResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  DeviceAttributeResult.Tags = {
    errorMessage: 0,
    attribute: 1,
  };

  DeviceAttributeResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  DeviceAttributeResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "errorMessage",
        "attribute",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a DeviceAttributeResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(DeviceAttributeResult.prototype, "errorMessage", {
    get: function() {
      if (this.$tag != DeviceAttributeResult.Tags.errorMessage) {
        throw new ReferenceError(
            "DeviceAttributeResult.errorMessage is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DeviceAttributeResult.Tags.errorMessage;
      this.$data = value;
    }
  });
  Object.defineProperty(DeviceAttributeResult.prototype, "attribute", {
    get: function() {
      if (this.$tag != DeviceAttributeResult.Tags.attribute) {
        throw new ReferenceError(
            "DeviceAttributeResult.attribute is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DeviceAttributeResult.Tags.attribute;
      this.$data = value;
    }
  });


    DeviceAttributeResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case DeviceAttributeResult.Tags.errorMessage:
          encoder.encodeStruct(codec.String, val.errorMessage);
          break;
        case DeviceAttributeResult.Tags.attribute:
          encoder.encodeStruct(codec.String, val.attribute);
          break;
      }
      encoder.align();
    };


    DeviceAttributeResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new DeviceAttributeResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case DeviceAttributeResult.Tags.errorMessage:
          result.errorMessage = decoder.decodeStruct(codec.String);
          break;
        case DeviceAttributeResult.Tags.attribute:
          result.attribute = decoder.decodeStruct(codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    DeviceAttributeResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case DeviceAttributeResult.Tags.errorMessage:
          

    // validate DeviceAttributeResult.errorMessage
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DeviceAttributeResult.Tags.attribute:
          

    // validate DeviceAttributeResult.attribute
    err = messageValidator.validateStringPointer(data_offset, true)
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  DeviceAttributeResult.encodedSize = 16;
  var kManagedConfigurationObserver_OnConfigurationChanged_Name = 0;

  function ManagedConfigurationObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ManagedConfigurationObserver,
                                                   handleOrPtrInfo);
  }

  function ManagedConfigurationObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ManagedConfigurationObserver, associatedInterfacePtrInfo);
  }

  ManagedConfigurationObserverAssociatedPtr.prototype =
      Object.create(ManagedConfigurationObserverPtr.prototype);
  ManagedConfigurationObserverAssociatedPtr.prototype.constructor =
      ManagedConfigurationObserverAssociatedPtr;

  function ManagedConfigurationObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  ManagedConfigurationObserverPtr.prototype.onConfigurationChanged = function() {
    return ManagedConfigurationObserverProxy.prototype.onConfigurationChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  ManagedConfigurationObserverProxy.prototype.onConfigurationChanged = function() {
    var params_ = new ManagedConfigurationObserver_OnConfigurationChanged_Params();
    var builder = new codec.MessageV0Builder(
        kManagedConfigurationObserver_OnConfigurationChanged_Name,
        codec.align(ManagedConfigurationObserver_OnConfigurationChanged_Params.encodedSize));
    builder.encodeStruct(ManagedConfigurationObserver_OnConfigurationChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ManagedConfigurationObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  ManagedConfigurationObserverStub.prototype.onConfigurationChanged = function() {
    return this.delegate_ && this.delegate_.onConfigurationChanged && this.delegate_.onConfigurationChanged();
  }

  ManagedConfigurationObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kManagedConfigurationObserver_OnConfigurationChanged_Name:
      var params = reader.decodeStruct(ManagedConfigurationObserver_OnConfigurationChanged_Params);
      this.onConfigurationChanged();
      return true;
    default:
      return false;
    }
  };

  ManagedConfigurationObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateManagedConfigurationObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kManagedConfigurationObserver_OnConfigurationChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ManagedConfigurationObserver_OnConfigurationChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateManagedConfigurationObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ManagedConfigurationObserver = {
    name: 'blink.mojom.ManagedConfigurationObserver',
    kVersion: 0,
    ptrClass: ManagedConfigurationObserverPtr,
    proxyClass: ManagedConfigurationObserverProxy,
    stubClass: ManagedConfigurationObserverStub,
    validateRequest: validateManagedConfigurationObserverRequest,
    validateResponse: null,
  };
  ManagedConfigurationObserverStub.prototype.validator = validateManagedConfigurationObserverRequest;
  ManagedConfigurationObserverProxy.prototype.validator = null;
  var kDeviceAPIService_GetDirectoryId_Name = 0;
  var kDeviceAPIService_GetHostname_Name = 1;
  var kDeviceAPIService_GetSerialNumber_Name = 2;
  var kDeviceAPIService_GetAnnotatedAssetId_Name = 3;
  var kDeviceAPIService_GetAnnotatedLocation_Name = 4;

  function DeviceAPIServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DeviceAPIService,
                                                   handleOrPtrInfo);
  }

  function DeviceAPIServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DeviceAPIService, associatedInterfacePtrInfo);
  }

  DeviceAPIServiceAssociatedPtr.prototype =
      Object.create(DeviceAPIServicePtr.prototype);
  DeviceAPIServiceAssociatedPtr.prototype.constructor =
      DeviceAPIServiceAssociatedPtr;

  function DeviceAPIServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  DeviceAPIServicePtr.prototype.getDirectoryId = function() {
    return DeviceAPIServiceProxy.prototype.getDirectoryId
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceAPIServiceProxy.prototype.getDirectoryId = function() {
    var params_ = new DeviceAPIService_GetDirectoryId_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDeviceAPIService_GetDirectoryId_Name,
          codec.align(DeviceAPIService_GetDirectoryId_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DeviceAPIService_GetDirectoryId_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DeviceAPIService_GetDirectoryId_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DeviceAPIServicePtr.prototype.getHostname = function() {
    return DeviceAPIServiceProxy.prototype.getHostname
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceAPIServiceProxy.prototype.getHostname = function() {
    var params_ = new DeviceAPIService_GetHostname_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDeviceAPIService_GetHostname_Name,
          codec.align(DeviceAPIService_GetHostname_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DeviceAPIService_GetHostname_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DeviceAPIService_GetHostname_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DeviceAPIServicePtr.prototype.getSerialNumber = function() {
    return DeviceAPIServiceProxy.prototype.getSerialNumber
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceAPIServiceProxy.prototype.getSerialNumber = function() {
    var params_ = new DeviceAPIService_GetSerialNumber_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDeviceAPIService_GetSerialNumber_Name,
          codec.align(DeviceAPIService_GetSerialNumber_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DeviceAPIService_GetSerialNumber_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DeviceAPIService_GetSerialNumber_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DeviceAPIServicePtr.prototype.getAnnotatedAssetId = function() {
    return DeviceAPIServiceProxy.prototype.getAnnotatedAssetId
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceAPIServiceProxy.prototype.getAnnotatedAssetId = function() {
    var params_ = new DeviceAPIService_GetAnnotatedAssetId_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDeviceAPIService_GetAnnotatedAssetId_Name,
          codec.align(DeviceAPIService_GetAnnotatedAssetId_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DeviceAPIService_GetAnnotatedAssetId_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DeviceAPIService_GetAnnotatedAssetId_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DeviceAPIServicePtr.prototype.getAnnotatedLocation = function() {
    return DeviceAPIServiceProxy.prototype.getAnnotatedLocation
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceAPIServiceProxy.prototype.getAnnotatedLocation = function() {
    var params_ = new DeviceAPIService_GetAnnotatedLocation_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDeviceAPIService_GetAnnotatedLocation_Name,
          codec.align(DeviceAPIService_GetAnnotatedLocation_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DeviceAPIService_GetAnnotatedLocation_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DeviceAPIService_GetAnnotatedLocation_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function DeviceAPIServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  DeviceAPIServiceStub.prototype.getDirectoryId = function() {
    return this.delegate_ && this.delegate_.getDirectoryId && this.delegate_.getDirectoryId();
  }
  DeviceAPIServiceStub.prototype.getHostname = function() {
    return this.delegate_ && this.delegate_.getHostname && this.delegate_.getHostname();
  }
  DeviceAPIServiceStub.prototype.getSerialNumber = function() {
    return this.delegate_ && this.delegate_.getSerialNumber && this.delegate_.getSerialNumber();
  }
  DeviceAPIServiceStub.prototype.getAnnotatedAssetId = function() {
    return this.delegate_ && this.delegate_.getAnnotatedAssetId && this.delegate_.getAnnotatedAssetId();
  }
  DeviceAPIServiceStub.prototype.getAnnotatedLocation = function() {
    return this.delegate_ && this.delegate_.getAnnotatedLocation && this.delegate_.getAnnotatedLocation();
  }

  DeviceAPIServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  DeviceAPIServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDeviceAPIService_GetDirectoryId_Name:
      var params = reader.decodeStruct(DeviceAPIService_GetDirectoryId_Params);
      this.getDirectoryId().then(function(response) {
        var responseParams =
            new DeviceAPIService_GetDirectoryId_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kDeviceAPIService_GetDirectoryId_Name,
            codec.align(DeviceAPIService_GetDirectoryId_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DeviceAPIService_GetDirectoryId_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDeviceAPIService_GetHostname_Name:
      var params = reader.decodeStruct(DeviceAPIService_GetHostname_Params);
      this.getHostname().then(function(response) {
        var responseParams =
            new DeviceAPIService_GetHostname_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kDeviceAPIService_GetHostname_Name,
            codec.align(DeviceAPIService_GetHostname_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DeviceAPIService_GetHostname_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDeviceAPIService_GetSerialNumber_Name:
      var params = reader.decodeStruct(DeviceAPIService_GetSerialNumber_Params);
      this.getSerialNumber().then(function(response) {
        var responseParams =
            new DeviceAPIService_GetSerialNumber_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kDeviceAPIService_GetSerialNumber_Name,
            codec.align(DeviceAPIService_GetSerialNumber_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DeviceAPIService_GetSerialNumber_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDeviceAPIService_GetAnnotatedAssetId_Name:
      var params = reader.decodeStruct(DeviceAPIService_GetAnnotatedAssetId_Params);
      this.getAnnotatedAssetId().then(function(response) {
        var responseParams =
            new DeviceAPIService_GetAnnotatedAssetId_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kDeviceAPIService_GetAnnotatedAssetId_Name,
            codec.align(DeviceAPIService_GetAnnotatedAssetId_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DeviceAPIService_GetAnnotatedAssetId_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDeviceAPIService_GetAnnotatedLocation_Name:
      var params = reader.decodeStruct(DeviceAPIService_GetAnnotatedLocation_Params);
      this.getAnnotatedLocation().then(function(response) {
        var responseParams =
            new DeviceAPIService_GetAnnotatedLocation_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kDeviceAPIService_GetAnnotatedLocation_Name,
            codec.align(DeviceAPIService_GetAnnotatedLocation_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DeviceAPIService_GetAnnotatedLocation_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateDeviceAPIServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDeviceAPIService_GetDirectoryId_Name:
        if (message.expectsResponse())
          paramsClass = DeviceAPIService_GetDirectoryId_Params;
      break;
      case kDeviceAPIService_GetHostname_Name:
        if (message.expectsResponse())
          paramsClass = DeviceAPIService_GetHostname_Params;
      break;
      case kDeviceAPIService_GetSerialNumber_Name:
        if (message.expectsResponse())
          paramsClass = DeviceAPIService_GetSerialNumber_Params;
      break;
      case kDeviceAPIService_GetAnnotatedAssetId_Name:
        if (message.expectsResponse())
          paramsClass = DeviceAPIService_GetAnnotatedAssetId_Params;
      break;
      case kDeviceAPIService_GetAnnotatedLocation_Name:
        if (message.expectsResponse())
          paramsClass = DeviceAPIService_GetAnnotatedLocation_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDeviceAPIServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kDeviceAPIService_GetDirectoryId_Name:
        if (message.isResponse())
          paramsClass = DeviceAPIService_GetDirectoryId_ResponseParams;
        break;
      case kDeviceAPIService_GetHostname_Name:
        if (message.isResponse())
          paramsClass = DeviceAPIService_GetHostname_ResponseParams;
        break;
      case kDeviceAPIService_GetSerialNumber_Name:
        if (message.isResponse())
          paramsClass = DeviceAPIService_GetSerialNumber_ResponseParams;
        break;
      case kDeviceAPIService_GetAnnotatedAssetId_Name:
        if (message.isResponse())
          paramsClass = DeviceAPIService_GetAnnotatedAssetId_ResponseParams;
        break;
      case kDeviceAPIService_GetAnnotatedLocation_Name:
        if (message.isResponse())
          paramsClass = DeviceAPIService_GetAnnotatedLocation_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var DeviceAPIService = {
    name: 'blink.mojom.DeviceAPIService',
    kVersion: 0,
    ptrClass: DeviceAPIServicePtr,
    proxyClass: DeviceAPIServiceProxy,
    stubClass: DeviceAPIServiceStub,
    validateRequest: validateDeviceAPIServiceRequest,
    validateResponse: validateDeviceAPIServiceResponse,
  };
  DeviceAPIServiceStub.prototype.validator = validateDeviceAPIServiceRequest;
  DeviceAPIServiceProxy.prototype.validator = validateDeviceAPIServiceResponse;
  var kManagedConfigurationService_GetManagedConfiguration_Name = 0;
  var kManagedConfigurationService_SubscribeToManagedConfiguration_Name = 1;

  function ManagedConfigurationServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ManagedConfigurationService,
                                                   handleOrPtrInfo);
  }

  function ManagedConfigurationServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ManagedConfigurationService, associatedInterfacePtrInfo);
  }

  ManagedConfigurationServiceAssociatedPtr.prototype =
      Object.create(ManagedConfigurationServicePtr.prototype);
  ManagedConfigurationServiceAssociatedPtr.prototype.constructor =
      ManagedConfigurationServiceAssociatedPtr;

  function ManagedConfigurationServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  ManagedConfigurationServicePtr.prototype.getManagedConfiguration = function() {
    return ManagedConfigurationServiceProxy.prototype.getManagedConfiguration
        .apply(this.ptr.getProxy(), arguments);
  };

  ManagedConfigurationServiceProxy.prototype.getManagedConfiguration = function(keys) {
    var params_ = new ManagedConfigurationService_GetManagedConfiguration_Params();
    params_.keys = keys;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kManagedConfigurationService_GetManagedConfiguration_Name,
          codec.align(ManagedConfigurationService_GetManagedConfiguration_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ManagedConfigurationService_GetManagedConfiguration_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ManagedConfigurationService_GetManagedConfiguration_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ManagedConfigurationServicePtr.prototype.subscribeToManagedConfiguration = function() {
    return ManagedConfigurationServiceProxy.prototype.subscribeToManagedConfiguration
        .apply(this.ptr.getProxy(), arguments);
  };

  ManagedConfigurationServiceProxy.prototype.subscribeToManagedConfiguration = function(observer) {
    var params_ = new ManagedConfigurationService_SubscribeToManagedConfiguration_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kManagedConfigurationService_SubscribeToManagedConfiguration_Name,
        codec.align(ManagedConfigurationService_SubscribeToManagedConfiguration_Params.encodedSize));
    builder.encodeStruct(ManagedConfigurationService_SubscribeToManagedConfiguration_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ManagedConfigurationServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  ManagedConfigurationServiceStub.prototype.getManagedConfiguration = function(keys) {
    return this.delegate_ && this.delegate_.getManagedConfiguration && this.delegate_.getManagedConfiguration(keys);
  }
  ManagedConfigurationServiceStub.prototype.subscribeToManagedConfiguration = function(observer) {
    return this.delegate_ && this.delegate_.subscribeToManagedConfiguration && this.delegate_.subscribeToManagedConfiguration(observer);
  }

  ManagedConfigurationServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kManagedConfigurationService_SubscribeToManagedConfiguration_Name:
      var params = reader.decodeStruct(ManagedConfigurationService_SubscribeToManagedConfiguration_Params);
      this.subscribeToManagedConfiguration(params.observer);
      return true;
    default:
      return false;
    }
  };

  ManagedConfigurationServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kManagedConfigurationService_GetManagedConfiguration_Name:
      var params = reader.decodeStruct(ManagedConfigurationService_GetManagedConfiguration_Params);
      this.getManagedConfiguration(params.keys).then(function(response) {
        var responseParams =
            new ManagedConfigurationService_GetManagedConfiguration_ResponseParams();
        responseParams.configurations = response.configurations;
        var builder = new codec.MessageV1Builder(
            kManagedConfigurationService_GetManagedConfiguration_Name,
            codec.align(ManagedConfigurationService_GetManagedConfiguration_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ManagedConfigurationService_GetManagedConfiguration_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateManagedConfigurationServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kManagedConfigurationService_GetManagedConfiguration_Name:
        if (message.expectsResponse())
          paramsClass = ManagedConfigurationService_GetManagedConfiguration_Params;
      break;
      case kManagedConfigurationService_SubscribeToManagedConfiguration_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ManagedConfigurationService_SubscribeToManagedConfiguration_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateManagedConfigurationServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kManagedConfigurationService_GetManagedConfiguration_Name:
        if (message.isResponse())
          paramsClass = ManagedConfigurationService_GetManagedConfiguration_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ManagedConfigurationService = {
    name: 'blink.mojom.ManagedConfigurationService',
    kVersion: 0,
    ptrClass: ManagedConfigurationServicePtr,
    proxyClass: ManagedConfigurationServiceProxy,
    stubClass: ManagedConfigurationServiceStub,
    validateRequest: validateManagedConfigurationServiceRequest,
    validateResponse: validateManagedConfigurationServiceResponse,
  };
  ManagedConfigurationServiceStub.prototype.validator = validateManagedConfigurationServiceRequest;
  ManagedConfigurationServiceProxy.prototype.validator = validateManagedConfigurationServiceResponse;
  exports.DeviceAttributeResult = DeviceAttributeResult;
  exports.ManagedConfigurationObserver = ManagedConfigurationObserver;
  exports.ManagedConfigurationObserverPtr = ManagedConfigurationObserverPtr;
  exports.ManagedConfigurationObserverAssociatedPtr = ManagedConfigurationObserverAssociatedPtr;
  exports.DeviceAPIService = DeviceAPIService;
  exports.DeviceAPIServicePtr = DeviceAPIServicePtr;
  exports.DeviceAPIServiceAssociatedPtr = DeviceAPIServiceAssociatedPtr;
  exports.ManagedConfigurationService = ManagedConfigurationService;
  exports.ManagedConfigurationServicePtr = ManagedConfigurationServicePtr;
  exports.ManagedConfigurationServiceAssociatedPtr = ManagedConfigurationServiceAssociatedPtr;
})();