// third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('url.mojom.SchemeHostPort');
goog.require('mojoBase.mojom.String16');
goog.require('url.mojom.Url');




goog.provide('blink.mojom.CredentialType');
goog.provide('blink.mojom.CredentialTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CredentialTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CredentialType = {
  
  EMPTY: 0,
  PASSWORD: 1,
  FEDERATED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.CredentialMediationRequirement');
goog.provide('blink.mojom.CredentialMediationRequirementSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CredentialMediationRequirementSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CredentialMediationRequirement = {
  
  kSilent: 0,
  kOptional: 1,
  kRequired: 2,
  kConditional: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('blink.mojom.CredentialManagerError');
goog.provide('blink.mojom.CredentialManagerErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.CredentialManagerErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.CredentialManagerError = {
  
  SUCCESS: 0,
  PENDING_REQUEST: 1,
  PASSWORD_STORE_UNAVAILABLE: 2,
  UNKNOWN: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



goog.provide('blink.mojom.CredentialManager');
goog.provide('blink.mojom.CredentialManagerReceiver');
goog.provide('blink.mojom.CredentialManagerCallbackRouter');
goog.provide('blink.mojom.CredentialManagerInterface');
goog.provide('blink.mojom.CredentialManagerRemote');
goog.provide('blink.mojom.CredentialManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.CredentialManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.CredentialManager.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.CredentialManagerInterface = class {
  
  /**
   * @param { !blink.mojom.CredentialInfo } credential
   * @return {!Promise}
   */

  store(credential) {}
  
  /**
   * @return {!Promise}
   */

  preventSilentAccess() {}
  
  /**
   * @param { !blink.mojom.CredentialMediationRequirement } mediation
   * @param { !boolean } includePasswords
   * @param { !Array<!url.mojom.Url> } federations
   * @return {!Promise<{
        error: !blink.mojom.CredentialManagerError,
        credential: ?blink.mojom.CredentialInfo,
   *  }>}
   */

  get(mediation, includePasswords, federations) {}
};

/**
 * @export
 * @implements { blink.mojom.CredentialManagerInterface }
 */
blink.mojom.CredentialManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.CredentialManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.CredentialManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.CredentialManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.CredentialInfo } credential
   * @return {!Promise}
   */

  store(
      credential) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.CredentialManager_Store_ParamsSpec.$,
        blink.mojom.CredentialManager_Store_ResponseParamsSpec.$,
        [
          credential
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  preventSilentAccess() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.CredentialManager_PreventSilentAccess_ParamsSpec.$,
        blink.mojom.CredentialManager_PreventSilentAccess_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.CredentialMediationRequirement } mediation
   * @param { !boolean } includePasswords
   * @param { !Array<!url.mojom.Url> } federations
   * @return {!Promise<{
        error: !blink.mojom.CredentialManagerError,
        credential: ?blink.mojom.CredentialInfo,
   *  }>}
   */

  get(
      mediation,
      includePasswords,
      federations) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.CredentialManager_Get_ParamsSpec.$,
        blink.mojom.CredentialManager_Get_ResponseParamsSpec.$,
        [
          mediation,
          includePasswords,
          federations
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CredentialManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.CredentialManagerReceiver = class {
  /**
   * @param {!blink.mojom.CredentialManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.CredentialManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.CredentialManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.CredentialManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.CredentialManager_Store_ParamsSpec.$,
        blink.mojom.CredentialManager_Store_ResponseParamsSpec.$,
        impl.store.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.CredentialManager_PreventSilentAccess_ParamsSpec.$,
        blink.mojom.CredentialManager_PreventSilentAccess_ResponseParamsSpec.$,
        impl.preventSilentAccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.CredentialManager_Get_ParamsSpec.$,
        blink.mojom.CredentialManager_Get_ResponseParamsSpec.$,
        impl.get.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.CredentialManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CredentialManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.CredentialManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.CredentialManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CredentialManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.CredentialManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.CredentialManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.CredentialManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.store =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.CredentialManager_Store_ParamsSpec.$,
        blink.mojom.CredentialManager_Store_ResponseParamsSpec.$,
        this.store.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.preventSilentAccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.CredentialManager_PreventSilentAccess_ParamsSpec.$,
        blink.mojom.CredentialManager_PreventSilentAccess_ResponseParamsSpec.$,
        this.preventSilentAccess.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.get =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.CredentialManager_Get_ParamsSpec.$,
        blink.mojom.CredentialManager_Get_ResponseParamsSpec.$,
        this.get.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.CredentialInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CredentialInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.CredentialManager_Store_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CredentialManager_Store_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.CredentialManager_Store_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CredentialManager_Store_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.CredentialManager_PreventSilentAccess_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CredentialManager_PreventSilentAccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.CredentialManager_PreventSilentAccess_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CredentialManager_PreventSilentAccess_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.CredentialManager_Get_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CredentialManager_Get_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.CredentialManager_Get_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CredentialManager_Get_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.CredentialInfoSpec.$,
    'CredentialInfo',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.CredentialTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'icon', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'password', 32,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'federation', 40,
        0,
        url.mojom.SchemeHostPortSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.CredentialInfo');

/** @record */
blink.mojom.CredentialInfo = class {
  constructor() {
    /** @export { !blink.mojom.CredentialType } */
    this.type;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.id;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.name;
    /** @export { !url.mojom.Url } */
    this.icon;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.password;
    /** @export { !url.mojom.SchemeHostPort } */
    this.federation;
  }
};



mojo.internal.Struct(
    blink.mojom.CredentialManager_Store_ParamsSpec.$,
    'CredentialManager_Store_Params',
    [
      mojo.internal.StructField(
        'credential', 0,
        0,
        blink.mojom.CredentialInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.CredentialManager_Store_Params');

/** @record */
blink.mojom.CredentialManager_Store_Params = class {
  constructor() {
    /** @export { !blink.mojom.CredentialInfo } */
    this.credential;
  }
};



mojo.internal.Struct(
    blink.mojom.CredentialManager_Store_ResponseParamsSpec.$,
    'CredentialManager_Store_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.CredentialManager_Store_ResponseParams');

/** @record */
blink.mojom.CredentialManager_Store_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.CredentialManager_PreventSilentAccess_ParamsSpec.$,
    'CredentialManager_PreventSilentAccess_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.CredentialManager_PreventSilentAccess_Params');

/** @record */
blink.mojom.CredentialManager_PreventSilentAccess_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.CredentialManager_PreventSilentAccess_ResponseParamsSpec.$,
    'CredentialManager_PreventSilentAccess_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.CredentialManager_PreventSilentAccess_ResponseParams');

/** @record */
blink.mojom.CredentialManager_PreventSilentAccess_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.CredentialManager_Get_ParamsSpec.$,
    'CredentialManager_Get_Params',
    [
      mojo.internal.StructField(
        'mediation', 0,
        0,
        blink.mojom.CredentialMediationRequirementSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includePasswords', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'federations', 8,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.CredentialManager_Get_Params');

/** @record */
blink.mojom.CredentialManager_Get_Params = class {
  constructor() {
    /** @export { !blink.mojom.CredentialMediationRequirement } */
    this.mediation;
    /** @export { !boolean } */
    this.includePasswords;
    /** @export { !Array<!url.mojom.Url> } */
    this.federations;
  }
};



mojo.internal.Struct(
    blink.mojom.CredentialManager_Get_ResponseParamsSpec.$,
    'CredentialManager_Get_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.CredentialManagerErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credential', 8,
        0,
        blink.mojom.CredentialInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.CredentialManager_Get_ResponseParams');

/** @record */
blink.mojom.CredentialManager_Get_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.CredentialManagerError } */
    this.error;
    /** @export { (blink.mojom.CredentialInfo|undefined) } */
    this.credential;
  }
};

