// third_party/blink/public/mojom/crash/crash_memory_metrics_reporter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/crash/crash_memory_metrics_reporter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/crash/crash_memory_metrics_reporter.mojom-params-data.h"
#include "third_party/blink/public/mojom/crash/crash_memory_metrics_reporter.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/crash/crash_memory_metrics_reporter.mojom-import-headers.h"
#include "third_party/blink/public/mojom/crash/crash_memory_metrics_reporter.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

CrashMemoryMetricsReporter::IPCStableHashFunction CrashMemoryMetricsReporter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CrashMemoryMetricsReporter>(message.name())) {
    case messages::CrashMemoryMetricsReporter::kSetSharedMemory: {
      return &CrashMemoryMetricsReporter::SetSharedMemory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CrashMemoryMetricsReporter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CrashMemoryMetricsReporter>(message.name())) {
      case messages::CrashMemoryMetricsReporter::kSetSharedMemory:
            return "Receive blink::mojom::CrashMemoryMetricsReporter::SetSharedMemory";
    }
  } else {
    switch (static_cast<messages::CrashMemoryMetricsReporter>(message.name())) {
      case messages::CrashMemoryMetricsReporter::kSetSharedMemory:
            return "Receive reply blink::mojom::CrashMemoryMetricsReporter::SetSharedMemory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CrashMemoryMetricsReporter::SetSharedMemory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd755fa6d;  // IPCStableHash for blink::mojom::CrashMemoryMetricsReporter::SetSharedMemory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CrashMemoryMetricsReporterProxy::CrashMemoryMetricsReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CrashMemoryMetricsReporterProxy::SetSharedMemory(
    ::base::UnsafeSharedMemoryRegion in_shared_metrics_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CrashMemoryMetricsReporter::SetSharedMemory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_metrics_buffer"), in_shared_metrics_buffer,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CrashMemoryMetricsReporter::kSetSharedMemory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CrashMemoryMetricsReporter_SetSharedMemory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->shared_metrics_buffer)::BaseType> shared_metrics_buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
    in_shared_metrics_buffer,
    shared_metrics_buffer_fragment);

  params->shared_metrics_buffer.Set(
      shared_metrics_buffer_fragment.is_null() ? nullptr : shared_metrics_buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->shared_metrics_buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null shared_metrics_buffer in CrashMemoryMetricsReporter.SetSharedMemory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CrashMemoryMetricsReporter::Name_);
  message.set_method_name("SetSharedMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CrashMemoryMetricsReporterStubDispatch::Accept(
    CrashMemoryMetricsReporter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CrashMemoryMetricsReporter>(message->header()->name)) {
    case messages::CrashMemoryMetricsReporter::kSetSharedMemory: {
      DCHECK(message->is_serialized());
      internal::CrashMemoryMetricsReporter_SetSharedMemory_Params_Data* params =
          reinterpret_cast<internal::CrashMemoryMetricsReporter_SetSharedMemory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CrashMemoryMetricsReporter.0
      bool success = true;
      ::base::UnsafeSharedMemoryRegion p_shared_metrics_buffer{};
      CrashMemoryMetricsReporter_SetSharedMemory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSharedMetricsBuffer(&p_shared_metrics_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CrashMemoryMetricsReporter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSharedMemory(        
        std::move(p_shared_metrics_buffer));
      return true;
    }
  }
  return false;
}

// static
bool CrashMemoryMetricsReporterStubDispatch::AcceptWithResponder(
    CrashMemoryMetricsReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CrashMemoryMetricsReporter>(message->header()->name)) {
    case messages::CrashMemoryMetricsReporter::kSetSharedMemory: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCrashMemoryMetricsReporterValidationInfo[] = {
    { &internal::CrashMemoryMetricsReporter_SetSharedMemory_Params_Data::Validate,
     nullptr /* no response */},
};

bool CrashMemoryMetricsReporterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::CrashMemoryMetricsReporter::Name_,
    kCrashMemoryMetricsReporterValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void CrashMemoryMetricsReporterInterceptorForTesting::SetSharedMemory(::base::UnsafeSharedMemoryRegion shared_metrics_buffer) {
  GetForwardingInterface()->SetSharedMemory(
    std::move(shared_metrics_buffer)
    );
}
CrashMemoryMetricsReporterAsyncWaiter::CrashMemoryMetricsReporterAsyncWaiter(
    CrashMemoryMetricsReporter* proxy) : proxy_(proxy) {}

CrashMemoryMetricsReporterAsyncWaiter::~CrashMemoryMetricsReporterAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif