// third_party/blink/public/mojom/conversions/conversions.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('attributionReporting.mojom.RegistrationEligibility');
goog.require('attributionReporting.mojom.DataHost');
goog.require('blink.mojom.AttributionSrcToken');
goog.require('url.mojom.Origin');






goog.provide('blink.mojom.AttributionHost');
goog.provide('blink.mojom.AttributionHostReceiver');
goog.provide('blink.mojom.AttributionHostCallbackRouter');
goog.provide('blink.mojom.AttributionHostInterface');
goog.provide('blink.mojom.AttributionHostRemote');
goog.provide('blink.mojom.AttributionHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AttributionHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AttributionHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AttributionHostInterface = class {
  
  /**
   * @param { !attributionReporting.mojom.DataHostPendingReceiver } dataHost
   * @param { !attributionReporting.mojom.RegistrationEligibility } registrationEligibility
   * @param { !boolean } isForBackgroundRequests
   * @param { !Array<!url.mojom.Origin> } reportingOrigins
   */

  registerDataHost(dataHost, registrationEligibility, isForBackgroundRequests, reportingOrigins) {}
  
  /**
   * @param { !attributionReporting.mojom.DataHostPendingReceiver } dataHost
   * @param { !blink.mojom.AttributionSrcToken } attributionSrcToken
   */

  registerNavigationDataHost(dataHost, attributionSrcToken) {}
  
  /**
   * @param { !blink.mojom.AttributionSrcToken } attributionSrcToken
   * @param { !number } expectedRegistrations
   */

  notifyNavigationWithBackgroundRegistrationsWillStart(attributionSrcToken, expectedRegistrations) {}
};

/**
 * @export
 * @implements { blink.mojom.AttributionHostInterface }
 */
blink.mojom.AttributionHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AttributionHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AttributionHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AttributionHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !attributionReporting.mojom.DataHostPendingReceiver } dataHost
   * @param { !attributionReporting.mojom.RegistrationEligibility } registrationEligibility
   * @param { !boolean } isForBackgroundRequests
   * @param { !Array<!url.mojom.Origin> } reportingOrigins
   */

  registerDataHost(
      dataHost,
      registrationEligibility,
      isForBackgroundRequests,
      reportingOrigins) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AttributionHost_RegisterDataHost_ParamsSpec.$,
        null,
        [
          dataHost,
          registrationEligibility,
          isForBackgroundRequests,
          reportingOrigins
        ],
        false);
  }

  
  /**
   * @param { !attributionReporting.mojom.DataHostPendingReceiver } dataHost
   * @param { !blink.mojom.AttributionSrcToken } attributionSrcToken
   */

  registerNavigationDataHost(
      dataHost,
      attributionSrcToken) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AttributionHost_RegisterNavigationDataHost_ParamsSpec.$,
        null,
        [
          dataHost,
          attributionSrcToken
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AttributionSrcToken } attributionSrcToken
   * @param { !number } expectedRegistrations
   */

  notifyNavigationWithBackgroundRegistrationsWillStart(
      attributionSrcToken,
      expectedRegistrations) {
    this.proxy.sendMessage(
        2,
        blink.mojom.AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec.$,
        null,
        [
          attributionSrcToken,
          expectedRegistrations
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AttributionHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AttributionHostReceiver = class {
  /**
   * @param {!blink.mojom.AttributionHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AttributionHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AttributionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AttributionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AttributionHost_RegisterDataHost_ParamsSpec.$,
        null,
        impl.registerDataHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AttributionHost_RegisterNavigationDataHost_ParamsSpec.$,
        null,
        impl.registerNavigationDataHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec.$,
        null,
        impl.notifyNavigationWithBackgroundRegistrationsWillStart.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AttributionHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AttributionHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AttributionHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AttributionHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AttributionHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AttributionHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AttributionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AttributionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerDataHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AttributionHost_RegisterDataHost_ParamsSpec.$,
        null,
        this.registerDataHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerNavigationDataHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AttributionHost_RegisterNavigationDataHost_ParamsSpec.$,
        null,
        this.registerNavigationDataHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyNavigationWithBackgroundRegistrationsWillStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec.$,
        null,
        this.notifyNavigationWithBackgroundRegistrationsWillStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ImpressionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ImpressionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AttributionHost_RegisterDataHost_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AttributionHost_RegisterDataHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AttributionHost_RegisterNavigationDataHost_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AttributionHost_RegisterNavigationDataHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ImpressionSpec.$,
    'Impression',
    [
      mojo.internal.StructField(
        'attributionSrcToken', 0,
        0,
        blink.mojom.AttributionSrcTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isEmptyAttributionSrcTag', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.Impression');

/** @record */
blink.mojom.Impression = class {
  constructor() {
    /** @export { !blink.mojom.AttributionSrcToken } */
    this.attributionSrcToken;
    /** @export { !boolean } */
    this.isEmptyAttributionSrcTag;
  }
};



mojo.internal.Struct(
    blink.mojom.AttributionHost_RegisterDataHost_ParamsSpec.$,
    'AttributionHost_RegisterDataHost_Params',
    [
      mojo.internal.StructField(
        'dataHost', 0,
        0,
        mojo.internal.InterfaceRequest(attributionReporting.mojom.DataHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'registrationEligibility', 4,
        0,
        attributionReporting.mojom.RegistrationEligibilitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isForBackgroundRequests', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportingOrigins', 16,
        0,
        mojo.internal.Array(url.mojom.OriginSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AttributionHost_RegisterDataHost_Params');

/** @record */
blink.mojom.AttributionHost_RegisterDataHost_Params = class {
  constructor() {
    /** @export { !attributionReporting.mojom.DataHostPendingReceiver } */
    this.dataHost;
    /** @export { !attributionReporting.mojom.RegistrationEligibility } */
    this.registrationEligibility;
    /** @export { !boolean } */
    this.isForBackgroundRequests;
    /** @export { !Array<!url.mojom.Origin> } */
    this.reportingOrigins;
  }
};



mojo.internal.Struct(
    blink.mojom.AttributionHost_RegisterNavigationDataHost_ParamsSpec.$,
    'AttributionHost_RegisterNavigationDataHost_Params',
    [
      mojo.internal.StructField(
        'dataHost', 0,
        0,
        mojo.internal.InterfaceRequest(attributionReporting.mojom.DataHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'attributionSrcToken', 8,
        0,
        blink.mojom.AttributionSrcTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AttributionHost_RegisterNavigationDataHost_Params');

/** @record */
blink.mojom.AttributionHost_RegisterNavigationDataHost_Params = class {
  constructor() {
    /** @export { !attributionReporting.mojom.DataHostPendingReceiver } */
    this.dataHost;
    /** @export { !blink.mojom.AttributionSrcToken } */
    this.attributionSrcToken;
  }
};



mojo.internal.Struct(
    blink.mojom.AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsSpec.$,
    'AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params',
    [
      mojo.internal.StructField(
        'attributionSrcToken', 0,
        0,
        blink.mojom.AttributionSrcTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'expectedRegistrations', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params');

/** @record */
blink.mojom.AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params = class {
  constructor() {
    /** @export { !blink.mojom.AttributionSrcToken } */
    this.attributionSrcToken;
    /** @export { !number } */
    this.expectedRegistrations;
  }
};

