// third_party/blink/public/mojom/conversions/conversions.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/conversions/conversions.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/conversions/conversions.mojom-blink-forward.h"  // IWYU pragma: export
#include "components/attribution_reporting/data_host.mojom-blink-forward.h"
#include "components/attribution_reporting/registration_eligibility.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"
#include "services/network/public/mojom/attribution.mojom-blink-forward.h"
#include "url/mojom/origin.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/navigation/impression_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class AttributionHostProxy;

template <typename ImplRefTraits>
class AttributionHostStub;

class AttributionHostRequestValidator;


class PLATFORM_EXPORT AttributionHost
    : public AttributionHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AttributionHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AttributionHostInterfaceBase;
  using Proxy_ = AttributionHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = AttributionHostStub<ImplRefTraits>;

  using RequestValidator_ = AttributionHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRegisterDataHostMinVersion = 0,
    kRegisterNavigationDataHostMinVersion = 0,
    kNotifyNavigationWithBackgroundRegistrationsWillStartMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RegisterDataHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterNavigationDataHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyNavigationWithBackgroundRegistrationsWillStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AttributionHost() = default;

  virtual void RegisterDataHost(::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost> data_host, ::attribution_reporting::mojom::blink::RegistrationEligibility registration_eligibility, bool is_for_background_requests, const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& reporting_origins) = 0;

  virtual void RegisterNavigationDataHost(::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost> data_host, const ::blink::AttributionSrcToken& attribution_src_token) = 0;

  virtual void NotifyNavigationWithBackgroundRegistrationsWillStart(const ::blink::AttributionSrcToken& attribution_src_token, uint32_t expected_registrations) = 0;
};



class PLATFORM_EXPORT AttributionHostProxy
    : public AttributionHost {
 public:
  using InterfaceType = AttributionHost;

  explicit AttributionHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterDataHost(::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost> data_host, ::attribution_reporting::mojom::blink::RegistrationEligibility registration_eligibility, bool is_for_background_requests, const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& reporting_origins) final;
  
  void RegisterNavigationDataHost(::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost> data_host, const ::blink::AttributionSrcToken& attribution_src_token) final;
  
  void NotifyNavigationWithBackgroundRegistrationsWillStart(const ::blink::AttributionSrcToken& attribution_src_token, uint32_t expected_registrations) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT AttributionHostStubDispatch {
 public:
  static bool Accept(AttributionHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AttributionHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AttributionHost>>
class AttributionHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AttributionHostStub() = default;
  ~AttributionHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AttributionHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AttributionHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AttributionHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT Impression {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Impression, T>::value>;
  using DataView = ImpressionDataView;
  using Data_ = internal::Impression_Data;

  template <typename... Args>
  static ImpressionPtr New(Args&&... args) {
    return ImpressionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImpressionPtr From(const U& u) {
    return mojo::TypeConverter<ImpressionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Impression>::Convert(*this);
  }


  Impression();

  Impression(
      const ::blink::AttributionSrcToken& attribution_src_token,
      bool is_empty_attribution_src_tag);


  ~Impression();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImpressionPtr>
  ImpressionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Impression::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Impression::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Impression::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Impression::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Impression::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Impression::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Impression_UnserializedMessageContext<
            UserType, Impression::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Impression::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Impression::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Impression_UnserializedMessageContext<
            UserType, Impression::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Impression::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::AttributionSrcToken attribution_src_token;
  
  bool is_empty_attribution_src_tag;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Impression::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Impression::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Impression::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Impression::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ImpressionPtr Impression::Clone() const {
  return New(
      mojo::Clone(attribution_src_token),
      mojo::Clone(is_empty_attribution_src_tag)
  );
}

template <typename T, Impression::EnableIfSame<T>*>
bool Impression::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->attribution_src_token, other_struct.attribution_src_token))
    return false;
  if (!mojo::Equals(this->is_empty_attribution_src_tag, other_struct.is_empty_attribution_src_tag))
    return false;
  return true;
}

template <typename T, Impression::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.attribution_src_token < rhs.attribution_src_token)
    return true;
  if (rhs.attribution_src_token < lhs.attribution_src_token)
    return false;
  if (lhs.is_empty_attribution_src_tag < rhs.is_empty_attribution_src_tag)
    return true;
  if (rhs.is_empty_attribution_src_tag < lhs.is_empty_attribution_src_tag)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::Impression::DataView,
                                         ::blink::mojom::blink::ImpressionPtr> {
  static bool IsNull(const ::blink::mojom::blink::ImpressionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ImpressionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::Impression::attribution_src_token)& attribution_src_token(
      const ::blink::mojom::blink::ImpressionPtr& input) {
    return input->attribution_src_token;
  }

  static decltype(::blink::mojom::blink::Impression::is_empty_attribution_src_tag) is_empty_attribution_src_tag(
      const ::blink::mojom::blink::ImpressionPtr& input) {
    return input->is_empty_attribution_src_tag;
  }

  static bool Read(::blink::mojom::blink::Impression::DataView input, ::blink::mojom::blink::ImpressionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONVERSIONS_CONVERSIONS_MOJOM_BLINK_H_