// third_party/blink/public/mojom/conversions/conversions.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/conversions/conversions.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/conversions/conversions.mojom-params-data.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/conversions/conversions.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
Impression::Impression()
    : attribution_src_token(),
      is_empty_attribution_src_tag() {}

Impression::Impression(
    const ::blink::AttributionSrcToken& attribution_src_token_in,
    bool is_empty_attribution_src_tag_in)
    : attribution_src_token(std::move(attribution_src_token_in)),
      is_empty_attribution_src_tag(std::move(is_empty_attribution_src_tag_in)) {}

Impression::~Impression() = default;

void Impression::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribution_src_token"), this->attribution_src_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AttributionSrcToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_empty_attribution_src_tag"), this->is_empty_attribution_src_tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Impression::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AttributionHost::IPCStableHashFunction AttributionHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AttributionHost>(message.name())) {
    case messages::AttributionHost::kRegisterDataHost: {
      return &AttributionHost::RegisterDataHost_Sym::IPCStableHash;
    }
    case messages::AttributionHost::kRegisterNavigationDataHost: {
      return &AttributionHost::RegisterNavigationDataHost_Sym::IPCStableHash;
    }
    case messages::AttributionHost::kNotifyNavigationWithBackgroundRegistrationsWillStart: {
      return &AttributionHost::NotifyNavigationWithBackgroundRegistrationsWillStart_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AttributionHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AttributionHost>(message.name())) {
      case messages::AttributionHost::kRegisterDataHost:
            return "Receive blink::mojom::AttributionHost::RegisterDataHost";
      case messages::AttributionHost::kRegisterNavigationDataHost:
            return "Receive blink::mojom::AttributionHost::RegisterNavigationDataHost";
      case messages::AttributionHost::kNotifyNavigationWithBackgroundRegistrationsWillStart:
            return "Receive blink::mojom::AttributionHost::NotifyNavigationWithBackgroundRegistrationsWillStart";
    }
  } else {
    switch (static_cast<messages::AttributionHost>(message.name())) {
      case messages::AttributionHost::kRegisterDataHost:
            return "Receive reply blink::mojom::AttributionHost::RegisterDataHost";
      case messages::AttributionHost::kRegisterNavigationDataHost:
            return "Receive reply blink::mojom::AttributionHost::RegisterNavigationDataHost";
      case messages::AttributionHost::kNotifyNavigationWithBackgroundRegistrationsWillStart:
            return "Receive reply blink::mojom::AttributionHost::NotifyNavigationWithBackgroundRegistrationsWillStart";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AttributionHost::RegisterDataHost_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab5b6f83;  // IPCStableHash for blink::mojom::AttributionHost::RegisterDataHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AttributionHost::RegisterNavigationDataHost_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65bd5f32;  // IPCStableHash for blink::mojom::AttributionHost::RegisterNavigationDataHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AttributionHost::NotifyNavigationWithBackgroundRegistrationsWillStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd5047c0;  // IPCStableHash for blink::mojom::AttributionHost::NotifyNavigationWithBackgroundRegistrationsWillStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AttributionHostProxy::AttributionHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AttributionHostProxy::RegisterDataHost(
    ::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost> in_data_host, ::attribution_reporting::mojom::blink::RegistrationEligibility in_registration_eligibility, bool in_is_for_background_requests, const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& in_reporting_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AttributionHost::RegisterDataHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_host"), in_data_host,
                        "<value of type ::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_eligibility"), in_registration_eligibility,
                        "<value of type ::attribution_reporting::mojom::blink::RegistrationEligibility>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_for_background_requests"), in_is_for_background_requests,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporting_origins"), in_reporting_origins,
                        "<value of type const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AttributionHost::kRegisterDataHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AttributionHost_RegisterDataHost_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::attribution_reporting::mojom::DataHostInterfaceBase>>(
    in_data_host,
    &params->data_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->data_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid data_host in AttributionHost.RegisterDataHost request");

  
  mojo::internal::Serialize<::attribution_reporting::mojom::RegistrationEligibility>(
    in_registration_eligibility,
    &params->registration_eligibility);

  params->is_for_background_requests = in_is_for_background_requests;
  mojo::internal::MessageFragment<
      typename decltype(params->reporting_origins)::BaseType>
      reporting_origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& reporting_origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
    in_reporting_origins,
    reporting_origins_fragment,
    &reporting_origins_validate_params);

  params->reporting_origins.Set(
      reporting_origins_fragment.is_null() ? nullptr : reporting_origins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reporting_origins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reporting_origins in AttributionHost.RegisterDataHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AttributionHost::Name_);
  message.set_method_name("RegisterDataHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AttributionHostProxy::RegisterNavigationDataHost(
    ::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost> in_data_host, const ::blink::AttributionSrcToken& in_attribution_src_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AttributionHost::RegisterNavigationDataHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_host"), in_data_host,
                        "<value of type ::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attribution_src_token"), in_attribution_src_token,
                        "<value of type const ::blink::AttributionSrcToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AttributionHost::kRegisterNavigationDataHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AttributionHost_RegisterNavigationDataHost_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::attribution_reporting::mojom::DataHostInterfaceBase>>(
    in_data_host,
    &params->data_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->data_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid data_host in AttributionHost.RegisterNavigationDataHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->attribution_src_token)::BaseType> attribution_src_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AttributionSrcTokenDataView>(
    in_attribution_src_token,
    attribution_src_token_fragment);

  params->attribution_src_token.Set(
      attribution_src_token_fragment.is_null() ? nullptr : attribution_src_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attribution_src_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attribution_src_token in AttributionHost.RegisterNavigationDataHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AttributionHost::Name_);
  message.set_method_name("RegisterNavigationDataHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AttributionHostProxy::NotifyNavigationWithBackgroundRegistrationsWillStart(
    const ::blink::AttributionSrcToken& in_attribution_src_token, uint32_t in_expected_registrations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AttributionHost::NotifyNavigationWithBackgroundRegistrationsWillStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attribution_src_token"), in_attribution_src_token,
                        "<value of type const ::blink::AttributionSrcToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_registrations"), in_expected_registrations,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AttributionHost::kNotifyNavigationWithBackgroundRegistrationsWillStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->attribution_src_token)::BaseType> attribution_src_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AttributionSrcTokenDataView>(
    in_attribution_src_token,
    attribution_src_token_fragment);

  params->attribution_src_token.Set(
      attribution_src_token_fragment.is_null() ? nullptr : attribution_src_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attribution_src_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attribution_src_token in AttributionHost.NotifyNavigationWithBackgroundRegistrationsWillStart request");

  params->expected_registrations = in_expected_registrations;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AttributionHost::Name_);
  message.set_method_name("NotifyNavigationWithBackgroundRegistrationsWillStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AttributionHostStubDispatch::Accept(
    AttributionHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AttributionHost>(message->header()->name)) {
    case messages::AttributionHost::kRegisterDataHost: {
      DCHECK(message->is_serialized());
      internal::AttributionHost_RegisterDataHost_Params_Data* params =
          reinterpret_cast<internal::AttributionHost_RegisterDataHost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AttributionHost.0
      bool success = true;
      ::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost> p_data_host{};
      ::attribution_reporting::mojom::blink::RegistrationEligibility p_registration_eligibility{};
      bool p_is_for_background_requests{};
      ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> p_reporting_origins{};
      AttributionHost_RegisterDataHost_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_data_host =
            input_data_view.TakeDataHost<decltype(p_data_host)>();
      }
      if (success && !input_data_view.ReadRegistrationEligibility(&p_registration_eligibility))
        success = false;
      if (success)
        p_is_for_background_requests = input_data_view.is_for_background_requests();
      if (success && !input_data_view.ReadReportingOrigins(&p_reporting_origins))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AttributionHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterDataHost(        
        std::move(p_data_host), 
        std::move(p_registration_eligibility), 
        std::move(p_is_for_background_requests), 
        std::move(p_reporting_origins));
      return true;
    }
    case messages::AttributionHost::kRegisterNavigationDataHost: {
      DCHECK(message->is_serialized());
      internal::AttributionHost_RegisterNavigationDataHost_Params_Data* params =
          reinterpret_cast<internal::AttributionHost_RegisterNavigationDataHost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AttributionHost.1
      bool success = true;
      ::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost> p_data_host{};
      ::blink::AttributionSrcToken p_attribution_src_token{};
      AttributionHost_RegisterNavigationDataHost_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_data_host =
            input_data_view.TakeDataHost<decltype(p_data_host)>();
      }
      if (success && !input_data_view.ReadAttributionSrcToken(&p_attribution_src_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AttributionHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterNavigationDataHost(        
        std::move(p_data_host), 
        std::move(p_attribution_src_token));
      return true;
    }
    case messages::AttributionHost::kNotifyNavigationWithBackgroundRegistrationsWillStart: {
      DCHECK(message->is_serialized());
      internal::AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params_Data* params =
          reinterpret_cast<internal::AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AttributionHost.2
      bool success = true;
      ::blink::AttributionSrcToken p_attribution_src_token{};
      uint32_t p_expected_registrations{};
      AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAttributionSrcToken(&p_attribution_src_token))
        success = false;
      if (success)
        p_expected_registrations = input_data_view.expected_registrations();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AttributionHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyNavigationWithBackgroundRegistrationsWillStart(        
        std::move(p_attribution_src_token), 
        std::move(p_expected_registrations));
      return true;
    }
  }
  return false;
}

// static
bool AttributionHostStubDispatch::AcceptWithResponder(
    AttributionHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AttributionHost>(message->header()->name)) {
    case messages::AttributionHost::kRegisterDataHost: {
      break;
    }
    case messages::AttributionHost::kRegisterNavigationDataHost: {
      break;
    }
    case messages::AttributionHost::kNotifyNavigationWithBackgroundRegistrationsWillStart: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAttributionHostValidationInfo[] = {
    { &internal::AttributionHost_RegisterDataHost_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AttributionHost_RegisterNavigationDataHost_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AttributionHost_NotifyNavigationWithBackgroundRegistrationsWillStart_Params_Data::Validate,
     nullptr /* no response */},
};

bool AttributionHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AttributionHost::Name_,
    kAttributionHostValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::Impression::DataView, ::blink::mojom::blink::ImpressionPtr>::Read(
    ::blink::mojom::blink::Impression::DataView input,
    ::blink::mojom::blink::ImpressionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ImpressionPtr result(::blink::mojom::blink::Impression::New());
  
      if (success && !input.ReadAttributionSrcToken(&result->attribution_src_token))
        success = false;
      if (success)
        result->is_empty_attribution_src_tag = input.is_empty_attribution_src_tag();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void AttributionHostInterceptorForTesting::RegisterDataHost(::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost> data_host, ::attribution_reporting::mojom::blink::RegistrationEligibility registration_eligibility, bool is_for_background_requests, const ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& reporting_origins) {
  GetForwardingInterface()->RegisterDataHost(
    std::move(data_host)
    , 
    std::move(registration_eligibility)
    , 
    std::move(is_for_background_requests)
    , 
    std::move(reporting_origins)
    );
}
void AttributionHostInterceptorForTesting::RegisterNavigationDataHost(::mojo::PendingReceiver<::attribution_reporting::mojom::blink::DataHost> data_host, const ::blink::AttributionSrcToken& attribution_src_token) {
  GetForwardingInterface()->RegisterNavigationDataHost(
    std::move(data_host)
    , 
    std::move(attribution_src_token)
    );
}
void AttributionHostInterceptorForTesting::NotifyNavigationWithBackgroundRegistrationsWillStart(const ::blink::AttributionSrcToken& attribution_src_token, uint32_t expected_registrations) {
  GetForwardingInterface()->NotifyNavigationWithBackgroundRegistrationsWillStart(
    std::move(attribution_src_token)
    , 
    std::move(expected_registrations)
    );
}
AttributionHostAsyncWaiter::AttributionHostAsyncWaiter(
    AttributionHost* proxy) : proxy_(proxy) {}

AttributionHostAsyncWaiter::~AttributionHostAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif