// third_party/blink/public/mojom/context_menu/context_menu.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/annotation/annotation.mojom-shared.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"
#include "third_party/blink/public/mojom/forms/form_control_type.mojom-shared.h"
#include "ui/base/mojom/menu_source_type.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class AcceleratorDataView;

class FormRendererIdDataView;

class FieldRendererIdDataView;

class CustomContextMenuItemDataView;

class UntrustworthyContextMenuParamsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AcceleratorDataView> {
  using Data = ::blink::mojom::internal::Accelerator_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FormRendererIdDataView> {
  using Data = ::blink::mojom::internal::FormRendererId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FieldRendererIdDataView> {
  using Data = ::blink::mojom::internal::FieldRendererId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CustomContextMenuItemDataView> {
  using Data = ::blink::mojom::internal::CustomContextMenuItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::UntrustworthyContextMenuParamsDataView> {
  using Data = ::blink::mojom::internal::UntrustworthyContextMenuParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ContextMenuDataMediaType : int32_t {
  
  kNone = 0,
  
  kImage = 1,
  
  kVideo = 2,
  
  kAudio = 3,
  
  kCanvas = 4,
  
  kFile = 5,
  
  kPlugin = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ContextMenuDataMediaType value);
inline bool IsKnownEnumValue(ContextMenuDataMediaType value) {
  return internal::ContextMenuDataMediaType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CustomContextMenuItemType : int32_t {
  
  kOption = 0,
  
  kCheckableOption = 1,
  
  kGroup = 2,
  
  kSeparator = 3,
  
  kSubMenu = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CustomContextMenuItemType value);
inline bool IsKnownEnumValue(CustomContextMenuItemType value) {
  return internal::CustomContextMenuItemType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ContextMenuClientInterfaceBase {};

using ContextMenuClientPtrDataView =
    mojo::InterfacePtrDataView<ContextMenuClientInterfaceBase>;
using ContextMenuClientRequestDataView =
    mojo::InterfaceRequestDataView<ContextMenuClientInterfaceBase>;
using ContextMenuClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContextMenuClientInterfaceBase>;
using ContextMenuClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContextMenuClientInterfaceBase>;


class AcceleratorDataView {
 public:
  AcceleratorDataView() = default;

  AcceleratorDataView(
      internal::Accelerator_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t key_code() const {
    return data_->key_code;
  }
  int32_t modifiers() const {
    return data_->modifiers;
  }
 private:
  internal::Accelerator_Data* data_ = nullptr;
};


class FormRendererIdDataView {
 public:
  FormRendererIdDataView() = default;

  FormRendererIdDataView(
      internal::FormRendererId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
 private:
  internal::FormRendererId_Data* data_ = nullptr;
};


class FieldRendererIdDataView {
 public:
  FieldRendererIdDataView() = default;

  FieldRendererIdDataView(
      internal::FieldRendererId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t id() const {
    return data_->id;
  }
 private:
  internal::FieldRendererId_Data* data_ = nullptr;
};


class CustomContextMenuItemDataView {
 public:
  CustomContextMenuItemDataView() = default;

  CustomContextMenuItemDataView(
      internal::CustomContextMenuItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAcceleratorDataView(
      AcceleratorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccelerator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AcceleratorDataView, UserType>(),
    "Attempting to read the optional `accelerator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAccelerator` instead "
    "of `ReadAccelerator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->accelerator.Get();
    return mojo::internal::Deserialize<::blink::mojom::AcceleratorDataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetToolTipDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToolTip(UserType* output) {
    
    auto* pointer = data_->tool_tip.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::CustomContextMenuItemType>(
        data_value, output);
  }
  CustomContextMenuItemType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CustomContextMenuItemType>(data_->type));
  }
  int32_t action() const {
    return data_->action;
  }
  inline void GetFeatureNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatureName(UserType* output) {
    
    auto* pointer = data_->feature_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool is_experimental_feature() const {
    return data_->is_experimental_feature;
  }
  bool rtl() const {
    return data_->rtl;
  }
  bool has_directional_override() const {
    return data_->has_directional_override;
  }
  bool enabled() const {
    return data_->enabled;
  }
  bool checked() const {
    return data_->checked;
  }
  bool force_show_accelerator_for_item() const {
    return data_->force_show_accelerator_for_item;
  }
  inline void GetSubmenuDataView(
      mojo::ArrayDataView<CustomContextMenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubmenu(UserType* output) {
    
    auto* pointer = data_->submenu.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CustomContextMenuItemDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CustomContextMenuItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UntrustworthyContextMenuParamsDataView {
 public:
  UntrustworthyContextMenuParamsDataView() = default;

  UntrustworthyContextMenuParamsDataView(
      internal::UntrustworthyContextMenuParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMediaType(UserType* output) const {
    auto data_value = data_->media_type;
    return mojo::internal::Deserialize<::blink::mojom::ContextMenuDataMediaType>(
        data_value, output);
  }
  ContextMenuDataMediaType media_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ContextMenuDataMediaType>(data_->media_type));
  }
  int32_t x() const {
    return data_->x;
  }
  int32_t y() const {
    return data_->y;
  }
  inline void GetLinkUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinkUrl(UserType* output) {
    
    auto* pointer = data_->link_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLinkTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinkText(UserType* output) {
    
    auto* pointer = data_->link_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetImpressionDataView(
      ::blink::mojom::ImpressionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImpression(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ImpressionDataView, UserType>(),
    "Attempting to read the optional `impression` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImpression` instead "
    "of `ReadImpression if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->impression.Get();
    return mojo::internal::Deserialize<::blink::mojom::ImpressionDataView>(
        pointer, output, message_);
  }
  inline void GetUnfilteredLinkUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnfilteredLinkUrl(UserType* output) {
    
    auto* pointer = data_->unfiltered_link_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSrcUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrcUrl(UserType* output) {
    
    auto* pointer = data_->src_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool has_image_contents() const {
    return data_->has_image_contents;
  }
  bool is_image_media_plugin_document() const {
    return data_->is_image_media_plugin_document;
  }
  int32_t media_flags() const {
    return data_->media_flags;
  }
  inline void GetSelectionTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectionText(UserType* output) {
    
    auto* pointer = data_->selection_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetTitleTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitleText(UserType* output) {
    
    auto* pointer = data_->title_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAltTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAltText(UserType* output) {
    
    auto* pointer = data_->alt_text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSuggestedFilenameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestedFilename(UserType* output) {
    
    auto* pointer = data_->suggested_filename.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetMisspelledWordDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMisspelledWord(UserType* output) {
    
    auto* pointer = data_->misspelled_word.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDictionarySuggestionsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDictionarySuggestions(UserType* output) {
    
    auto* pointer = data_->dictionary_suggestions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  bool spellcheck_enabled() const {
    return data_->spellcheck_enabled;
  }
  bool is_editable() const {
    return data_->is_editable;
  }
  int32_t writing_direction_default() const {
    return data_->writing_direction_default;
  }
  int32_t writing_direction_left_to_right() const {
    return data_->writing_direction_left_to_right;
  }
  int32_t writing_direction_right_to_left() const {
    return data_->writing_direction_right_to_left;
  }
  int32_t edit_flags() const {
    return data_->edit_flags;
  }
  inline void GetFrameCharsetDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameCharset(UserType* output) {
    
    auto* pointer = data_->frame_charset.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetLinkFollowedDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinkFollowed(UserType* output) {
    
    auto* pointer = data_->link_followed.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetCustomItemsDataView(
      mojo::ArrayDataView<CustomContextMenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCustomItems(UserType* output) {
    
    auto* pointer = data_->custom_items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CustomContextMenuItemDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceType(UserType* output) const {
    auto data_value = data_->source_type;
    return mojo::internal::Deserialize<::ui::mojom::MenuSourceType>(
        data_value, output);
  }
  ::ui::mojom::MenuSourceType source_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::MenuSourceType>(data_->source_type));
  }
  inline void GetSelectionRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectionRect(UserType* output) {
    
    auto* pointer = data_->selection_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  int32_t selection_start_offset() const {
    return data_->selection_start_offset;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAnnotationType(UserType* output) const {
    if (!data_->annotation_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::AnnotationType>(
        data_->annotation_type_$value, &output->emplace());
  }
  std::optional<::blink::mojom::AnnotationType> annotation_type() const {
    if (!data_->annotation_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AnnotationType>(data_->annotation_type_$value));
  }
  bool opened_from_interest_for() const {
    return data_->opened_from_interest_for;
  }
  int32_t interest_for_node_id() const {
    return data_->interest_for_node_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFormControlType(UserType* output) const {
    if (!data_->form_control_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::blink::mojom::FormControlType>(
        data_->form_control_type_$value, &output->emplace());
  }
  std::optional<::blink::mojom::FormControlType> form_control_type() const {
    if (!data_->form_control_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FormControlType>(data_->form_control_type_$value));
  }
  bool is_content_editable_for_autofill() const {
    return data_->is_content_editable_for_autofill;
  }
  inline void GetFieldRendererIdDataView(
      FieldRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldRendererId(UserType* output) {
    
    auto* pointer = data_->field_renderer_id.Get();
    return mojo::internal::Deserialize<::blink::mojom::FieldRendererIdDataView>(
        pointer, output, message_);
  }
  inline void GetFormRendererIdDataView(
      FormRendererIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormRendererId(UserType* output) {
    
    auto* pointer = data_->form_renderer_id.Get();
    return mojo::internal::Deserialize<::blink::mojom::FormRendererIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::UntrustworthyContextMenuParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_DATA_VIEW_H_