// third_party/blink/public/mojom/content_extraction/ai_page_content.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Role as ax_mojom_Role,
  RoleSpec as ax_mojom_RoleSpec
} from '../../../../../ui/accessibility/ax_enums.mojom.m.js';

import {
  Point as gfx_mojom_Point,
  PointSpec as gfx_mojom_PointSpec,
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  FormControlType as blink_mojom_FormControlType,
  FormControlTypeSpec as blink_mojom_FormControlTypeSpec
} from '../forms/form_control_type.mojom.m.js';

import {
  FrameToken as blink_mojom_FrameToken,
  FrameTokenSpec as blink_mojom_FrameTokenSpec
} from '../tokens/tokens.mojom.m.js';

import {
  ScriptTool as blink_mojom_ScriptTool,
  ScriptToolSpec as blink_mojom_ScriptToolSpec
} from './script_tools.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIPageContentAttributeTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIPageContentAttributeType = {
  
  kRoot: 0,
  kIframe: 1,
  kContainer: 2,
  kText: 3,
  kAnchor: 4,
  kParagraph: 5,
  kHeading: 6,
  kImage: 7,
  kSVG: 8,
  kCanvas: 9,
  kVideo: 10,
  kForm: 11,
  kFormControl: 12,
  kTable: 13,
  kTableRow: 14,
  kTableCell: 15,
  kOrderedList: 16,
  kUnorderedList: 17,
  kListItem: 18,
  MIN_VALUE: 0,
  MAX_VALUE: 18,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIPageContentAnnotatedRoleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIPageContentAnnotatedRole = {
  
  kHeader: 0,
  kNav: 1,
  kSearch: 2,
  kMain: 3,
  kArticle: 4,
  kSection: 5,
  kAside: 6,
  kFooter: 7,
  kContentHidden: 8,
  kPaidContent: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIPageContentClickabilityReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIPageContentClickabilityReason = {
  
  kClickableControl: 0,
  kClickEvents: 1,
  kMouseEvents: 2,
  kMouseClick: 3,
  kMouseHover: 4,
  kKeyEvents: 5,
  kEditable: 6,
  kCursorPointer: 7,
  kAriaRole: 8,
  kAriaHasPopup: 9,
  kAriaExpandedTrue: 10,
  kAriaExpandedFalse: 11,
  kTabIndex: 12,
  kAutocomplete: 13,
  kHoverPseudoClass: 14,
  MIN_VALUE: 0,
  MAX_VALUE: 14,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIPageContentTextSizeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIPageContentTextSize = {
  
  kXS: 0,
  kS: 1,
  kM: 2,
  kL: 3,
  kXL: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIPageContentAnchorRelSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIPageContentAnchorRel = {
  
  kRelationUnknown: 0,
  kRelationNoReferrer: 1,
  kRelationNoOpener: 2,
  kRelationOpener: 3,
  kRelationPrivacyPolicy: 4,
  kRelationTermsOfService: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIPageContentTableRowTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIPageContentTableRowType = {
  
  kHeader: 0,
  kBody: 1,
  kFooter: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIPageContentRedactionDecisionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIPageContentRedactionDecision = {
  
  kNoRedactionNecessary: 0,
  kUnredacted_EmptyPassword: 1,
  kRedacted_HasBeenPassword: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIPageContentModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIPageContentMode = {
  
  kDefault: 0,
  kActionableElements: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AIPageContentAgentPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AIPageContentAgent', scope);
  }
}

/** @interface */
export class AIPageContentAgentInterface {
  
  /**
   * @param { !AIPageContentOptions } request
   * @return {!Promise<{
        pageContent: ?AIPageContent,
   *  }>}
   */

  getAIPageContent(request) {}
}

/**
 * @implements { AIPageContentAgentInterface }
 */
export class AIPageContentAgentRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AIPageContentAgentPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AIPageContentAgentPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AIPageContentAgentPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AIPageContentOptions } request
   * @return {!Promise<{
        pageContent: ?AIPageContent,
   *  }>}
   */

  getAIPageContent(
      request) {
    return this.proxy.sendMessage(
        0,
        AIPageContentAgent_GetAIPageContent_ParamsSpec.$,
        AIPageContentAgent_GetAIPageContent_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AIPageContentAgent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AIPageContentAgentReceiver {
  /**
   * @param {!AIPageContentAgentInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AIPageContentAgentRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AIPageContentAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIPageContentAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AIPageContentAgent_GetAIPageContent_ParamsSpec.$,
        AIPageContentAgent_GetAIPageContent_ResponseParamsSpec.$,
        impl.getAIPageContent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AIPageContentAgent {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIPageContentAgent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AIPageContentAgentRemote}
   */
  static getRemote() {
    let remote = new AIPageContentAgentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AIPageContentAgent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AIPageContentAgentCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AIPageContentAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIPageContentAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAIPageContent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AIPageContentAgent_GetAIPageContent_ParamsSpec.$,
        AIPageContentAgent_GetAIPageContent_ResponseParamsSpec.$,
        this.getAIPageContent.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentGeometrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentSelectionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentPageInteractionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentFrameInteractionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentNodeInteractionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentScrollerInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentTextStyleSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentTextInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentAnchorDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentImageInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentSVGDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentCanvasDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentVideoDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentMetaSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentFrameDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RedactedFrameMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentIframeDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentTableDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentTableRowDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentFormDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentSelectOptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentFormControlDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentNodeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentPopupSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentAgent_GetAIPageContent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIPageContentAgent_GetAIPageContent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AIPageContentIframeContentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AIPageContentGeometrySpec.$,
    'AIPageContentGeometry',
    [
      mojo.internal.StructField(
        'outerBoundingBox', 0,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'visibleBoundingBox', 8,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fragmentVisibleBoundingBoxes', 16,
        0,
        mojo.internal.Array(gfx_mojom_RectSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isFixedOrStickyPosition', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AIPageContentGeometry {
  constructor() {
    /** @type { !gfx_mojom_Rect } */
    this.outerBoundingBox;
    /** @type { !gfx_mojom_Rect } */
    this.visibleBoundingBox;
    /** @type { !Array<!gfx_mojom_Rect> } */
    this.fragmentVisibleBoundingBoxes;
    /** @type { !boolean } */
    this.isFixedOrStickyPosition;
  }
}



mojo.internal.Struct(
    AIPageContentSelectionSpec.$,
    'AIPageContentSelection',
    [
      mojo.internal.StructField(
        'startDomNodeId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startOffset', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endDomNodeId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endOffset', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectedText', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AIPageContentSelection {
  constructor() {
    /** @type { !number } */
    this.startDomNodeId;
    /** @type { !number } */
    this.startOffset;
    /** @type { !number } */
    this.endDomNodeId;
    /** @type { !number } */
    this.endOffset;
    /** @type { !string } */
    this.selectedText;
  }
}



mojo.internal.Struct(
    AIPageContentPageInteractionInfoSpec.$,
    'AIPageContentPageInteractionInfo',
    [
      mojo.internal.StructField(
        'focused_dom_node_id_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "focused_dom_node_id_$value",
          originalFieldName: "focusedDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'focused_dom_node_id_$value', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "focusedDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'accessibility_focused_dom_node_id_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "accessibility_focused_dom_node_id_$value",
          originalFieldName: "accessibilityFocusedDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'accessibility_focused_dom_node_id_$value', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "accessibilityFocusedDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'mousePosition', 16,
        0,
        gfx_mojom_PointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AIPageContentPageInteractionInfo {
  constructor() {
    /** @type { (number|undefined) } */
    this.focusedDomNodeId;
    /** @type { (number|undefined) } */
    this.accessibilityFocusedDomNodeId;
    /** @type { (gfx_mojom_Point|undefined) } */
    this.mousePosition;
  }
}



mojo.internal.Struct(
    AIPageContentFrameInteractionInfoSpec.$,
    'AIPageContentFrameInteractionInfo',
    [
      mojo.internal.StructField(
        'selection', 0,
        0,
        AIPageContentSelectionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIPageContentFrameInteractionInfo {
  constructor() {
    /** @type { (AIPageContentSelection|undefined) } */
    this.selection;
  }
}



mojo.internal.Struct(
    AIPageContentNodeInteractionInfoSpec.$,
    'AIPageContentNodeInteractionInfo',
    [
      mojo.internal.StructField(
        'scrollerInfo', 0,
        0,
        AIPageContentScrollerInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isFocusable', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isClickable', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'document_scoped_z_order_$flag', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "document_scoped_z_order_$value",
          originalFieldName: "documentScopedZOrder",
        }
      ),
      mojo.internal.StructField(
        'document_scoped_z_order_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "documentScopedZOrder",
        }
      ),
      mojo.internal.StructField(
        'clickabilityReasons', 16,
        0,
        mojo.internal.Array(AIPageContentClickabilityReasonSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isDisabled', 8,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AIPageContentNodeInteractionInfo {
  constructor() {
    /** @type { (AIPageContentScrollerInfo|undefined) } */
    this.scrollerInfo;
    /** @type { !boolean } */
    this.isFocusable;
    /** @type { !boolean } */
    this.isClickable;
    /** @type { (number|undefined) } */
    this.documentScopedZOrder;
    /** @type { !Array<!AIPageContentClickabilityReason> } */
    this.clickabilityReasons;
    /** @type { !boolean } */
    this.isDisabled;
  }
}



mojo.internal.Struct(
    AIPageContentScrollerInfoSpec.$,
    'AIPageContentScrollerInfo',
    [
      mojo.internal.StructField(
        'scrollingBounds', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'visibleArea', 8,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userScrollableHorizontal', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userScrollableVertical', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AIPageContentScrollerInfo {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.scrollingBounds;
    /** @type { !gfx_mojom_Rect } */
    this.visibleArea;
    /** @type { !boolean } */
    this.userScrollableHorizontal;
    /** @type { !boolean } */
    this.userScrollableVertical;
  }
}



mojo.internal.Struct(
    AIPageContentTextStyleSpec.$,
    'AIPageContentTextStyle',
    [
      mojo.internal.StructField(
        'textSize', 0,
        0,
        AIPageContentTextSizeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasEmphasis', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'color', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIPageContentTextStyle {
  constructor() {
    /** @type { !AIPageContentTextSize } */
    this.textSize;
    /** @type { !boolean } */
    this.hasEmphasis;
    /** @type { !number } */
    this.color;
  }
}



mojo.internal.Struct(
    AIPageContentTextInfoSpec.$,
    'AIPageContentTextInfo',
    [
      mojo.internal.StructField(
        'textContent', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textStyle', 8,
        0,
        AIPageContentTextStyleSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIPageContentTextInfo {
  constructor() {
    /** @type { !string } */
    this.textContent;
    /** @type { !AIPageContentTextStyle } */
    this.textStyle;
  }
}



mojo.internal.Struct(
    AIPageContentAnchorDataSpec.$,
    'AIPageContentAnchorData',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rel', 8,
        0,
        mojo.internal.Array(AIPageContentAnchorRelSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIPageContentAnchorData {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !Array<!AIPageContentAnchorRel> } */
    this.rel;
  }
}



mojo.internal.Struct(
    AIPageContentImageInfoSpec.$,
    'AIPageContentImageInfo',
    [
      mojo.internal.StructField(
        'imageCaption', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIPageContentImageInfo {
  constructor() {
    /** @type { (string|undefined) } */
    this.imageCaption;
    /** @type { (url_mojom_Origin|undefined) } */
    this.sourceOrigin;
  }
}



mojo.internal.Struct(
    AIPageContentSVGDataSpec.$,
    'AIPageContentSVGData',
    [
      mojo.internal.StructField(
        'innerText', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIPageContentSVGData {
  constructor() {
    /** @type { (string|undefined) } */
    this.innerText;
  }
}



mojo.internal.Struct(
    AIPageContentCanvasDataSpec.$,
    'AIPageContentCanvasData',
    [
      mojo.internal.StructField(
        'layoutSize', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIPageContentCanvasData {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.layoutSize;
  }
}



mojo.internal.Struct(
    AIPageContentVideoDataSpec.$,
    'AIPageContentVideoData',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIPageContentVideoData {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { (url_mojom_Origin|undefined) } */
    this.sourceOrigin;
  }
}



mojo.internal.Struct(
    AIPageContentMetaSpec.$,
    'AIPageContentMeta',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'content', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIPageContentMeta {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.content;
  }
}



mojo.internal.Struct(
    AIPageContentFrameDataSpec.$,
    'AIPageContentFrameData',
    [
      mojo.internal.StructField(
        'frameInteractionInfo', 0,
        0,
        AIPageContentFrameInteractionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metaData', 8,
        0,
        mojo.internal.Array(AIPageContentMetaSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'title', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contains_paid_content_$flag', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "contains_paid_content_$value",
          originalFieldName: "containsPaidContent",
        }
      ),
      mojo.internal.StructField(
        'contains_paid_content_$value', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "containsPaidContent",
        }
      ),
      mojo.internal.StructField(
        'scriptTools', 32,
        0,
        mojo.internal.Array(blink_mojom_ScriptToolSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'popup', 40,
        0,
        AIPageContentPopupSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class AIPageContentFrameData {
  constructor() {
    /** @type { !AIPageContentFrameInteractionInfo } */
    this.frameInteractionInfo;
    /** @type { !Array<!AIPageContentMeta> } */
    this.metaData;
    /** @type { (string|undefined) } */
    this.title;
    /** @type { (boolean|undefined) } */
    this.containsPaidContent;
    /** @type { !Array<!blink_mojom_ScriptTool> } */
    this.scriptTools;
    /** @type { (AIPageContentPopup|undefined) } */
    this.popup;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RedactedFrameMetadata_ReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RedactedFrameMetadata_Reason = {
  
  kCrossSite: 0,
  kCrossOrigin: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    RedactedFrameMetadataSpec.$,
    'RedactedFrameMetadata',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        RedactedFrameMetadata_ReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RedactedFrameMetadata {
  constructor() {
    /** @type { !RedactedFrameMetadata_Reason } */
    this.reason;
  }
}



mojo.internal.Struct(
    AIPageContentIframeDataSpec.$,
    'AIPageContentIframeData',
    [
      mojo.internal.StructField(
        'frameToken', 0,
        0,
        blink_mojom_FrameTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'content', 16,
        0,
        AIPageContentIframeContentSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AIPageContentIframeData {
  constructor() {
    /** @type { !blink_mojom_FrameToken } */
    this.frameToken;
    /** @type { (AIPageContentIframeContent|undefined) } */
    this.content;
  }
}



mojo.internal.Struct(
    AIPageContentTableDataSpec.$,
    'AIPageContentTableData',
    [
      mojo.internal.StructField(
        'tableName', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIPageContentTableData {
  constructor() {
    /** @type { (string|undefined) } */
    this.tableName;
  }
}



mojo.internal.Struct(
    AIPageContentTableRowDataSpec.$,
    'AIPageContentTableRowData',
    [
      mojo.internal.StructField(
        'rowType', 0,
        0,
        AIPageContentTableRowTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIPageContentTableRowData {
  constructor() {
    /** @type { !AIPageContentTableRowType } */
    this.rowType;
  }
}



mojo.internal.Struct(
    AIPageContentFormDataSpec.$,
    'AIPageContentFormData',
    [
      mojo.internal.StructField(
        'formName', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'actionUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIPageContentFormData {
  constructor() {
    /** @type { (string|undefined) } */
    this.formName;
    /** @type { (url_mojom_Url|undefined) } */
    this.actionUrl;
  }
}



mojo.internal.Struct(
    AIPageContentSelectOptionSpec.$,
    'AIPageContentSelectOption',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSelected', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'disabled', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AIPageContentSelectOption {
  constructor() {
    /** @type { (string|undefined) } */
    this.value;
    /** @type { (string|undefined) } */
    this.text;
    /** @type { !boolean } */
    this.isSelected;
    /** @type { !boolean } */
    this.disabled;
  }
}



mojo.internal.Struct(
    AIPageContentFormControlDataSpec.$,
    'AIPageContentFormControlData',
    [
      mojo.internal.StructField(
        'formControlType', 0,
        0,
        blink_mojom_FormControlTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fieldName', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fieldValue', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectOptions', 24,
        0,
        mojo.internal.Array(AIPageContentSelectOptionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'placeholder', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isChecked', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isRequired', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'redactionDecision', 40,
        0,
        AIPageContentRedactionDecisionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class AIPageContentFormControlData {
  constructor() {
    /** @type { !blink_mojom_FormControlType } */
    this.formControlType;
    /** @type { (string|undefined) } */
    this.fieldName;
    /** @type { (string|undefined) } */
    this.fieldValue;
    /** @type { !Array<!AIPageContentSelectOption> } */
    this.selectOptions;
    /** @type { (string|undefined) } */
    this.placeholder;
    /** @type { !boolean } */
    this.isChecked;
    /** @type { !boolean } */
    this.isRequired;
    /** @type { !AIPageContentRedactionDecision } */
    this.redactionDecision;
  }
}



mojo.internal.Struct(
    AIPageContentAttributesSpec.$,
    'AIPageContentAttributes',
    [
      mojo.internal.StructField(
        'dom_node_id_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "dom_node_id_$value",
          originalFieldName: "domNodeId",
        }
      ),
      mojo.internal.StructField(
        'dom_node_id_$value', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "domNodeId",
        }
      ),
      mojo.internal.StructField(
        'attributeType', 8,
        0,
        AIPageContentAttributeTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'geometry', 16,
        0,
        AIPageContentGeometrySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nodeInteractionInfo', 24,
        0,
        AIPageContentNodeInteractionInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textInfo', 32,
        0,
        AIPageContentTextInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'imageInfo', 40,
        0,
        AIPageContentImageInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'svgData', 48,
        0,
        AIPageContentSVGDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'canvasData', 56,
        0,
        AIPageContentCanvasDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'videoData', 64,
        0,
        AIPageContentVideoDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'anchorData', 72,
        0,
        AIPageContentAnchorDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'formData', 80,
        0,
        AIPageContentFormDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'formControlData', 88,
        0,
        AIPageContentFormControlDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tableData', 96,
        0,
        AIPageContentTableDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'iframeData', 104,
        0,
        AIPageContentIframeDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tableRowData', 112,
        0,
        AIPageContentTableRowDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'annotatedRoles', 120,
        0,
        mojo.internal.Array(AIPageContentAnnotatedRoleSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 128,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'aria_role_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "aria_role_$value",
          originalFieldName: "ariaRole",
        }
      ),
      mojo.internal.StructField(
        'aria_role_$value', 12,
        0,
        ax_mojom_RoleSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "ariaRole",
        }
      ),
      mojo.internal.StructField(
        'label_for_dom_node_id_$flag', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "label_for_dom_node_id_$value",
          originalFieldName: "labelForDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'label_for_dom_node_id_$value', 136,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "labelForDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'isAdRelated', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 152],]);



/**
 * @record
 */
export class AIPageContentAttributes {
  constructor() {
    /** @type { (number|undefined) } */
    this.domNodeId;
    /** @type { !AIPageContentAttributeType } */
    this.attributeType;
    /** @type { (AIPageContentGeometry|undefined) } */
    this.geometry;
    /** @type { (AIPageContentNodeInteractionInfo|undefined) } */
    this.nodeInteractionInfo;
    /** @type { (AIPageContentTextInfo|undefined) } */
    this.textInfo;
    /** @type { (AIPageContentImageInfo|undefined) } */
    this.imageInfo;
    /** @type { (AIPageContentSVGData|undefined) } */
    this.svgData;
    /** @type { (AIPageContentCanvasData|undefined) } */
    this.canvasData;
    /** @type { (AIPageContentVideoData|undefined) } */
    this.videoData;
    /** @type { (AIPageContentAnchorData|undefined) } */
    this.anchorData;
    /** @type { (AIPageContentFormData|undefined) } */
    this.formData;
    /** @type { (AIPageContentFormControlData|undefined) } */
    this.formControlData;
    /** @type { (AIPageContentTableData|undefined) } */
    this.tableData;
    /** @type { (AIPageContentIframeData|undefined) } */
    this.iframeData;
    /** @type { (AIPageContentTableRowData|undefined) } */
    this.tableRowData;
    /** @type { !Array<!AIPageContentAnnotatedRole> } */
    this.annotatedRoles;
    /** @type { (string|undefined) } */
    this.label;
    /** @type { (ax_mojom_Role|undefined) } */
    this.ariaRole;
    /** @type { (number|undefined) } */
    this.labelForDomNodeId;
    /** @type { !boolean } */
    this.isAdRelated;
  }
}



mojo.internal.Struct(
    AIPageContentNodeSpec.$,
    'AIPageContentNode',
    [
      mojo.internal.StructField(
        'childrenNodes', 0,
        0,
        mojo.internal.Array(AIPageContentNodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentAttributes', 8,
        0,
        AIPageContentAttributesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIPageContentNode {
  constructor() {
    /** @type { !Array<!AIPageContentNode> } */
    this.childrenNodes;
    /** @type { !AIPageContentAttributes } */
    this.contentAttributes;
  }
}



mojo.internal.Struct(
    AIPageContentPopupSpec.$,
    'AIPageContentPopup',
    [
      mojo.internal.StructField(
        'rootNode', 0,
        0,
        AIPageContentNodeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'openerDomNodeId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIPageContentPopup {
  constructor() {
    /** @type { !AIPageContentNode } */
    this.rootNode;
    /** @type { !number } */
    this.openerDomNodeId;
  }
}



mojo.internal.Struct(
    AIPageContentSpec.$,
    'AIPageContent',
    [
      mojo.internal.StructField(
        'rootNode', 0,
        0,
        AIPageContentNodeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pageInteractionInfo', 8,
        0,
        AIPageContentPageInteractionInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameData', 16,
        0,
        AIPageContentFrameDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AIPageContent {
  constructor() {
    /** @type { !AIPageContentNode } */
    this.rootNode;
    /** @type { (AIPageContentPageInteractionInfo|undefined) } */
    this.pageInteractionInfo;
    /** @type { !AIPageContentFrameData } */
    this.frameData;
  }
}



mojo.internal.Struct(
    AIPageContentOptionsSpec.$,
    'AIPageContentOptions',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        AIPageContentModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'onCriticalPath', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxMetaElements', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeSameSiteOnly', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mainFrameViewRectInDips', 16,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AIPageContentOptions {
  constructor() {
    /** @type { !AIPageContentMode } */
    this.mode;
    /** @type { !boolean } */
    this.onCriticalPath;
    /** @type { !number } */
    this.maxMetaElements;
    /** @type { !boolean } */
    this.includeSameSiteOnly;
    /** @type { !gfx_mojom_Rect } */
    this.mainFrameViewRectInDips;
  }
}



mojo.internal.Struct(
    AIPageContentAgent_GetAIPageContent_ParamsSpec.$,
    'AIPageContentAgent_GetAIPageContent_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        AIPageContentOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIPageContentAgent_GetAIPageContent_Params {
  constructor() {
    /** @type { !AIPageContentOptions } */
    this.request;
  }
}



mojo.internal.Struct(
    AIPageContentAgent_GetAIPageContent_ResponseParamsSpec.$,
    'AIPageContentAgent_GetAIPageContent_ResponseParams',
    [
      mojo.internal.StructField(
        'pageContent', 0,
        0,
        AIPageContentSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIPageContentAgent_GetAIPageContent_ResponseParams {
  constructor() {
    /** @type { (AIPageContent|undefined) } */
    this.pageContent;
  }
}

mojo.internal.Union(
    AIPageContentIframeContentSpec.$, 'AIPageContentIframeContent',
    {
      'localFrameData': {
        'ordinal': 0,
        'type': AIPageContentFrameDataSpec.$,
      },
      'redactedFrameMetadata': {
        'ordinal': 1,
        'type': RedactedFrameMetadataSpec.$,
      },
    });

/**
 * @typedef { {
 *   localFrameData: (!AIPageContentFrameData|undefined),
 *   redactedFrameMetadata: (!RedactedFrameMetadata|undefined),
 * } }
 */
export const AIPageContentIframeContent = {};
