// third_party/blink/public/mojom/content_extraction/ai_page_content.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-params-data.h"
#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-import-headers.h"
#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-test-utils.h"


namespace blink::mojom {
AIPageContentGeometry::AIPageContentGeometry()
    : outer_bounding_box(),
      visible_bounding_box(),
      fragment_visible_bounding_boxes(),
      is_fixed_or_sticky_position() {}

AIPageContentGeometry::AIPageContentGeometry(
    const ::gfx::Rect& outer_bounding_box_in,
    const ::gfx::Rect& visible_bounding_box_in,
    std::vector<::gfx::Rect> fragment_visible_bounding_boxes_in,
    bool is_fixed_or_sticky_position_in)
    : outer_bounding_box(std::move(outer_bounding_box_in)),
      visible_bounding_box(std::move(visible_bounding_box_in)),
      fragment_visible_bounding_boxes(std::move(fragment_visible_bounding_boxes_in)),
      is_fixed_or_sticky_position(std::move(is_fixed_or_sticky_position_in)) {}

AIPageContentGeometry::~AIPageContentGeometry() = default;

void AIPageContentGeometry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outer_bounding_box"), this->outer_bounding_box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_bounding_box"), this->visible_bounding_box,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fragment_visible_bounding_boxes"), this->fragment_visible_bounding_boxes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_fixed_or_sticky_position"), this->is_fixed_or_sticky_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentGeometry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentSelection::AIPageContentSelection()
    : start_dom_node_id(),
      start_offset(),
      end_dom_node_id(),
      end_offset(),
      selected_text() {}

AIPageContentSelection::AIPageContentSelection(
    int32_t start_dom_node_id_in,
    int32_t start_offset_in,
    int32_t end_dom_node_id_in,
    int32_t end_offset_in,
    const std::string& selected_text_in)
    : start_dom_node_id(std::move(start_dom_node_id_in)),
      start_offset(std::move(start_offset_in)),
      end_dom_node_id(std::move(end_dom_node_id_in)),
      end_offset(std::move(end_offset_in)),
      selected_text(std::move(selected_text_in)) {}

AIPageContentSelection::~AIPageContentSelection() = default;
size_t AIPageContentSelection::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->start_dom_node_id);
  seed = mojo::internal::Hash(seed, this->start_offset);
  seed = mojo::internal::Hash(seed, this->end_dom_node_id);
  seed = mojo::internal::Hash(seed, this->end_offset);
  seed = mojo::internal::Hash(seed, this->selected_text);
  return seed;
}

void AIPageContentSelection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_dom_node_id"), this->start_dom_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_offset"), this->start_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_dom_node_id"), this->end_dom_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_offset"), this->end_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_text"), this->selected_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentSelection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentPageInteractionInfo::AIPageContentPageInteractionInfo()
    : focused_dom_node_id(),
      accessibility_focused_dom_node_id(),
      mouse_position() {}

AIPageContentPageInteractionInfo::AIPageContentPageInteractionInfo(
    std::optional<int32_t> focused_dom_node_id_in,
    std::optional<int32_t> accessibility_focused_dom_node_id_in,
    const std::optional<::gfx::Point>& mouse_position_in)
    : focused_dom_node_id(std::move(focused_dom_node_id_in)),
      accessibility_focused_dom_node_id(std::move(accessibility_focused_dom_node_id_in)),
      mouse_position(std::move(mouse_position_in)) {}

AIPageContentPageInteractionInfo::~AIPageContentPageInteractionInfo() = default;

void AIPageContentPageInteractionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "focused_dom_node_id"), this->focused_dom_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accessibility_focused_dom_node_id"), this->accessibility_focused_dom_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mouse_position"), this->mouse_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Point>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentPageInteractionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentFrameInteractionInfo::AIPageContentFrameInteractionInfo()
    : selection() {}

AIPageContentFrameInteractionInfo::AIPageContentFrameInteractionInfo(
    AIPageContentSelectionPtr selection_in)
    : selection(std::move(selection_in)) {}

AIPageContentFrameInteractionInfo::~AIPageContentFrameInteractionInfo() = default;

void AIPageContentFrameInteractionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection"), this->selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentSelectionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentFrameInteractionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentNodeInteractionInfo::AIPageContentNodeInteractionInfo()
    : scroller_info(),
      is_focusable(),
      is_clickable(),
      document_scoped_z_order(),
      clickability_reasons(),
      is_disabled() {}

AIPageContentNodeInteractionInfo::AIPageContentNodeInteractionInfo(
    AIPageContentScrollerInfoPtr scroller_info_in,
    bool is_focusable_in,
    bool is_clickable_in,
    std::optional<int32_t> document_scoped_z_order_in,
    std::vector<AIPageContentClickabilityReason> clickability_reasons_in,
    bool is_disabled_in)
    : scroller_info(std::move(scroller_info_in)),
      is_focusable(std::move(is_focusable_in)),
      is_clickable(std::move(is_clickable_in)),
      document_scoped_z_order(std::move(document_scoped_z_order_in)),
      clickability_reasons(std::move(clickability_reasons_in)),
      is_disabled(std::move(is_disabled_in)) {}

AIPageContentNodeInteractionInfo::~AIPageContentNodeInteractionInfo() = default;

void AIPageContentNodeInteractionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroller_info"), this->scroller_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentScrollerInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_focusable"), this->is_focusable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_clickable"), this->is_clickable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_scoped_z_order"), this->document_scoped_z_order,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clickability_reasons"), this->clickability_reasons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<AIPageContentClickabilityReason>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_disabled"), this->is_disabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentNodeInteractionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentScrollerInfo::AIPageContentScrollerInfo()
    : scrolling_bounds(),
      visible_area(),
      user_scrollable_horizontal(),
      user_scrollable_vertical() {}

AIPageContentScrollerInfo::AIPageContentScrollerInfo(
    const ::gfx::Size& scrolling_bounds_in,
    const ::gfx::Rect& visible_area_in,
    bool user_scrollable_horizontal_in,
    bool user_scrollable_vertical_in)
    : scrolling_bounds(std::move(scrolling_bounds_in)),
      visible_area(std::move(visible_area_in)),
      user_scrollable_horizontal(std::move(user_scrollable_horizontal_in)),
      user_scrollable_vertical(std::move(user_scrollable_vertical_in)) {}

AIPageContentScrollerInfo::~AIPageContentScrollerInfo() = default;

void AIPageContentScrollerInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrolling_bounds"), this->scrolling_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_area"), this->visible_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_scrollable_horizontal"), this->user_scrollable_horizontal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_scrollable_vertical"), this->user_scrollable_vertical,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentScrollerInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentTextStyle::AIPageContentTextStyle()
    : text_size(),
      has_emphasis(),
      color() {}

AIPageContentTextStyle::AIPageContentTextStyle(
    AIPageContentTextSize text_size_in,
    bool has_emphasis_in,
    uint32_t color_in)
    : text_size(std::move(text_size_in)),
      has_emphasis(std::move(has_emphasis_in)),
      color(std::move(color_in)) {}

AIPageContentTextStyle::~AIPageContentTextStyle() = default;
size_t AIPageContentTextStyle::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->text_size);
  seed = mojo::internal::Hash(seed, this->has_emphasis);
  seed = mojo::internal::Hash(seed, this->color);
  return seed;
}

void AIPageContentTextStyle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_size"), this->text_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentTextSize>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_emphasis"), this->has_emphasis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentTextStyle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentTextInfo::AIPageContentTextInfo()
    : text_content(),
      text_style() {}

AIPageContentTextInfo::AIPageContentTextInfo(
    const std::string& text_content_in,
    AIPageContentTextStylePtr text_style_in)
    : text_content(std::move(text_content_in)),
      text_style(std::move(text_style_in)) {}

AIPageContentTextInfo::~AIPageContentTextInfo() = default;
size_t AIPageContentTextInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->text_content);
  seed = mojo::internal::Hash(seed, this->text_style);
  return seed;
}

void AIPageContentTextInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_content"), this->text_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_style"), this->text_style,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentTextStylePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentTextInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentAnchorData::AIPageContentAnchorData()
    : url(),
      rel() {}

AIPageContentAnchorData::AIPageContentAnchorData(
    const ::GURL& url_in,
    std::vector<AIPageContentAnchorRel> rel_in)
    : url(std::move(url_in)),
      rel(std::move(rel_in)) {}

AIPageContentAnchorData::~AIPageContentAnchorData() = default;

void AIPageContentAnchorData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rel"), this->rel,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<AIPageContentAnchorRel>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentAnchorData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentImageInfo::AIPageContentImageInfo()
    : image_caption(),
      source_origin() {}

AIPageContentImageInfo::AIPageContentImageInfo(
    const std::optional<std::string>& image_caption_in,
    const std::optional<::url::Origin>& source_origin_in)
    : image_caption(std::move(image_caption_in)),
      source_origin(std::move(source_origin_in)) {}

AIPageContentImageInfo::~AIPageContentImageInfo() = default;

void AIPageContentImageInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_caption"), this->image_caption,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_origin"), this->source_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentImageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentSVGData::AIPageContentSVGData()
    : inner_text() {}

AIPageContentSVGData::AIPageContentSVGData(
    const std::optional<std::string>& inner_text_in)
    : inner_text(std::move(inner_text_in)) {}

AIPageContentSVGData::~AIPageContentSVGData() = default;

void AIPageContentSVGData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inner_text"), this->inner_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentSVGData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentCanvasData::AIPageContentCanvasData()
    : layout_size() {}

AIPageContentCanvasData::AIPageContentCanvasData(
    const ::gfx::Size& layout_size_in)
    : layout_size(std::move(layout_size_in)) {}

AIPageContentCanvasData::~AIPageContentCanvasData() = default;

void AIPageContentCanvasData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout_size"), this->layout_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentCanvasData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentVideoData::AIPageContentVideoData()
    : url(),
      source_origin() {}

AIPageContentVideoData::AIPageContentVideoData(
    const ::GURL& url_in,
    const std::optional<::url::Origin>& source_origin_in)
    : url(std::move(url_in)),
      source_origin(std::move(source_origin_in)) {}

AIPageContentVideoData::~AIPageContentVideoData() = default;

void AIPageContentVideoData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_origin"), this->source_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentVideoData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentMeta::AIPageContentMeta()
    : name(),
      content() {}

AIPageContentMeta::AIPageContentMeta(
    const std::string& name_in,
    const std::string& content_in)
    : name(std::move(name_in)),
      content(std::move(content_in)) {}

AIPageContentMeta::~AIPageContentMeta() = default;
size_t AIPageContentMeta::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->content);
  return seed;
}

void AIPageContentMeta::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentMeta::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentFrameData::AIPageContentFrameData()
    : frame_interaction_info(),
      meta_data(),
      title(),
      contains_paid_content(),
      script_tools(),
      popup() {}

AIPageContentFrameData::AIPageContentFrameData(
    AIPageContentFrameInteractionInfoPtr frame_interaction_info_in,
    std::vector<AIPageContentMetaPtr> meta_data_in,
    const std::optional<std::string>& title_in,
    std::optional<bool> contains_paid_content_in,
    std::vector<::blink::mojom::ScriptToolPtr> script_tools_in,
    AIPageContentPopupPtr popup_in)
    : frame_interaction_info(std::move(frame_interaction_info_in)),
      meta_data(std::move(meta_data_in)),
      title(std::move(title_in)),
      contains_paid_content(std::move(contains_paid_content_in)),
      script_tools(std::move(script_tools_in)),
      popup(std::move(popup_in)) {}

AIPageContentFrameData::~AIPageContentFrameData() = default;

void AIPageContentFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_interaction_info"), this->frame_interaction_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentFrameInteractionInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meta_data"), this->meta_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AIPageContentMetaPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contains_paid_content"), this->contains_paid_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_tools"), this->script_tools,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::blink::mojom::ScriptToolPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "popup"), this->popup,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentPopupPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RedactedFrameMetadata::RedactedFrameMetadata()
    : reason() {}

RedactedFrameMetadata::RedactedFrameMetadata(
    RedactedFrameMetadata::Reason reason_in)
    : reason(std::move(reason_in)) {}

RedactedFrameMetadata::~RedactedFrameMetadata() = default;
size_t RedactedFrameMetadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->reason);
  return seed;
}

void RedactedFrameMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reason"), this->reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RedactedFrameMetadata::Reason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RedactedFrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentIframeData::AIPageContentIframeData()
    : frame_token(),
      content() {}

AIPageContentIframeData::AIPageContentIframeData(
    const ::blink::FrameToken& frame_token_in,
    AIPageContentIframeContentPtr content_in)
    : frame_token(std::move(frame_token_in)),
      content(std::move(content_in)) {}

AIPageContentIframeData::~AIPageContentIframeData() = default;

void AIPageContentIframeData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_token"), this->frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::FrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentIframeContentPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentIframeData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentTableData::AIPageContentTableData()
    : table_name() {}

AIPageContentTableData::AIPageContentTableData(
    const std::optional<std::string>& table_name_in)
    : table_name(std::move(table_name_in)) {}

AIPageContentTableData::~AIPageContentTableData() = default;

void AIPageContentTableData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "table_name"), this->table_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentTableData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentTableRowData::AIPageContentTableRowData()
    : row_type() {}

AIPageContentTableRowData::AIPageContentTableRowData(
    AIPageContentTableRowType row_type_in)
    : row_type(std::move(row_type_in)) {}

AIPageContentTableRowData::~AIPageContentTableRowData() = default;
size_t AIPageContentTableRowData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->row_type);
  return seed;
}

void AIPageContentTableRowData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "row_type"), this->row_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentTableRowType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentTableRowData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentFormData::AIPageContentFormData()
    : form_name(),
      action_url() {}

AIPageContentFormData::AIPageContentFormData(
    const std::optional<std::string>& form_name_in,
    const std::optional<::GURL>& action_url_in)
    : form_name(std::move(form_name_in)),
      action_url(std::move(action_url_in)) {}

AIPageContentFormData::~AIPageContentFormData() = default;

void AIPageContentFormData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_name"), this->form_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action_url"), this->action_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentFormData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentSelectOption::AIPageContentSelectOption()
    : value(),
      text(),
      is_selected(),
      disabled() {}

AIPageContentSelectOption::AIPageContentSelectOption(
    const std::optional<std::string>& value_in,
    const std::optional<std::string>& text_in,
    bool is_selected_in,
    bool disabled_in)
    : value(std::move(value_in)),
      text(std::move(text_in)),
      is_selected(std::move(is_selected_in)),
      disabled(std::move(disabled_in)) {}

AIPageContentSelectOption::~AIPageContentSelectOption() = default;

void AIPageContentSelectOption::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_selected"), this->is_selected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disabled"), this->disabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentSelectOption::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentFormControlData::AIPageContentFormControlData()
    : form_control_type(),
      field_name(),
      field_value(),
      select_options(),
      placeholder(),
      is_checked(),
      is_required(),
      redaction_decision() {}

AIPageContentFormControlData::AIPageContentFormControlData(
    ::blink::mojom::FormControlType form_control_type_in,
    const std::optional<std::string>& field_name_in,
    const std::optional<std::string>& field_value_in,
    std::vector<AIPageContentSelectOptionPtr> select_options_in,
    const std::optional<std::string>& placeholder_in,
    bool is_checked_in,
    bool is_required_in,
    AIPageContentRedactionDecision redaction_decision_in)
    : form_control_type(std::move(form_control_type_in)),
      field_name(std::move(field_name_in)),
      field_value(std::move(field_value_in)),
      select_options(std::move(select_options_in)),
      placeholder(std::move(placeholder_in)),
      is_checked(std::move(is_checked_in)),
      is_required(std::move(is_required_in)),
      redaction_decision(std::move(redaction_decision_in)) {}

AIPageContentFormControlData::~AIPageContentFormControlData() = default;

void AIPageContentFormControlData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_control_type"), this->form_control_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FormControlType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "field_name"), this->field_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "field_value"), this->field_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "select_options"), this->select_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AIPageContentSelectOptionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "placeholder"), this->placeholder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_checked"), this->is_checked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_required"), this->is_required,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redaction_decision"), this->redaction_decision,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentRedactionDecision>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentFormControlData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentAttributes::AIPageContentAttributes()
    : dom_node_id(),
      attribute_type(),
      geometry(),
      node_interaction_info(),
      text_info(),
      image_info(),
      svg_data(),
      canvas_data(),
      video_data(),
      anchor_data(),
      form_data(),
      form_control_data(),
      table_data(),
      iframe_data(),
      table_row_data(),
      annotated_roles(),
      label(),
      aria_role(),
      label_for_dom_node_id(),
      is_ad_related() {}

AIPageContentAttributes::AIPageContentAttributes(
    std::optional<int32_t> dom_node_id_in,
    AIPageContentAttributeType attribute_type_in,
    AIPageContentGeometryPtr geometry_in,
    AIPageContentNodeInteractionInfoPtr node_interaction_info_in,
    AIPageContentTextInfoPtr text_info_in,
    AIPageContentImageInfoPtr image_info_in,
    AIPageContentSVGDataPtr svg_data_in,
    AIPageContentCanvasDataPtr canvas_data_in,
    AIPageContentVideoDataPtr video_data_in,
    AIPageContentAnchorDataPtr anchor_data_in,
    AIPageContentFormDataPtr form_data_in,
    AIPageContentFormControlDataPtr form_control_data_in,
    AIPageContentTableDataPtr table_data_in,
    AIPageContentIframeDataPtr iframe_data_in,
    AIPageContentTableRowDataPtr table_row_data_in,
    std::vector<AIPageContentAnnotatedRole> annotated_roles_in,
    const std::optional<std::string>& label_in,
    std::optional<::ax::mojom::Role> aria_role_in,
    std::optional<int32_t> label_for_dom_node_id_in,
    bool is_ad_related_in)
    : dom_node_id(std::move(dom_node_id_in)),
      attribute_type(std::move(attribute_type_in)),
      geometry(std::move(geometry_in)),
      node_interaction_info(std::move(node_interaction_info_in)),
      text_info(std::move(text_info_in)),
      image_info(std::move(image_info_in)),
      svg_data(std::move(svg_data_in)),
      canvas_data(std::move(canvas_data_in)),
      video_data(std::move(video_data_in)),
      anchor_data(std::move(anchor_data_in)),
      form_data(std::move(form_data_in)),
      form_control_data(std::move(form_control_data_in)),
      table_data(std::move(table_data_in)),
      iframe_data(std::move(iframe_data_in)),
      table_row_data(std::move(table_row_data_in)),
      annotated_roles(std::move(annotated_roles_in)),
      label(std::move(label_in)),
      aria_role(std::move(aria_role_in)),
      label_for_dom_node_id(std::move(label_for_dom_node_id_in)),
      is_ad_related(std::move(is_ad_related_in)) {}

AIPageContentAttributes::~AIPageContentAttributes() = default;

void AIPageContentAttributes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dom_node_id"), this->dom_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribute_type"), this->attribute_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentAttributeType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "geometry"), this->geometry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentGeometryPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_interaction_info"), this->node_interaction_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentNodeInteractionInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_info"), this->text_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentTextInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_info"), this->image_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentImageInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "svg_data"), this->svg_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentSVGDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "canvas_data"), this->canvas_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentCanvasDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_data"), this->video_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentVideoDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_data"), this->anchor_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentAnchorDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_data"), this->form_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentFormDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_control_data"), this->form_control_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentFormControlDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "table_data"), this->table_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentTableDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iframe_data"), this->iframe_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentIframeDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "table_row_data"), this->table_row_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentTableRowDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "annotated_roles"), this->annotated_roles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<AIPageContentAnnotatedRole>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aria_role"), this->aria_role,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::ax::mojom::Role>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label_for_dom_node_id"), this->label_for_dom_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_ad_related"), this->is_ad_related,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentAttributes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentNode::AIPageContentNode()
    : children_nodes(),
      content_attributes() {}

AIPageContentNode::AIPageContentNode(
    std::vector<AIPageContentNodePtr> children_nodes_in,
    AIPageContentAttributesPtr content_attributes_in)
    : children_nodes(std::move(children_nodes_in)),
      content_attributes(std::move(content_attributes_in)) {}

AIPageContentNode::~AIPageContentNode() = default;

void AIPageContentNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children_nodes"), this->children_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AIPageContentNodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_attributes"), this->content_attributes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentAttributesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentPopup::AIPageContentPopup()
    : root_node(),
      opener_dom_node_id() {}

AIPageContentPopup::AIPageContentPopup(
    AIPageContentNodePtr root_node_in,
    int32_t opener_dom_node_id_in)
    : root_node(std::move(root_node_in)),
      opener_dom_node_id(std::move(opener_dom_node_id_in)) {}

AIPageContentPopup::~AIPageContentPopup() = default;

void AIPageContentPopup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_node"), this->root_node,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentNodePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opener_dom_node_id"), this->opener_dom_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentPopup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContent::AIPageContent()
    : root_node(),
      page_interaction_info(),
      frame_data() {}

AIPageContent::AIPageContent(
    AIPageContentNodePtr root_node_in,
    AIPageContentPageInteractionInfoPtr page_interaction_info_in,
    AIPageContentFrameDataPtr frame_data_in)
    : root_node(std::move(root_node_in)),
      page_interaction_info(std::move(page_interaction_info_in)),
      frame_data(std::move(frame_data_in)) {}

AIPageContent::~AIPageContent() = default;

void AIPageContent::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_node"), this->root_node,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentNodePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_interaction_info"), this->page_interaction_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentPageInteractionInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_data"), this->frame_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentFrameDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentOptions::AIPageContentOptions()
    : mode(),
      on_critical_path(false),
      max_meta_elements(0),
      include_same_site_only(false),
      main_frame_view_rect_in_dips() {}

AIPageContentOptions::AIPageContentOptions(
    AIPageContentMode mode_in,
    bool on_critical_path_in,
    int32_t max_meta_elements_in,
    bool include_same_site_only_in,
    const ::gfx::Rect& main_frame_view_rect_in_dips_in)
    : mode(std::move(mode_in)),
      on_critical_path(std::move(on_critical_path_in)),
      max_meta_elements(std::move(max_meta_elements_in)),
      include_same_site_only(std::move(include_same_site_only_in)),
      main_frame_view_rect_in_dips(std::move(main_frame_view_rect_in_dips_in)) {}

AIPageContentOptions::~AIPageContentOptions() = default;

void AIPageContentOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AIPageContentMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "on_critical_path"), this->on_critical_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_meta_elements"), this->max_meta_elements,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_same_site_only"), this->include_same_site_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_view_rect_in_dips"), this->main_frame_view_rect_in_dips,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AIPageContentOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AIPageContentIframeContentPtr
AIPageContentIframeContent::NewLocalFrameData(
    AIPageContentFrameDataPtr value) {
  return AIPageContentIframeContentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kLocalFrameData)>,
      std::move(value));
}

AIPageContentIframeContentPtr
AIPageContentIframeContent::NewRedactedFrameMetadata(
    RedactedFrameMetadataPtr value) {
  return AIPageContentIframeContentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRedactedFrameMetadata)>,
      std::move(value));
}

AIPageContentIframeContent::AIPageContentIframeContent(
    std::in_place_index_t<static_cast<size_t>(Tag::kLocalFrameData)>,
    AIPageContentFrameDataPtr value)
    : tag_(Tag::kLocalFrameData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kLocalFrameData)>,
            std::move(value)) {}

AIPageContentIframeContent::AIPageContentIframeContent(
    std::in_place_index_t<static_cast<size_t>(Tag::kRedactedFrameMetadata)>,
    RedactedFrameMetadataPtr value)
    : tag_(Tag::kRedactedFrameMetadata),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRedactedFrameMetadata)>,
            std::move(value)) {}
AIPageContentIframeContent::~AIPageContentIframeContent() {
  DestroyActive();
}

void AIPageContentIframeContent::set_local_frame_data(AIPageContentFrameDataPtr local_frame_data) {
  if (tag_ == Tag::kLocalFrameData) {
    data_.local_frame_data = std::move(local_frame_data);
  } else {
    DestroyActive();
    tag_ = Tag::kLocalFrameData;
    new (&data_.local_frame_data) AIPageContentFrameDataPtr(
        std::move(local_frame_data));
  }
}

void AIPageContentIframeContent::set_redacted_frame_metadata(RedactedFrameMetadataPtr redacted_frame_metadata) {
  if (tag_ == Tag::kRedactedFrameMetadata) {
    data_.redacted_frame_metadata = std::move(redacted_frame_metadata);
  } else {
    DestroyActive();
    tag_ = Tag::kRedactedFrameMetadata;
    new (&data_.redacted_frame_metadata) RedactedFrameMetadataPtr(
        std::move(redacted_frame_metadata));
  }
}


AIPageContentIframeContent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kLocalFrameData)>,
    AIPageContentFrameDataPtr value)
    : local_frame_data(std::move(value)) {}

AIPageContentIframeContent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRedactedFrameMetadata)>,
    RedactedFrameMetadataPtr value)
    : redacted_frame_metadata(std::move(value)) {}

void AIPageContentIframeContent::DestroyActive() {
  switch (tag_) {

    case Tag::kLocalFrameData:
      std::destroy_at(&data_.local_frame_data);
      break;
    case Tag::kRedactedFrameMetadata:
      std::destroy_at(&data_.redacted_frame_metadata);
      break;
  }
}

bool AIPageContentIframeContent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

AIPageContentAgent::IPCStableHashFunction AIPageContentAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AIPageContentAgent>(message.name())) {
    case messages::AIPageContentAgent::kGetAIPageContent: {
      return &AIPageContentAgent::GetAIPageContent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AIPageContentAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AIPageContentAgent>(message.name())) {
      case messages::AIPageContentAgent::kGetAIPageContent:
            return "Receive blink::mojom::AIPageContentAgent::GetAIPageContent";
    }
  } else {
    switch (static_cast<messages::AIPageContentAgent>(message.name())) {
      case messages::AIPageContentAgent::kGetAIPageContent:
            return "Receive reply blink::mojom::AIPageContentAgent::GetAIPageContent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AIPageContentAgent::GetAIPageContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xabf3c01d;  // IPCStableHash for blink::mojom::AIPageContentAgent::GetAIPageContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AIPageContentAgent_GetAIPageContent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AIPageContentAgent_GetAIPageContent_ForwardToCallback(
      AIPageContentAgent::GetAIPageContentCallback callback
      ) : callback_(std::move(callback)) {
  }

  AIPageContentAgent_GetAIPageContent_ForwardToCallback(const AIPageContentAgent_GetAIPageContent_ForwardToCallback&) = delete;
  AIPageContentAgent_GetAIPageContent_ForwardToCallback& operator=(const AIPageContentAgent_GetAIPageContent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AIPageContentAgent::GetAIPageContentCallback callback_;
};

AIPageContentAgentProxy::AIPageContentAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AIPageContentAgentProxy::GetAIPageContent(
    AIPageContentOptionsPtr in_request, GetAIPageContentCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AIPageContentAgent::GetAIPageContent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type AIPageContentOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIPageContentAgent::kGetAIPageContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIPageContentAgent_GetAIPageContent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AIPageContentOptionsDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in AIPageContentAgent.GetAIPageContent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIPageContentAgent::Name_);
  message.set_method_name("GetAIPageContent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AIPageContentAgent_GetAIPageContent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AIPageContentAgent_GetAIPageContent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AIPageContentAgent::GetAIPageContentCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AIPageContentAgent_GetAIPageContent_ProxyToResponder> proxy(
        new AIPageContentAgent_GetAIPageContent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AIPageContentAgent_GetAIPageContent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AIPageContentAgent_GetAIPageContent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AIPageContentAgent_GetAIPageContent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AIPageContentAgent::GetAIPageContentCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      AIPageContentPtr in_page_content);
};

bool AIPageContentAgent_GetAIPageContent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AIPageContentAgent_GetAIPageContent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AIPageContentAgent_GetAIPageContent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AIPageContentAgent.0
  bool success = true;
  AIPageContentPtr p_page_content{};
  AIPageContentAgent_GetAIPageContent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPageContent(&p_page_content))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AIPageContentAgent::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_page_content));
  }
  return true;
}

void AIPageContentAgent_GetAIPageContent_ProxyToResponder::Run(
    AIPageContentPtr in_page_content) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AIPageContentAgent::GetAIPageContent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_content"), in_page_content,
                        "<value of type AIPageContentPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AIPageContentAgent::kGetAIPageContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AIPageContentAgent_GetAIPageContent_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_content)::BaseType> page_content_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AIPageContentDataView>(
    in_page_content,
    page_content_fragment);

  params->page_content.Set(
      page_content_fragment.is_null() ? nullptr : page_content_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AIPageContentAgent::Name_);
  message.set_method_name("GetAIPageContent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AIPageContentAgentStubDispatch::Accept(
    AIPageContentAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AIPageContentAgent>(message->header()->name)) {
    case messages::AIPageContentAgent::kGetAIPageContent: {
      break;
    }
  }
  return false;
}

// static
bool AIPageContentAgentStubDispatch::AcceptWithResponder(
    AIPageContentAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AIPageContentAgent>(message->header()->name)) {
    case messages::AIPageContentAgent::kGetAIPageContent: {
      internal::AIPageContentAgent_GetAIPageContent_Params_Data* params =
          reinterpret_cast<
              internal::AIPageContentAgent_GetAIPageContent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AIPageContentAgent.0
      bool success = true;
      AIPageContentOptionsPtr p_request{};
      AIPageContentAgent_GetAIPageContent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AIPageContentAgent::Name_, 0, false);
        return false;
      }
      auto callback =
          AIPageContentAgent_GetAIPageContent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAIPageContent(        
        std::move(p_request), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAIPageContentAgentValidationInfo[] = {
    { &internal::AIPageContentAgent_GetAIPageContent_Params_Data::Validate,
     &internal::AIPageContentAgent_GetAIPageContent_ResponseParams_Data::Validate},
};

bool AIPageContentAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AIPageContentAgent::Name_,
    kAIPageContentAgentValidationInfo);
}

bool AIPageContentAgentResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::AIPageContentAgent::Name_,
    kAIPageContentAgentValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::AIPageContentGeometry::DataView, ::blink::mojom::AIPageContentGeometryPtr>::Read(
    ::blink::mojom::AIPageContentGeometry::DataView input,
    ::blink::mojom::AIPageContentGeometryPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentGeometryPtr result(::blink::mojom::AIPageContentGeometry::New());
  
      if (success && !input.ReadOuterBoundingBox(&result->outer_bounding_box))
        success = false;
      if (success && !input.ReadVisibleBoundingBox(&result->visible_bounding_box))
        success = false;
      if (success && !input.ReadFragmentVisibleBoundingBoxes(&result->fragment_visible_bounding_boxes))
        success = false;
      if (success)
        result->is_fixed_or_sticky_position = input.is_fixed_or_sticky_position();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentSelection::DataView, ::blink::mojom::AIPageContentSelectionPtr>::Read(
    ::blink::mojom::AIPageContentSelection::DataView input,
    ::blink::mojom::AIPageContentSelectionPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentSelectionPtr result(::blink::mojom::AIPageContentSelection::New());
  
      if (success)
        result->start_dom_node_id = input.start_dom_node_id();
      if (success)
        result->start_offset = input.start_offset();
      if (success)
        result->end_dom_node_id = input.end_dom_node_id();
      if (success)
        result->end_offset = input.end_offset();
      if (success && !input.ReadSelectedText(&result->selected_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentPageInteractionInfo::DataView, ::blink::mojom::AIPageContentPageInteractionInfoPtr>::Read(
    ::blink::mojom::AIPageContentPageInteractionInfo::DataView input,
    ::blink::mojom::AIPageContentPageInteractionInfoPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentPageInteractionInfoPtr result(::blink::mojom::AIPageContentPageInteractionInfo::New());
  
      if (success) {
        result->focused_dom_node_id = input.focused_dom_node_id();
      }
      if (success) {
        result->accessibility_focused_dom_node_id = input.accessibility_focused_dom_node_id();
      }
      if (success && !input.ReadMousePosition(&result->mouse_position))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentFrameInteractionInfo::DataView, ::blink::mojom::AIPageContentFrameInteractionInfoPtr>::Read(
    ::blink::mojom::AIPageContentFrameInteractionInfo::DataView input,
    ::blink::mojom::AIPageContentFrameInteractionInfoPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentFrameInteractionInfoPtr result(::blink::mojom::AIPageContentFrameInteractionInfo::New());
  
      if (success && !input.ReadSelection(&result->selection))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentNodeInteractionInfo::DataView, ::blink::mojom::AIPageContentNodeInteractionInfoPtr>::Read(
    ::blink::mojom::AIPageContentNodeInteractionInfo::DataView input,
    ::blink::mojom::AIPageContentNodeInteractionInfoPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentNodeInteractionInfoPtr result(::blink::mojom::AIPageContentNodeInteractionInfo::New());
  
      if (success && !input.ReadScrollerInfo(&result->scroller_info))
        success = false;
      if (success)
        result->is_focusable = input.is_focusable();
      if (success)
        result->is_clickable = input.is_clickable();
      if (success) {
        result->document_scoped_z_order = input.document_scoped_z_order();
      }
      if (success && !input.ReadClickabilityReasons(&result->clickability_reasons))
        success = false;
      if (success)
        result->is_disabled = input.is_disabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentScrollerInfo::DataView, ::blink::mojom::AIPageContentScrollerInfoPtr>::Read(
    ::blink::mojom::AIPageContentScrollerInfo::DataView input,
    ::blink::mojom::AIPageContentScrollerInfoPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentScrollerInfoPtr result(::blink::mojom::AIPageContentScrollerInfo::New());
  
      if (success && !input.ReadScrollingBounds(&result->scrolling_bounds))
        success = false;
      if (success && !input.ReadVisibleArea(&result->visible_area))
        success = false;
      if (success)
        result->user_scrollable_horizontal = input.user_scrollable_horizontal();
      if (success)
        result->user_scrollable_vertical = input.user_scrollable_vertical();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentTextStyle::DataView, ::blink::mojom::AIPageContentTextStylePtr>::Read(
    ::blink::mojom::AIPageContentTextStyle::DataView input,
    ::blink::mojom::AIPageContentTextStylePtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentTextStylePtr result(::blink::mojom::AIPageContentTextStyle::New());
  
      if (success && !input.ReadTextSize(&result->text_size))
        success = false;
      if (success)
        result->has_emphasis = input.has_emphasis();
      if (success)
        result->color = input.color();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentTextInfo::DataView, ::blink::mojom::AIPageContentTextInfoPtr>::Read(
    ::blink::mojom::AIPageContentTextInfo::DataView input,
    ::blink::mojom::AIPageContentTextInfoPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentTextInfoPtr result(::blink::mojom::AIPageContentTextInfo::New());
  
      if (success && !input.ReadTextContent(&result->text_content))
        success = false;
      if (success && !input.ReadTextStyle(&result->text_style))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentAnchorData::DataView, ::blink::mojom::AIPageContentAnchorDataPtr>::Read(
    ::blink::mojom::AIPageContentAnchorData::DataView input,
    ::blink::mojom::AIPageContentAnchorDataPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentAnchorDataPtr result(::blink::mojom::AIPageContentAnchorData::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadRel(&result->rel))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentImageInfo::DataView, ::blink::mojom::AIPageContentImageInfoPtr>::Read(
    ::blink::mojom::AIPageContentImageInfo::DataView input,
    ::blink::mojom::AIPageContentImageInfoPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentImageInfoPtr result(::blink::mojom::AIPageContentImageInfo::New());
  
      if (success && !input.ReadImageCaption(&result->image_caption))
        success = false;
      if (success && !input.ReadSourceOrigin(&result->source_origin))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentSVGData::DataView, ::blink::mojom::AIPageContentSVGDataPtr>::Read(
    ::blink::mojom::AIPageContentSVGData::DataView input,
    ::blink::mojom::AIPageContentSVGDataPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentSVGDataPtr result(::blink::mojom::AIPageContentSVGData::New());
  
      if (success && !input.ReadInnerText(&result->inner_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentCanvasData::DataView, ::blink::mojom::AIPageContentCanvasDataPtr>::Read(
    ::blink::mojom::AIPageContentCanvasData::DataView input,
    ::blink::mojom::AIPageContentCanvasDataPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentCanvasDataPtr result(::blink::mojom::AIPageContentCanvasData::New());
  
      if (success && !input.ReadLayoutSize(&result->layout_size))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentVideoData::DataView, ::blink::mojom::AIPageContentVideoDataPtr>::Read(
    ::blink::mojom::AIPageContentVideoData::DataView input,
    ::blink::mojom::AIPageContentVideoDataPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentVideoDataPtr result(::blink::mojom::AIPageContentVideoData::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSourceOrigin(&result->source_origin))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentMeta::DataView, ::blink::mojom::AIPageContentMetaPtr>::Read(
    ::blink::mojom::AIPageContentMeta::DataView input,
    ::blink::mojom::AIPageContentMetaPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentMetaPtr result(::blink::mojom::AIPageContentMeta::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadContent(&result->content))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentFrameData::DataView, ::blink::mojom::AIPageContentFrameDataPtr>::Read(
    ::blink::mojom::AIPageContentFrameData::DataView input,
    ::blink::mojom::AIPageContentFrameDataPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentFrameDataPtr result(::blink::mojom::AIPageContentFrameData::New());
  
      if (success && !input.ReadFrameInteractionInfo(&result->frame_interaction_info))
        success = false;
      if (success && !input.ReadMetaData(&result->meta_data))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success) {
        result->contains_paid_content = input.contains_paid_content();
      }
      if (success && !input.ReadScriptTools(&result->script_tools))
        success = false;
      if (success && !input.ReadPopup(&result->popup))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::RedactedFrameMetadata::DataView, ::blink::mojom::RedactedFrameMetadataPtr>::Read(
    ::blink::mojom::RedactedFrameMetadata::DataView input,
    ::blink::mojom::RedactedFrameMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::RedactedFrameMetadataPtr result(::blink::mojom::RedactedFrameMetadata::New());
  
      if (success && !input.ReadReason(&result->reason))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentIframeData::DataView, ::blink::mojom::AIPageContentIframeDataPtr>::Read(
    ::blink::mojom::AIPageContentIframeData::DataView input,
    ::blink::mojom::AIPageContentIframeDataPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentIframeDataPtr result(::blink::mojom::AIPageContentIframeData::New());
  
      if (success && !input.ReadFrameToken(&result->frame_token))
        success = false;
      if (success && !input.ReadContent(&result->content))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentTableData::DataView, ::blink::mojom::AIPageContentTableDataPtr>::Read(
    ::blink::mojom::AIPageContentTableData::DataView input,
    ::blink::mojom::AIPageContentTableDataPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentTableDataPtr result(::blink::mojom::AIPageContentTableData::New());
  
      if (success && !input.ReadTableName(&result->table_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentTableRowData::DataView, ::blink::mojom::AIPageContentTableRowDataPtr>::Read(
    ::blink::mojom::AIPageContentTableRowData::DataView input,
    ::blink::mojom::AIPageContentTableRowDataPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentTableRowDataPtr result(::blink::mojom::AIPageContentTableRowData::New());
  
      if (success && !input.ReadRowType(&result->row_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentFormData::DataView, ::blink::mojom::AIPageContentFormDataPtr>::Read(
    ::blink::mojom::AIPageContentFormData::DataView input,
    ::blink::mojom::AIPageContentFormDataPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentFormDataPtr result(::blink::mojom::AIPageContentFormData::New());
  
      if (success && !input.ReadFormName(&result->form_name))
        success = false;
      if (success && !input.ReadActionUrl(&result->action_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentSelectOption::DataView, ::blink::mojom::AIPageContentSelectOptionPtr>::Read(
    ::blink::mojom::AIPageContentSelectOption::DataView input,
    ::blink::mojom::AIPageContentSelectOptionPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentSelectOptionPtr result(::blink::mojom::AIPageContentSelectOption::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success)
        result->is_selected = input.is_selected();
      if (success)
        result->disabled = input.disabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentFormControlData::DataView, ::blink::mojom::AIPageContentFormControlDataPtr>::Read(
    ::blink::mojom::AIPageContentFormControlData::DataView input,
    ::blink::mojom::AIPageContentFormControlDataPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentFormControlDataPtr result(::blink::mojom::AIPageContentFormControlData::New());
  
      if (success && !input.ReadFormControlType(&result->form_control_type))
        success = false;
      if (success && !input.ReadFieldName(&result->field_name))
        success = false;
      if (success && !input.ReadFieldValue(&result->field_value))
        success = false;
      if (success && !input.ReadSelectOptions(&result->select_options))
        success = false;
      if (success && !input.ReadPlaceholder(&result->placeholder))
        success = false;
      if (success)
        result->is_checked = input.is_checked();
      if (success)
        result->is_required = input.is_required();
      if (success && !input.ReadRedactionDecision(&result->redaction_decision))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentAttributes::DataView, ::blink::mojom::AIPageContentAttributesPtr>::Read(
    ::blink::mojom::AIPageContentAttributes::DataView input,
    ::blink::mojom::AIPageContentAttributesPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentAttributesPtr result(::blink::mojom::AIPageContentAttributes::New());
  
      if (success) {
        result->dom_node_id = input.dom_node_id();
      }
      if (success && !input.ReadAttributeType(&result->attribute_type))
        success = false;
      if (success && !input.ReadGeometry(&result->geometry))
        success = false;
      if (success && !input.ReadNodeInteractionInfo(&result->node_interaction_info))
        success = false;
      if (success && !input.ReadTextInfo(&result->text_info))
        success = false;
      if (success && !input.ReadImageInfo(&result->image_info))
        success = false;
      if (success && !input.ReadSvgData(&result->svg_data))
        success = false;
      if (success && !input.ReadCanvasData(&result->canvas_data))
        success = false;
      if (success && !input.ReadVideoData(&result->video_data))
        success = false;
      if (success && !input.ReadAnchorData(&result->anchor_data))
        success = false;
      if (success && !input.ReadFormData(&result->form_data))
        success = false;
      if (success && !input.ReadFormControlData(&result->form_control_data))
        success = false;
      if (success && !input.ReadTableData(&result->table_data))
        success = false;
      if (success && !input.ReadIframeData(&result->iframe_data))
        success = false;
      if (success && !input.ReadTableRowData(&result->table_row_data))
        success = false;
      if (success && !input.ReadAnnotatedRoles(&result->annotated_roles))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadAriaRole(&result->aria_role)) {
        success = false;
      }
      if (success) {
        result->label_for_dom_node_id = input.label_for_dom_node_id();
      }
      if (success)
        result->is_ad_related = input.is_ad_related();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentNode::DataView, ::blink::mojom::AIPageContentNodePtr>::Read(
    ::blink::mojom::AIPageContentNode::DataView input,
    ::blink::mojom::AIPageContentNodePtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentNodePtr result(::blink::mojom::AIPageContentNode::New());
  
      if (success && !input.ReadChildrenNodes(&result->children_nodes))
        success = false;
      if (success && !input.ReadContentAttributes(&result->content_attributes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentPopup::DataView, ::blink::mojom::AIPageContentPopupPtr>::Read(
    ::blink::mojom::AIPageContentPopup::DataView input,
    ::blink::mojom::AIPageContentPopupPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentPopupPtr result(::blink::mojom::AIPageContentPopup::New());
  
      if (success && !input.ReadRootNode(&result->root_node))
        success = false;
      if (success)
        result->opener_dom_node_id = input.opener_dom_node_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContent::DataView, ::blink::mojom::AIPageContentPtr>::Read(
    ::blink::mojom::AIPageContent::DataView input,
    ::blink::mojom::AIPageContentPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentPtr result(::blink::mojom::AIPageContent::New());
  
      if (success && !input.ReadRootNode(&result->root_node))
        success = false;
      if (success && !input.ReadPageInteractionInfo(&result->page_interaction_info))
        success = false;
      if (success && !input.ReadFrameData(&result->frame_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AIPageContentOptions::DataView, ::blink::mojom::AIPageContentOptionsPtr>::Read(
    ::blink::mojom::AIPageContentOptions::DataView input,
    ::blink::mojom::AIPageContentOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::AIPageContentOptionsPtr result(::blink::mojom::AIPageContentOptions::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success)
        result->on_critical_path = input.on_critical_path();
      if (success)
        result->max_meta_elements = input.max_meta_elements();
      if (success)
        result->include_same_site_only = input.include_same_site_only();
      if (success && !input.ReadMainFrameViewRectInDips(&result->main_frame_view_rect_in_dips))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::AIPageContentIframeContent::DataView, ::blink::mojom::AIPageContentIframeContentPtr>::Read(
    ::blink::mojom::AIPageContentIframeContent::DataView input,
    ::blink::mojom::AIPageContentIframeContentPtr* output) {
  using UnionType = ::blink::mojom::AIPageContentIframeContent;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kLocalFrameData: {
      ::blink::mojom::AIPageContentFrameDataPtr result_local_frame_data{};
      if (!input.ReadLocalFrameData(&result_local_frame_data))
        return false;

      *output = UnionType::NewLocalFrameData(
          std::move(result_local_frame_data));
      break;
    }
    case Tag::kRedactedFrameMetadata: {
      ::blink::mojom::RedactedFrameMetadataPtr result_redacted_frame_metadata{};
      if (!input.ReadRedactedFrameMetadata(&result_redacted_frame_metadata))
        return false;

      *output = UnionType::NewRedactedFrameMetadata(
          std::move(result_redacted_frame_metadata));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void AIPageContentAgentInterceptorForTesting::GetAIPageContent(AIPageContentOptionsPtr request, GetAIPageContentCallback callback) {
  GetForwardingInterface()->GetAIPageContent(
    std::move(request)
    , std::move(callback));
}
AIPageContentAgentAsyncWaiter::AIPageContentAgentAsyncWaiter(
    AIPageContentAgent* proxy) : proxy_(proxy) {}

AIPageContentAgentAsyncWaiter::~AIPageContentAgentAsyncWaiter() = default;


void AIPageContentAgentAsyncWaiter::GetAIPageContent(
    AIPageContentOptionsPtr request, AIPageContentPtr* out_page_content) {
  base::RunLoop loop;
  proxy_->GetAIPageContent(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             AIPageContentPtr* out_page_content
,
             AIPageContentPtr page_content) {*out_page_content = std::move(page_content);
            loop->Quit();
          },
          &loop,
          out_page_content));
  loop.Run();
}

AIPageContentPtr AIPageContentAgentAsyncWaiter::GetAIPageContent(
    AIPageContentOptionsPtr request) {
  AIPageContentPtr async_wait_result;
  GetAIPageContent(std::move(request),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif