// third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.FormControlType');
goog.require('ax.mojom.Role');
goog.require('url.mojom.Origin');
goog.require('gfx.mojom.Point');
goog.require('gfx.mojom.Rect');
goog.require('blink.mojom.ScriptTool');
goog.require('gfx.mojom.Size');
goog.require('url.mojom.Url');
goog.require('blink.mojom.FrameToken');




goog.provide('blink.mojom.AIPageContentAttributeType');
goog.provide('blink.mojom.AIPageContentAttributeTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AIPageContentAttributeTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AIPageContentAttributeType = {
  
  kRoot: 0,
  kIframe: 1,
  kContainer: 2,
  kText: 3,
  kAnchor: 4,
  kParagraph: 5,
  kHeading: 6,
  kImage: 7,
  kSVG: 8,
  kCanvas: 9,
  kVideo: 10,
  kForm: 11,
  kFormControl: 12,
  kTable: 13,
  kTableRow: 14,
  kTableCell: 15,
  kOrderedList: 16,
  kUnorderedList: 17,
  kListItem: 18,
  MIN_VALUE: 0,
  MAX_VALUE: 18,
};

goog.provide('blink.mojom.AIPageContentAnnotatedRole');
goog.provide('blink.mojom.AIPageContentAnnotatedRoleSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AIPageContentAnnotatedRoleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AIPageContentAnnotatedRole = {
  
  kHeader: 0,
  kNav: 1,
  kSearch: 2,
  kMain: 3,
  kArticle: 4,
  kSection: 5,
  kAside: 6,
  kFooter: 7,
  kContentHidden: 8,
  kPaidContent: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};

goog.provide('blink.mojom.AIPageContentClickabilityReason');
goog.provide('blink.mojom.AIPageContentClickabilityReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AIPageContentClickabilityReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AIPageContentClickabilityReason = {
  
  kClickableControl: 0,
  kClickEvents: 1,
  kMouseEvents: 2,
  kMouseClick: 3,
  kMouseHover: 4,
  kKeyEvents: 5,
  kEditable: 6,
  kCursorPointer: 7,
  kAriaRole: 8,
  kAriaHasPopup: 9,
  kAriaExpandedTrue: 10,
  kAriaExpandedFalse: 11,
  kTabIndex: 12,
  kAutocomplete: 13,
  kHoverPseudoClass: 14,
  MIN_VALUE: 0,
  MAX_VALUE: 14,
};

goog.provide('blink.mojom.AIPageContentTextSize');
goog.provide('blink.mojom.AIPageContentTextSizeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AIPageContentTextSizeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AIPageContentTextSize = {
  
  kXS: 0,
  kS: 1,
  kM: 2,
  kL: 3,
  kXL: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

goog.provide('blink.mojom.AIPageContentAnchorRel');
goog.provide('blink.mojom.AIPageContentAnchorRelSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AIPageContentAnchorRelSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AIPageContentAnchorRel = {
  
  kRelationUnknown: 0,
  kRelationNoReferrer: 1,
  kRelationNoOpener: 2,
  kRelationOpener: 3,
  kRelationPrivacyPolicy: 4,
  kRelationTermsOfService: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

goog.provide('blink.mojom.AIPageContentTableRowType');
goog.provide('blink.mojom.AIPageContentTableRowTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AIPageContentTableRowTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AIPageContentTableRowType = {
  
  kHeader: 0,
  kBody: 1,
  kFooter: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.AIPageContentRedactionDecision');
goog.provide('blink.mojom.AIPageContentRedactionDecisionSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AIPageContentRedactionDecisionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AIPageContentRedactionDecision = {
  
  kNoRedactionNecessary: 0,
  kUnredacted_EmptyPassword: 1,
  kRedacted_HasBeenPassword: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.AIPageContentMode');
goog.provide('blink.mojom.AIPageContentModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AIPageContentModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AIPageContentMode = {
  
  kDefault: 0,
  kActionableElements: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('blink.mojom.AIPageContentAgent');
goog.provide('blink.mojom.AIPageContentAgentReceiver');
goog.provide('blink.mojom.AIPageContentAgentCallbackRouter');
goog.provide('blink.mojom.AIPageContentAgentInterface');
goog.provide('blink.mojom.AIPageContentAgentRemote');
goog.provide('blink.mojom.AIPageContentAgentPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AIPageContentAgentPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AIPageContentAgent.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AIPageContentAgentInterface = class {
  
  /**
   * @param { !blink.mojom.AIPageContentOptions } request
   * @return {!Promise<{
        pageContent: ?blink.mojom.AIPageContent,
   *  }>}
   */

  getAIPageContent(request) {}
};

/**
 * @export
 * @implements { blink.mojom.AIPageContentAgentInterface }
 */
blink.mojom.AIPageContentAgentRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AIPageContentAgentPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AIPageContentAgentPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AIPageContentAgentPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AIPageContentOptions } request
   * @return {!Promise<{
        pageContent: ?blink.mojom.AIPageContent,
   *  }>}
   */

  getAIPageContent(
      request) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.AIPageContentAgent_GetAIPageContent_ParamsSpec.$,
        blink.mojom.AIPageContentAgent_GetAIPageContent_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AIPageContentAgent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AIPageContentAgentReceiver = class {
  /**
   * @param {!blink.mojom.AIPageContentAgentInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AIPageContentAgentRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AIPageContentAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIPageContentAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIPageContentAgent_GetAIPageContent_ParamsSpec.$,
        blink.mojom.AIPageContentAgent_GetAIPageContent_ResponseParamsSpec.$,
        impl.getAIPageContent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AIPageContentAgent = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIPageContentAgent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AIPageContentAgentRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AIPageContentAgentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AIPageContentAgent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AIPageContentAgentCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AIPageContentAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIPageContentAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAIPageContent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIPageContentAgent_GetAIPageContent_ParamsSpec.$,
        blink.mojom.AIPageContentAgent_GetAIPageContent_ResponseParamsSpec.$,
        this.getAIPageContent.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AIPageContentGeometrySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentGeometrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentSelectionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentSelectionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentPageInteractionInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentPageInteractionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentFrameInteractionInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentFrameInteractionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentNodeInteractionInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentNodeInteractionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentScrollerInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentScrollerInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentTextStyleSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentTextStyleSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentTextInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentTextInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentAnchorDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentAnchorDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentImageInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentImageInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentSVGDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentSVGDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentCanvasDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentCanvasDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentVideoDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentVideoDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentMetaSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentMetaSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentFrameDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentFrameDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.RedactedFrameMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.RedactedFrameMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentIframeDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentIframeDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentTableDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentTableDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentTableRowDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentTableRowDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentFormDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentFormDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentSelectOptionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentSelectOptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentFormControlDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentFormControlDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentAttributesSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentNodeSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentNodeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentPopupSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentPopupSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentAgent_GetAIPageContent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentAgent_GetAIPageContent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentAgent_GetAIPageContent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIPageContentAgent_GetAIPageContent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIPageContentIframeContentSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AIPageContentIframeContentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AIPageContentGeometrySpec.$,
    'AIPageContentGeometry',
    [
      mojo.internal.StructField(
        'outerBoundingBox', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'visibleBoundingBox', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fragmentVisibleBoundingBoxes', 16,
        0,
        mojo.internal.Array(gfx.mojom.RectSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isFixedOrStickyPosition', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.AIPageContentGeometry');

/** @record */
blink.mojom.AIPageContentGeometry = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.outerBoundingBox;
    /** @export { !gfx.mojom.Rect } */
    this.visibleBoundingBox;
    /** @export { !Array<!gfx.mojom.Rect> } */
    this.fragmentVisibleBoundingBoxes;
    /** @export { !boolean } */
    this.isFixedOrStickyPosition;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentSelectionSpec.$,
    'AIPageContentSelection',
    [
      mojo.internal.StructField(
        'startDomNodeId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startOffset', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endDomNodeId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endOffset', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectedText', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AIPageContentSelection');

/** @record */
blink.mojom.AIPageContentSelection = class {
  constructor() {
    /** @export { !number } */
    this.startDomNodeId;
    /** @export { !number } */
    this.startOffset;
    /** @export { !number } */
    this.endDomNodeId;
    /** @export { !number } */
    this.endOffset;
    /** @export { !string } */
    this.selectedText;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentPageInteractionInfoSpec.$,
    'AIPageContentPageInteractionInfo',
    [
      mojo.internal.StructField(
        'focused_dom_node_id_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "focused_dom_node_id_$value",
          originalFieldName: "focusedDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'focused_dom_node_id_$value', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "focusedDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'accessibility_focused_dom_node_id_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "accessibility_focused_dom_node_id_$value",
          originalFieldName: "accessibilityFocusedDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'accessibility_focused_dom_node_id_$value', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "accessibilityFocusedDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'mousePosition', 16,
        0,
        gfx.mojom.PointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AIPageContentPageInteractionInfo');

/** @record */
blink.mojom.AIPageContentPageInteractionInfo = class {
  constructor() {
    /** @export { (number|undefined) } */
    this.focusedDomNodeId;
    /** @export { (number|undefined) } */
    this.accessibilityFocusedDomNodeId;
    /** @export { (gfx.mojom.Point|undefined) } */
    this.mousePosition;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentFrameInteractionInfoSpec.$,
    'AIPageContentFrameInteractionInfo',
    [
      mojo.internal.StructField(
        'selection', 0,
        0,
        blink.mojom.AIPageContentSelectionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIPageContentFrameInteractionInfo');

/** @record */
blink.mojom.AIPageContentFrameInteractionInfo = class {
  constructor() {
    /** @export { (blink.mojom.AIPageContentSelection|undefined) } */
    this.selection;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentNodeInteractionInfoSpec.$,
    'AIPageContentNodeInteractionInfo',
    [
      mojo.internal.StructField(
        'scrollerInfo', 0,
        0,
        blink.mojom.AIPageContentScrollerInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isFocusable', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isClickable', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'document_scoped_z_order_$flag', 8,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "document_scoped_z_order_$value",
          originalFieldName: "documentScopedZOrder",
        }
      ),
      mojo.internal.StructField(
        'document_scoped_z_order_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "documentScopedZOrder",
        }
      ),
      mojo.internal.StructField(
        'clickabilityReasons', 16,
        0,
        mojo.internal.Array(blink.mojom.AIPageContentClickabilityReasonSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isDisabled', 8,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AIPageContentNodeInteractionInfo');

/** @record */
blink.mojom.AIPageContentNodeInteractionInfo = class {
  constructor() {
    /** @export { (blink.mojom.AIPageContentScrollerInfo|undefined) } */
    this.scrollerInfo;
    /** @export { !boolean } */
    this.isFocusable;
    /** @export { !boolean } */
    this.isClickable;
    /** @export { (number|undefined) } */
    this.documentScopedZOrder;
    /** @export { !Array<!blink.mojom.AIPageContentClickabilityReason> } */
    this.clickabilityReasons;
    /** @export { !boolean } */
    this.isDisabled;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentScrollerInfoSpec.$,
    'AIPageContentScrollerInfo',
    [
      mojo.internal.StructField(
        'scrollingBounds', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'visibleArea', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userScrollableHorizontal', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userScrollableVertical', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AIPageContentScrollerInfo');

/** @record */
blink.mojom.AIPageContentScrollerInfo = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.scrollingBounds;
    /** @export { !gfx.mojom.Rect } */
    this.visibleArea;
    /** @export { !boolean } */
    this.userScrollableHorizontal;
    /** @export { !boolean } */
    this.userScrollableVertical;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentTextStyleSpec.$,
    'AIPageContentTextStyle',
    [
      mojo.internal.StructField(
        'textSize', 0,
        0,
        blink.mojom.AIPageContentTextSizeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasEmphasis', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'color', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIPageContentTextStyle');

/** @record */
blink.mojom.AIPageContentTextStyle = class {
  constructor() {
    /** @export { !blink.mojom.AIPageContentTextSize } */
    this.textSize;
    /** @export { !boolean } */
    this.hasEmphasis;
    /** @export { !number } */
    this.color;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentTextInfoSpec.$,
    'AIPageContentTextInfo',
    [
      mojo.internal.StructField(
        'textContent', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textStyle', 8,
        0,
        blink.mojom.AIPageContentTextStyleSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIPageContentTextInfo');

/** @record */
blink.mojom.AIPageContentTextInfo = class {
  constructor() {
    /** @export { !string } */
    this.textContent;
    /** @export { !blink.mojom.AIPageContentTextStyle } */
    this.textStyle;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentAnchorDataSpec.$,
    'AIPageContentAnchorData',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rel', 8,
        0,
        mojo.internal.Array(blink.mojom.AIPageContentAnchorRelSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIPageContentAnchorData');

/** @record */
blink.mojom.AIPageContentAnchorData = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !Array<!blink.mojom.AIPageContentAnchorRel> } */
    this.rel;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentImageInfoSpec.$,
    'AIPageContentImageInfo',
    [
      mojo.internal.StructField(
        'imageCaption', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIPageContentImageInfo');

/** @record */
blink.mojom.AIPageContentImageInfo = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.imageCaption;
    /** @export { (url.mojom.Origin|undefined) } */
    this.sourceOrigin;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentSVGDataSpec.$,
    'AIPageContentSVGData',
    [
      mojo.internal.StructField(
        'innerText', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIPageContentSVGData');

/** @record */
blink.mojom.AIPageContentSVGData = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.innerText;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentCanvasDataSpec.$,
    'AIPageContentCanvasData',
    [
      mojo.internal.StructField(
        'layoutSize', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIPageContentCanvasData');

/** @record */
blink.mojom.AIPageContentCanvasData = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.layoutSize;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentVideoDataSpec.$,
    'AIPageContentVideoData',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIPageContentVideoData');

/** @record */
blink.mojom.AIPageContentVideoData = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { (url.mojom.Origin|undefined) } */
    this.sourceOrigin;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentMetaSpec.$,
    'AIPageContentMeta',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'content', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIPageContentMeta');

/** @record */
blink.mojom.AIPageContentMeta = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.content;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentFrameDataSpec.$,
    'AIPageContentFrameData',
    [
      mojo.internal.StructField(
        'frameInteractionInfo', 0,
        0,
        blink.mojom.AIPageContentFrameInteractionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metaData', 8,
        0,
        mojo.internal.Array(blink.mojom.AIPageContentMetaSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'title', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contains_paid_content_$flag', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "contains_paid_content_$value",
          originalFieldName: "containsPaidContent",
        }
      ),
      mojo.internal.StructField(
        'contains_paid_content_$value', 24,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "containsPaidContent",
        }
      ),
      mojo.internal.StructField(
        'scriptTools', 32,
        0,
        mojo.internal.Array(blink.mojom.ScriptToolSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'popup', 40,
        0,
        blink.mojom.AIPageContentPopupSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.AIPageContentFrameData');

/** @record */
blink.mojom.AIPageContentFrameData = class {
  constructor() {
    /** @export { !blink.mojom.AIPageContentFrameInteractionInfo } */
    this.frameInteractionInfo;
    /** @export { !Array<!blink.mojom.AIPageContentMeta> } */
    this.metaData;
    /** @export { (string|undefined) } */
    this.title;
    /** @export { (boolean|undefined) } */
    this.containsPaidContent;
    /** @export { !Array<!blink.mojom.ScriptTool> } */
    this.scriptTools;
    /** @export { (blink.mojom.AIPageContentPopup|undefined) } */
    this.popup;
  }
};


goog.provide('blink.mojom.RedactedFrameMetadata_Reason');
goog.provide('blink.mojom.RedactedFrameMetadataSpec.ReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.RedactedFrameMetadataSpec.ReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.RedactedFrameMetadata_Reason = {
  
  kCrossSite: 0,
  kCrossOrigin: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    blink.mojom.RedactedFrameMetadataSpec.$,
    'RedactedFrameMetadata',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        blink.mojom.RedactedFrameMetadataSpec.ReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.RedactedFrameMetadata');

/** @record */
blink.mojom.RedactedFrameMetadata = class {
  constructor() {
    /** @export { !blink.mojom.RedactedFrameMetadata_Reason } */
    this.reason;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentIframeDataSpec.$,
    'AIPageContentIframeData',
    [
      mojo.internal.StructField(
        'frameToken', 0,
        0,
        blink.mojom.FrameTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'content', 16,
        0,
        blink.mojom.AIPageContentIframeContentSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.AIPageContentIframeData');

/** @record */
blink.mojom.AIPageContentIframeData = class {
  constructor() {
    /** @export { !blink.mojom.FrameToken } */
    this.frameToken;
    /** @export { (blink.mojom.AIPageContentIframeContent|undefined) } */
    this.content;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentTableDataSpec.$,
    'AIPageContentTableData',
    [
      mojo.internal.StructField(
        'tableName', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIPageContentTableData');

/** @record */
blink.mojom.AIPageContentTableData = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.tableName;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentTableRowDataSpec.$,
    'AIPageContentTableRowData',
    [
      mojo.internal.StructField(
        'rowType', 0,
        0,
        blink.mojom.AIPageContentTableRowTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIPageContentTableRowData');

/** @record */
blink.mojom.AIPageContentTableRowData = class {
  constructor() {
    /** @export { !blink.mojom.AIPageContentTableRowType } */
    this.rowType;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentFormDataSpec.$,
    'AIPageContentFormData',
    [
      mojo.internal.StructField(
        'formName', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'actionUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIPageContentFormData');

/** @record */
blink.mojom.AIPageContentFormData = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.formName;
    /** @export { (url.mojom.Url|undefined) } */
    this.actionUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentSelectOptionSpec.$,
    'AIPageContentSelectOption',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isSelected', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disabled', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AIPageContentSelectOption');

/** @record */
blink.mojom.AIPageContentSelectOption = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.value;
    /** @export { (string|undefined) } */
    this.text;
    /** @export { !boolean } */
    this.isSelected;
    /** @export { !boolean } */
    this.disabled;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentFormControlDataSpec.$,
    'AIPageContentFormControlData',
    [
      mojo.internal.StructField(
        'formControlType', 0,
        0,
        blink.mojom.FormControlTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fieldName', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fieldValue', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectOptions', 24,
        0,
        mojo.internal.Array(blink.mojom.AIPageContentSelectOptionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'placeholder', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isChecked', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isRequired', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'redactionDecision', 40,
        0,
        blink.mojom.AIPageContentRedactionDecisionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.AIPageContentFormControlData');

/** @record */
blink.mojom.AIPageContentFormControlData = class {
  constructor() {
    /** @export { !blink.mojom.FormControlType } */
    this.formControlType;
    /** @export { (string|undefined) } */
    this.fieldName;
    /** @export { (string|undefined) } */
    this.fieldValue;
    /** @export { !Array<!blink.mojom.AIPageContentSelectOption> } */
    this.selectOptions;
    /** @export { (string|undefined) } */
    this.placeholder;
    /** @export { !boolean } */
    this.isChecked;
    /** @export { !boolean } */
    this.isRequired;
    /** @export { !blink.mojom.AIPageContentRedactionDecision } */
    this.redactionDecision;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentAttributesSpec.$,
    'AIPageContentAttributes',
    [
      mojo.internal.StructField(
        'dom_node_id_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "dom_node_id_$value",
          originalFieldName: "domNodeId",
        }
      ),
      mojo.internal.StructField(
        'dom_node_id_$value', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "domNodeId",
        }
      ),
      mojo.internal.StructField(
        'attributeType', 8,
        0,
        blink.mojom.AIPageContentAttributeTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'geometry', 16,
        0,
        blink.mojom.AIPageContentGeometrySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nodeInteractionInfo', 24,
        0,
        blink.mojom.AIPageContentNodeInteractionInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textInfo', 32,
        0,
        blink.mojom.AIPageContentTextInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'imageInfo', 40,
        0,
        blink.mojom.AIPageContentImageInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'svgData', 48,
        0,
        blink.mojom.AIPageContentSVGDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'canvasData', 56,
        0,
        blink.mojom.AIPageContentCanvasDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoData', 64,
        0,
        blink.mojom.AIPageContentVideoDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'anchorData', 72,
        0,
        blink.mojom.AIPageContentAnchorDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'formData', 80,
        0,
        blink.mojom.AIPageContentFormDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'formControlData', 88,
        0,
        blink.mojom.AIPageContentFormControlDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tableData', 96,
        0,
        blink.mojom.AIPageContentTableDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'iframeData', 104,
        0,
        blink.mojom.AIPageContentIframeDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tableRowData', 112,
        0,
        blink.mojom.AIPageContentTableRowDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'annotatedRoles', 120,
        0,
        mojo.internal.Array(blink.mojom.AIPageContentAnnotatedRoleSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 128,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'aria_role_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "aria_role_$value",
          originalFieldName: "ariaRole",
        }
      ),
      mojo.internal.StructField(
        'aria_role_$value', 12,
        0,
        ax.mojom.RoleSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "ariaRole",
        }
      ),
      mojo.internal.StructField(
        'label_for_dom_node_id_$flag', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "label_for_dom_node_id_$value",
          originalFieldName: "labelForDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'label_for_dom_node_id_$value', 136,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "labelForDomNodeId",
        }
      ),
      mojo.internal.StructField(
        'isAdRelated', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 152],]);



goog.provide('blink.mojom.AIPageContentAttributes');

/** @record */
blink.mojom.AIPageContentAttributes = class {
  constructor() {
    /** @export { (number|undefined) } */
    this.domNodeId;
    /** @export { !blink.mojom.AIPageContentAttributeType } */
    this.attributeType;
    /** @export { (blink.mojom.AIPageContentGeometry|undefined) } */
    this.geometry;
    /** @export { (blink.mojom.AIPageContentNodeInteractionInfo|undefined) } */
    this.nodeInteractionInfo;
    /** @export { (blink.mojom.AIPageContentTextInfo|undefined) } */
    this.textInfo;
    /** @export { (blink.mojom.AIPageContentImageInfo|undefined) } */
    this.imageInfo;
    /** @export { (blink.mojom.AIPageContentSVGData|undefined) } */
    this.svgData;
    /** @export { (blink.mojom.AIPageContentCanvasData|undefined) } */
    this.canvasData;
    /** @export { (blink.mojom.AIPageContentVideoData|undefined) } */
    this.videoData;
    /** @export { (blink.mojom.AIPageContentAnchorData|undefined) } */
    this.anchorData;
    /** @export { (blink.mojom.AIPageContentFormData|undefined) } */
    this.formData;
    /** @export { (blink.mojom.AIPageContentFormControlData|undefined) } */
    this.formControlData;
    /** @export { (blink.mojom.AIPageContentTableData|undefined) } */
    this.tableData;
    /** @export { (blink.mojom.AIPageContentIframeData|undefined) } */
    this.iframeData;
    /** @export { (blink.mojom.AIPageContentTableRowData|undefined) } */
    this.tableRowData;
    /** @export { !Array<!blink.mojom.AIPageContentAnnotatedRole> } */
    this.annotatedRoles;
    /** @export { (string|undefined) } */
    this.label;
    /** @export { (ax.mojom.Role|undefined) } */
    this.ariaRole;
    /** @export { (number|undefined) } */
    this.labelForDomNodeId;
    /** @export { !boolean } */
    this.isAdRelated;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentNodeSpec.$,
    'AIPageContentNode',
    [
      mojo.internal.StructField(
        'childrenNodes', 0,
        0,
        mojo.internal.Array(blink.mojom.AIPageContentNodeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contentAttributes', 8,
        0,
        blink.mojom.AIPageContentAttributesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIPageContentNode');

/** @record */
blink.mojom.AIPageContentNode = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AIPageContentNode> } */
    this.childrenNodes;
    /** @export { !blink.mojom.AIPageContentAttributes } */
    this.contentAttributes;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentPopupSpec.$,
    'AIPageContentPopup',
    [
      mojo.internal.StructField(
        'rootNode', 0,
        0,
        blink.mojom.AIPageContentNodeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'openerDomNodeId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIPageContentPopup');

/** @record */
blink.mojom.AIPageContentPopup = class {
  constructor() {
    /** @export { !blink.mojom.AIPageContentNode } */
    this.rootNode;
    /** @export { !number } */
    this.openerDomNodeId;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentSpec.$,
    'AIPageContent',
    [
      mojo.internal.StructField(
        'rootNode', 0,
        0,
        blink.mojom.AIPageContentNodeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pageInteractionInfo', 8,
        0,
        blink.mojom.AIPageContentPageInteractionInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameData', 16,
        0,
        blink.mojom.AIPageContentFrameDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AIPageContent');

/** @record */
blink.mojom.AIPageContent = class {
  constructor() {
    /** @export { !blink.mojom.AIPageContentNode } */
    this.rootNode;
    /** @export { (blink.mojom.AIPageContentPageInteractionInfo|undefined) } */
    this.pageInteractionInfo;
    /** @export { !blink.mojom.AIPageContentFrameData } */
    this.frameData;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentOptionsSpec.$,
    'AIPageContentOptions',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink.mojom.AIPageContentModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'onCriticalPath', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxMetaElements', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeSameSiteOnly', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mainFrameViewRectInDips', 16,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AIPageContentOptions');

/** @record */
blink.mojom.AIPageContentOptions = class {
  constructor() {
    /** @export { !blink.mojom.AIPageContentMode } */
    this.mode;
    /** @export { !boolean } */
    this.onCriticalPath;
    /** @export { !number } */
    this.maxMetaElements;
    /** @export { !boolean } */
    this.includeSameSiteOnly;
    /** @export { !gfx.mojom.Rect } */
    this.mainFrameViewRectInDips;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentAgent_GetAIPageContent_ParamsSpec.$,
    'AIPageContentAgent_GetAIPageContent_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        blink.mojom.AIPageContentOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIPageContentAgent_GetAIPageContent_Params');

/** @record */
blink.mojom.AIPageContentAgent_GetAIPageContent_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIPageContentOptions } */
    this.request;
  }
};



mojo.internal.Struct(
    blink.mojom.AIPageContentAgent_GetAIPageContent_ResponseParamsSpec.$,
    'AIPageContentAgent_GetAIPageContent_ResponseParams',
    [
      mojo.internal.StructField(
        'pageContent', 0,
        0,
        blink.mojom.AIPageContentSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIPageContentAgent_GetAIPageContent_ResponseParams');

/** @record */
blink.mojom.AIPageContentAgent_GetAIPageContent_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.AIPageContent|undefined) } */
    this.pageContent;
  }
};

goog.provide('blink.mojom.AIPageContentIframeContent');


mojo.internal.Union(
    blink.mojom.AIPageContentIframeContentSpec.$, 'AIPageContentIframeContent',
    {
      'localFrameData': {
        'ordinal': 0,
        'type': blink.mojom.AIPageContentFrameDataSpec.$,
      },
      'redactedFrameMetadata': {
        'ordinal': 1,
        'type': blink.mojom.RedactedFrameMetadataSpec.$,
      },
    });

/**
 * @typedef { {
 *   localFrameData: (!blink.mojom.AIPageContentFrameData|undefined),
 *   redactedFrameMetadata: (!blink.mojom.RedactedFrameMetadata|undefined),
 * } }
 */
blink.mojom.AIPageContentIframeContent;
