// third_party/blink/public/mojom/contacts/contacts_manager.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ContactsManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ContactsManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.ContactsManagerInterface }
 */
blink.mojom.ContactsManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ContactsManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ContactsManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ContactsManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } multiple
   * @param { !boolean } includeNames
   * @param { !boolean } includeEmails
   * @param { !boolean } includeTel
   * @param { !boolean } includeAddresses
   * @param { !boolean } includeIcons
   * @return {!Promise<{
        contacts: ?Array<!blink.mojom.ContactInfo>,
   *  }>}
   */

  select(
      multiple,
      includeNames,
      includeEmails,
      includeTel,
      includeAddresses,
      includeIcons) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.ContactsManager_Select_ParamsSpec.$,
        blink.mojom.ContactsManager_Select_ResponseParamsSpec.$,
        [
          multiple,
          includeNames,
          includeEmails,
          includeTel,
          includeAddresses,
          includeIcons
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ContactsManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ContactsManagerReceiver = class {
  /**
   * @param {!blink.mojom.ContactsManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ContactsManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ContactsManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ContactsManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ContactsManager_Select_ParamsSpec.$,
        blink.mojom.ContactsManager_Select_ResponseParamsSpec.$,
        impl.select.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ContactsManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ContactsManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ContactsManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ContactsManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ContactsManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ContactsManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ContactsManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ContactsManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.select =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ContactsManager_Select_ParamsSpec.$,
        blink.mojom.ContactsManager_Select_ResponseParamsSpec.$,
        this.select.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContactIconBlobSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContactInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContactsManager_Select_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ContactsManager_Select_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ContactIconBlobSpec.$,
    'ContactIconBlob',
    [
      mojo.internal.StructField(
        'mimeType', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.ContactIconBlob = class {
  constructor() {
    /** @export { !string } */
    this.mimeType;
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.ContactInfoSpec.$,
    'ContactInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'email', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tel', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'address', 24,
        0,
        mojo.internal.Array(payments.mojom.PaymentAddressSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'icon', 32,
        0,
        mojo.internal.Array(blink.mojom.ContactIconBlobSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.ContactInfo = class {
  constructor() {
    /** @export { (Array<!string>|undefined) } */
    this.name;
    /** @export { (Array<!string>|undefined) } */
    this.email;
    /** @export { (Array<!string>|undefined) } */
    this.tel;
    /** @export { (Array<!payments.mojom.PaymentAddress>|undefined) } */
    this.address;
    /** @export { (Array<!blink.mojom.ContactIconBlob>|undefined) } */
    this.icon;
  }
};



mojo.internal.Struct(
    blink.mojom.ContactsManager_Select_ParamsSpec.$,
    'ContactsManager_Select_Params',
    [
      mojo.internal.StructField(
        'multiple', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeNames', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeEmails', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeTel', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeAddresses', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeIcons', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.ContactsManager_Select_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.multiple;
    /** @export { !boolean } */
    this.includeNames;
    /** @export { !boolean } */
    this.includeEmails;
    /** @export { !boolean } */
    this.includeTel;
    /** @export { !boolean } */
    this.includeAddresses;
    /** @export { !boolean } */
    this.includeIcons;
  }
};



mojo.internal.Struct(
    blink.mojom.ContactsManager_Select_ResponseParamsSpec.$,
    'ContactsManager_Select_ResponseParams',
    [
      mojo.internal.StructField(
        'contacts', 0,
        0,
        mojo.internal.Array(blink.mojom.ContactInfoSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.ContactsManager_Select_ResponseParams = class {
  constructor() {
    /** @export { (Array<!blink.mojom.ContactInfo>|undefined) } */
    this.contacts;
  }
};

