// third_party/blink/public/mojom/choosers/file_chooser.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::FileChooserParams_Mode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FileChooserParams_Mode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileChooserParams_Mode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FileChooserParams_Mode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FileChooserParams_Mode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileChooserParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileChooserParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FileChooserParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::FileChooserParams_Mode>(
      Traits::mode(input),
      &fragment->mode);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in FileChooserParams struct");

    decltype(Traits::default_file_name(input)) in_default_file_name = Traits::default_file_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->default_file_name)::BaseType> default_file_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_default_file_name,
      default_file_name_fragment);

    fragment->default_file_name.Set(
        default_file_name_fragment.is_null() ? nullptr : default_file_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->default_file_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_file_name in FileChooserParams struct");

    decltype(Traits::selected_files(input)) in_selected_files = Traits::selected_files(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selected_files)::BaseType>
        selected_files_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& selected_files_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
      in_selected_files,
      selected_files_fragment,
      &selected_files_validate_params);

    fragment->selected_files.Set(
        selected_files_fragment.is_null() ? nullptr : selected_files_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selected_files.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selected_files in FileChooserParams struct");

    decltype(Traits::accept_types(input)) in_accept_types = Traits::accept_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accept_types)::BaseType>
        accept_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& accept_types_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_accept_types,
      accept_types_fragment,
      &accept_types_validate_params);

    fragment->accept_types.Set(
        accept_types_fragment.is_null() ? nullptr : accept_types_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->accept_types.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accept_types in FileChooserParams struct");

    fragment->need_local_path = Traits::need_local_path(input);

    fragment->use_media_capture = Traits::use_media_capture(input);

    fragment->open_writable = Traits::open_writable(input);

    decltype(Traits::requestor(input)) in_requestor = Traits::requestor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->requestor)::BaseType> requestor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_requestor,
      requestor_fragment);

    fragment->requestor.Set(
        requestor_fragment.is_null() ? nullptr : requestor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->requestor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requestor in FileChooserParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::FileChooserParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FileChooserParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::NativeFileInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::NativeFileInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::NativeFileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::file_path(input)) in_file_path = Traits::file_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_path)::BaseType> file_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_file_path,
      file_path_fragment);

    fragment->file_path.Set(
        file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->file_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_path in NativeFileInfo struct");

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in NativeFileInfo struct");

    decltype(Traits::base_subdirs(input)) in_base_subdirs = Traits::base_subdirs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->base_subdirs)::BaseType>
        base_subdirs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& base_subdirs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_base_subdirs,
      base_subdirs_fragment,
      &base_subdirs_validate_params);

    fragment->base_subdirs.Set(
        base_subdirs_fragment.is_null() ? nullptr : base_subdirs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->base_subdirs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null base_subdirs in NativeFileInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::NativeFileInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::NativeFileInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileSystemFileInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileSystemFileInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FileSystemFileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in FileSystemFileInfo struct");

    decltype(Traits::modification_time(input)) in_modification_time = Traits::modification_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->modification_time)::BaseType> modification_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_modification_time,
      modification_time_fragment);

    fragment->modification_time.Set(
        modification_time_fragment.is_null() ? nullptr : modification_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->modification_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null modification_time in FileSystemFileInfo struct");

    fragment->length = Traits::length(input);
  }

  static bool Deserialize(::blink::mojom::internal::FileSystemFileInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FileSystemFileInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileChooserResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileChooserResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FileChooserResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::files(input)) in_files = Traits::files(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->files)::BaseType>
        files_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FileChooserFileInfoDataView>>(
      in_files,
      files_fragment,
      &files_validate_params);

    fragment->files.Set(
        files_fragment.is_null() ? nullptr : files_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->files.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null files in FileChooserResult struct");

    decltype(Traits::base_directory(input)) in_base_directory = Traits::base_directory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->base_directory)::BaseType> base_directory_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_base_directory,
      base_directory_fragment);

    fragment->base_directory.Set(
        base_directory_fragment.is_null() ? nullptr : base_directory_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->base_directory.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null base_directory in FileChooserResult struct");
  }

  static bool Deserialize(::blink::mojom::internal::FileChooserResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FileChooserResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileChooserFileInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::FileChooserFileInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::FileChooserFileInfo_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::FileChooserFileInfoDataView::Tag::kNativeFile: {
    decltype(Traits::native_file(input))
    in_native_file = Traits::native_file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_native_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::NativeFileInfoDataView>(
  in_native_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null native_file in FileChooserFileInfo union");
    fragment->data.f_native_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::FileChooserFileInfoDataView::Tag::kFileSystem: {
    decltype(Traits::file_system(input))
    in_file_system = Traits::file_system(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file_system)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::FileSystemFileInfoDataView>(
  in_file_system,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file_system in FileChooserFileInfo union");
    fragment->data.f_file_system.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::FileChooserFileInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FileChooserFileInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FileChooserParamsDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FileChooserParamsDataView::GetDefaultFileNameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->default_file_name.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void FileChooserParamsDataView::GetSelectedFilesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output) {
  auto pointer = data_->selected_files.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>(pointer, message_);
}
inline void FileChooserParamsDataView::GetAcceptTypesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->accept_types.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void FileChooserParamsDataView::GetRequestorDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->requestor.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void NativeFileInfoDataView::GetFilePathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->file_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void NativeFileInfoDataView::GetDisplayNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->display_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void NativeFileInfoDataView::GetBaseSubdirsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->base_subdirs.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}


inline void FileSystemFileInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void FileSystemFileInfoDataView::GetModificationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->modification_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void FileChooserResultDataView::GetFilesDataView(
    mojo::ArrayDataView<FileChooserFileInfoDataView>* output) {
  auto pointer = data_->files.Get();
  *output = mojo::ArrayDataView<FileChooserFileInfoDataView>(pointer, message_);
}
inline void FileChooserResultDataView::GetBaseDirectoryDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->base_directory.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}


inline void FileChooserFileInfoDataView::GetNativeFileDataView(
    NativeFileInfoDataView* output) const {
  CHECK(is_native_file());
  *output = NativeFileInfoDataView(data_->data.f_native_file.Get(), message_);
}
inline void FileChooserFileInfoDataView::GetFileSystemDataView(
    FileSystemFileInfoDataView* output) const {
  CHECK(is_file_system());
  *output = FileSystemFileInfoDataView(data_->data.f_file_system.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FileChooserParams_Mode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FileChooserParams_Mode value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_FILE_CHOOSER_MOJOM_SHARED_H_