// third_party/blink/public/mojom/choosers/file_chooser.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-params-data.h"
#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/choosers/file_chooser.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
FileChooserParams::FileChooserParams()
    : mode(FileChooserParams_Mode::kOpen),
      title(),
      default_file_name(),
      selected_files(),
      accept_types(),
      need_local_path(true),
      use_media_capture(false),
      open_writable(false),
      requestor() {}

FileChooserParams::FileChooserParams(
    FileChooserParams::Mode mode_in,
    const ::blink::String& title_in,
    const ::base::FilePath& default_file_name_in,
    ::blink::Vector<::base::FilePath> selected_files_in,
    ::blink::Vector<::blink::String> accept_types_in,
    bool need_local_path_in,
    bool use_media_capture_in,
    bool open_writable_in,
    const ::blink::KURL& requestor_in)
    : mode(std::move(mode_in)),
      title(std::move(title_in)),
      default_file_name(std::move(default_file_name_in)),
      selected_files(std::move(selected_files_in)),
      accept_types(std::move(accept_types_in)),
      need_local_path(std::move(need_local_path_in)),
      use_media_capture(std::move(use_media_capture_in)),
      open_writable(std::move(open_writable_in)),
      requestor(std::move(requestor_in)) {}

FileChooserParams::~FileChooserParams() = default;

void FileChooserParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FileChooserParams::Mode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_file_name"), this->default_file_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_files"), this->selected_files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept_types"), this->accept_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "need_local_path"), this->need_local_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_media_capture"), this->use_media_capture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "open_writable"), this->open_writable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requestor"), this->requestor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileChooserParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NativeFileInfo::NativeFileInfo()
    : file_path(),
      display_name(),
      base_subdirs() {}

NativeFileInfo::NativeFileInfo(
    const ::base::FilePath& file_path_in,
    const ::blink::String& display_name_in,
    ::blink::Vector<::blink::String> base_subdirs_in)
    : file_path(std::move(file_path_in)),
      display_name(std::move(display_name_in)),
      base_subdirs(std::move(base_subdirs_in)) {}

NativeFileInfo::~NativeFileInfo() = default;

void NativeFileInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_path"), this->file_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_subdirs"), this->base_subdirs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NativeFileInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileSystemFileInfo::FileSystemFileInfo()
    : url(),
      modification_time(),
      length(0) {}

FileSystemFileInfo::FileSystemFileInfo(
    const ::blink::KURL& url_in,
    ::base::Time modification_time_in,
    int64_t length_in)
    : url(std::move(url_in)),
      modification_time(std::move(modification_time_in)),
      length(std::move(length_in)) {}

FileSystemFileInfo::~FileSystemFileInfo() = default;

void FileSystemFileInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modification_time"), this->modification_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemFileInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileChooserResult::FileChooserResult()
    : files(),
      base_directory() {}

FileChooserResult::FileChooserResult(
    ::blink::Vector<FileChooserFileInfoPtr> files_in,
    const ::base::FilePath& base_directory_in)
    : files(std::move(files_in)),
      base_directory(std::move(base_directory_in)) {}

FileChooserResult::~FileChooserResult() = default;

void FileChooserResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "files"), this->files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<FileChooserFileInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_directory"), this->base_directory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileChooserResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileChooserFileInfoPtr
FileChooserFileInfo::NewNativeFile(
    NativeFileInfoPtr value) {
  return FileChooserFileInfoPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNativeFile)>,
      std::move(value));
}

FileChooserFileInfoPtr
FileChooserFileInfo::NewFileSystem(
    FileSystemFileInfoPtr value) {
  return FileChooserFileInfoPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFileSystem)>,
      std::move(value));
}

FileChooserFileInfo::FileChooserFileInfo(
    std::in_place_index_t<static_cast<size_t>(Tag::kNativeFile)>,
    NativeFileInfoPtr value)
    : tag_(Tag::kNativeFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNativeFile)>,
            std::move(value)) {}

FileChooserFileInfo::FileChooserFileInfo(
    std::in_place_index_t<static_cast<size_t>(Tag::kFileSystem)>,
    FileSystemFileInfoPtr value)
    : tag_(Tag::kFileSystem),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFileSystem)>,
            std::move(value)) {}
FileChooserFileInfo::~FileChooserFileInfo() {
  DestroyActive();
}

void FileChooserFileInfo::set_native_file(NativeFileInfoPtr native_file) {
  if (tag_ == Tag::kNativeFile) {
    data_.native_file = std::move(native_file);
  } else {
    DestroyActive();
    tag_ = Tag::kNativeFile;
    new (&data_.native_file) NativeFileInfoPtr(
        std::move(native_file));
  }
}

void FileChooserFileInfo::set_file_system(FileSystemFileInfoPtr file_system) {
  if (tag_ == Tag::kFileSystem) {
    data_.file_system = std::move(file_system);
  } else {
    DestroyActive();
    tag_ = Tag::kFileSystem;
    new (&data_.file_system) FileSystemFileInfoPtr(
        std::move(file_system));
  }
}


FileChooserFileInfo::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNativeFile)>,
    NativeFileInfoPtr value)
    : native_file(std::move(value)) {}

FileChooserFileInfo::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFileSystem)>,
    FileSystemFileInfoPtr value)
    : file_system(std::move(value)) {}

void FileChooserFileInfo::DestroyActive() {
  switch (tag_) {

    case Tag::kNativeFile:
      std::destroy_at(&data_.native_file);
      break;
    case Tag::kFileSystem:
      std::destroy_at(&data_.file_system);
      break;
  }
}

bool FileChooserFileInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

FileChooser::IPCStableHashFunction FileChooser::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileChooser>(message.name())) {
    case messages::FileChooser::kOpenFileChooser: {
      return &FileChooser::OpenFileChooser_Sym::IPCStableHash;
    }
    case messages::FileChooser::kEnumerateChosenDirectory: {
      return &FileChooser::EnumerateChosenDirectory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileChooser::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileChooser>(message.name())) {
      case messages::FileChooser::kOpenFileChooser:
            return "Receive blink::mojom::FileChooser::OpenFileChooser";
      case messages::FileChooser::kEnumerateChosenDirectory:
            return "Receive blink::mojom::FileChooser::EnumerateChosenDirectory";
    }
  } else {
    switch (static_cast<messages::FileChooser>(message.name())) {
      case messages::FileChooser::kOpenFileChooser:
            return "Receive reply blink::mojom::FileChooser::OpenFileChooser";
      case messages::FileChooser::kEnumerateChosenDirectory:
            return "Receive reply blink::mojom::FileChooser::EnumerateChosenDirectory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileChooser::OpenFileChooser_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc546606a;  // IPCStableHash for blink::mojom::FileChooser::OpenFileChooser
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileChooser::EnumerateChosenDirectory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x594cc3eb;  // IPCStableHash for blink::mojom::FileChooser::EnumerateChosenDirectory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FileChooser_OpenFileChooser_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileChooser_OpenFileChooser_ForwardToCallback(
      FileChooser::OpenFileChooserCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileChooser_OpenFileChooser_ForwardToCallback(const FileChooser_OpenFileChooser_ForwardToCallback&) = delete;
  FileChooser_OpenFileChooser_ForwardToCallback& operator=(const FileChooser_OpenFileChooser_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileChooser::OpenFileChooserCallback callback_;
};

class FileChooser_EnumerateChosenDirectory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileChooser_EnumerateChosenDirectory_ForwardToCallback(
      FileChooser::EnumerateChosenDirectoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileChooser_EnumerateChosenDirectory_ForwardToCallback(const FileChooser_EnumerateChosenDirectory_ForwardToCallback&) = delete;
  FileChooser_EnumerateChosenDirectory_ForwardToCallback& operator=(const FileChooser_EnumerateChosenDirectory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileChooser::EnumerateChosenDirectoryCallback callback_;
};

FileChooserProxy::FileChooserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileChooserProxy::OpenFileChooser(
    FileChooserParamsPtr in_params, OpenFileChooserCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileChooser::OpenFileChooser", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type FileChooserParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileChooser::kOpenFileChooser), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileChooser_OpenFileChooser_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileChooserParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in FileChooser.OpenFileChooser request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileChooser::Name_);
  message.set_method_name("OpenFileChooser");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileChooser_OpenFileChooser_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileChooserProxy::EnumerateChosenDirectory(
    const ::base::FilePath& in_directory_path, EnumerateChosenDirectoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileChooser::EnumerateChosenDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory_path"), in_directory_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileChooser::kEnumerateChosenDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileChooser_EnumerateChosenDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->directory_path)::BaseType> directory_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_directory_path,
    directory_path_fragment);

  params->directory_path.Set(
      directory_path_fragment.is_null() ? nullptr : directory_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->directory_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null directory_path in FileChooser.EnumerateChosenDirectory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileChooser::Name_);
  message.set_method_name("EnumerateChosenDirectory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileChooser_EnumerateChosenDirectory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileChooser_OpenFileChooser_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileChooser::OpenFileChooserCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileChooser_OpenFileChooser_ProxyToResponder> proxy(
        new FileChooser_OpenFileChooser_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileChooser_OpenFileChooser_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileChooser_OpenFileChooser_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileChooser_OpenFileChooser_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileChooser::OpenFileChooserCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      FileChooserResultPtr in_result);
};

bool FileChooser_OpenFileChooser_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileChooser_OpenFileChooser_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileChooser_OpenFileChooser_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileChooser.0
  bool success = true;
  FileChooserResultPtr p_result{};
  FileChooser_OpenFileChooser_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileChooser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileChooser_OpenFileChooser_ProxyToResponder::Run(
    FileChooserResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileChooser::OpenFileChooser", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type FileChooserResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileChooser::kOpenFileChooser), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileChooser_OpenFileChooser_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileChooserResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileChooser::Name_);
  message.set_method_name("OpenFileChooser");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileChooser_EnumerateChosenDirectory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileChooser::EnumerateChosenDirectoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileChooser_EnumerateChosenDirectory_ProxyToResponder> proxy(
        new FileChooser_EnumerateChosenDirectory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileChooser_EnumerateChosenDirectory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileChooser_EnumerateChosenDirectory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileChooser_EnumerateChosenDirectory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileChooser::EnumerateChosenDirectoryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      FileChooserResultPtr in_result);
};

bool FileChooser_EnumerateChosenDirectory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileChooser_EnumerateChosenDirectory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileChooser_EnumerateChosenDirectory_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileChooser.1
  bool success = true;
  FileChooserResultPtr p_result{};
  FileChooser_EnumerateChosenDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileChooser::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileChooser_EnumerateChosenDirectory_ProxyToResponder::Run(
    FileChooserResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileChooser::EnumerateChosenDirectory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type FileChooserResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileChooser::kEnumerateChosenDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileChooser_EnumerateChosenDirectory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileChooserResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileChooser::Name_);
  message.set_method_name("EnumerateChosenDirectory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileChooserStubDispatch::Accept(
    FileChooser* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileChooser>(message->header()->name)) {
    case messages::FileChooser::kOpenFileChooser: {
      break;
    }
    case messages::FileChooser::kEnumerateChosenDirectory: {
      break;
    }
  }
  return false;
}

// static
bool FileChooserStubDispatch::AcceptWithResponder(
    FileChooser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileChooser>(message->header()->name)) {
    case messages::FileChooser::kOpenFileChooser: {
      internal::FileChooser_OpenFileChooser_Params_Data* params =
          reinterpret_cast<
              internal::FileChooser_OpenFileChooser_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileChooser.0
      bool success = true;
      FileChooserParamsPtr p_params{};
      FileChooser_OpenFileChooser_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileChooser::Name_, 0, false);
        return false;
      }
      auto callback =
          FileChooser_OpenFileChooser_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFileChooser(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::FileChooser::kEnumerateChosenDirectory: {
      internal::FileChooser_EnumerateChosenDirectory_Params_Data* params =
          reinterpret_cast<
              internal::FileChooser_EnumerateChosenDirectory_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileChooser.1
      bool success = true;
      ::base::FilePath p_directory_path{};
      FileChooser_EnumerateChosenDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDirectoryPath(&p_directory_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileChooser::Name_, 1, false);
        return false;
      }
      auto callback =
          FileChooser_EnumerateChosenDirectory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateChosenDirectory(        
        std::move(p_directory_path), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileChooserValidationInfo[] = {
    { &internal::FileChooser_OpenFileChooser_Params_Data::Validate,
     &internal::FileChooser_OpenFileChooser_ResponseParams_Data::Validate},
    { &internal::FileChooser_EnumerateChosenDirectory_Params_Data::Validate,
     &internal::FileChooser_EnumerateChosenDirectory_ResponseParams_Data::Validate},
};

bool FileChooserRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FileChooser::Name_,
    kFileChooserValidationInfo);
}

bool FileChooserResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::FileChooser::Name_,
    kFileChooserValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::FileChooserParams::DataView, ::blink::mojom::blink::FileChooserParamsPtr>::Read(
    ::blink::mojom::blink::FileChooserParams::DataView input,
    ::blink::mojom::blink::FileChooserParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FileChooserParamsPtr result(::blink::mojom::blink::FileChooserParams::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadDefaultFileName(&result->default_file_name))
        success = false;
      if (success && !input.ReadSelectedFiles(&result->selected_files))
        success = false;
      if (success && !input.ReadAcceptTypes(&result->accept_types))
        success = false;
      if (success)
        result->need_local_path = input.need_local_path();
      if (success)
        result->use_media_capture = input.use_media_capture();
      if (success)
        result->open_writable = input.open_writable();
      if (success && !input.ReadRequestor(&result->requestor))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::NativeFileInfo::DataView, ::blink::mojom::blink::NativeFileInfoPtr>::Read(
    ::blink::mojom::blink::NativeFileInfo::DataView input,
    ::blink::mojom::blink::NativeFileInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::NativeFileInfoPtr result(::blink::mojom::blink::NativeFileInfo::New());
  
      if (success && !input.ReadFilePath(&result->file_path))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadBaseSubdirs(&result->base_subdirs))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::FileSystemFileInfo::DataView, ::blink::mojom::blink::FileSystemFileInfoPtr>::Read(
    ::blink::mojom::blink::FileSystemFileInfo::DataView input,
    ::blink::mojom::blink::FileSystemFileInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FileSystemFileInfoPtr result(::blink::mojom::blink::FileSystemFileInfo::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadModificationTime(&result->modification_time))
        success = false;
      if (success)
        result->length = input.length();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::FileChooserResult::DataView, ::blink::mojom::blink::FileChooserResultPtr>::Read(
    ::blink::mojom::blink::FileChooserResult::DataView input,
    ::blink::mojom::blink::FileChooserResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FileChooserResultPtr result(::blink::mojom::blink::FileChooserResult::New());
  
      if (success && !input.ReadFiles(&result->files))
        success = false;
      if (success && !input.ReadBaseDirectory(&result->base_directory))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::FileChooserFileInfo::DataView, ::blink::mojom::blink::FileChooserFileInfoPtr>::Read(
    ::blink::mojom::blink::FileChooserFileInfo::DataView input,
    ::blink::mojom::blink::FileChooserFileInfoPtr* output) {
  using UnionType = ::blink::mojom::blink::FileChooserFileInfo;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNativeFile: {
      ::blink::mojom::blink::NativeFileInfoPtr result_native_file{};
      if (!input.ReadNativeFile(&result_native_file))
        return false;

      *output = UnionType::NewNativeFile(
          std::move(result_native_file));
      break;
    }
    case Tag::kFileSystem: {
      ::blink::mojom::blink::FileSystemFileInfoPtr result_file_system{};
      if (!input.ReadFileSystem(&result_file_system))
        return false;

      *output = UnionType::NewFileSystem(
          std::move(result_file_system));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void FileChooserInterceptorForTesting::OpenFileChooser(FileChooserParamsPtr params, OpenFileChooserCallback callback) {
  GetForwardingInterface()->OpenFileChooser(
    std::move(params)
    , std::move(callback));
}
void FileChooserInterceptorForTesting::EnumerateChosenDirectory(const ::base::FilePath& directory_path, EnumerateChosenDirectoryCallback callback) {
  GetForwardingInterface()->EnumerateChosenDirectory(
    std::move(directory_path)
    , std::move(callback));
}
FileChooserAsyncWaiter::FileChooserAsyncWaiter(
    FileChooser* proxy) : proxy_(proxy) {}

FileChooserAsyncWaiter::~FileChooserAsyncWaiter() = default;


void FileChooserAsyncWaiter::OpenFileChooser(
    FileChooserParamsPtr params, FileChooserResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->OpenFileChooser(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             FileChooserResultPtr* out_result
,
             FileChooserResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

FileChooserResultPtr FileChooserAsyncWaiter::OpenFileChooser(
    FileChooserParamsPtr params) {
  FileChooserResultPtr async_wait_result;
  OpenFileChooser(std::move(params),&async_wait_result);
  return async_wait_result;
}

void FileChooserAsyncWaiter::EnumerateChosenDirectory(
    const ::base::FilePath& directory_path, FileChooserResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->EnumerateChosenDirectory(
      std::move(directory_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             FileChooserResultPtr* out_result
,
             FileChooserResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

FileChooserResultPtr FileChooserAsyncWaiter::EnumerateChosenDirectory(
    const ::base::FilePath& directory_path) {
  FileChooserResultPtr async_wait_result;
  EnumerateChosenDirectory(std::move(directory_path),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif