// third_party/blink/public/mojom/cache_storage/cache_storage.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT CacheStorageCacheInterceptorForTesting : public CacheStorageCache {
  virtual CacheStorageCache* GetForwardingInterface() = 0;
  void Match(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) override;
  void MatchAll(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, MatchAllCallback callback) override;
  void GetAllMatchedEntries(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, GetAllMatchedEntriesCallback callback) override;
  void Keys(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id, KeysCallback callback) override;
  void Batch(std::vector<BatchOperationPtr> batch_operations, int64_t trace_id, BatchCallback callback) override;
  void WriteSideData(const ::GURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, int64_t trace_id, WriteSideDataCallback callback) override;
};
class BLINK_COMMON_EXPORT CacheStorageCacheAsyncWaiter {
 public:
  explicit CacheStorageCacheAsyncWaiter(CacheStorageCache* proxy);

  CacheStorageCacheAsyncWaiter(const CacheStorageCacheAsyncWaiter&) = delete;
  CacheStorageCacheAsyncWaiter& operator=(const CacheStorageCacheAsyncWaiter&) = delete;

  ~CacheStorageCacheAsyncWaiter();
  void Match(
      ::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id,
base::expected<
  MatchResponsePtr,
  CacheStorageError>* out_result);
  CacheStorageCache_Match_ResponseParam_ResultPtr Match(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id);
  void MatchAll(
      ::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id,
base::expected<
  std::vector<::blink::mojom::FetchAPIResponsePtr>,
  CacheStorageError>* out_result);
  CacheStorageCache_MatchAll_ResponseParam_ResultPtr MatchAll(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id);
  void GetAllMatchedEntries(
      ::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id,
base::expected<
  std::vector<CacheEntryPtr>,
  CacheStorageError>* out_result);
  CacheStorageCache_GetAllMatchedEntries_ResponseParam_ResultPtr GetAllMatchedEntries(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id);
  void Keys(
      ::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id,
base::expected<
  std::vector<::blink::mojom::FetchAPIRequestPtr>,
  CacheStorageError>* out_result);
  CacheStorageCache_Keys_ResponseParam_ResultPtr Keys(::blink::mojom::FetchAPIRequestPtr request, CacheQueryOptionsPtr query_options, int64_t trace_id);
  void Batch(
      std::vector<BatchOperationPtr> batch_operations, int64_t trace_id, CacheStorageVerboseErrorPtr* out_result);
  CacheStorageVerboseErrorPtr Batch(std::vector<BatchOperationPtr> batch_operations, int64_t trace_id);
  void WriteSideData(
      const ::GURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, int64_t trace_id, CacheStorageError* out_result);
  CacheStorageError WriteSideData(const ::GURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, int64_t trace_id);

 private:
  CacheStorageCache* const proxy_;
};


class BLINK_COMMON_EXPORT CacheStorageInterceptorForTesting : public CacheStorage {
  virtual CacheStorage* GetForwardingInterface() = 0;
  void Has(const ::std::u16string& cache_name, int64_t trace_id, HasCallback callback) override;
  void Delete(const ::std::u16string& cache_name, int64_t trace_id, DeleteCallback callback) override;
  void Keys(int64_t trace_id, KeysCallback callback) override;
  void Match(::blink::mojom::FetchAPIRequestPtr request, MultiCacheQueryOptionsPtr match_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id, MatchCallback callback) override;
  void Open(const ::std::u16string& cache_name, int64_t trace_id, OpenCallback callback) override;
};
class BLINK_COMMON_EXPORT CacheStorageAsyncWaiter {
 public:
  explicit CacheStorageAsyncWaiter(CacheStorage* proxy);

  CacheStorageAsyncWaiter(const CacheStorageAsyncWaiter&) = delete;
  CacheStorageAsyncWaiter& operator=(const CacheStorageAsyncWaiter&) = delete;

  ~CacheStorageAsyncWaiter();
  void Has(
      const ::std::u16string& cache_name, int64_t trace_id, CacheStorageError* out_result);
  CacheStorageError Has(const ::std::u16string& cache_name, int64_t trace_id);
  void Delete(
      const ::std::u16string& cache_name, int64_t trace_id, CacheStorageError* out_result);
  CacheStorageError Delete(const ::std::u16string& cache_name, int64_t trace_id);
  void Keys(
      int64_t trace_id, std::vector<::std::u16string>* out_keys);
  std::vector<::std::u16string> Keys(int64_t trace_id);
  void Match(
      ::blink::mojom::FetchAPIRequestPtr request, MultiCacheQueryOptionsPtr match_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id,
base::expected<
  MatchResponsePtr,
  CacheStorageError>* out_result);
  CacheStorage_Match_ResponseParam_ResultPtr Match(::blink::mojom::FetchAPIRequestPtr request, MultiCacheQueryOptionsPtr match_options, bool in_related_fetch_event, bool in_range_fetch_event, int64_t trace_id);
  void Open(
      const ::std::u16string& cache_name, int64_t trace_id,
base::expected<
  ::mojo::PendingAssociatedRemote<CacheStorageCache>,
  CacheStorageError>* out_result);
  CacheStorage_Open_ResponseParam_ResultPtr Open(const ::std::u16string& cache_name, int64_t trace_id);

 private:
  CacheStorage* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_TEST_UTILS_H_