// third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BUCKETS_BUCKET_MANAGER_HOST_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BUCKETS_BUCKET_MANAGER_HOST_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT BucketHostInterceptorForTesting : public BucketHost {
  virtual BucketHost* GetForwardingInterface() = 0;
  void Persist(PersistCallback callback) override;
  void Persisted(PersistedCallback callback) override;
  void Estimate(EstimateCallback callback) override;
  void Durability(DurabilityCallback callback) override;
  void SetExpires(::base::Time expires, SetExpiresCallback callback) override;
  void Expires(ExpiresCallback callback) override;
  void GetIdbFactory(::mojo::PendingReceiver<::blink::mojom::IDBFactory> idb_factory) override;
  void GetLockManager(::mojo::PendingReceiver<::blink::mojom::LockManager> lock_manager) override;
  void GetCaches(::mojo::PendingReceiver<::blink::mojom::CacheStorage> cache_storage) override;
  void GetDirectory(GetDirectoryCallback callback) override;
  void GetDirectoryForDevtools(const std::vector<std::string>& directory_path_components, GetDirectoryForDevtoolsCallback callback) override;
};
class BLINK_COMMON_EXPORT BucketHostAsyncWaiter {
 public:
  explicit BucketHostAsyncWaiter(BucketHost* proxy);

  BucketHostAsyncWaiter(const BucketHostAsyncWaiter&) = delete;
  BucketHostAsyncWaiter& operator=(const BucketHostAsyncWaiter&) = delete;

  ~BucketHostAsyncWaiter();
  void Persist(
      bool* out_persisted, bool* out_success);
  
  void Persisted(
      bool* out_persisted, bool* out_success);
  
  void Estimate(
      int64_t* out_current_usage, int64_t* out_current_quota, bool* out_success);
  
  void Durability(
      ::blink::mojom::BucketDurability* out_durability, bool* out_success);
  
  void SetExpires(
      ::base::Time expires, bool* out_success);
  bool SetExpires(::base::Time expires);
  void Expires(
      std::optional<::base::Time>* out_expires, bool* out_success);
  
  void GetDirectory(
      ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>* out_directory);
  
  void GetDirectoryForDevtools(
      const std::vector<std::string>& directory_path_components, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>* out_directory);
  

 private:
  BucketHost* const proxy_;
};


class BLINK_COMMON_EXPORT BucketManagerHostInterceptorForTesting : public BucketManagerHost {
  virtual BucketManagerHost* GetForwardingInterface() = 0;
  void OpenBucket(const std::string& name, BucketPoliciesPtr policy, OpenBucketCallback callback) override;
  void GetBucketForDevtools(const std::string& name, ::mojo::PendingReceiver<BucketHost> receiver) override;
  void Keys(KeysCallback callback) override;
  void DeleteBucket(const std::string& name, DeleteBucketCallback callback) override;
};
class BLINK_COMMON_EXPORT BucketManagerHostAsyncWaiter {
 public:
  explicit BucketManagerHostAsyncWaiter(BucketManagerHost* proxy);

  BucketManagerHostAsyncWaiter(const BucketManagerHostAsyncWaiter&) = delete;
  BucketManagerHostAsyncWaiter& operator=(const BucketManagerHostAsyncWaiter&) = delete;

  ~BucketManagerHostAsyncWaiter();
  void OpenBucket(
      const std::string& name, BucketPoliciesPtr policy, ::mojo::PendingRemote<BucketHost>* out_remote, BucketError* out_error);
  
  void Keys(
      std::vector<std::string>* out_buckets, bool* out_success);
  
  void DeleteBucket(
      const std::string& name, bool* out_success);
  bool DeleteBucket(const std::string& name);

 private:
  BucketManagerHost* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BUCKETS_BUCKET_MANAGER_HOST_MOJOM_TEST_UTILS_H_