// third_party/blink/public/mojom/blob/serialized_blob.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_SERIALIZED_BLOB_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_SERIALIZED_BLOB_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"

#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::SerializedBlobDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SerializedBlobDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SerializedBlob_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uuid)::BaseType> uuid_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_uuid,
        uuid_fragment);

      fragment->uuid.Set(
          uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uuid.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuid in SerializedBlob struct");

      decltype(Traits::content_type(input)) in_content_type = Traits::content_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_type)::BaseType> content_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_content_type,
        content_type_fragment);

      fragment->content_type.Set(
          content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_type in SerializedBlob struct");

      fragment->size = Traits::size(input);

      decltype(Traits::blob(input)) in_blob = Traits::blob(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
        in_blob,
        &fragment->blob,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->blob)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid blob in SerializedBlob struct");
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_SERIALIZED_BLOB_MOJOM_SEND_VALIDATION_H_