// third_party/blink/public/mojom/blob/data_element.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/blob/data_element.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../../../mojo/public/mojom/base/file.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/blob.mojom', 'blob.mojom.js');
  }



  function DataElementBytes(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataElementBytes.MAXIMUM_EMBEDDED_DATA_SIZE = 256000;
  DataElementBytes.prototype.initDefaults_ = function() {
    this.length = 0;
    this.embeddedData = null;
    this.data = new BytesProviderPtr();
  };
  DataElementBytes.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataElementBytes.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DataElementBytes.embeddedData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataElementBytes.data
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DataElementBytes.encodedSize = codec.kStructHeaderSize + 24;

  DataElementBytes.decode = function(decoder) {
    var packed;
    var val = new DataElementBytes();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.length =
        decoder.decodeStruct(codec.Uint64);
    val.embeddedData =
        decoder.decodeArrayPointer(codec.Uint8);
    val.data =
        decoder.decodeStruct(new codec.Interface(BytesProviderPtr));
    return val;
  };

  DataElementBytes.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataElementBytes.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.length);
    encoder.encodeArrayPointer(codec.Uint8, val.embeddedData);
    encoder.encodeStruct(new codec.Interface(BytesProviderPtr), val.data);
  };
  function DataElementFile(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataElementFile.prototype.initDefaults_ = function() {
    this.path = null;
    this.offset = 0;
    this.length = 0;
    this.expectedModificationTime = null;
  };
  DataElementFile.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataElementFile.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataElementFile.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate DataElementFile.expectedModificationTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DataElementFile.encodedSize = codec.kStructHeaderSize + 32;

  DataElementFile.decode = function(decoder) {
    var packed;
    var val = new DataElementFile();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.offset =
        decoder.decodeStruct(codec.Uint64);
    val.length =
        decoder.decodeStruct(codec.Uint64);
    val.expectedModificationTime =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  DataElementFile.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataElementFile.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    encoder.encodeStruct(codec.Uint64, val.offset);
    encoder.encodeStruct(codec.Uint64, val.length);
    encoder.encodeStructPointer(time$.Time, val.expectedModificationTime);
  };
  function DataElementBlob(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataElementBlob.prototype.initDefaults_ = function() {
    this.blob = new blob$.BlobPtr();
    this.offset = 0;
    this.length = 0;
  };
  DataElementBlob.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataElementBlob.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataElementBlob.blob
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  DataElementBlob.encodedSize = codec.kStructHeaderSize + 24;

  DataElementBlob.decode = function(decoder) {
    var packed;
    var val = new DataElementBlob();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blob =
        decoder.decodeStruct(new codec.Interface(blob$.BlobPtr));
    val.offset =
        decoder.decodeStruct(codec.Uint64);
    val.length =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  DataElementBlob.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataElementBlob.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(blob$.BlobPtr), val.blob);
    encoder.encodeStruct(codec.Uint64, val.offset);
    encoder.encodeStruct(codec.Uint64, val.length);
  };
  function BytesProvider_RequestAsReply_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BytesProvider_RequestAsReply_Params.prototype.initDefaults_ = function() {
  };
  BytesProvider_RequestAsReply_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BytesProvider_RequestAsReply_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BytesProvider_RequestAsReply_Params.encodedSize = codec.kStructHeaderSize + 0;

  BytesProvider_RequestAsReply_Params.decode = function(decoder) {
    var packed;
    var val = new BytesProvider_RequestAsReply_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  BytesProvider_RequestAsReply_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BytesProvider_RequestAsReply_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function BytesProvider_RequestAsReply_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BytesProvider_RequestAsReply_ResponseParams.prototype.initDefaults_ = function() {
    this.data = null;
  };
  BytesProvider_RequestAsReply_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BytesProvider_RequestAsReply_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BytesProvider_RequestAsReply_ResponseParams.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BytesProvider_RequestAsReply_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  BytesProvider_RequestAsReply_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BytesProvider_RequestAsReply_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  BytesProvider_RequestAsReply_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BytesProvider_RequestAsReply_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
  };
  function BytesProvider_RequestAsStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BytesProvider_RequestAsStream_Params.prototype.initDefaults_ = function() {
    this.pipe = null;
  };
  BytesProvider_RequestAsStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BytesProvider_RequestAsStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BytesProvider_RequestAsStream_Params.pipe
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BytesProvider_RequestAsStream_Params.encodedSize = codec.kStructHeaderSize + 8;

  BytesProvider_RequestAsStream_Params.decode = function(decoder) {
    var packed;
    var val = new BytesProvider_RequestAsStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pipe =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BytesProvider_RequestAsStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BytesProvider_RequestAsStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Handle, val.pipe);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function BytesProvider_RequestAsFile_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BytesProvider_RequestAsFile_Params.prototype.initDefaults_ = function() {
    this.sourceOffset = 0;
    this.sourceSize = 0;
    this.file = null;
    this.fileOffset = 0;
  };
  BytesProvider_RequestAsFile_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BytesProvider_RequestAsFile_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate BytesProvider_RequestAsFile_Params.file
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, file$.File, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  BytesProvider_RequestAsFile_Params.encodedSize = codec.kStructHeaderSize + 32;

  BytesProvider_RequestAsFile_Params.decode = function(decoder) {
    var packed;
    var val = new BytesProvider_RequestAsFile_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceOffset =
        decoder.decodeStruct(codec.Uint64);
    val.sourceSize =
        decoder.decodeStruct(codec.Uint64);
    val.file =
        decoder.decodeStructPointer(file$.File);
    val.fileOffset =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  BytesProvider_RequestAsFile_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BytesProvider_RequestAsFile_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.sourceOffset);
    encoder.encodeStruct(codec.Uint64, val.sourceSize);
    encoder.encodeStructPointer(file$.File, val.file);
    encoder.encodeStruct(codec.Uint64, val.fileOffset);
  };
  function BytesProvider_RequestAsFile_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BytesProvider_RequestAsFile_ResponseParams.prototype.initDefaults_ = function() {
    this.timeFileModified = null;
  };
  BytesProvider_RequestAsFile_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BytesProvider_RequestAsFile_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BytesProvider_RequestAsFile_ResponseParams.timeFileModified
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BytesProvider_RequestAsFile_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  BytesProvider_RequestAsFile_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new BytesProvider_RequestAsFile_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.timeFileModified =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  BytesProvider_RequestAsFile_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BytesProvider_RequestAsFile_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.timeFileModified);
  };

  function DataElement(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  DataElement.Tags = {
    bytes: 0,
    file: 1,
    blob: 2,
  };

  DataElement.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  DataElement.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "bytes",
        "file",
        "blob",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a DataElement member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(DataElement.prototype, "bytes", {
    get: function() {
      if (this.$tag != DataElement.Tags.bytes) {
        throw new ReferenceError(
            "DataElement.bytes is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DataElement.Tags.bytes;
      this.$data = value;
    }
  });
  Object.defineProperty(DataElement.prototype, "file", {
    get: function() {
      if (this.$tag != DataElement.Tags.file) {
        throw new ReferenceError(
            "DataElement.file is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DataElement.Tags.file;
      this.$data = value;
    }
  });
  Object.defineProperty(DataElement.prototype, "blob", {
    get: function() {
      if (this.$tag != DataElement.Tags.blob) {
        throw new ReferenceError(
            "DataElement.blob is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DataElement.Tags.blob;
      this.$data = value;
    }
  });


    DataElement.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case DataElement.Tags.bytes:
          encoder.encodeStructPointer(DataElementBytes, val.bytes);
          break;
        case DataElement.Tags.file:
          encoder.encodeStructPointer(DataElementFile, val.file);
          break;
        case DataElement.Tags.blob:
          encoder.encodeStructPointer(DataElementBlob, val.blob);
          break;
      }
      encoder.align();
    };


    DataElement.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new DataElement();
      var tag = decoder.readUint32();
      switch (tag) {
        case DataElement.Tags.bytes:
          result.bytes = decoder.decodeStructPointer(DataElementBytes);
          break;
        case DataElement.Tags.file:
          result.file = decoder.decodeStructPointer(DataElementFile);
          break;
        case DataElement.Tags.blob:
          result.blob = decoder.decodeStructPointer(DataElementBlob);
          break;
      }
      decoder.align();

      return result;
    };


    DataElement.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case DataElement.Tags.bytes:
          

    // validate DataElement.bytes
    err = messageValidator.validateStructPointer(data_offset, DataElementBytes, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DataElement.Tags.file:
          

    // validate DataElement.file
    err = messageValidator.validateStructPointer(data_offset, DataElementFile, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DataElement.Tags.blob:
          

    // validate DataElement.blob
    err = messageValidator.validateStructPointer(data_offset, DataElementBlob, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  DataElement.encodedSize = 16;
  var kBytesProvider_RequestAsReply_Name = 0;
  var kBytesProvider_RequestAsStream_Name = 1;
  var kBytesProvider_RequestAsFile_Name = 2;

  function BytesProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(BytesProvider,
                                                   handleOrPtrInfo);
  }

  function BytesProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        BytesProvider, associatedInterfacePtrInfo);
  }

  BytesProviderAssociatedPtr.prototype =
      Object.create(BytesProviderPtr.prototype);
  BytesProviderAssociatedPtr.prototype.constructor =
      BytesProviderAssociatedPtr;

  function BytesProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  BytesProviderPtr.prototype.requestAsReply = function() {
    return BytesProviderProxy.prototype.requestAsReply
        .apply(this.ptr.getProxy(), arguments);
  };

  BytesProviderProxy.prototype.requestAsReply = function() {
    var params_ = new BytesProvider_RequestAsReply_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBytesProvider_RequestAsReply_Name,
          codec.align(BytesProvider_RequestAsReply_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BytesProvider_RequestAsReply_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BytesProvider_RequestAsReply_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  BytesProviderPtr.prototype.requestAsStream = function() {
    return BytesProviderProxy.prototype.requestAsStream
        .apply(this.ptr.getProxy(), arguments);
  };

  BytesProviderProxy.prototype.requestAsStream = function(pipe) {
    var params_ = new BytesProvider_RequestAsStream_Params();
    params_.pipe = pipe;
    var builder = new codec.MessageV0Builder(
        kBytesProvider_RequestAsStream_Name,
        codec.align(BytesProvider_RequestAsStream_Params.encodedSize));
    builder.encodeStruct(BytesProvider_RequestAsStream_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  BytesProviderPtr.prototype.requestAsFile = function() {
    return BytesProviderProxy.prototype.requestAsFile
        .apply(this.ptr.getProxy(), arguments);
  };

  BytesProviderProxy.prototype.requestAsFile = function(sourceOffset, sourceSize, file, fileOffset) {
    var params_ = new BytesProvider_RequestAsFile_Params();
    params_.sourceOffset = sourceOffset;
    params_.sourceSize = sourceSize;
    params_.file = file;
    params_.fileOffset = fileOffset;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kBytesProvider_RequestAsFile_Name,
          codec.align(BytesProvider_RequestAsFile_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(BytesProvider_RequestAsFile_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(BytesProvider_RequestAsFile_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function BytesProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  BytesProviderStub.prototype.requestAsReply = function() {
    return this.delegate_ && this.delegate_.requestAsReply && this.delegate_.requestAsReply();
  }
  BytesProviderStub.prototype.requestAsStream = function(pipe) {
    return this.delegate_ && this.delegate_.requestAsStream && this.delegate_.requestAsStream(pipe);
  }
  BytesProviderStub.prototype.requestAsFile = function(sourceOffset, sourceSize, file, fileOffset) {
    return this.delegate_ && this.delegate_.requestAsFile && this.delegate_.requestAsFile(sourceOffset, sourceSize, file, fileOffset);
  }

  BytesProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBytesProvider_RequestAsStream_Name:
      var params = reader.decodeStruct(BytesProvider_RequestAsStream_Params);
      this.requestAsStream(params.pipe);
      return true;
    default:
      return false;
    }
  };

  BytesProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBytesProvider_RequestAsReply_Name:
      var params = reader.decodeStruct(BytesProvider_RequestAsReply_Params);
      this.requestAsReply().then(function(response) {
        var responseParams =
            new BytesProvider_RequestAsReply_ResponseParams();
        responseParams.data = response.data;
        var builder = new codec.MessageV1Builder(
            kBytesProvider_RequestAsReply_Name,
            codec.align(BytesProvider_RequestAsReply_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BytesProvider_RequestAsReply_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kBytesProvider_RequestAsFile_Name:
      var params = reader.decodeStruct(BytesProvider_RequestAsFile_Params);
      this.requestAsFile(params.sourceOffset, params.sourceSize, params.file, params.fileOffset).then(function(response) {
        var responseParams =
            new BytesProvider_RequestAsFile_ResponseParams();
        responseParams.timeFileModified = response.timeFileModified;
        var builder = new codec.MessageV1Builder(
            kBytesProvider_RequestAsFile_Name,
            codec.align(BytesProvider_RequestAsFile_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(BytesProvider_RequestAsFile_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateBytesProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kBytesProvider_RequestAsReply_Name:
        if (message.expectsResponse())
          paramsClass = BytesProvider_RequestAsReply_Params;
      break;
      case kBytesProvider_RequestAsStream_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = BytesProvider_RequestAsStream_Params;
      break;
      case kBytesProvider_RequestAsFile_Name:
        if (message.expectsResponse())
          paramsClass = BytesProvider_RequestAsFile_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateBytesProviderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kBytesProvider_RequestAsReply_Name:
        if (message.isResponse())
          paramsClass = BytesProvider_RequestAsReply_ResponseParams;
        break;
      case kBytesProvider_RequestAsFile_Name:
        if (message.isResponse())
          paramsClass = BytesProvider_RequestAsFile_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var BytesProvider = {
    name: 'blink.mojom.BytesProvider',
    kVersion: 0,
    ptrClass: BytesProviderPtr,
    proxyClass: BytesProviderProxy,
    stubClass: BytesProviderStub,
    validateRequest: validateBytesProviderRequest,
    validateResponse: validateBytesProviderResponse,
  };
  BytesProviderStub.prototype.validator = validateBytesProviderRequest;
  BytesProviderProxy.prototype.validator = validateBytesProviderResponse;
  exports.DataElementBytes = DataElementBytes;
  exports.DataElementFile = DataElementFile;
  exports.DataElementBlob = DataElementBlob;
  exports.DataElement = DataElement;
  exports.BytesProvider = BytesProvider;
  exports.BytesProviderPtr = BytesProviderPtr;
  exports.BytesProviderAssociatedPtr = BytesProviderAssociatedPtr;
})();