// third_party/blink/public/mojom/badging/badging.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/badging/badging.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function BadgeService_SetBadge_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BadgeService_SetBadge_Params.prototype.initDefaults_ = function() {
    this.value = null;
  };
  BadgeService_SetBadge_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BadgeService_SetBadge_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BadgeService_SetBadge_Params.value
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, BadgeValue, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BadgeService_SetBadge_Params.encodedSize = codec.kStructHeaderSize + 16;

  BadgeService_SetBadge_Params.decode = function(decoder) {
    var packed;
    var val = new BadgeService_SetBadge_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(BadgeValue);
    return val;
  };

  BadgeService_SetBadge_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BadgeService_SetBadge_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(BadgeValue, val.value);
  };
  function BadgeService_ClearBadge_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BadgeService_ClearBadge_Params.prototype.initDefaults_ = function() {
  };
  BadgeService_ClearBadge_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BadgeService_ClearBadge_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BadgeService_ClearBadge_Params.encodedSize = codec.kStructHeaderSize + 0;

  BadgeService_ClearBadge_Params.decode = function(decoder) {
    var packed;
    var val = new BadgeService_ClearBadge_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  BadgeService_ClearBadge_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BadgeService_ClearBadge_Params.encodedSize);
    encoder.writeUint32(0);
  };

  function BadgeValue(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  BadgeValue.Tags = {
    flag: 0,
    number: 1,
  };

  BadgeValue.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  BadgeValue.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "flag",
        "number",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a BadgeValue member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(BadgeValue.prototype, "flag", {
    get: function() {
      if (this.$tag != BadgeValue.Tags.flag) {
        throw new ReferenceError(
            "BadgeValue.flag is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = BadgeValue.Tags.flag;
      this.$data = value;
    }
  });
  Object.defineProperty(BadgeValue.prototype, "number", {
    get: function() {
      if (this.$tag != BadgeValue.Tags.number) {
        throw new ReferenceError(
            "BadgeValue.number is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = BadgeValue.Tags.number;
      this.$data = value;
    }
  });


    BadgeValue.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case BadgeValue.Tags.flag:
          encoder.encodeStruct(codec.Uint8, val.flag);
          break;
        case BadgeValue.Tags.number:
          encoder.encodeStruct(codec.Uint64, val.number);
          break;
      }
      encoder.align();
    };


    BadgeValue.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new BadgeValue();
      var tag = decoder.readUint32();
      switch (tag) {
        case BadgeValue.Tags.flag:
          result.flag = decoder.decodeStruct(codec.Uint8);
          break;
        case BadgeValue.Tags.number:
          result.number = decoder.decodeStruct(codec.Uint64);
          break;
      }
      decoder.align();

      return result;
    };


    BadgeValue.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case BadgeValue.Tags.flag:
          

          break;
        case BadgeValue.Tags.number:
          

          break;
      }

      return validator.validationError.NONE;
    };

  BadgeValue.encodedSize = 16;
  var kBadgeService_SetBadge_Name = 0;
  var kBadgeService_ClearBadge_Name = 1;

  function BadgeServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(BadgeService,
                                                   handleOrPtrInfo);
  }

  function BadgeServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        BadgeService, associatedInterfacePtrInfo);
  }

  BadgeServiceAssociatedPtr.prototype =
      Object.create(BadgeServicePtr.prototype);
  BadgeServiceAssociatedPtr.prototype.constructor =
      BadgeServiceAssociatedPtr;

  function BadgeServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  BadgeServicePtr.prototype.setBadge = function() {
    return BadgeServiceProxy.prototype.setBadge
        .apply(this.ptr.getProxy(), arguments);
  };

  BadgeServiceProxy.prototype.setBadge = function(value) {
    var params_ = new BadgeService_SetBadge_Params();
    params_.value = value;
    var builder = new codec.MessageV0Builder(
        kBadgeService_SetBadge_Name,
        codec.align(BadgeService_SetBadge_Params.encodedSize));
    builder.encodeStruct(BadgeService_SetBadge_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  BadgeServicePtr.prototype.clearBadge = function() {
    return BadgeServiceProxy.prototype.clearBadge
        .apply(this.ptr.getProxy(), arguments);
  };

  BadgeServiceProxy.prototype.clearBadge = function() {
    var params_ = new BadgeService_ClearBadge_Params();
    var builder = new codec.MessageV0Builder(
        kBadgeService_ClearBadge_Name,
        codec.align(BadgeService_ClearBadge_Params.encodedSize));
    builder.encodeStruct(BadgeService_ClearBadge_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function BadgeServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  BadgeServiceStub.prototype.setBadge = function(value) {
    return this.delegate_ && this.delegate_.setBadge && this.delegate_.setBadge(value);
  }
  BadgeServiceStub.prototype.clearBadge = function() {
    return this.delegate_ && this.delegate_.clearBadge && this.delegate_.clearBadge();
  }

  BadgeServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBadgeService_SetBadge_Name:
      var params = reader.decodeStruct(BadgeService_SetBadge_Params);
      this.setBadge(params.value);
      return true;
    case kBadgeService_ClearBadge_Name:
      var params = reader.decodeStruct(BadgeService_ClearBadge_Params);
      this.clearBadge();
      return true;
    default:
      return false;
    }
  };

  BadgeServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateBadgeServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kBadgeService_SetBadge_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = BadgeService_SetBadge_Params;
      break;
      case kBadgeService_ClearBadge_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = BadgeService_ClearBadge_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateBadgeServiceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var BadgeService = {
    name: 'blink.mojom.BadgeService',
    kVersion: 0,
    ptrClass: BadgeServicePtr,
    proxyClass: BadgeServiceProxy,
    stubClass: BadgeServiceStub,
    validateRequest: validateBadgeServiceRequest,
    validateResponse: null,
  };
  BadgeServiceStub.prototype.validator = validateBadgeServiceRequest;
  BadgeServiceProxy.prototype.validator = null;
  exports.BadgeValue = BadgeValue;
  exports.BadgeService = BadgeService;
  exports.BadgeServicePtr = BadgeServicePtr;
  exports.BadgeServiceAssociatedPtr = BadgeServiceAssociatedPtr;
})();