// third_party/blink/public/mojom/background_fetch/background_fetch.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::BackgroundFetchError>
    : public mojo::internal::EnumHashImpl<::blink::mojom::BackgroundFetchError> {};

template <>
struct hash<::blink::mojom::BackgroundFetchResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::BackgroundFetchResult> {};

template <>
struct hash<::blink::mojom::BackgroundFetchFailureReason>
    : public mojo::internal::EnumHashImpl<::blink::mojom::BackgroundFetchFailureReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::BackgroundFetchError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::BackgroundFetchError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::BackgroundFetchResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::BackgroundFetchResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchFailureReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::BackgroundFetchFailureReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::BackgroundFetchFailureReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchSettledFetchDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BackgroundFetchSettledFetchDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BackgroundFetchSettledFetch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
      in_request,
      request_fragment);

    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->request.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in BackgroundFetchSettledFetch struct");

    decltype(Traits::response(input)) in_response = Traits::response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response)::BaseType> response_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::FetchAPIResponseDataView>(
      in_response,
      response_fragment);

    fragment->response.Set(
        response_fragment.is_null() ? nullptr : response_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::BackgroundFetchSettledFetch_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BackgroundFetchSettledFetchDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BackgroundFetchOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BackgroundFetchOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>>(
      in_icons,
      icons_fragment,
      &icons_validate_params);

    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons in BackgroundFetchOptions struct");

    fragment->download_total = Traits::download_total(input);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in BackgroundFetchOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::BackgroundFetchOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BackgroundFetchOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchRegistrationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BackgroundFetchRegistrationDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BackgroundFetchRegistrationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::developer_id(input)) in_developer_id = Traits::developer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->developer_id)::BaseType> developer_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_developer_id,
      developer_id_fragment);

    fragment->developer_id.Set(
        developer_id_fragment.is_null() ? nullptr : developer_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->developer_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null developer_id in BackgroundFetchRegistrationData struct");

    fragment->upload_total = Traits::upload_total(input);

    fragment->uploaded = Traits::uploaded(input);

    fragment->download_total = Traits::download_total(input);

    fragment->downloaded = Traits::downloaded(input);

    
    mojo::internal::Serialize<::blink::mojom::BackgroundFetchResult>(
      Traits::result(input),
      &fragment->result);

    
    mojo::internal::Serialize<::blink::mojom::BackgroundFetchFailureReason>(
      Traits::failure_reason(input),
      &fragment->failure_reason);
  }

  static bool Deserialize(::blink::mojom::internal::BackgroundFetchRegistrationData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BackgroundFetchRegistrationDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchRegistrationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BackgroundFetchRegistrationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BackgroundFetchRegistration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::registration_data(input)) in_registration_data = Traits::registration_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->registration_data)::BaseType> registration_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::BackgroundFetchRegistrationDataDataView>(
      in_registration_data,
      registration_data_fragment);

    fragment->registration_data.Set(
        registration_data_fragment.is_null() ? nullptr : registration_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->registration_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registration_data in BackgroundFetchRegistration struct");

    decltype(Traits::registration_interface(input)) in_registration_interface = Traits::registration_interface(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BackgroundFetchRegistrationServiceInterfaceBase>>(
      in_registration_interface,
      &fragment->registration_interface,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->registration_interface)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid registration_interface in BackgroundFetchRegistration struct");
  }

  static bool Deserialize(::blink::mojom::internal::BackgroundFetchRegistration_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BackgroundFetchRegistrationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BackgroundFetchUkmDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BackgroundFetchUkmDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BackgroundFetchUkmData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->ideal_to_chosen_icon_size = Traits::ideal_to_chosen_icon_size(input);
  }

  static bool Deserialize(::blink::mojom::internal::BackgroundFetchUkmData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BackgroundFetchUkmDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void BackgroundFetchSettledFetchDataView::GetRequestDataView(
    ::blink::mojom::FetchAPIRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = ::blink::mojom::FetchAPIRequestDataView(pointer, message_);
}
inline void BackgroundFetchSettledFetchDataView::GetResponseDataView(
    ::blink::mojom::FetchAPIResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = ::blink::mojom::FetchAPIResponseDataView(pointer, message_);
}


inline void BackgroundFetchOptionsDataView::GetIconsDataView(
    mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::ArrayDataView<::blink::mojom::ManifestImageResourceDataView>(pointer, message_);
}
inline void BackgroundFetchOptionsDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BackgroundFetchRegistrationDataDataView::GetDeveloperIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->developer_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BackgroundFetchRegistrationDataView::GetRegistrationDataDataView(
    BackgroundFetchRegistrationDataDataView* output) {
  auto pointer = data_->registration_data.Get();
  *output = BackgroundFetchRegistrationDataDataView(pointer, message_);
}





}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::BackgroundFetchError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::BackgroundFetchError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::BackgroundFetchResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::BackgroundFetchResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::BackgroundFetchFailureReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::BackgroundFetchFailureReason value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_SHARED_H_