// third_party/blink/public/mojom/ai/model_streaming_responder.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_MODEL_STREAMING_RESPONDER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_MODEL_STREAMING_RESPONDER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_common.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class ModelStreamingResponderProxy;

template <typename ImplRefTraits>
class ModelStreamingResponderStub;

class ModelStreamingResponderRequestValidator;


class PLATFORM_EXPORT ModelStreamingResponder
    : public ModelStreamingResponderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ModelStreamingResponder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ModelStreamingResponderInterfaceBase;
  using Proxy_ = ModelStreamingResponderProxy;

  template <typename ImplRefTraits>
  using Stub_ = ModelStreamingResponderStub<ImplRefTraits>;

  using RequestValidator_ = ModelStreamingResponderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCompletionMinVersion = 0,
    kOnErrorMinVersion = 0,
    kOnStreamingMinVersion = 0,
    kOnQuotaOverflowMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnCompletion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStreaming_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnQuotaOverflow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ModelStreamingResponder() = default;

  virtual void OnCompletion(ModelExecutionContextInfoPtr context_info) = 0;

  virtual void OnError(ModelStreamingResponseStatus status, ::blink::mojom::blink::QuotaErrorInfoPtr quota_error_info) = 0;

  virtual void OnStreaming(const ::blink::String& text) = 0;

  virtual void OnQuotaOverflow() = 0;
};



class PLATFORM_EXPORT ModelStreamingResponderProxy
    : public ModelStreamingResponder {
 public:
  using InterfaceType = ModelStreamingResponder;

  explicit ModelStreamingResponderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCompletion(ModelExecutionContextInfoPtr context_info) final;
  
  void OnError(ModelStreamingResponseStatus status, ::blink::mojom::blink::QuotaErrorInfoPtr quota_error_info) final;
  
  void OnStreaming(const ::blink::String& text) final;
  
  void OnQuotaOverflow() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT ModelStreamingResponderStubDispatch {
 public:
  static bool Accept(ModelStreamingResponder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ModelStreamingResponder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ModelStreamingResponder>>
class ModelStreamingResponderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ModelStreamingResponderStub() = default;
  ~ModelStreamingResponderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ModelStreamingResponderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ModelStreamingResponderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT ModelStreamingResponderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT ModelExecutionContextInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ModelExecutionContextInfo, T>::value>;
  using DataView = ModelExecutionContextInfoDataView;
  using Data_ = internal::ModelExecutionContextInfo_Data;

  template <typename... Args>
  static ModelExecutionContextInfoPtr New(Args&&... args) {
    return ModelExecutionContextInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ModelExecutionContextInfoPtr From(const U& u) {
    return mojo::TypeConverter<ModelExecutionContextInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ModelExecutionContextInfo>::Convert(*this);
  }


  ModelExecutionContextInfo();

  explicit ModelExecutionContextInfo(
      uint64_t current_tokens);


  ~ModelExecutionContextInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ModelExecutionContextInfoPtr>
  ModelExecutionContextInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ModelExecutionContextInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ModelExecutionContextInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ModelExecutionContextInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ModelExecutionContextInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ModelExecutionContextInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ModelExecutionContextInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ModelExecutionContextInfo_UnserializedMessageContext<
            UserType, ModelExecutionContextInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ModelExecutionContextInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ModelExecutionContextInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ModelExecutionContextInfo_UnserializedMessageContext<
            UserType, ModelExecutionContextInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ModelExecutionContextInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t current_tokens;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ModelExecutionContextInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ModelExecutionContextInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ModelExecutionContextInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ModelExecutionContextInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
ModelExecutionContextInfoPtr ModelExecutionContextInfo::Clone() const {
  return New(
      mojo::Clone(current_tokens)
  );
}

template <typename T, ModelExecutionContextInfo::EnableIfSame<T>*>
bool ModelExecutionContextInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->current_tokens, other_struct.current_tokens))
    return false;
  return true;
}

template <typename T, ModelExecutionContextInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.current_tokens < rhs.current_tokens)
    return true;
  if (rhs.current_tokens < lhs.current_tokens)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ModelExecutionContextInfo::DataView,
                                         ::blink::mojom::blink::ModelExecutionContextInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::ModelExecutionContextInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ModelExecutionContextInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::ModelExecutionContextInfo::current_tokens) current_tokens(
      const ::blink::mojom::blink::ModelExecutionContextInfoPtr& input) {
    return input->current_tokens;
  }

  static bool Read(::blink::mojom::blink::ModelExecutionContextInfo::DataView input, ::blink::mojom::blink::ModelExecutionContextInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_MODEL_STREAMING_RESPONDER_MOJOM_BLINK_H_