// third_party/blink/public/mojom/ai/ai_rewriter.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AILanguageCode as blink_mojom_AILanguageCode,
  AILanguageCodeSpec as blink_mojom_AILanguageCodeSpec
} from './ai_common.mojom.m.js';

import {
  ModelStreamingResponderRemote as blink_mojom_ModelStreamingResponderRemote,
  ModelStreamingResponderPendingReceiver as blink_mojom_ModelStreamingResponderPendingReceiver
} from './model_streaming_responder.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIRewriterToneSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIRewriterTone = {
  
  kAsIs: 0,
  kMoreFormal: 1,
  kMoreCasual: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIRewriterFormatSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIRewriterFormat = {
  
  kAsIs: 0,
  kPlainText: 1,
  kMarkdown: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AIRewriterLengthSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AIRewriterLength = {
  
  kAsIs: 0,
  kShorter: 1,
  kLonger: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AIRewriterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AIRewriter', scope);
  }
}

/** @interface */
export class AIRewriterInterface {
  
  /**
   * @param { !string } input
   * @param { ?string } context
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  rewrite(input, context, pendingResponder) {}
  
  /**
   * @param { !string } input
   * @param { !string } context
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureUsage(input, context) {}
}

/**
 * @implements { AIRewriterInterface }
 */
export class AIRewriterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AIRewriterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AIRewriterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AIRewriterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } input
   * @param { ?string } context
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  rewrite(
      input,
      context,
      pendingResponder) {
    this.proxy.sendMessage(
        0,
        AIRewriter_Rewrite_ParamsSpec.$,
        null,
        [
          input,
          context,
          pendingResponder
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @param { !string } context
   * @return {!Promise<{
        numberOfTokens: ?number,
   *  }>}
   */

  measureUsage(
      input,
      context) {
    return this.proxy.sendMessage(
        1,
        AIRewriter_MeasureUsage_ParamsSpec.$,
        AIRewriter_MeasureUsage_ResponseParamsSpec.$,
        [
          input,
          context
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AIRewriter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AIRewriterReceiver {
  /**
   * @param {!AIRewriterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AIRewriterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AIRewriterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIRewriterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AIRewriter_Rewrite_ParamsSpec.$,
        null,
        impl.rewrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AIRewriter_MeasureUsage_ParamsSpec.$,
        AIRewriter_MeasureUsage_ResponseParamsSpec.$,
        impl.measureUsage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AIRewriter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIRewriter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AIRewriterRemote}
   */
  static getRemote() {
    let remote = new AIRewriterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AIRewriter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AIRewriterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AIRewriterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIRewriterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rewrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AIRewriter_Rewrite_ParamsSpec.$,
        null,
        this.rewrite.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.measureUsage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AIRewriter_MeasureUsage_ParamsSpec.$,
        AIRewriter_MeasureUsage_ResponseParamsSpec.$,
        this.measureUsage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIRewriterCreateOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIRewriter_Rewrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIRewriter_MeasureUsage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIRewriter_MeasureUsage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AIRewriterCreateOptionsSpec.$,
    'AIRewriterCreateOptions',
    [
      mojo.internal.StructField(
        'sharedContext', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tone', 8,
        0,
        AIRewriterToneSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'format', 12,
        0,
        AIRewriterFormatSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 16,
        0,
        AIRewriterLengthSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedInputLanguages', 24,
        0,
        mojo.internal.Array(blink_mojom_AILanguageCodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedContextLanguages', 32,
        0,
        mojo.internal.Array(blink_mojom_AILanguageCodeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputLanguage', 40,
        0,
        blink_mojom_AILanguageCodeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class AIRewriterCreateOptions {
  constructor() {
    /** @type { (string|undefined) } */
    this.sharedContext;
    /** @type { !AIRewriterTone } */
    this.tone;
    /** @type { !AIRewriterFormat } */
    this.format;
    /** @type { !AIRewriterLength } */
    this.length;
    /** @type { !Array<!blink_mojom_AILanguageCode> } */
    this.expectedInputLanguages;
    /** @type { !Array<!blink_mojom_AILanguageCode> } */
    this.expectedContextLanguages;
    /** @type { !blink_mojom_AILanguageCode } */
    this.outputLanguage;
  }
}



mojo.internal.Struct(
    AIRewriter_Rewrite_ParamsSpec.$,
    'AIRewriter_Rewrite_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pendingResponder', 16,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelStreamingResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AIRewriter_Rewrite_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { (string|undefined) } */
    this.context;
    /** @type { !blink_mojom_ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
}



mojo.internal.Struct(
    AIRewriter_MeasureUsage_ParamsSpec.$,
    'AIRewriter_MeasureUsage_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIRewriter_MeasureUsage_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { !string } */
    this.context;
  }
}



mojo.internal.Struct(
    AIRewriter_MeasureUsage_ResponseParamsSpec.$,
    'AIRewriter_MeasureUsage_ResponseParams',
    [
      mojo.internal.StructField(
        'number_of_tokens_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "number_of_tokens_$value",
          originalFieldName: "numberOfTokens",
        }
      ),
      mojo.internal.StructField(
        'number_of_tokens_$value', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "numberOfTokens",
        }
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIRewriter_MeasureUsage_ResponseParams {
  constructor() {
    /** @type { (number|undefined) } */
    this.numberOfTokens;
  }
}

