// third_party/blink/public/mojom/ai/ai_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AIManagerCreateClientError as blink_mojom_AIManagerCreateClientError,
  AIManagerCreateClientErrorSpec as blink_mojom_AIManagerCreateClientErrorSpec,
  QuotaErrorInfo as blink_mojom_QuotaErrorInfo,
  QuotaErrorInfoSpec as blink_mojom_QuotaErrorInfoSpec
} from './ai_common.mojom.m.js';

import {
  AIManagerCreateLanguageModelClientRemote as blink_mojom_AIManagerCreateLanguageModelClientRemote,
  AIManagerCreateLanguageModelClientPendingReceiver as blink_mojom_AIManagerCreateLanguageModelClientPendingReceiver,
  AILanguageModelCreateOptions as blink_mojom_AILanguageModelCreateOptions,
  AILanguageModelCreateOptionsSpec as blink_mojom_AILanguageModelCreateOptionsSpec,
  AILanguageModelParams as blink_mojom_AILanguageModelParams,
  AILanguageModelParamsSpec as blink_mojom_AILanguageModelParamsSpec
} from './ai_language_model.mojom.m.js';

import {
  AIProofreaderRemote as blink_mojom_AIProofreaderRemote,
  AIProofreaderPendingReceiver as blink_mojom_AIProofreaderPendingReceiver,
  AIProofreaderCreateOptions as blink_mojom_AIProofreaderCreateOptions,
  AIProofreaderCreateOptionsSpec as blink_mojom_AIProofreaderCreateOptionsSpec
} from './ai_proofreader.mojom.m.js';

import {
  AIRewriterRemote as blink_mojom_AIRewriterRemote,
  AIRewriterPendingReceiver as blink_mojom_AIRewriterPendingReceiver,
  AIRewriterCreateOptions as blink_mojom_AIRewriterCreateOptions,
  AIRewriterCreateOptionsSpec as blink_mojom_AIRewriterCreateOptionsSpec
} from './ai_rewriter.mojom.m.js';

import {
  AISummarizerRemote as blink_mojom_AISummarizerRemote,
  AISummarizerPendingReceiver as blink_mojom_AISummarizerPendingReceiver,
  AISummarizerCreateOptions as blink_mojom_AISummarizerCreateOptions,
  AISummarizerCreateOptionsSpec as blink_mojom_AISummarizerCreateOptionsSpec
} from './ai_summarizer.mojom.m.js';

import {
  AIWriterRemote as blink_mojom_AIWriterRemote,
  AIWriterPendingReceiver as blink_mojom_AIWriterPendingReceiver,
  AIWriterCreateOptions as blink_mojom_AIWriterCreateOptions,
  AIWriterCreateOptionsSpec as blink_mojom_AIWriterCreateOptionsSpec
} from './ai_writer.mojom.m.js';

import {
  ModelDownloadProgressObserverRemote as blink_mojom_ModelDownloadProgressObserverRemote,
  ModelDownloadProgressObserverPendingReceiver as blink_mojom_ModelDownloadProgressObserverPendingReceiver
} from './model_download_progress_observer.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ModelAvailabilityCheckResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ModelAvailabilityCheckResult = {
  
  kAvailable: 0,
  kDownloadable: 1,
  kDownloading: 2,
  kUnavailableServiceNotRunning: 3,
  kUnavailableUnsupportedLanguage: 4,
  kUnavailableUnknown: 5,
  kUnavailableFeatureNotEnabled: 6,
  kUnavailableConfigNotAvailableForFeature: 7,
  kUnavailableGpuBlocked: 8,
  kUnavailableTooManyRecentCrashes: 9,
  kUnavailableSafetyModelNotAvailable: 10,
  kUnavailableSafetyConfigNotAvailableForFeature: 11,
  kUnavailableLanguageDetectionModelNotAvailable: 12,
  kUnavailableFeatureExecutionNotEnabled: 13,
  kUnavailableModelAdaptationNotAvailable: 14,
  kUnavailableValidationPending: 15,
  kUnavailableValidationFailed: 16,
  kUnavailableModelNotEligible: 17,
  kUnavailableInsufficientDiskSpace: 18,
  kUnavailableTranslationNotEligible: 19,
  kUnavailableEnterprisePolicyDisabled: 20,
  MIN_VALUE: 0,
  MAX_VALUE: 20,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AIManagerCreateWriterClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AIManagerCreateWriterClient', scope);
  }
}

/** @interface */
export class AIManagerCreateWriterClientInterface {
  
  /**
   * @param { !blink_mojom_AIWriterRemote } writer
   */

  onResult(writer) {}
  
  /**
   * @param { !blink_mojom_AIManagerCreateClientError } error
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(error, quotaErrorInfo) {}
}

/**
 * @implements { AIManagerCreateWriterClientInterface }
 */
export class AIManagerCreateWriterClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AIManagerCreateWriterClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AIManagerCreateWriterClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AIManagerCreateWriterClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_AIWriterRemote } writer
   */

  onResult(
      writer) {
    this.proxy.sendMessage(
        0,
        AIManagerCreateWriterClient_OnResult_ParamsSpec.$,
        null,
        [
          writer
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AIManagerCreateClientError } error
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      error,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        AIManagerCreateWriterClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          quotaErrorInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AIManagerCreateWriterClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AIManagerCreateWriterClientReceiver {
  /**
   * @param {!AIManagerCreateWriterClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AIManagerCreateWriterClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AIManagerCreateWriterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerCreateWriterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AIManagerCreateWriterClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AIManagerCreateWriterClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AIManagerCreateWriterClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManagerCreateWriterClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AIManagerCreateWriterClientRemote}
   */
  static getRemote() {
    let remote = new AIManagerCreateWriterClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AIManagerCreateWriterClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AIManagerCreateWriterClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AIManagerCreateWriterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerCreateWriterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AIManagerCreateWriterClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AIManagerCreateWriterClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AIManagerCreateRewriterClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AIManagerCreateRewriterClient', scope);
  }
}

/** @interface */
export class AIManagerCreateRewriterClientInterface {
  
  /**
   * @param { !blink_mojom_AIRewriterRemote } rewriter
   */

  onResult(rewriter) {}
  
  /**
   * @param { !blink_mojom_AIManagerCreateClientError } error
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(error, quotaErrorInfo) {}
}

/**
 * @implements { AIManagerCreateRewriterClientInterface }
 */
export class AIManagerCreateRewriterClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AIManagerCreateRewriterClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AIManagerCreateRewriterClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AIManagerCreateRewriterClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_AIRewriterRemote } rewriter
   */

  onResult(
      rewriter) {
    this.proxy.sendMessage(
        0,
        AIManagerCreateRewriterClient_OnResult_ParamsSpec.$,
        null,
        [
          rewriter
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AIManagerCreateClientError } error
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      error,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        AIManagerCreateRewriterClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          quotaErrorInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AIManagerCreateRewriterClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AIManagerCreateRewriterClientReceiver {
  /**
   * @param {!AIManagerCreateRewriterClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AIManagerCreateRewriterClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AIManagerCreateRewriterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerCreateRewriterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AIManagerCreateRewriterClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AIManagerCreateRewriterClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AIManagerCreateRewriterClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManagerCreateRewriterClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AIManagerCreateRewriterClientRemote}
   */
  static getRemote() {
    let remote = new AIManagerCreateRewriterClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AIManagerCreateRewriterClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AIManagerCreateRewriterClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AIManagerCreateRewriterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerCreateRewriterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AIManagerCreateRewriterClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AIManagerCreateRewriterClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AIManagerCreateSummarizerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AIManagerCreateSummarizerClient', scope);
  }
}

/** @interface */
export class AIManagerCreateSummarizerClientInterface {
  
  /**
   * @param { !blink_mojom_AISummarizerRemote } summarizer
   */

  onResult(summarizer) {}
  
  /**
   * @param { !blink_mojom_AIManagerCreateClientError } error
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(error, quotaErrorInfo) {}
}

/**
 * @implements { AIManagerCreateSummarizerClientInterface }
 */
export class AIManagerCreateSummarizerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AIManagerCreateSummarizerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AIManagerCreateSummarizerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AIManagerCreateSummarizerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_AISummarizerRemote } summarizer
   */

  onResult(
      summarizer) {
    this.proxy.sendMessage(
        0,
        AIManagerCreateSummarizerClient_OnResult_ParamsSpec.$,
        null,
        [
          summarizer
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AIManagerCreateClientError } error
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      error,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        AIManagerCreateSummarizerClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          quotaErrorInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AIManagerCreateSummarizerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AIManagerCreateSummarizerClientReceiver {
  /**
   * @param {!AIManagerCreateSummarizerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AIManagerCreateSummarizerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AIManagerCreateSummarizerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerCreateSummarizerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AIManagerCreateSummarizerClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AIManagerCreateSummarizerClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AIManagerCreateSummarizerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManagerCreateSummarizerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AIManagerCreateSummarizerClientRemote}
   */
  static getRemote() {
    let remote = new AIManagerCreateSummarizerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AIManagerCreateSummarizerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AIManagerCreateSummarizerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AIManagerCreateSummarizerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerCreateSummarizerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AIManagerCreateSummarizerClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AIManagerCreateSummarizerClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AIManagerCreateProofreaderClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AIManagerCreateProofreaderClient', scope);
  }
}

/** @interface */
export class AIManagerCreateProofreaderClientInterface {
  
  /**
   * @param { !blink_mojom_AIProofreaderRemote } proofreader
   */

  onResult(proofreader) {}
  
  /**
   * @param { !blink_mojom_AIManagerCreateClientError } error
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(error, quotaErrorInfo) {}
}

/**
 * @implements { AIManagerCreateProofreaderClientInterface }
 */
export class AIManagerCreateProofreaderClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AIManagerCreateProofreaderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AIManagerCreateProofreaderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AIManagerCreateProofreaderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_AIProofreaderRemote } proofreader
   */

  onResult(
      proofreader) {
    this.proxy.sendMessage(
        0,
        AIManagerCreateProofreaderClient_OnResult_ParamsSpec.$,
        null,
        [
          proofreader
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AIManagerCreateClientError } error
   * @param { ?blink_mojom_QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      error,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        AIManagerCreateProofreaderClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          quotaErrorInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AIManagerCreateProofreaderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AIManagerCreateProofreaderClientReceiver {
  /**
   * @param {!AIManagerCreateProofreaderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AIManagerCreateProofreaderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AIManagerCreateProofreaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerCreateProofreaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AIManagerCreateProofreaderClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AIManagerCreateProofreaderClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AIManagerCreateProofreaderClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManagerCreateProofreaderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AIManagerCreateProofreaderClientRemote}
   */
  static getRemote() {
    let remote = new AIManagerCreateProofreaderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AIManagerCreateProofreaderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AIManagerCreateProofreaderClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AIManagerCreateProofreaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerCreateProofreaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AIManagerCreateProofreaderClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AIManagerCreateProofreaderClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AIManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.AIManager', scope);
  }
}

/** @interface */
export class AIManagerInterface {
  
  /**
   * @param { !blink_mojom_AILanguageModelCreateOptions } options
   * @return {!Promise<{
        result: !ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateLanguageModel(options) {}
  
  /**
   * @param { !blink_mojom_AIManagerCreateLanguageModelClientRemote } client
   * @param { !blink_mojom_AILanguageModelCreateOptions } options
   */

  createLanguageModel(client, options) {}
  
  /**
   * @param { ?blink_mojom_AISummarizerCreateOptions } options
   * @return {!Promise<{
        result: !ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateSummarizer(options) {}
  
  /**
   * @param { !AIManagerCreateSummarizerClientRemote } client
   * @param { !blink_mojom_AISummarizerCreateOptions } options
   */

  createSummarizer(client, options) {}
  
  /**
   * @return {!Promise<{
        languageModelParams: ?blink_mojom_AILanguageModelParams,
   *  }>}
   */

  getLanguageModelParams() {}
  
  /**
   * @param { !blink_mojom_AIWriterCreateOptions } options
   * @return {!Promise<{
        result: !ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateWriter(options) {}
  
  /**
   * @param { !AIManagerCreateWriterClientRemote } client
   * @param { !blink_mojom_AIWriterCreateOptions } options
   */

  createWriter(client, options) {}
  
  /**
   * @param { !blink_mojom_AIRewriterCreateOptions } options
   * @return {!Promise<{
        result: !ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateRewriter(options) {}
  
  /**
   * @param { !AIManagerCreateRewriterClientRemote } client
   * @param { !blink_mojom_AIRewriterCreateOptions } options
   */

  createRewriter(client, options) {}
  
  /**
   * @param { !blink_mojom_AIProofreaderCreateOptions } options
   * @return {!Promise<{
        result: !ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateProofreader(options) {}
  
  /**
   * @param { !AIManagerCreateProofreaderClientRemote } client
   * @param { !blink_mojom_AIProofreaderCreateOptions } options
   */

  createProofreader(client, options) {}
  
  /**
   * @param { !blink_mojom_ModelDownloadProgressObserverRemote } observerRemote
   */

  addModelDownloadProgressObserver(observerRemote) {}
}

/**
 * @implements { AIManagerInterface }
 */
export class AIManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AIManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AIManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AIManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_AILanguageModelCreateOptions } options
   * @return {!Promise<{
        result: !ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateLanguageModel(
      options) {
    return this.proxy.sendMessage(
        0,
        AIManager_CanCreateLanguageModel_ParamsSpec.$,
        AIManager_CanCreateLanguageModel_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AIManagerCreateLanguageModelClientRemote } client
   * @param { !blink_mojom_AILanguageModelCreateOptions } options
   */

  createLanguageModel(
      client,
      options) {
    this.proxy.sendMessage(
        1,
        AIManager_CreateLanguageModel_ParamsSpec.$,
        null,
        [
          client,
          options
        ],
        false);
  }

  
  /**
   * @param { ?blink_mojom_AISummarizerCreateOptions } options
   * @return {!Promise<{
        result: !ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateSummarizer(
      options) {
    return this.proxy.sendMessage(
        2,
        AIManager_CanCreateSummarizer_ParamsSpec.$,
        AIManager_CanCreateSummarizer_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !AIManagerCreateSummarizerClientRemote } client
   * @param { !blink_mojom_AISummarizerCreateOptions } options
   */

  createSummarizer(
      client,
      options) {
    this.proxy.sendMessage(
        3,
        AIManager_CreateSummarizer_ParamsSpec.$,
        null,
        [
          client,
          options
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        languageModelParams: ?blink_mojom_AILanguageModelParams,
   *  }>}
   */

  getLanguageModelParams() {
    return this.proxy.sendMessage(
        4,
        AIManager_GetLanguageModelParams_ParamsSpec.$,
        AIManager_GetLanguageModelParams_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AIWriterCreateOptions } options
   * @return {!Promise<{
        result: !ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateWriter(
      options) {
    return this.proxy.sendMessage(
        5,
        AIManager_CanCreateWriter_ParamsSpec.$,
        AIManager_CanCreateWriter_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !AIManagerCreateWriterClientRemote } client
   * @param { !blink_mojom_AIWriterCreateOptions } options
   */

  createWriter(
      client,
      options) {
    this.proxy.sendMessage(
        6,
        AIManager_CreateWriter_ParamsSpec.$,
        null,
        [
          client,
          options
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AIRewriterCreateOptions } options
   * @return {!Promise<{
        result: !ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateRewriter(
      options) {
    return this.proxy.sendMessage(
        7,
        AIManager_CanCreateRewriter_ParamsSpec.$,
        AIManager_CanCreateRewriter_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !AIManagerCreateRewriterClientRemote } client
   * @param { !blink_mojom_AIRewriterCreateOptions } options
   */

  createRewriter(
      client,
      options) {
    this.proxy.sendMessage(
        8,
        AIManager_CreateRewriter_ParamsSpec.$,
        null,
        [
          client,
          options
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_AIProofreaderCreateOptions } options
   * @return {!Promise<{
        result: !ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateProofreader(
      options) {
    return this.proxy.sendMessage(
        9,
        AIManager_CanCreateProofreader_ParamsSpec.$,
        AIManager_CanCreateProofreader_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !AIManagerCreateProofreaderClientRemote } client
   * @param { !blink_mojom_AIProofreaderCreateOptions } options
   */

  createProofreader(
      client,
      options) {
    this.proxy.sendMessage(
        10,
        AIManager_CreateProofreader_ParamsSpec.$,
        null,
        [
          client,
          options
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ModelDownloadProgressObserverRemote } observerRemote
   */

  addModelDownloadProgressObserver(
      observerRemote) {
    this.proxy.sendMessage(
        11,
        AIManager_AddModelDownloadProgressObserver_ParamsSpec.$,
        null,
        [
          observerRemote
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AIManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AIManagerReceiver {
  /**
   * @param {!AIManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AIManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AIManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AIManager_CanCreateLanguageModel_ParamsSpec.$,
        AIManager_CanCreateLanguageModel_ResponseParamsSpec.$,
        impl.canCreateLanguageModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AIManager_CreateLanguageModel_ParamsSpec.$,
        null,
        impl.createLanguageModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AIManager_CanCreateSummarizer_ParamsSpec.$,
        AIManager_CanCreateSummarizer_ResponseParamsSpec.$,
        impl.canCreateSummarizer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AIManager_CreateSummarizer_ParamsSpec.$,
        null,
        impl.createSummarizer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AIManager_GetLanguageModelParams_ParamsSpec.$,
        AIManager_GetLanguageModelParams_ResponseParamsSpec.$,
        impl.getLanguageModelParams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        AIManager_CanCreateWriter_ParamsSpec.$,
        AIManager_CanCreateWriter_ResponseParamsSpec.$,
        impl.canCreateWriter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        AIManager_CreateWriter_ParamsSpec.$,
        null,
        impl.createWriter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        AIManager_CanCreateRewriter_ParamsSpec.$,
        AIManager_CanCreateRewriter_ResponseParamsSpec.$,
        impl.canCreateRewriter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        AIManager_CreateRewriter_ParamsSpec.$,
        null,
        impl.createRewriter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        AIManager_CanCreateProofreader_ParamsSpec.$,
        AIManager_CanCreateProofreader_ResponseParamsSpec.$,
        impl.canCreateProofreader.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        AIManager_CreateProofreader_ParamsSpec.$,
        null,
        impl.createProofreader.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        AIManager_AddModelDownloadProgressObserver_ParamsSpec.$,
        null,
        impl.addModelDownloadProgressObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AIManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AIManagerRemote}
   */
  static getRemote() {
    let remote = new AIManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AIManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AIManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AIManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AIManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canCreateLanguageModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AIManager_CanCreateLanguageModel_ParamsSpec.$,
        AIManager_CanCreateLanguageModel_ResponseParamsSpec.$,
        this.canCreateLanguageModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createLanguageModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AIManager_CreateLanguageModel_ParamsSpec.$,
        null,
        this.createLanguageModel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canCreateSummarizer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AIManager_CanCreateSummarizer_ParamsSpec.$,
        AIManager_CanCreateSummarizer_ResponseParamsSpec.$,
        this.canCreateSummarizer.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSummarizer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AIManager_CreateSummarizer_ParamsSpec.$,
        null,
        this.createSummarizer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getLanguageModelParams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AIManager_GetLanguageModelParams_ParamsSpec.$,
        AIManager_GetLanguageModelParams_ResponseParamsSpec.$,
        this.getLanguageModelParams.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canCreateWriter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        AIManager_CanCreateWriter_ParamsSpec.$,
        AIManager_CanCreateWriter_ResponseParamsSpec.$,
        this.canCreateWriter.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createWriter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        AIManager_CreateWriter_ParamsSpec.$,
        null,
        this.createWriter.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canCreateRewriter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        AIManager_CanCreateRewriter_ParamsSpec.$,
        AIManager_CanCreateRewriter_ResponseParamsSpec.$,
        this.canCreateRewriter.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createRewriter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        AIManager_CreateRewriter_ParamsSpec.$,
        null,
        this.createRewriter.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canCreateProofreader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        AIManager_CanCreateProofreader_ParamsSpec.$,
        AIManager_CanCreateProofreader_ResponseParamsSpec.$,
        this.canCreateProofreader.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createProofreader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        AIManager_CreateProofreader_ParamsSpec.$,
        null,
        this.createProofreader.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addModelDownloadProgressObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        AIManager_AddModelDownloadProgressObserver_ParamsSpec.$,
        null,
        this.addModelDownloadProgressObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManagerCreateWriterClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManagerCreateWriterClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManagerCreateRewriterClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManagerCreateRewriterClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManagerCreateSummarizerClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManagerCreateSummarizerClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManagerCreateProofreaderClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManagerCreateProofreaderClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CanCreateLanguageModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CanCreateLanguageModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CreateLanguageModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CanCreateSummarizer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CanCreateSummarizer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CreateSummarizer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_GetLanguageModelParams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_GetLanguageModelParams_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CanCreateWriter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CanCreateWriter_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CreateWriter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CanCreateRewriter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CanCreateRewriter_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CreateRewriter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CanCreateProofreader_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CanCreateProofreader_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_CreateProofreader_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AIManager_AddModelDownloadProgressObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AIManagerCreateWriterClient_OnResult_ParamsSpec.$,
    'AIManagerCreateWriterClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'writer', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_AIWriterRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManagerCreateWriterClient_OnResult_Params {
  constructor() {
    /** @type { !blink_mojom_AIWriterRemote } */
    this.writer;
  }
}



mojo.internal.Struct(
    AIManagerCreateWriterClient_OnError_ParamsSpec.$,
    'AIManagerCreateWriterClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_AIManagerCreateClientErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink_mojom_QuotaErrorInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManagerCreateWriterClient_OnError_Params {
  constructor() {
    /** @type { !blink_mojom_AIManagerCreateClientError } */
    this.error;
    /** @type { (blink_mojom_QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
}



mojo.internal.Struct(
    AIManagerCreateRewriterClient_OnResult_ParamsSpec.$,
    'AIManagerCreateRewriterClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'rewriter', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_AIRewriterRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManagerCreateRewriterClient_OnResult_Params {
  constructor() {
    /** @type { !blink_mojom_AIRewriterRemote } */
    this.rewriter;
  }
}



mojo.internal.Struct(
    AIManagerCreateRewriterClient_OnError_ParamsSpec.$,
    'AIManagerCreateRewriterClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_AIManagerCreateClientErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink_mojom_QuotaErrorInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManagerCreateRewriterClient_OnError_Params {
  constructor() {
    /** @type { !blink_mojom_AIManagerCreateClientError } */
    this.error;
    /** @type { (blink_mojom_QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
}



mojo.internal.Struct(
    AIManagerCreateSummarizerClient_OnResult_ParamsSpec.$,
    'AIManagerCreateSummarizerClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'summarizer', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_AISummarizerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManagerCreateSummarizerClient_OnResult_Params {
  constructor() {
    /** @type { !blink_mojom_AISummarizerRemote } */
    this.summarizer;
  }
}



mojo.internal.Struct(
    AIManagerCreateSummarizerClient_OnError_ParamsSpec.$,
    'AIManagerCreateSummarizerClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_AIManagerCreateClientErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink_mojom_QuotaErrorInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManagerCreateSummarizerClient_OnError_Params {
  constructor() {
    /** @type { !blink_mojom_AIManagerCreateClientError } */
    this.error;
    /** @type { (blink_mojom_QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
}



mojo.internal.Struct(
    AIManagerCreateProofreaderClient_OnResult_ParamsSpec.$,
    'AIManagerCreateProofreaderClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'proofreader', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_AIProofreaderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManagerCreateProofreaderClient_OnResult_Params {
  constructor() {
    /** @type { !blink_mojom_AIProofreaderRemote } */
    this.proofreader;
  }
}



mojo.internal.Struct(
    AIManagerCreateProofreaderClient_OnError_ParamsSpec.$,
    'AIManagerCreateProofreaderClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_AIManagerCreateClientErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink_mojom_QuotaErrorInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManagerCreateProofreaderClient_OnError_Params {
  constructor() {
    /** @type { !blink_mojom_AIManagerCreateClientError } */
    this.error;
    /** @type { (blink_mojom_QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
}



mojo.internal.Struct(
    AIManager_CanCreateLanguageModel_ParamsSpec.$,
    'AIManager_CanCreateLanguageModel_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink_mojom_AILanguageModelCreateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_CanCreateLanguageModel_Params {
  constructor() {
    /** @type { !blink_mojom_AILanguageModelCreateOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    AIManager_CanCreateLanguageModel_ResponseParamsSpec.$,
    'AIManager_CanCreateLanguageModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ModelAvailabilityCheckResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_CanCreateLanguageModel_ResponseParams {
  constructor() {
    /** @type { !ModelAvailabilityCheckResult } */
    this.result;
  }
}



mojo.internal.Struct(
    AIManager_CreateLanguageModel_ParamsSpec.$,
    'AIManager_CreateLanguageModel_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_AIManagerCreateLanguageModelClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink_mojom_AILanguageModelCreateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManager_CreateLanguageModel_Params {
  constructor() {
    /** @type { !blink_mojom_AIManagerCreateLanguageModelClientRemote } */
    this.client;
    /** @type { !blink_mojom_AILanguageModelCreateOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    AIManager_CanCreateSummarizer_ParamsSpec.$,
    'AIManager_CanCreateSummarizer_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink_mojom_AISummarizerCreateOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_CanCreateSummarizer_Params {
  constructor() {
    /** @type { (blink_mojom_AISummarizerCreateOptions|undefined) } */
    this.options;
  }
}



mojo.internal.Struct(
    AIManager_CanCreateSummarizer_ResponseParamsSpec.$,
    'AIManager_CanCreateSummarizer_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ModelAvailabilityCheckResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_CanCreateSummarizer_ResponseParams {
  constructor() {
    /** @type { !ModelAvailabilityCheckResult } */
    this.result;
  }
}



mojo.internal.Struct(
    AIManager_CreateSummarizer_ParamsSpec.$,
    'AIManager_CreateSummarizer_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(AIManagerCreateSummarizerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink_mojom_AISummarizerCreateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManager_CreateSummarizer_Params {
  constructor() {
    /** @type { !AIManagerCreateSummarizerClientRemote } */
    this.client;
    /** @type { !blink_mojom_AISummarizerCreateOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    AIManager_GetLanguageModelParams_ParamsSpec.$,
    'AIManager_GetLanguageModelParams_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AIManager_GetLanguageModelParams_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AIManager_GetLanguageModelParams_ResponseParamsSpec.$,
    'AIManager_GetLanguageModelParams_ResponseParams',
    [
      mojo.internal.StructField(
        'languageModelParams', 0,
        0,
        blink_mojom_AILanguageModelParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_GetLanguageModelParams_ResponseParams {
  constructor() {
    /** @type { (blink_mojom_AILanguageModelParams|undefined) } */
    this.languageModelParams;
  }
}



mojo.internal.Struct(
    AIManager_CanCreateWriter_ParamsSpec.$,
    'AIManager_CanCreateWriter_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink_mojom_AIWriterCreateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_CanCreateWriter_Params {
  constructor() {
    /** @type { !blink_mojom_AIWriterCreateOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    AIManager_CanCreateWriter_ResponseParamsSpec.$,
    'AIManager_CanCreateWriter_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ModelAvailabilityCheckResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_CanCreateWriter_ResponseParams {
  constructor() {
    /** @type { !ModelAvailabilityCheckResult } */
    this.result;
  }
}



mojo.internal.Struct(
    AIManager_CreateWriter_ParamsSpec.$,
    'AIManager_CreateWriter_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(AIManagerCreateWriterClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink_mojom_AIWriterCreateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManager_CreateWriter_Params {
  constructor() {
    /** @type { !AIManagerCreateWriterClientRemote } */
    this.client;
    /** @type { !blink_mojom_AIWriterCreateOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    AIManager_CanCreateRewriter_ParamsSpec.$,
    'AIManager_CanCreateRewriter_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink_mojom_AIRewriterCreateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_CanCreateRewriter_Params {
  constructor() {
    /** @type { !blink_mojom_AIRewriterCreateOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    AIManager_CanCreateRewriter_ResponseParamsSpec.$,
    'AIManager_CanCreateRewriter_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ModelAvailabilityCheckResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_CanCreateRewriter_ResponseParams {
  constructor() {
    /** @type { !ModelAvailabilityCheckResult } */
    this.result;
  }
}



mojo.internal.Struct(
    AIManager_CreateRewriter_ParamsSpec.$,
    'AIManager_CreateRewriter_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(AIManagerCreateRewriterClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink_mojom_AIRewriterCreateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManager_CreateRewriter_Params {
  constructor() {
    /** @type { !AIManagerCreateRewriterClientRemote } */
    this.client;
    /** @type { !blink_mojom_AIRewriterCreateOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    AIManager_CanCreateProofreader_ParamsSpec.$,
    'AIManager_CanCreateProofreader_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink_mojom_AIProofreaderCreateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_CanCreateProofreader_Params {
  constructor() {
    /** @type { !blink_mojom_AIProofreaderCreateOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    AIManager_CanCreateProofreader_ResponseParamsSpec.$,
    'AIManager_CanCreateProofreader_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ModelAvailabilityCheckResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_CanCreateProofreader_ResponseParams {
  constructor() {
    /** @type { !ModelAvailabilityCheckResult } */
    this.result;
  }
}



mojo.internal.Struct(
    AIManager_CreateProofreader_ParamsSpec.$,
    'AIManager_CreateProofreader_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(AIManagerCreateProofreaderClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink_mojom_AIProofreaderCreateOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AIManager_CreateProofreader_Params {
  constructor() {
    /** @type { !AIManagerCreateProofreaderClientRemote } */
    this.client;
    /** @type { !blink_mojom_AIProofreaderCreateOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    AIManager_AddModelDownloadProgressObserver_ParamsSpec.$,
    'AIManager_AddModelDownloadProgressObserver_Params',
    [
      mojo.internal.StructField(
        'observerRemote', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelDownloadProgressObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AIManager_AddModelDownloadProgressObserver_Params {
  constructor() {
    /** @type { !blink_mojom_ModelDownloadProgressObserverRemote } */
    this.observerRemote;
  }
}

