// third_party/blink/public/mojom/ai/ai_manager.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.AIManagerCreateClientError');
goog.require('blink.mojom.AIManagerCreateLanguageModelClient');
goog.require('blink.mojom.AIProofreader');
goog.require('blink.mojom.AIRewriter');
goog.require('blink.mojom.AISummarizer');
goog.require('blink.mojom.AIWriter');
goog.require('blink.mojom.ModelDownloadProgressObserver');
goog.require('blink.mojom.AILanguageModelCreateOptions');
goog.require('blink.mojom.AILanguageModelParams');
goog.require('blink.mojom.AIProofreaderCreateOptions');
goog.require('blink.mojom.AIRewriterCreateOptions');
goog.require('blink.mojom.AISummarizerCreateOptions');
goog.require('blink.mojom.AIWriterCreateOptions');
goog.require('blink.mojom.QuotaErrorInfo');




goog.provide('blink.mojom.ModelAvailabilityCheckResult');
goog.provide('blink.mojom.ModelAvailabilityCheckResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ModelAvailabilityCheckResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ModelAvailabilityCheckResult = {
  
  kAvailable: 0,
  kDownloadable: 1,
  kDownloading: 2,
  kUnavailableServiceNotRunning: 3,
  kUnavailableUnsupportedLanguage: 4,
  kUnavailableUnknown: 5,
  kUnavailableFeatureNotEnabled: 6,
  kUnavailableConfigNotAvailableForFeature: 7,
  kUnavailableGpuBlocked: 8,
  kUnavailableTooManyRecentCrashes: 9,
  kUnavailableSafetyModelNotAvailable: 10,
  kUnavailableSafetyConfigNotAvailableForFeature: 11,
  kUnavailableLanguageDetectionModelNotAvailable: 12,
  kUnavailableFeatureExecutionNotEnabled: 13,
  kUnavailableModelAdaptationNotAvailable: 14,
  kUnavailableValidationPending: 15,
  kUnavailableValidationFailed: 16,
  kUnavailableModelNotEligible: 17,
  kUnavailableInsufficientDiskSpace: 18,
  kUnavailableTranslationNotEligible: 19,
  kUnavailableEnterprisePolicyDisabled: 20,
  MIN_VALUE: 0,
  MAX_VALUE: 20,
};



goog.provide('blink.mojom.AIManagerCreateWriterClient');
goog.provide('blink.mojom.AIManagerCreateWriterClientReceiver');
goog.provide('blink.mojom.AIManagerCreateWriterClientCallbackRouter');
goog.provide('blink.mojom.AIManagerCreateWriterClientInterface');
goog.provide('blink.mojom.AIManagerCreateWriterClientRemote');
goog.provide('blink.mojom.AIManagerCreateWriterClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AIManagerCreateWriterClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AIManagerCreateWriterClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AIManagerCreateWriterClientInterface = class {
  
  /**
   * @param { !blink.mojom.AIWriterRemote } writer
   */

  onResult(writer) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateClientError } error
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(error, quotaErrorInfo) {}
};

/**
 * @export
 * @implements { blink.mojom.AIManagerCreateWriterClientInterface }
 */
blink.mojom.AIManagerCreateWriterClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AIManagerCreateWriterClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AIManagerCreateWriterClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AIManagerCreateWriterClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AIWriterRemote } writer
   */

  onResult(
      writer) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AIManagerCreateWriterClient_OnResult_ParamsSpec.$,
        null,
        [
          writer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateClientError } error
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      error,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AIManagerCreateWriterClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          quotaErrorInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AIManagerCreateWriterClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AIManagerCreateWriterClientReceiver = class {
  /**
   * @param {!blink.mojom.AIManagerCreateWriterClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AIManagerCreateWriterClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AIManagerCreateWriterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerCreateWriterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManagerCreateWriterClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManagerCreateWriterClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AIManagerCreateWriterClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManagerCreateWriterClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AIManagerCreateWriterClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AIManagerCreateWriterClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AIManagerCreateWriterClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AIManagerCreateWriterClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AIManagerCreateWriterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerCreateWriterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManagerCreateWriterClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManagerCreateWriterClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AIManagerCreateRewriterClient');
goog.provide('blink.mojom.AIManagerCreateRewriterClientReceiver');
goog.provide('blink.mojom.AIManagerCreateRewriterClientCallbackRouter');
goog.provide('blink.mojom.AIManagerCreateRewriterClientInterface');
goog.provide('blink.mojom.AIManagerCreateRewriterClientRemote');
goog.provide('blink.mojom.AIManagerCreateRewriterClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AIManagerCreateRewriterClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AIManagerCreateRewriterClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AIManagerCreateRewriterClientInterface = class {
  
  /**
   * @param { !blink.mojom.AIRewriterRemote } rewriter
   */

  onResult(rewriter) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateClientError } error
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(error, quotaErrorInfo) {}
};

/**
 * @export
 * @implements { blink.mojom.AIManagerCreateRewriterClientInterface }
 */
blink.mojom.AIManagerCreateRewriterClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AIManagerCreateRewriterClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AIManagerCreateRewriterClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AIManagerCreateRewriterClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AIRewriterRemote } rewriter
   */

  onResult(
      rewriter) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AIManagerCreateRewriterClient_OnResult_ParamsSpec.$,
        null,
        [
          rewriter
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateClientError } error
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      error,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AIManagerCreateRewriterClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          quotaErrorInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AIManagerCreateRewriterClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AIManagerCreateRewriterClientReceiver = class {
  /**
   * @param {!blink.mojom.AIManagerCreateRewriterClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AIManagerCreateRewriterClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AIManagerCreateRewriterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerCreateRewriterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManagerCreateRewriterClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManagerCreateRewriterClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AIManagerCreateRewriterClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManagerCreateRewriterClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AIManagerCreateRewriterClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AIManagerCreateRewriterClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AIManagerCreateRewriterClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AIManagerCreateRewriterClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AIManagerCreateRewriterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerCreateRewriterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManagerCreateRewriterClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManagerCreateRewriterClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AIManagerCreateSummarizerClient');
goog.provide('blink.mojom.AIManagerCreateSummarizerClientReceiver');
goog.provide('blink.mojom.AIManagerCreateSummarizerClientCallbackRouter');
goog.provide('blink.mojom.AIManagerCreateSummarizerClientInterface');
goog.provide('blink.mojom.AIManagerCreateSummarizerClientRemote');
goog.provide('blink.mojom.AIManagerCreateSummarizerClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AIManagerCreateSummarizerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AIManagerCreateSummarizerClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AIManagerCreateSummarizerClientInterface = class {
  
  /**
   * @param { !blink.mojom.AISummarizerRemote } summarizer
   */

  onResult(summarizer) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateClientError } error
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(error, quotaErrorInfo) {}
};

/**
 * @export
 * @implements { blink.mojom.AIManagerCreateSummarizerClientInterface }
 */
blink.mojom.AIManagerCreateSummarizerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AIManagerCreateSummarizerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AIManagerCreateSummarizerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AIManagerCreateSummarizerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AISummarizerRemote } summarizer
   */

  onResult(
      summarizer) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AIManagerCreateSummarizerClient_OnResult_ParamsSpec.$,
        null,
        [
          summarizer
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateClientError } error
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      error,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AIManagerCreateSummarizerClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          quotaErrorInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AIManagerCreateSummarizerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AIManagerCreateSummarizerClientReceiver = class {
  /**
   * @param {!blink.mojom.AIManagerCreateSummarizerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AIManagerCreateSummarizerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AIManagerCreateSummarizerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerCreateSummarizerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManagerCreateSummarizerClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManagerCreateSummarizerClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AIManagerCreateSummarizerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManagerCreateSummarizerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AIManagerCreateSummarizerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AIManagerCreateSummarizerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AIManagerCreateSummarizerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AIManagerCreateSummarizerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AIManagerCreateSummarizerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerCreateSummarizerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManagerCreateSummarizerClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManagerCreateSummarizerClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AIManagerCreateProofreaderClient');
goog.provide('blink.mojom.AIManagerCreateProofreaderClientReceiver');
goog.provide('blink.mojom.AIManagerCreateProofreaderClientCallbackRouter');
goog.provide('blink.mojom.AIManagerCreateProofreaderClientInterface');
goog.provide('blink.mojom.AIManagerCreateProofreaderClientRemote');
goog.provide('blink.mojom.AIManagerCreateProofreaderClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AIManagerCreateProofreaderClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AIManagerCreateProofreaderClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AIManagerCreateProofreaderClientInterface = class {
  
  /**
   * @param { !blink.mojom.AIProofreaderRemote } proofreader
   */

  onResult(proofreader) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateClientError } error
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(error, quotaErrorInfo) {}
};

/**
 * @export
 * @implements { blink.mojom.AIManagerCreateProofreaderClientInterface }
 */
blink.mojom.AIManagerCreateProofreaderClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AIManagerCreateProofreaderClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AIManagerCreateProofreaderClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AIManagerCreateProofreaderClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AIProofreaderRemote } proofreader
   */

  onResult(
      proofreader) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AIManagerCreateProofreaderClient_OnResult_ParamsSpec.$,
        null,
        [
          proofreader
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateClientError } error
   * @param { ?blink.mojom.QuotaErrorInfo } quotaErrorInfo
   */

  onError(
      error,
      quotaErrorInfo) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AIManagerCreateProofreaderClient_OnError_ParamsSpec.$,
        null,
        [
          error,
          quotaErrorInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AIManagerCreateProofreaderClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AIManagerCreateProofreaderClientReceiver = class {
  /**
   * @param {!blink.mojom.AIManagerCreateProofreaderClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AIManagerCreateProofreaderClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AIManagerCreateProofreaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerCreateProofreaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManagerCreateProofreaderClient_OnResult_ParamsSpec.$,
        null,
        impl.onResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManagerCreateProofreaderClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AIManagerCreateProofreaderClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManagerCreateProofreaderClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AIManagerCreateProofreaderClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AIManagerCreateProofreaderClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AIManagerCreateProofreaderClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AIManagerCreateProofreaderClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AIManagerCreateProofreaderClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerCreateProofreaderClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManagerCreateProofreaderClient_OnResult_ParamsSpec.$,
        null,
        this.onResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManagerCreateProofreaderClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AIManager');
goog.provide('blink.mojom.AIManagerReceiver');
goog.provide('blink.mojom.AIManagerCallbackRouter');
goog.provide('blink.mojom.AIManagerInterface');
goog.provide('blink.mojom.AIManagerRemote');
goog.provide('blink.mojom.AIManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AIManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AIManager.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AIManagerInterface = class {
  
  /**
   * @param { !blink.mojom.AILanguageModelCreateOptions } options
   * @return {!Promise<{
        result: !blink.mojom.ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateLanguageModel(options) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateLanguageModelClientRemote } client
   * @param { !blink.mojom.AILanguageModelCreateOptions } options
   */

  createLanguageModel(client, options) {}
  
  /**
   * @param { ?blink.mojom.AISummarizerCreateOptions } options
   * @return {!Promise<{
        result: !blink.mojom.ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateSummarizer(options) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateSummarizerClientRemote } client
   * @param { !blink.mojom.AISummarizerCreateOptions } options
   */

  createSummarizer(client, options) {}
  
  /**
   * @return {!Promise<{
        languageModelParams: ?blink.mojom.AILanguageModelParams,
   *  }>}
   */

  getLanguageModelParams() {}
  
  /**
   * @param { !blink.mojom.AIWriterCreateOptions } options
   * @return {!Promise<{
        result: !blink.mojom.ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateWriter(options) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateWriterClientRemote } client
   * @param { !blink.mojom.AIWriterCreateOptions } options
   */

  createWriter(client, options) {}
  
  /**
   * @param { !blink.mojom.AIRewriterCreateOptions } options
   * @return {!Promise<{
        result: !blink.mojom.ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateRewriter(options) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateRewriterClientRemote } client
   * @param { !blink.mojom.AIRewriterCreateOptions } options
   */

  createRewriter(client, options) {}
  
  /**
   * @param { !blink.mojom.AIProofreaderCreateOptions } options
   * @return {!Promise<{
        result: !blink.mojom.ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateProofreader(options) {}
  
  /**
   * @param { !blink.mojom.AIManagerCreateProofreaderClientRemote } client
   * @param { !blink.mojom.AIProofreaderCreateOptions } options
   */

  createProofreader(client, options) {}
  
  /**
   * @param { !blink.mojom.ModelDownloadProgressObserverRemote } observerRemote
   */

  addModelDownloadProgressObserver(observerRemote) {}
};

/**
 * @export
 * @implements { blink.mojom.AIManagerInterface }
 */
blink.mojom.AIManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AIManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AIManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AIManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AILanguageModelCreateOptions } options
   * @return {!Promise<{
        result: !blink.mojom.ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateLanguageModel(
      options) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.AIManager_CanCreateLanguageModel_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateLanguageModel_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateLanguageModelClientRemote } client
   * @param { !blink.mojom.AILanguageModelCreateOptions } options
   */

  createLanguageModel(
      client,
      options) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AIManager_CreateLanguageModel_ParamsSpec.$,
        null,
        [
          client,
          options
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.AISummarizerCreateOptions } options
   * @return {!Promise<{
        result: !blink.mojom.ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateSummarizer(
      options) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.AIManager_CanCreateSummarizer_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateSummarizer_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateSummarizerClientRemote } client
   * @param { !blink.mojom.AISummarizerCreateOptions } options
   */

  createSummarizer(
      client,
      options) {
    this.proxy.sendMessage(
        3,
        blink.mojom.AIManager_CreateSummarizer_ParamsSpec.$,
        null,
        [
          client,
          options
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        languageModelParams: ?blink.mojom.AILanguageModelParams,
   *  }>}
   */

  getLanguageModelParams() {
    return this.proxy.sendMessage(
        4,
        blink.mojom.AIManager_GetLanguageModelParams_ParamsSpec.$,
        blink.mojom.AIManager_GetLanguageModelParams_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIWriterCreateOptions } options
   * @return {!Promise<{
        result: !blink.mojom.ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateWriter(
      options) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.AIManager_CanCreateWriter_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateWriter_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateWriterClientRemote } client
   * @param { !blink.mojom.AIWriterCreateOptions } options
   */

  createWriter(
      client,
      options) {
    this.proxy.sendMessage(
        6,
        blink.mojom.AIManager_CreateWriter_ParamsSpec.$,
        null,
        [
          client,
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIRewriterCreateOptions } options
   * @return {!Promise<{
        result: !blink.mojom.ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateRewriter(
      options) {
    return this.proxy.sendMessage(
        7,
        blink.mojom.AIManager_CanCreateRewriter_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateRewriter_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateRewriterClientRemote } client
   * @param { !blink.mojom.AIRewriterCreateOptions } options
   */

  createRewriter(
      client,
      options) {
    this.proxy.sendMessage(
        8,
        blink.mojom.AIManager_CreateRewriter_ParamsSpec.$,
        null,
        [
          client,
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIProofreaderCreateOptions } options
   * @return {!Promise<{
        result: !blink.mojom.ModelAvailabilityCheckResult,
   *  }>}
   */

  canCreateProofreader(
      options) {
    return this.proxy.sendMessage(
        9,
        blink.mojom.AIManager_CanCreateProofreader_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateProofreader_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AIManagerCreateProofreaderClientRemote } client
   * @param { !blink.mojom.AIProofreaderCreateOptions } options
   */

  createProofreader(
      client,
      options) {
    this.proxy.sendMessage(
        10,
        blink.mojom.AIManager_CreateProofreader_ParamsSpec.$,
        null,
        [
          client,
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ModelDownloadProgressObserverRemote } observerRemote
   */

  addModelDownloadProgressObserver(
      observerRemote) {
    this.proxy.sendMessage(
        11,
        blink.mojom.AIManager_AddModelDownloadProgressObserver_ParamsSpec.$,
        null,
        [
          observerRemote
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AIManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AIManagerReceiver = class {
  /**
   * @param {!blink.mojom.AIManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AIManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AIManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManager_CanCreateLanguageModel_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateLanguageModel_ResponseParamsSpec.$,
        impl.canCreateLanguageModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManager_CreateLanguageModel_ParamsSpec.$,
        null,
        impl.createLanguageModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AIManager_CanCreateSummarizer_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateSummarizer_ResponseParamsSpec.$,
        impl.canCreateSummarizer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AIManager_CreateSummarizer_ParamsSpec.$,
        null,
        impl.createSummarizer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AIManager_GetLanguageModelParams_ParamsSpec.$,
        blink.mojom.AIManager_GetLanguageModelParams_ResponseParamsSpec.$,
        impl.getLanguageModelParams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.AIManager_CanCreateWriter_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateWriter_ResponseParamsSpec.$,
        impl.canCreateWriter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.AIManager_CreateWriter_ParamsSpec.$,
        null,
        impl.createWriter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.AIManager_CanCreateRewriter_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateRewriter_ResponseParamsSpec.$,
        impl.canCreateRewriter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.AIManager_CreateRewriter_ParamsSpec.$,
        null,
        impl.createRewriter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.AIManager_CanCreateProofreader_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateProofreader_ResponseParamsSpec.$,
        impl.canCreateProofreader.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.AIManager_CreateProofreader_ParamsSpec.$,
        null,
        impl.createProofreader.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.AIManager_AddModelDownloadProgressObserver_ParamsSpec.$,
        null,
        impl.addModelDownloadProgressObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AIManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AIManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AIManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AIManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AIManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AIManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AIManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AIManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canCreateLanguageModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AIManager_CanCreateLanguageModel_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateLanguageModel_ResponseParamsSpec.$,
        this.canCreateLanguageModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createLanguageModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AIManager_CreateLanguageModel_ParamsSpec.$,
        null,
        this.createLanguageModel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canCreateSummarizer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AIManager_CanCreateSummarizer_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateSummarizer_ResponseParamsSpec.$,
        this.canCreateSummarizer.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSummarizer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AIManager_CreateSummarizer_ParamsSpec.$,
        null,
        this.createSummarizer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getLanguageModelParams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AIManager_GetLanguageModelParams_ParamsSpec.$,
        blink.mojom.AIManager_GetLanguageModelParams_ResponseParamsSpec.$,
        this.getLanguageModelParams.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canCreateWriter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.AIManager_CanCreateWriter_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateWriter_ResponseParamsSpec.$,
        this.canCreateWriter.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createWriter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.AIManager_CreateWriter_ParamsSpec.$,
        null,
        this.createWriter.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canCreateRewriter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.AIManager_CanCreateRewriter_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateRewriter_ResponseParamsSpec.$,
        this.canCreateRewriter.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createRewriter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.AIManager_CreateRewriter_ParamsSpec.$,
        null,
        this.createRewriter.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canCreateProofreader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.AIManager_CanCreateProofreader_ParamsSpec.$,
        blink.mojom.AIManager_CanCreateProofreader_ResponseParamsSpec.$,
        this.canCreateProofreader.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createProofreader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.AIManager_CreateProofreader_ParamsSpec.$,
        null,
        this.createProofreader.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addModelDownloadProgressObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.AIManager_AddModelDownloadProgressObserver_ParamsSpec.$,
        null,
        this.addModelDownloadProgressObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AIManagerCreateWriterClient_OnResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManagerCreateWriterClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManagerCreateWriterClient_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManagerCreateWriterClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManagerCreateRewriterClient_OnResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManagerCreateRewriterClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManagerCreateRewriterClient_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManagerCreateRewriterClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManagerCreateSummarizerClient_OnResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManagerCreateSummarizerClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManagerCreateSummarizerClient_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManagerCreateSummarizerClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManagerCreateProofreaderClient_OnResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManagerCreateProofreaderClient_OnResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManagerCreateProofreaderClient_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManagerCreateProofreaderClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CanCreateLanguageModel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CanCreateLanguageModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CanCreateLanguageModel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CanCreateLanguageModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CreateLanguageModel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CreateLanguageModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CanCreateSummarizer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CanCreateSummarizer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CanCreateSummarizer_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CanCreateSummarizer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CreateSummarizer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CreateSummarizer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_GetLanguageModelParams_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_GetLanguageModelParams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_GetLanguageModelParams_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_GetLanguageModelParams_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CanCreateWriter_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CanCreateWriter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CanCreateWriter_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CanCreateWriter_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CreateWriter_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CreateWriter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CanCreateRewriter_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CanCreateRewriter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CanCreateRewriter_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CanCreateRewriter_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CreateRewriter_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CreateRewriter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CanCreateProofreader_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CanCreateProofreader_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CanCreateProofreader_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CanCreateProofreader_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_CreateProofreader_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_CreateProofreader_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AIManager_AddModelDownloadProgressObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AIManager_AddModelDownloadProgressObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AIManagerCreateWriterClient_OnResult_ParamsSpec.$,
    'AIManagerCreateWriterClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'writer', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AIWriterRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManagerCreateWriterClient_OnResult_Params');

/** @record */
blink.mojom.AIManagerCreateWriterClient_OnResult_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIWriterRemote } */
    this.writer;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManagerCreateWriterClient_OnError_ParamsSpec.$,
    'AIManagerCreateWriterClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.AIManagerCreateClientErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink.mojom.QuotaErrorInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManagerCreateWriterClient_OnError_Params');

/** @record */
blink.mojom.AIManagerCreateWriterClient_OnError_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateClientError } */
    this.error;
    /** @export { (blink.mojom.QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManagerCreateRewriterClient_OnResult_ParamsSpec.$,
    'AIManagerCreateRewriterClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'rewriter', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AIRewriterRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManagerCreateRewriterClient_OnResult_Params');

/** @record */
blink.mojom.AIManagerCreateRewriterClient_OnResult_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIRewriterRemote } */
    this.rewriter;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManagerCreateRewriterClient_OnError_ParamsSpec.$,
    'AIManagerCreateRewriterClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.AIManagerCreateClientErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink.mojom.QuotaErrorInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManagerCreateRewriterClient_OnError_Params');

/** @record */
blink.mojom.AIManagerCreateRewriterClient_OnError_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateClientError } */
    this.error;
    /** @export { (blink.mojom.QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManagerCreateSummarizerClient_OnResult_ParamsSpec.$,
    'AIManagerCreateSummarizerClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'summarizer', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AISummarizerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManagerCreateSummarizerClient_OnResult_Params');

/** @record */
blink.mojom.AIManagerCreateSummarizerClient_OnResult_Params = class {
  constructor() {
    /** @export { !blink.mojom.AISummarizerRemote } */
    this.summarizer;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManagerCreateSummarizerClient_OnError_ParamsSpec.$,
    'AIManagerCreateSummarizerClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.AIManagerCreateClientErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink.mojom.QuotaErrorInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManagerCreateSummarizerClient_OnError_Params');

/** @record */
blink.mojom.AIManagerCreateSummarizerClient_OnError_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateClientError } */
    this.error;
    /** @export { (blink.mojom.QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManagerCreateProofreaderClient_OnResult_ParamsSpec.$,
    'AIManagerCreateProofreaderClient_OnResult_Params',
    [
      mojo.internal.StructField(
        'proofreader', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AIProofreaderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManagerCreateProofreaderClient_OnResult_Params');

/** @record */
blink.mojom.AIManagerCreateProofreaderClient_OnResult_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIProofreaderRemote } */
    this.proofreader;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManagerCreateProofreaderClient_OnError_ParamsSpec.$,
    'AIManagerCreateProofreaderClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.AIManagerCreateClientErrorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'quotaErrorInfo', 8,
        0,
        blink.mojom.QuotaErrorInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManagerCreateProofreaderClient_OnError_Params');

/** @record */
blink.mojom.AIManagerCreateProofreaderClient_OnError_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateClientError } */
    this.error;
    /** @export { (blink.mojom.QuotaErrorInfo|undefined) } */
    this.quotaErrorInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CanCreateLanguageModel_ParamsSpec.$,
    'AIManager_CanCreateLanguageModel_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.AILanguageModelCreateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_CanCreateLanguageModel_Params');

/** @record */
blink.mojom.AIManager_CanCreateLanguageModel_Params = class {
  constructor() {
    /** @export { !blink.mojom.AILanguageModelCreateOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CanCreateLanguageModel_ResponseParamsSpec.$,
    'AIManager_CanCreateLanguageModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.ModelAvailabilityCheckResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_CanCreateLanguageModel_ResponseParams');

/** @record */
blink.mojom.AIManager_CanCreateLanguageModel_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ModelAvailabilityCheckResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CreateLanguageModel_ParamsSpec.$,
    'AIManager_CreateLanguageModel_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AIManagerCreateLanguageModelClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink.mojom.AILanguageModelCreateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManager_CreateLanguageModel_Params');

/** @record */
blink.mojom.AIManager_CreateLanguageModel_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateLanguageModelClientRemote } */
    this.client;
    /** @export { !blink.mojom.AILanguageModelCreateOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CanCreateSummarizer_ParamsSpec.$,
    'AIManager_CanCreateSummarizer_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.AISummarizerCreateOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_CanCreateSummarizer_Params');

/** @record */
blink.mojom.AIManager_CanCreateSummarizer_Params = class {
  constructor() {
    /** @export { (blink.mojom.AISummarizerCreateOptions|undefined) } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CanCreateSummarizer_ResponseParamsSpec.$,
    'AIManager_CanCreateSummarizer_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.ModelAvailabilityCheckResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_CanCreateSummarizer_ResponseParams');

/** @record */
blink.mojom.AIManager_CanCreateSummarizer_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ModelAvailabilityCheckResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CreateSummarizer_ParamsSpec.$,
    'AIManager_CreateSummarizer_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AIManagerCreateSummarizerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink.mojom.AISummarizerCreateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManager_CreateSummarizer_Params');

/** @record */
blink.mojom.AIManager_CreateSummarizer_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateSummarizerClientRemote } */
    this.client;
    /** @export { !blink.mojom.AISummarizerCreateOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_GetLanguageModelParams_ParamsSpec.$,
    'AIManager_GetLanguageModelParams_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.AIManager_GetLanguageModelParams_Params');

/** @record */
blink.mojom.AIManager_GetLanguageModelParams_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_GetLanguageModelParams_ResponseParamsSpec.$,
    'AIManager_GetLanguageModelParams_ResponseParams',
    [
      mojo.internal.StructField(
        'languageModelParams', 0,
        0,
        blink.mojom.AILanguageModelParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_GetLanguageModelParams_ResponseParams');

/** @record */
blink.mojom.AIManager_GetLanguageModelParams_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.AILanguageModelParams|undefined) } */
    this.languageModelParams;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CanCreateWriter_ParamsSpec.$,
    'AIManager_CanCreateWriter_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.AIWriterCreateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_CanCreateWriter_Params');

/** @record */
blink.mojom.AIManager_CanCreateWriter_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIWriterCreateOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CanCreateWriter_ResponseParamsSpec.$,
    'AIManager_CanCreateWriter_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.ModelAvailabilityCheckResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_CanCreateWriter_ResponseParams');

/** @record */
blink.mojom.AIManager_CanCreateWriter_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ModelAvailabilityCheckResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CreateWriter_ParamsSpec.$,
    'AIManager_CreateWriter_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AIManagerCreateWriterClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink.mojom.AIWriterCreateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManager_CreateWriter_Params');

/** @record */
blink.mojom.AIManager_CreateWriter_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateWriterClientRemote } */
    this.client;
    /** @export { !blink.mojom.AIWriterCreateOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CanCreateRewriter_ParamsSpec.$,
    'AIManager_CanCreateRewriter_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.AIRewriterCreateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_CanCreateRewriter_Params');

/** @record */
blink.mojom.AIManager_CanCreateRewriter_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIRewriterCreateOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CanCreateRewriter_ResponseParamsSpec.$,
    'AIManager_CanCreateRewriter_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.ModelAvailabilityCheckResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_CanCreateRewriter_ResponseParams');

/** @record */
blink.mojom.AIManager_CanCreateRewriter_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ModelAvailabilityCheckResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CreateRewriter_ParamsSpec.$,
    'AIManager_CreateRewriter_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AIManagerCreateRewriterClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink.mojom.AIRewriterCreateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManager_CreateRewriter_Params');

/** @record */
blink.mojom.AIManager_CreateRewriter_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateRewriterClientRemote } */
    this.client;
    /** @export { !blink.mojom.AIRewriterCreateOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CanCreateProofreader_ParamsSpec.$,
    'AIManager_CanCreateProofreader_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.AIProofreaderCreateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_CanCreateProofreader_Params');

/** @record */
blink.mojom.AIManager_CanCreateProofreader_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIProofreaderCreateOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CanCreateProofreader_ResponseParamsSpec.$,
    'AIManager_CanCreateProofreader_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.ModelAvailabilityCheckResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_CanCreateProofreader_ResponseParams');

/** @record */
blink.mojom.AIManager_CanCreateProofreader_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ModelAvailabilityCheckResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_CreateProofreader_ParamsSpec.$,
    'AIManager_CreateProofreader_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.AIManagerCreateProofreaderClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink.mojom.AIProofreaderCreateOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AIManager_CreateProofreader_Params');

/** @record */
blink.mojom.AIManager_CreateProofreader_Params = class {
  constructor() {
    /** @export { !blink.mojom.AIManagerCreateProofreaderClientRemote } */
    this.client;
    /** @export { !blink.mojom.AIProofreaderCreateOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.AIManager_AddModelDownloadProgressObserver_ParamsSpec.$,
    'AIManager_AddModelDownloadProgressObserver_Params',
    [
      mojo.internal.StructField(
        'observerRemote', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ModelDownloadProgressObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AIManager_AddModelDownloadProgressObserver_Params');

/** @record */
blink.mojom.AIManager_AddModelDownloadProgressObserver_Params = class {
  constructor() {
    /** @export { !blink.mojom.ModelDownloadProgressObserverRemote } */
    this.observerRemote;
  }
};

