// storage/browser/quota/quota_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "storage/browser/quota/quota_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "storage/browser/quota/quota_internals.mojom-params-data.h"
#include "storage/browser/quota/quota_internals.mojom-shared-message-ids.h"

#include "storage/browser/quota/quota_internals.mojom-import-headers.h"
#include "storage/browser/quota/quota_internals.mojom-test-utils.h"


namespace storage::mojom {
BucketTableEntry::BucketTableEntry()
    : bucket_id(),
      storage_key(),
      name(),
      usage(-1),
      use_count(),
      last_accessed(),
      last_modified() {}

BucketTableEntry::BucketTableEntry(
    int64_t bucket_id_in,
    const std::string& storage_key_in,
    const std::string& name_in,
    int64_t usage_in,
    int64_t use_count_in,
    ::base::Time last_accessed_in,
    ::base::Time last_modified_in)
    : bucket_id(std::move(bucket_id_in)),
      storage_key(std::move(storage_key_in)),
      name(std::move(name_in)),
      usage(std::move(usage_in)),
      use_count(std::move(use_count_in)),
      last_accessed(std::move(last_accessed_in)),
      last_modified(std::move(last_modified_in)) {}

BucketTableEntry::~BucketTableEntry() = default;

void BucketTableEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bucket_id"), this->bucket_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage_key"), this->storage_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_count"), this->use_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_accessed"), this->last_accessed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_modified"), this->last_modified,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BucketTableEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

QuotaInternalsHandler::IPCStableHashFunction QuotaInternalsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::QuotaInternalsHandler>(message.name())) {
    case messages::QuotaInternalsHandler::kGetDiskAvailabilityAndTempPoolSize: {
      return &QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSize_Sym::IPCStableHash;
    }
    case messages::QuotaInternalsHandler::kGetStatistics: {
      return &QuotaInternalsHandler::GetStatistics_Sym::IPCStableHash;
    }
    case messages::QuotaInternalsHandler::kSimulateStoragePressure: {
      return &QuotaInternalsHandler::SimulateStoragePressure_Sym::IPCStableHash;
    }
    case messages::QuotaInternalsHandler::kRetrieveBucketsTable: {
      return &QuotaInternalsHandler::RetrieveBucketsTable_Sym::IPCStableHash;
    }
    case messages::QuotaInternalsHandler::kGetGlobalUsageForInternals: {
      return &QuotaInternalsHandler::GetGlobalUsageForInternals_Sym::IPCStableHash;
    }
    case messages::QuotaInternalsHandler::kIsSimulateStoragePressureAvailable: {
      return &QuotaInternalsHandler::IsSimulateStoragePressureAvailable_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* QuotaInternalsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::QuotaInternalsHandler>(message.name())) {
      case messages::QuotaInternalsHandler::kGetDiskAvailabilityAndTempPoolSize:
            return "Receive storage::mojom::QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSize";
      case messages::QuotaInternalsHandler::kGetStatistics:
            return "Receive storage::mojom::QuotaInternalsHandler::GetStatistics";
      case messages::QuotaInternalsHandler::kSimulateStoragePressure:
            return "Receive storage::mojom::QuotaInternalsHandler::SimulateStoragePressure";
      case messages::QuotaInternalsHandler::kRetrieveBucketsTable:
            return "Receive storage::mojom::QuotaInternalsHandler::RetrieveBucketsTable";
      case messages::QuotaInternalsHandler::kGetGlobalUsageForInternals:
            return "Receive storage::mojom::QuotaInternalsHandler::GetGlobalUsageForInternals";
      case messages::QuotaInternalsHandler::kIsSimulateStoragePressureAvailable:
            return "Receive storage::mojom::QuotaInternalsHandler::IsSimulateStoragePressureAvailable";
    }
  } else {
    switch (static_cast<messages::QuotaInternalsHandler>(message.name())) {
      case messages::QuotaInternalsHandler::kGetDiskAvailabilityAndTempPoolSize:
            return "Receive reply storage::mojom::QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSize";
      case messages::QuotaInternalsHandler::kGetStatistics:
            return "Receive reply storage::mojom::QuotaInternalsHandler::GetStatistics";
      case messages::QuotaInternalsHandler::kSimulateStoragePressure:
            return "Receive reply storage::mojom::QuotaInternalsHandler::SimulateStoragePressure";
      case messages::QuotaInternalsHandler::kRetrieveBucketsTable:
            return "Receive reply storage::mojom::QuotaInternalsHandler::RetrieveBucketsTable";
      case messages::QuotaInternalsHandler::kGetGlobalUsageForInternals:
            return "Receive reply storage::mojom::QuotaInternalsHandler::GetGlobalUsageForInternals";
      case messages::QuotaInternalsHandler::kIsSimulateStoragePressureAvailable:
            return "Receive reply storage::mojom::QuotaInternalsHandler::IsSimulateStoragePressureAvailable";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x576a4c22;  // IPCStableHash for storage::mojom::QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t QuotaInternalsHandler::GetStatistics_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x798e7f54;  // IPCStableHash for storage::mojom::QuotaInternalsHandler::GetStatistics
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t QuotaInternalsHandler::SimulateStoragePressure_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8218eafd;  // IPCStableHash for storage::mojom::QuotaInternalsHandler::SimulateStoragePressure
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t QuotaInternalsHandler::RetrieveBucketsTable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1e1703ad;  // IPCStableHash for storage::mojom::QuotaInternalsHandler::RetrieveBucketsTable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t QuotaInternalsHandler::GetGlobalUsageForInternals_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23a5e47c;  // IPCStableHash for storage::mojom::QuotaInternalsHandler::GetGlobalUsageForInternals
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t QuotaInternalsHandler::IsSimulateStoragePressureAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc60d6200;  // IPCStableHash for storage::mojom::QuotaInternalsHandler::IsSimulateStoragePressureAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ForwardToCallback(
      QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSizeCallback callback
      ) : callback_(std::move(callback)) {
  }

  QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ForwardToCallback(const QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ForwardToCallback&) = delete;
  QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ForwardToCallback& operator=(const QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSizeCallback callback_;
};

class QuotaInternalsHandler_GetStatistics_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaInternalsHandler_GetStatistics_ForwardToCallback(
      QuotaInternalsHandler::GetStatisticsCallback callback
      ) : callback_(std::move(callback)) {
  }

  QuotaInternalsHandler_GetStatistics_ForwardToCallback(const QuotaInternalsHandler_GetStatistics_ForwardToCallback&) = delete;
  QuotaInternalsHandler_GetStatistics_ForwardToCallback& operator=(const QuotaInternalsHandler_GetStatistics_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  QuotaInternalsHandler::GetStatisticsCallback callback_;
};

class QuotaInternalsHandler_RetrieveBucketsTable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaInternalsHandler_RetrieveBucketsTable_ForwardToCallback(
      QuotaInternalsHandler::RetrieveBucketsTableCallback callback
      ) : callback_(std::move(callback)) {
  }

  QuotaInternalsHandler_RetrieveBucketsTable_ForwardToCallback(const QuotaInternalsHandler_RetrieveBucketsTable_ForwardToCallback&) = delete;
  QuotaInternalsHandler_RetrieveBucketsTable_ForwardToCallback& operator=(const QuotaInternalsHandler_RetrieveBucketsTable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  QuotaInternalsHandler::RetrieveBucketsTableCallback callback_;
};

class QuotaInternalsHandler_GetGlobalUsageForInternals_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaInternalsHandler_GetGlobalUsageForInternals_ForwardToCallback(
      QuotaInternalsHandler::GetGlobalUsageForInternalsCallback callback
      ) : callback_(std::move(callback)) {
  }

  QuotaInternalsHandler_GetGlobalUsageForInternals_ForwardToCallback(const QuotaInternalsHandler_GetGlobalUsageForInternals_ForwardToCallback&) = delete;
  QuotaInternalsHandler_GetGlobalUsageForInternals_ForwardToCallback& operator=(const QuotaInternalsHandler_GetGlobalUsageForInternals_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  QuotaInternalsHandler::GetGlobalUsageForInternalsCallback callback_;
};

class QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ForwardToCallback(
      QuotaInternalsHandler::IsSimulateStoragePressureAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }

  QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ForwardToCallback(const QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ForwardToCallback&) = delete;
  QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ForwardToCallback& operator=(const QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  QuotaInternalsHandler::IsSimulateStoragePressureAvailableCallback callback_;
};

QuotaInternalsHandlerProxy::QuotaInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuotaInternalsHandlerProxy::GetDiskAvailabilityAndTempPoolSize(
    GetDiskAvailabilityAndTempPoolSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSize");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kGetDiskAvailabilityAndTempPoolSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("GetDiskAvailabilityAndTempPoolSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void QuotaInternalsHandlerProxy::GetStatistics(
    GetStatisticsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::QuotaInternalsHandler::GetStatistics");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kGetStatistics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_GetStatistics_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("GetStatistics");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaInternalsHandler_GetStatistics_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void QuotaInternalsHandlerProxy::SimulateStoragePressure(
    const ::url::Origin& in_origin_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::QuotaInternalsHandler::SimulateStoragePressure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_url"), in_origin_url,
                        "<value of type const ::url::Origin&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kSimulateStoragePressure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_SimulateStoragePressure_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin_url)::BaseType> origin_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin_url,
    origin_url_fragment);

  params->origin_url.Set(
      origin_url_fragment.is_null() ? nullptr : origin_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin_url in QuotaInternalsHandler.SimulateStoragePressure request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("SimulateStoragePressure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void QuotaInternalsHandlerProxy::RetrieveBucketsTable(
    RetrieveBucketsTableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::QuotaInternalsHandler::RetrieveBucketsTable");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kRetrieveBucketsTable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_RetrieveBucketsTable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("RetrieveBucketsTable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaInternalsHandler_RetrieveBucketsTable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void QuotaInternalsHandlerProxy::GetGlobalUsageForInternals(
    GetGlobalUsageForInternalsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::QuotaInternalsHandler::GetGlobalUsageForInternals");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kGetGlobalUsageForInternals), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_GetGlobalUsageForInternals_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("GetGlobalUsageForInternals");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaInternalsHandler_GetGlobalUsageForInternals_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void QuotaInternalsHandlerProxy::IsSimulateStoragePressureAvailable(
    IsSimulateStoragePressureAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::QuotaInternalsHandler::IsSimulateStoragePressureAvailable");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kIsSimulateStoragePressureAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("IsSimulateStoragePressureAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSizeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ProxyToResponder> proxy(
        new QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSizeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_total_space, int64_t in_available_space, int64_t in_temp_pool_size);
};

bool QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for QuotaInternalsHandler.0
  bool success = true;
  int64_t p_total_space{};
  int64_t p_available_space{};
  int64_t p_temp_pool_size{};
  QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_total_space = input_data_view.total_space();
  if (success)
    p_available_space = input_data_view.available_space();
  if (success)
    p_temp_pool_size = input_data_view.temp_pool_size();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaInternalsHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_total_space), 
std::move(p_available_space), 
std::move(p_temp_pool_size));
  }
  return true;
}

void QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ProxyToResponder::Run(
    int64_t in_total_space, int64_t in_available_space, int64_t in_temp_pool_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::QuotaInternalsHandler::GetDiskAvailabilityAndTempPoolSize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_space"), in_total_space,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("available_space"), in_available_space,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("temp_pool_size"), in_temp_pool_size,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kGetDiskAvailabilityAndTempPoolSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->total_space = in_total_space;

  params->available_space = in_available_space;

  params->temp_pool_size = in_temp_pool_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("GetDiskAvailabilityAndTempPoolSize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaInternalsHandler_GetStatistics_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static QuotaInternalsHandler::GetStatisticsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<QuotaInternalsHandler_GetStatistics_ProxyToResponder> proxy(
        new QuotaInternalsHandler_GetStatistics_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&QuotaInternalsHandler_GetStatistics_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaInternalsHandler_GetStatistics_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  QuotaInternalsHandler_GetStatistics_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "QuotaInternalsHandler::GetStatisticsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::flat_map<std::string, std::string>& in_eviction_statistics);
};

bool QuotaInternalsHandler_GetStatistics_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::QuotaInternalsHandler_GetStatistics_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaInternalsHandler_GetStatistics_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for QuotaInternalsHandler.1
  bool success = true;
  base::flat_map<std::string, std::string> p_eviction_statistics{};
  QuotaInternalsHandler_GetStatistics_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEvictionStatistics(&p_eviction_statistics))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaInternalsHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_eviction_statistics));
  }
  return true;
}

void QuotaInternalsHandler_GetStatistics_ProxyToResponder::Run(
    const base::flat_map<std::string, std::string>& in_eviction_statistics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::QuotaInternalsHandler::GetStatistics", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("eviction_statistics"), in_eviction_statistics,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kGetStatistics), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_GetStatistics_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->eviction_statistics)::BaseType>
      eviction_statistics_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& eviction_statistics_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_eviction_statistics,
    eviction_statistics_fragment,
    &eviction_statistics_validate_params);

  params->eviction_statistics.Set(
      eviction_statistics_fragment.is_null() ? nullptr : eviction_statistics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->eviction_statistics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null eviction_statistics in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("GetStatistics");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaInternalsHandler_RetrieveBucketsTable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static QuotaInternalsHandler::RetrieveBucketsTableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<QuotaInternalsHandler_RetrieveBucketsTable_ProxyToResponder> proxy(
        new QuotaInternalsHandler_RetrieveBucketsTable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&QuotaInternalsHandler_RetrieveBucketsTable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaInternalsHandler_RetrieveBucketsTable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  QuotaInternalsHandler_RetrieveBucketsTable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "QuotaInternalsHandler::RetrieveBucketsTableCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<BucketTableEntryPtr> in_entries);
};

bool QuotaInternalsHandler_RetrieveBucketsTable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for QuotaInternalsHandler.3
  bool success = true;
  std::vector<BucketTableEntryPtr> p_entries{};
  QuotaInternalsHandler_RetrieveBucketsTable_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaInternalsHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_entries));
  }
  return true;
}

void QuotaInternalsHandler_RetrieveBucketsTable_ProxyToResponder::Run(
    std::vector<BucketTableEntryPtr> in_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::QuotaInternalsHandler::RetrieveBucketsTable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type std::vector<BucketTableEntryPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kRetrieveBucketsTable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::BucketTableEntryDataView>>(
    in_entries,
    entries_fragment,
    &entries_validate_params);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("RetrieveBucketsTable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaInternalsHandler_GetGlobalUsageForInternals_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static QuotaInternalsHandler::GetGlobalUsageForInternalsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<QuotaInternalsHandler_GetGlobalUsageForInternals_ProxyToResponder> proxy(
        new QuotaInternalsHandler_GetGlobalUsageForInternals_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&QuotaInternalsHandler_GetGlobalUsageForInternals_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaInternalsHandler_GetGlobalUsageForInternals_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  QuotaInternalsHandler_GetGlobalUsageForInternals_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "QuotaInternalsHandler::GetGlobalUsageForInternalsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_usage, int64_t in_unlimited_usage);
};

bool QuotaInternalsHandler_GetGlobalUsageForInternals_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for QuotaInternalsHandler.4
  bool success = true;
  int64_t p_usage{};
  int64_t p_unlimited_usage{};
  QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_usage = input_data_view.usage();
  if (success)
    p_unlimited_usage = input_data_view.unlimited_usage();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaInternalsHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_usage), 
std::move(p_unlimited_usage));
  }
  return true;
}

void QuotaInternalsHandler_GetGlobalUsageForInternals_ProxyToResponder::Run(
    int64_t in_usage, int64_t in_unlimited_usage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::QuotaInternalsHandler::GetGlobalUsageForInternals", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage"), in_usage,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unlimited_usage"), in_unlimited_usage,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kGetGlobalUsageForInternals), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->usage = in_usage;

  params->unlimited_usage = in_unlimited_usage;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("GetGlobalUsageForInternals");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static QuotaInternalsHandler::IsSimulateStoragePressureAvailableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ProxyToResponder> proxy(
        new QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "QuotaInternalsHandler::IsSimulateStoragePressureAvailableCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_available);
};

bool QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for QuotaInternalsHandler.5
  bool success = true;
  bool p_available{};
  QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_available = input_data_view.available();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaInternalsHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_available));
  }
  return true;
}

void QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ProxyToResponder::Run(
    bool in_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::QuotaInternalsHandler::IsSimulateStoragePressureAvailable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("available"), in_available,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaInternalsHandler::kIsSimulateStoragePressureAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->available = in_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaInternalsHandler::Name_);
  message.set_method_name("IsSimulateStoragePressureAvailable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool QuotaInternalsHandlerStubDispatch::Accept(
    QuotaInternalsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::QuotaInternalsHandler>(message->header()->name)) {
    case messages::QuotaInternalsHandler::kGetDiskAvailabilityAndTempPoolSize: {
      break;
    }
    case messages::QuotaInternalsHandler::kGetStatistics: {
      break;
    }
    case messages::QuotaInternalsHandler::kSimulateStoragePressure: {
      DCHECK(message->is_serialized());
      internal::QuotaInternalsHandler_SimulateStoragePressure_Params_Data* params =
          reinterpret_cast<internal::QuotaInternalsHandler_SimulateStoragePressure_Params_Data*>(
              message->mutable_payload());
      

      // Validation for QuotaInternalsHandler.2
      bool success = true;
      ::url::Origin p_origin_url{};
      QuotaInternalsHandler_SimulateStoragePressure_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOriginUrl(&p_origin_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaInternalsHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateStoragePressure(        
        std::move(p_origin_url));
      return true;
    }
    case messages::QuotaInternalsHandler::kRetrieveBucketsTable: {
      break;
    }
    case messages::QuotaInternalsHandler::kGetGlobalUsageForInternals: {
      break;
    }
    case messages::QuotaInternalsHandler::kIsSimulateStoragePressureAvailable: {
      break;
    }
  }
  return false;
}

// static
bool QuotaInternalsHandlerStubDispatch::AcceptWithResponder(
    QuotaInternalsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::QuotaInternalsHandler>(message->header()->name)) {
    case messages::QuotaInternalsHandler::kGetDiskAvailabilityAndTempPoolSize: {
      internal::QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params_Data* params =
          reinterpret_cast<
              internal::QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for QuotaInternalsHandler.0
      bool success = true;
      QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaInternalsHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDiskAvailabilityAndTempPoolSize(std::move(callback));
      return true;
    }
    case messages::QuotaInternalsHandler::kGetStatistics: {
      internal::QuotaInternalsHandler_GetStatistics_Params_Data* params =
          reinterpret_cast<
              internal::QuotaInternalsHandler_GetStatistics_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for QuotaInternalsHandler.1
      bool success = true;
      QuotaInternalsHandler_GetStatistics_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaInternalsHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          QuotaInternalsHandler_GetStatistics_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStatistics(std::move(callback));
      return true;
    }
    case messages::QuotaInternalsHandler::kSimulateStoragePressure: {
      break;
    }
    case messages::QuotaInternalsHandler::kRetrieveBucketsTable: {
      internal::QuotaInternalsHandler_RetrieveBucketsTable_Params_Data* params =
          reinterpret_cast<
              internal::QuotaInternalsHandler_RetrieveBucketsTable_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for QuotaInternalsHandler.3
      bool success = true;
      QuotaInternalsHandler_RetrieveBucketsTable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaInternalsHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          QuotaInternalsHandler_RetrieveBucketsTable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RetrieveBucketsTable(std::move(callback));
      return true;
    }
    case messages::QuotaInternalsHandler::kGetGlobalUsageForInternals: {
      internal::QuotaInternalsHandler_GetGlobalUsageForInternals_Params_Data* params =
          reinterpret_cast<
              internal::QuotaInternalsHandler_GetGlobalUsageForInternals_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for QuotaInternalsHandler.4
      bool success = true;
      QuotaInternalsHandler_GetGlobalUsageForInternals_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaInternalsHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          QuotaInternalsHandler_GetGlobalUsageForInternals_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetGlobalUsageForInternals(std::move(callback));
      return true;
    }
    case messages::QuotaInternalsHandler::kIsSimulateStoragePressureAvailable: {
      internal::QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params_Data* params =
          reinterpret_cast<
              internal::QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for QuotaInternalsHandler.5
      bool success = true;
      QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaInternalsHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsSimulateStoragePressureAvailable(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kQuotaInternalsHandlerValidationInfo[] = {
    { &internal::QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params_Data::Validate,
     &internal::QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams_Data::Validate},
    { &internal::QuotaInternalsHandler_GetStatistics_Params_Data::Validate,
     &internal::QuotaInternalsHandler_GetStatistics_ResponseParams_Data::Validate},
    { &internal::QuotaInternalsHandler_SimulateStoragePressure_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::QuotaInternalsHandler_RetrieveBucketsTable_Params_Data::Validate,
     &internal::QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams_Data::Validate},
    { &internal::QuotaInternalsHandler_GetGlobalUsageForInternals_Params_Data::Validate,
     &internal::QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams_Data::Validate},
    { &internal::QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params_Data::Validate,
     &internal::QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams_Data::Validate},
};

bool QuotaInternalsHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::storage::mojom::QuotaInternalsHandler::Name_,
    kQuotaInternalsHandlerValidationInfo);
}

bool QuotaInternalsHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::storage::mojom::QuotaInternalsHandler::Name_,
    kQuotaInternalsHandlerValidationInfo);
}


}  // storage::mojom


namespace mojo {


// static
bool StructTraits<::storage::mojom::BucketTableEntry::DataView, ::storage::mojom::BucketTableEntryPtr>::Read(
    ::storage::mojom::BucketTableEntry::DataView input,
    ::storage::mojom::BucketTableEntryPtr* output) {
  bool success = true;
  ::storage::mojom::BucketTableEntryPtr result(::storage::mojom::BucketTableEntry::New());
  
      if (success)
        result->bucket_id = input.bucket_id();
      if (success && !input.ReadStorageKey(&result->storage_key))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->usage = input.usage();
      if (success)
        result->use_count = input.use_count();
      if (success && !input.ReadLastAccessed(&result->last_accessed))
        success = false;
      if (success && !input.ReadLastModified(&result->last_modified))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void QuotaInternalsHandlerInterceptorForTesting::GetDiskAvailabilityAndTempPoolSize(GetDiskAvailabilityAndTempPoolSizeCallback callback) {
  GetForwardingInterface()->GetDiskAvailabilityAndTempPoolSize(std::move(callback));
}
void QuotaInternalsHandlerInterceptorForTesting::GetStatistics(GetStatisticsCallback callback) {
  GetForwardingInterface()->GetStatistics(std::move(callback));
}
void QuotaInternalsHandlerInterceptorForTesting::SimulateStoragePressure(const ::url::Origin& origin_url) {
  GetForwardingInterface()->SimulateStoragePressure(
    std::move(origin_url)
    );
}
void QuotaInternalsHandlerInterceptorForTesting::RetrieveBucketsTable(RetrieveBucketsTableCallback callback) {
  GetForwardingInterface()->RetrieveBucketsTable(std::move(callback));
}
void QuotaInternalsHandlerInterceptorForTesting::GetGlobalUsageForInternals(GetGlobalUsageForInternalsCallback callback) {
  GetForwardingInterface()->GetGlobalUsageForInternals(std::move(callback));
}
void QuotaInternalsHandlerInterceptorForTesting::IsSimulateStoragePressureAvailable(IsSimulateStoragePressureAvailableCallback callback) {
  GetForwardingInterface()->IsSimulateStoragePressureAvailable(std::move(callback));
}
QuotaInternalsHandlerAsyncWaiter::QuotaInternalsHandlerAsyncWaiter(
    QuotaInternalsHandler* proxy) : proxy_(proxy) {}

QuotaInternalsHandlerAsyncWaiter::~QuotaInternalsHandlerAsyncWaiter() = default;


void QuotaInternalsHandlerAsyncWaiter::GetDiskAvailabilityAndTempPoolSize(
    int64_t* out_total_space, int64_t* out_available_space, int64_t* out_temp_pool_size) {
  base::RunLoop loop;
  proxy_->GetDiskAvailabilityAndTempPoolSize(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_total_space
,
             int64_t* out_available_space
,
             int64_t* out_temp_pool_size
,
             int64_t total_space,
             int64_t available_space,
             int64_t temp_pool_size) {*out_total_space = std::move(total_space);*out_available_space = std::move(available_space);*out_temp_pool_size = std::move(temp_pool_size);
            loop->Quit();
          },
          &loop,
          out_total_space,
          out_available_space,
          out_temp_pool_size));
  loop.Run();
}



void QuotaInternalsHandlerAsyncWaiter::GetStatistics(
    base::flat_map<std::string, std::string>* out_eviction_statistics) {
  base::RunLoop loop;
  proxy_->GetStatistics(
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<std::string, std::string>* out_eviction_statistics
,
             const base::flat_map<std::string, std::string>& eviction_statistics) {*out_eviction_statistics = std::move(eviction_statistics);
            loop->Quit();
          },
          &loop,
          out_eviction_statistics));
  loop.Run();
}

base::flat_map<std::string, std::string> QuotaInternalsHandlerAsyncWaiter::GetStatistics(
    ) {
  base::flat_map<std::string, std::string> async_wait_result;
  GetStatistics(&async_wait_result);
  return async_wait_result;
}

void QuotaInternalsHandlerAsyncWaiter::RetrieveBucketsTable(
    std::vector<BucketTableEntryPtr>* out_entries) {
  base::RunLoop loop;
  proxy_->RetrieveBucketsTable(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<BucketTableEntryPtr>* out_entries
,
             std::vector<BucketTableEntryPtr> entries) {*out_entries = std::move(entries);
            loop->Quit();
          },
          &loop,
          out_entries));
  loop.Run();
}

std::vector<BucketTableEntryPtr> QuotaInternalsHandlerAsyncWaiter::RetrieveBucketsTable(
    ) {
  std::vector<BucketTableEntryPtr> async_wait_result;
  RetrieveBucketsTable(&async_wait_result);
  return async_wait_result;
}

void QuotaInternalsHandlerAsyncWaiter::GetGlobalUsageForInternals(
    int64_t* out_usage, int64_t* out_unlimited_usage) {
  base::RunLoop loop;
  proxy_->GetGlobalUsageForInternals(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_usage
,
             int64_t* out_unlimited_usage
,
             int64_t usage,
             int64_t unlimited_usage) {*out_usage = std::move(usage);*out_unlimited_usage = std::move(unlimited_usage);
            loop->Quit();
          },
          &loop,
          out_usage,
          out_unlimited_usage));
  loop.Run();
}



void QuotaInternalsHandlerAsyncWaiter::IsSimulateStoragePressureAvailable(
    bool* out_available) {
  base::RunLoop loop;
  proxy_->IsSimulateStoragePressureAvailable(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_available
,
             bool available) {*out_available = std::move(available);
            loop->Quit();
          },
          &loop,
          out_available));
  loop.Run();
}

bool QuotaInternalsHandlerAsyncWaiter::IsSimulateStoragePressureAvailable(
    ) {
  bool async_wait_result;
  IsSimulateStoragePressureAvailable(&async_wait_result);
  return async_wait_result;
}






}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif