// skia/public/mojom/skcolorspace.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_SKCOLORSPACE_MOJOM_H_
#define SKIA_PUBLIC_MOJOM_SKCOLORSPACE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "skia/public/mojom/skcolorspace.mojom-features.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolorspace.mojom-shared.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolorspace.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "skia/public/mojom/skcolorspace_mojom_traits.h"




namespace skia::mojom {










class  SkcmsMatrix3x3 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SkcmsMatrix3x3, T>::value>;
  using DataView = SkcmsMatrix3x3DataView;
  using Data_ = internal::SkcmsMatrix3x3_Data;

  template <typename... Args>
  static SkcmsMatrix3x3Ptr New(Args&&... args) {
    return SkcmsMatrix3x3Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SkcmsMatrix3x3Ptr From(const U& u) {
    return mojo::TypeConverter<SkcmsMatrix3x3Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SkcmsMatrix3x3>::Convert(*this);
  }


  SkcmsMatrix3x3();

  explicit SkcmsMatrix3x3(
      std::vector<float> vals);


  ~SkcmsMatrix3x3();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SkcmsMatrix3x3Ptr>
  SkcmsMatrix3x3Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SkcmsMatrix3x3::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SkcmsMatrix3x3::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SkcmsMatrix3x3::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkcmsMatrix3x3::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkcmsMatrix3x3::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SkcmsMatrix3x3::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SkcmsMatrix3x3_UnserializedMessageContext<
            UserType, SkcmsMatrix3x3::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SkcmsMatrix3x3::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SkcmsMatrix3x3::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SkcmsMatrix3x3_UnserializedMessageContext<
            UserType, SkcmsMatrix3x3::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SkcmsMatrix3x3::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<float> vals;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SkcmsMatrix3x3::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SkcmsMatrix3x3::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SkcmsMatrix3x3::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SkcmsMatrix3x3::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SkcmsTransferFunction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SkcmsTransferFunction, T>::value>;
  using DataView = SkcmsTransferFunctionDataView;
  using Data_ = internal::SkcmsTransferFunction_Data;

  template <typename... Args>
  static SkcmsTransferFunctionPtr New(Args&&... args) {
    return SkcmsTransferFunctionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SkcmsTransferFunctionPtr From(const U& u) {
    return mojo::TypeConverter<SkcmsTransferFunctionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SkcmsTransferFunction>::Convert(*this);
  }


  SkcmsTransferFunction();

  SkcmsTransferFunction(
      float g,
      float a,
      float b,
      float c,
      float d,
      float e,
      float f);


  ~SkcmsTransferFunction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SkcmsTransferFunctionPtr>
  SkcmsTransferFunctionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SkcmsTransferFunction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SkcmsTransferFunction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SkcmsTransferFunction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkcmsTransferFunction::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkcmsTransferFunction::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SkcmsTransferFunction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SkcmsTransferFunction_UnserializedMessageContext<
            UserType, SkcmsTransferFunction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SkcmsTransferFunction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SkcmsTransferFunction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SkcmsTransferFunction_UnserializedMessageContext<
            UserType, SkcmsTransferFunction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SkcmsTransferFunction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float g;
  
  float a;
  
  float b;
  
  float c;
  
  float d;
  
  float e;
  
  float f;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SkcmsTransferFunction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SkcmsTransferFunction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SkcmsTransferFunction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SkcmsTransferFunction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SkColorSpace {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SkColorSpace, T>::value>;
  using DataView = SkColorSpaceDataView;
  using Data_ = internal::SkColorSpace_Data;

  template <typename... Args>
  static SkColorSpacePtr New(Args&&... args) {
    return SkColorSpacePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SkColorSpacePtr From(const U& u) {
    return mojo::TypeConverter<SkColorSpacePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SkColorSpace>::Convert(*this);
  }


  SkColorSpace();

  SkColorSpace(
      const std::optional<::skcms_TransferFunction>& to_linear,
      const std::optional<::skcms_Matrix3x3>& to_xyzd50);


  ~SkColorSpace();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SkColorSpacePtr>
  SkColorSpacePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SkColorSpace::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SkColorSpace::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SkColorSpace::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkColorSpace::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SkColorSpace::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SkColorSpace::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SkColorSpace_UnserializedMessageContext<
            UserType, SkColorSpace::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SkColorSpace::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SkColorSpace::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SkColorSpace_UnserializedMessageContext<
            UserType, SkColorSpace::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SkColorSpace::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::skcms_TransferFunction> to_linear;
  
  std::optional<::skcms_Matrix3x3> to_xyzd50;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SkColorSpace::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SkColorSpace::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SkColorSpace::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SkColorSpace::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SkcmsMatrix3x3Ptr SkcmsMatrix3x3::Clone() const {
  return New(
      mojo::Clone(vals)
  );
}

template <typename T, SkcmsMatrix3x3::EnableIfSame<T>*>
bool SkcmsMatrix3x3::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->vals, other_struct.vals))
    return false;
  return true;
}

template <typename T, SkcmsMatrix3x3::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.vals < rhs.vals)
    return true;
  if (rhs.vals < lhs.vals)
    return false;
  return false;
}
template <typename StructPtrType>
SkcmsTransferFunctionPtr SkcmsTransferFunction::Clone() const {
  return New(
      mojo::Clone(g),
      mojo::Clone(a),
      mojo::Clone(b),
      mojo::Clone(c),
      mojo::Clone(d),
      mojo::Clone(e),
      mojo::Clone(f)
  );
}

template <typename T, SkcmsTransferFunction::EnableIfSame<T>*>
bool SkcmsTransferFunction::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->g, other_struct.g))
    return false;
  if (!mojo::Equals(this->a, other_struct.a))
    return false;
  if (!mojo::Equals(this->b, other_struct.b))
    return false;
  if (!mojo::Equals(this->c, other_struct.c))
    return false;
  if (!mojo::Equals(this->d, other_struct.d))
    return false;
  if (!mojo::Equals(this->e, other_struct.e))
    return false;
  if (!mojo::Equals(this->f, other_struct.f))
    return false;
  return true;
}

template <typename T, SkcmsTransferFunction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.g < rhs.g)
    return true;
  if (rhs.g < lhs.g)
    return false;
  if (lhs.a < rhs.a)
    return true;
  if (rhs.a < lhs.a)
    return false;
  if (lhs.b < rhs.b)
    return true;
  if (rhs.b < lhs.b)
    return false;
  if (lhs.c < rhs.c)
    return true;
  if (rhs.c < lhs.c)
    return false;
  if (lhs.d < rhs.d)
    return true;
  if (rhs.d < lhs.d)
    return false;
  if (lhs.e < rhs.e)
    return true;
  if (rhs.e < lhs.e)
    return false;
  if (lhs.f < rhs.f)
    return true;
  if (rhs.f < lhs.f)
    return false;
  return false;
}
template <typename StructPtrType>
SkColorSpacePtr SkColorSpace::Clone() const {
  return New(
      mojo::Clone(to_linear),
      mojo::Clone(to_xyzd50)
  );
}

template <typename T, SkColorSpace::EnableIfSame<T>*>
bool SkColorSpace::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->to_linear, other_struct.to_linear))
    return false;
  if (!mojo::Equals(this->to_xyzd50, other_struct.to_xyzd50))
    return false;
  return true;
}

template <typename T, SkColorSpace::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.to_linear < rhs.to_linear)
    return true;
  if (rhs.to_linear < lhs.to_linear)
    return false;
  if (lhs.to_xyzd50 < rhs.to_xyzd50)
    return true;
  if (rhs.to_xyzd50 < lhs.to_xyzd50)
    return false;
  return false;
}


}  // skia::mojom

namespace mojo {


template <>
struct  StructTraits<::skia::mojom::SkcmsMatrix3x3::DataView,
                                         ::skia::mojom::SkcmsMatrix3x3Ptr> {
  static bool IsNull(const ::skia::mojom::SkcmsMatrix3x3Ptr& input) { return !input; }
  static void SetToNull(::skia::mojom::SkcmsMatrix3x3Ptr* output) { output->reset(); }

  static const decltype(::skia::mojom::SkcmsMatrix3x3::vals)& vals(
      const ::skia::mojom::SkcmsMatrix3x3Ptr& input) {
    return input->vals;
  }

  static bool Read(::skia::mojom::SkcmsMatrix3x3::DataView input, ::skia::mojom::SkcmsMatrix3x3Ptr* output);
};


template <>
struct  StructTraits<::skia::mojom::SkcmsTransferFunction::DataView,
                                         ::skia::mojom::SkcmsTransferFunctionPtr> {
  static bool IsNull(const ::skia::mojom::SkcmsTransferFunctionPtr& input) { return !input; }
  static void SetToNull(::skia::mojom::SkcmsTransferFunctionPtr* output) { output->reset(); }

  static decltype(::skia::mojom::SkcmsTransferFunction::g) g(
      const ::skia::mojom::SkcmsTransferFunctionPtr& input) {
    return input->g;
  }

  static decltype(::skia::mojom::SkcmsTransferFunction::a) a(
      const ::skia::mojom::SkcmsTransferFunctionPtr& input) {
    return input->a;
  }

  static decltype(::skia::mojom::SkcmsTransferFunction::b) b(
      const ::skia::mojom::SkcmsTransferFunctionPtr& input) {
    return input->b;
  }

  static decltype(::skia::mojom::SkcmsTransferFunction::c) c(
      const ::skia::mojom::SkcmsTransferFunctionPtr& input) {
    return input->c;
  }

  static decltype(::skia::mojom::SkcmsTransferFunction::d) d(
      const ::skia::mojom::SkcmsTransferFunctionPtr& input) {
    return input->d;
  }

  static decltype(::skia::mojom::SkcmsTransferFunction::e) e(
      const ::skia::mojom::SkcmsTransferFunctionPtr& input) {
    return input->e;
  }

  static decltype(::skia::mojom::SkcmsTransferFunction::f) f(
      const ::skia::mojom::SkcmsTransferFunctionPtr& input) {
    return input->f;
  }

  static bool Read(::skia::mojom::SkcmsTransferFunction::DataView input, ::skia::mojom::SkcmsTransferFunctionPtr* output);
};


template <>
struct  StructTraits<::skia::mojom::SkColorSpace::DataView,
                                         ::skia::mojom::SkColorSpacePtr> {
  static bool IsNull(const ::skia::mojom::SkColorSpacePtr& input) { return !input; }
  static void SetToNull(::skia::mojom::SkColorSpacePtr* output) { output->reset(); }

  static const decltype(::skia::mojom::SkColorSpace::to_linear)& to_linear(
      const ::skia::mojom::SkColorSpacePtr& input) {
    return input->to_linear;
  }

  static const decltype(::skia::mojom::SkColorSpace::to_xyzd50)& to_xyzd50(
      const ::skia::mojom::SkColorSpacePtr& input) {
    return input->to_xyzd50;
  }

  static bool Read(::skia::mojom::SkColorSpace::DataView input, ::skia::mojom::SkColorSpacePtr* output);
};

}  // namespace mojo

#endif  // SKIA_PUBLIC_MOJOM_SKCOLORSPACE_MOJOM_H_