// skia/public/mojom/skcolorspace.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_SKCOLORSPACE_MOJOM_DATA_VIEW_H_
#define SKIA_PUBLIC_MOJOM_SKCOLORSPACE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "skia/public/mojom/skcolorspace.mojom-shared-internal.h"


namespace skia::mojom {
class SkcmsMatrix3x3DataView;

class SkcmsTransferFunctionDataView;

class SkColorSpaceDataView;



}  // skia::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::skia::mojom::SkcmsMatrix3x3DataView> {
  using Data = ::skia::mojom::internal::SkcmsMatrix3x3_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::skia::mojom::SkcmsTransferFunctionDataView> {
  using Data = ::skia::mojom::internal::SkcmsTransferFunction_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::skia::mojom::SkColorSpaceDataView> {
  using Data = ::skia::mojom::internal::SkColorSpace_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace skia::mojom {


class SkcmsMatrix3x3DataView {
 public:
  SkcmsMatrix3x3DataView() = default;

  SkcmsMatrix3x3DataView(
      internal::SkcmsMatrix3x3_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValsDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVals(UserType* output) {
    
    auto* pointer = data_->vals.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
 private:
  internal::SkcmsMatrix3x3_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SkcmsTransferFunctionDataView {
 public:
  SkcmsTransferFunctionDataView() = default;

  SkcmsTransferFunctionDataView(
      internal::SkcmsTransferFunction_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float g() const {
    return data_->g;
  }
  float a() const {
    return data_->a;
  }
  float b() const {
    return data_->b;
  }
  float c() const {
    return data_->c;
  }
  float d() const {
    return data_->d;
  }
  float e() const {
    return data_->e;
  }
  float f() const {
    return data_->f;
  }
 private:
  internal::SkcmsTransferFunction_Data* data_ = nullptr;
};


class SkColorSpaceDataView {
 public:
  SkColorSpaceDataView() = default;

  SkColorSpaceDataView(
      internal::SkColorSpace_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetToLinearDataView(
      SkcmsTransferFunctionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToLinear(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkcmsTransferFunctionDataView, UserType>(),
    "Attempting to read the optional `to_linear` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadToLinear` instead "
    "of `ReadToLinear if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->to_linear.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkcmsTransferFunctionDataView>(
        pointer, output, message_);
  }
  inline void GetToXyzd50DataView(
      SkcmsMatrix3x3DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToXyzd50(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkcmsMatrix3x3DataView, UserType>(),
    "Attempting to read the optional `to_xyzd50` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadToXyzd50` instead "
    "of `ReadToXyzd50 if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->to_xyzd50.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkcmsMatrix3x3DataView>(
        pointer, output, message_);
  }
 private:
  internal::SkColorSpace_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // skia::mojom

#endif  // SKIA_PUBLIC_MOJOM_SKCOLORSPACE_MOJOM_DATA_VIEW_H_