// services/webnn/public/mojom/webnn_tensor.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_SHARED_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_tensor.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_graph.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/webnn/public/mojom/webnn_tensor.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::TensorUsageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::TensorUsageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::TensorUsage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->web_gpu_interop = Traits::web_gpu_interop(input);

    fragment->read = Traits::read(input);

    fragment->write = Traits::write(input);

    fragment->graph_constant = Traits::graph_constant(input);
  }

  static bool Deserialize(::webnn::mojom::internal::TensorUsage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::TensorUsageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::TensorInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::TensorInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::TensorInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::descriptor(input)) in_descriptor = Traits::descriptor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->descriptor)::BaseType> descriptor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::OperandDescriptorDataView>(
      in_descriptor,
      descriptor_fragment);

    fragment->descriptor.Set(
        descriptor_fragment.is_null() ? nullptr : descriptor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->descriptor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null descriptor in TensorInfo struct");

    decltype(Traits::usage(input)) in_usage = Traits::usage(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->usage)::BaseType> usage_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::TensorUsageDataView>(
      in_usage,
      usage_fragment);

    fragment->usage.Set(
        usage_fragment.is_null() ? nullptr : usage_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->usage.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null usage in TensorInfo struct");
  }

  static bool Deserialize(::webnn::mojom::internal::TensorInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::TensorInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::ReadTensorResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::ReadTensorResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::ReadTensorResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::ReadTensorResultDataView::Tag::kBuffer: {
    decltype(Traits::buffer(input))
    in_buffer = Traits::buffer(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_buffer)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
  in_buffer,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null buffer in ReadTensorResult union");
    fragment->data.f_buffer.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::ReadTensorResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ErrorDataView>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in ReadTensorResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::webnn::mojom::internal::ReadTensorResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::ReadTensorResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::WebNNTensor_ExportTensor_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in WebNNTensor_ExportTensor_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ErrorDataView>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in WebNNTensor_ExportTensor_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::webnn::mojom::internal::WebNNTensor_ExportTensor_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace webnn::mojom {



inline void TensorInfoDataView::GetDescriptorDataView(
    ::webnn::mojom::OperandDescriptorDataView* output) {
  auto pointer = data_->descriptor.Get();
  *output = ::webnn::mojom::OperandDescriptorDataView(pointer, message_);
}
inline void TensorInfoDataView::GetUsageDataView(
    TensorUsageDataView* output) {
  auto pointer = data_->usage.Get();
  *output = TensorUsageDataView(pointer, message_);
}


inline void ReadTensorResultDataView::GetBufferDataView(
    ::mojo_base::mojom::BigBufferDataView* output) const {
  CHECK(is_buffer());
  *output = ::mojo_base::mojom::BigBufferDataView(data_->data.f_buffer.Get(), message_);
}
inline void ReadTensorResultDataView::GetErrorDataView(
    ::webnn::mojom::ErrorDataView* output) const {
  CHECK(is_error());
  *output = ::webnn::mojom::ErrorDataView(data_->data.f_error.Get(), message_);
}

inline void WebNNTensor_ExportTensor_ResponseParam_ResultDataView::GetSuccessDataView(
    ::gpu::mojom::SyncTokenDataView* output) const {
  CHECK(is_success());
  *output = ::gpu::mojom::SyncTokenDataView(data_->data.f_success.Get(), message_);
}
inline void WebNNTensor_ExportTensor_ResponseParam_ResultDataView::GetFailureDataView(
    ::webnn::mojom::ErrorDataView* output) const {
  CHECK(is_failure());
  *output = ::webnn::mojom::ErrorDataView(data_->data.f_failure.Get(), message_);
}


}  // webnn::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_SHARED_H_