// services/webnn/public/mojom/webnn_tensor.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_SEND_VALIDATION_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_SEND_VALIDATION_H_

#include "services/webnn/public/mojom/webnn_tensor.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_graph.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"

#include "services/webnn/public/mojom/webnn_tensor.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::TensorUsageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::TensorUsageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::TensorUsage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->web_gpu_interop = Traits::web_gpu_interop(input);

      fragment->read = Traits::read(input);

      fragment->write = Traits::write(input);

      fragment->graph_constant = Traits::graph_constant(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::TensorInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::TensorInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::TensorInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::descriptor(input)) in_descriptor = Traits::descriptor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->descriptor)::BaseType> descriptor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::OperandDescriptorDataView, send_validation>(
        in_descriptor,
        descriptor_fragment);

      fragment->descriptor.Set(
          descriptor_fragment.is_null() ? nullptr : descriptor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->descriptor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null descriptor in TensorInfo struct");

      decltype(Traits::usage(input)) in_usage = Traits::usage(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->usage)::BaseType> usage_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::webnn::mojom::TensorUsageDataView, send_validation>(
        in_usage,
        usage_fragment);

      fragment->usage.Set(
          usage_fragment.is_null() ? nullptr : usage_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->usage.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null usage in TensorInfo struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::ReadTensorResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::ReadTensorResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::ReadTensorResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::ReadTensorResultDataView::Tag::kBuffer: {
    decltype(Traits::buffer(input))
    in_buffer = Traits::buffer(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_buffer)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView, send_validation>(
  in_buffer,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null buffer in ReadTensorResult union");
    fragment->data.f_buffer.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::ReadTensorResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ErrorDataView, send_validation>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in ReadTensorResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::WebNNTensor_ExportTensor_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in WebNNTensor_ExportTensor_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ErrorDataView, send_validation>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in WebNNTensor_ExportTensor_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_SEND_VALIDATION_H_