// services/webnn/public/mojom/webnn_tensor.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_DATA_VIEW_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/webnn/public/mojom/webnn_tensor.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_graph.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"


namespace webnn::mojom {
class TensorUsageDataView;

class TensorInfoDataView;

class ReadTensorResultDataView;
class WebNNTensor_ExportTensor_ResponseParam_ResultDataView;


}  // webnn::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::webnn::mojom::TensorUsageDataView> {
  using Data = ::webnn::mojom::internal::TensorUsage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::TensorInfoDataView> {
  using Data = ::webnn::mojom::internal::TensorInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ReadTensorResultDataView> {
  using Data = ::webnn::mojom::internal::ReadTensorResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::webnn::mojom::WebNNTensor_ExportTensor_ResponseParam_ResultDataView> {
  using Data = ::webnn::mojom::internal::WebNNTensor_ExportTensor_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace webnn::mojom {
// Interface base classes. They are used for type safety check.
class WebNNTensorInterfaceBase {};

using WebNNTensorPtrDataView =
    mojo::InterfacePtrDataView<WebNNTensorInterfaceBase>;
using WebNNTensorRequestDataView =
    mojo::InterfaceRequestDataView<WebNNTensorInterfaceBase>;
using WebNNTensorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebNNTensorInterfaceBase>;
using WebNNTensorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebNNTensorInterfaceBase>;


class TensorUsageDataView {
 public:
  TensorUsageDataView() = default;

  TensorUsageDataView(
      internal::TensorUsage_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool web_gpu_interop() const {
    return data_->web_gpu_interop;
  }
  bool read() const {
    return data_->read;
  }
  bool write() const {
    return data_->write;
  }
  bool graph_constant() const {
    return data_->graph_constant;
  }
 private:
  internal::TensorUsage_Data* data_ = nullptr;
};


class TensorInfoDataView {
 public:
  TensorInfoDataView() = default;

  TensorInfoDataView(
      internal::TensorInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDescriptorDataView(
      ::webnn::mojom::OperandDescriptorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptor(UserType* output) {
    
    auto* pointer = data_->descriptor.Get();
    return mojo::internal::Deserialize<::webnn::mojom::OperandDescriptorDataView>(
        pointer, output, message_);
  }
  inline void GetUsageDataView(
      TensorUsageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsage(UserType* output) {
    
    auto* pointer = data_->usage.Get();
    return mojo::internal::Deserialize<::webnn::mojom::TensorUsageDataView>(
        pointer, output, message_);
  }
 private:
  internal::TensorInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReadTensorResultDataView {
 public:
  using Tag = internal::ReadTensorResult_Data::ReadTensorResult_Tag;

  ReadTensorResultDataView() = default;

  ReadTensorResultDataView(
      internal::ReadTensorResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_buffer() const { return data_->tag == Tag::kBuffer; }
  inline void GetBufferDataView(
      ::mojo_base::mojom::BigBufferDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBuffer(UserType* output) const {
    
    CHECK(is_buffer());
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        data_->data.f_buffer.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      ::webnn::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<::webnn::mojom::ErrorDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::ReadTensorResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class WebNNTensor_ExportTensor_ResponseParam_ResultDataView {
 public:
  using Tag = internal::WebNNTensor_ExportTensor_ResponseParam_Result_Data::WebNNTensor_ExportTensor_ResponseParam_Result_Tag;

  WebNNTensor_ExportTensor_ResponseParam_ResultDataView() = default;

  WebNNTensor_ExportTensor_ResponseParam_ResultDataView(
      internal::WebNNTensor_ExportTensor_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      ::gpu::mojom::SyncTokenDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  inline void GetFailureDataView(
      ::webnn::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    
    CHECK(is_failure());
    return mojo::internal::Deserialize<::webnn::mojom::ErrorDataView>(
        data_->data.f_failure.Get(), output, message_);
  }

 private:
  internal::WebNNTensor_ExportTensor_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // webnn::mojom

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_TENSOR_MOJOM_DATA_VIEW_H_