// services/webnn/public/mojom/webnn_graph.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace webnn::mojom {
namespace internal {
class OperandDescriptor_Data;
class OperandId_Data;
class Operand_Data;
class ArgMinMax_Data;
class BatchNormalization_Data;
class Clamp_Data;
class Concat_Data;
class Size2d_Data;
class Padding2d_Data;
class Conv2d_Data;
class CumulativeSum_Data;
class DequantizeLinear_Data;
class ElementWiseBinary_Data;
class ElementWiseUnary_Data;
class Expand_Data;
class ConstantPadding_Data;
class EdgePadding_Data;
class ReflectionPadding_Data;
class InstanceNormalization_Data;
class Matmul_Data;
class Pad_Data;
class Reduce_Data;
class Pool2d_Data;
class Range_Data;
class Slice_Data;
class Elu_Data;
class Gather_Data;
class GatherElements_Data;
class GatherND_Data;
class Gelu_Data;
class Gru_Data;
class GruCell_Data;
class Gemm_Data;
class HardSigmoid_Data;
class HardSwish_Data;
class LayerNormalization_Data;
class LeakyRelu_Data;
class Linear_Data;
class Lstm_Data;
class LstmCell_Data;
class Prelu_Data;
class QuantizeLinear_Data;
class Relu_Data;
class Reshape_Data;
class Reverse_Data;
class ScatterElements_Data;
class ScatterND_Data;
class Sigmoid_Data;
class Softmax_Data;
class Softplus_Data;
class Softsign_Data;
class Split_Data;
class Tanh_Data;
class Tile_Data;
class Transpose_Data;
class Triangular_Data;
class Resample2d_Data;
class Where_Data;
class GraphInfo_Data;
class Number_Data;
class PaddingMode_Data;
class Operation_Data;

struct DataType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct RecurrentNetworkActivation_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct RecurrentNetworkDirection_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct GruWeightLayout_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct LstmWeightLayout_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct Operand_Kind_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ArgMinMax_Kind_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct Conv2d_Kind_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ElementWiseBinary_Kind_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ElementWiseUnary_Kind_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct Reduce_Kind_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct Pool2d_Kind_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct Resample2d_InterpolationMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Number_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  Number_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~Number_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<Number_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class Number_Tag : uint32_t {

    
    kFloatingPoint,
    
    kSignedInteger,
    
    kUnsignedInteger,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    double f_floating_point;
    int64_t f_signed_integer;
    uint64_t f_unsigned_integer;
    uint64_t unknown;
  };

  uint32_t size;
  Number_Tag tag;
  Union_ data;
};
static_assert(sizeof(Number_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(Number_Data)");


class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) PaddingMode_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  PaddingMode_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~PaddingMode_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<PaddingMode_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class PaddingMode_Tag : uint32_t {

    
    kConstant,
    
    kEdge,
    
    kReflection,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::ConstantPadding_Data> f_constant;
    mojo::internal::Pointer<internal::EdgePadding_Data> f_edge;
    mojo::internal::Pointer<internal::ReflectionPadding_Data> f_reflection;
    uint64_t unknown;
  };

  uint32_t size;
  PaddingMode_Tag tag;
  Union_ data;
};
static_assert(sizeof(PaddingMode_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(PaddingMode_Data)");


class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Operation_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  Operation_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~Operation_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<Operation_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class Operation_Tag : uint32_t {

    
    kArgMinMax,
    
    kBatchNormalization,
    
    kClamp,
    
    kConcat,
    
    kConv2d,
    
    kCumulativeSum,
    
    kDequantizeLinear,
    
    kElementWiseBinary,
    
    kElu,
    
    kElementWiseUnary,
    
    kExpand,
    
    kGather,
    
    kGatherElements,
    
    kGatherNd,
    
    kGelu,
    
    kGemm,
    
    kGru,
    
    kGruCell,
    
    kHardSigmoid,
    
    kHardSwish,
    
    kLayerNormalization,
    
    kInstanceNormalization,
    
    kLeakyRelu,
    
    kLinear,
    
    kLstm,
    
    kLstmCell,
    
    kMatmul,
    
    kPad,
    
    kPool2d,
    
    kPrelu,
    
    kQuantizeLinear,
    
    kReduce,
    
    kRelu,
    
    kResample2d,
    
    kReshape,
    
    kReverse,
    
    kScatterElements,
    
    kScatterNd,
    
    kSigmoid,
    
    kSlice,
    
    kSoftmax,
    
    kSoftplus,
    
    kSoftsign,
    
    kSplit,
    
    kTanh,
    
    kTile,
    
    kTranspose,
    
    kTriangular,
    
    kWhere,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::ArgMinMax_Data> f_arg_min_max;
    mojo::internal::Pointer<internal::BatchNormalization_Data> f_batch_normalization;
    mojo::internal::Pointer<internal::Clamp_Data> f_clamp;
    mojo::internal::Pointer<internal::Concat_Data> f_concat;
    mojo::internal::Pointer<internal::Conv2d_Data> f_conv2d;
    mojo::internal::Pointer<internal::CumulativeSum_Data> f_cumulative_sum;
    mojo::internal::Pointer<internal::DequantizeLinear_Data> f_dequantize_linear;
    mojo::internal::Pointer<internal::ElementWiseBinary_Data> f_element_wise_binary;
    mojo::internal::Pointer<internal::Elu_Data> f_elu;
    mojo::internal::Pointer<internal::ElementWiseUnary_Data> f_element_wise_unary;
    mojo::internal::Pointer<internal::Expand_Data> f_expand;
    mojo::internal::Pointer<internal::Gather_Data> f_gather;
    mojo::internal::Pointer<internal::GatherElements_Data> f_gather_elements;
    mojo::internal::Pointer<internal::GatherND_Data> f_gather_nd;
    mojo::internal::Pointer<internal::Gelu_Data> f_gelu;
    mojo::internal::Pointer<internal::Gemm_Data> f_gemm;
    mojo::internal::Pointer<internal::Gru_Data> f_gru;
    mojo::internal::Pointer<internal::GruCell_Data> f_gru_cell;
    mojo::internal::Pointer<internal::HardSigmoid_Data> f_hard_sigmoid;
    mojo::internal::Pointer<internal::HardSwish_Data> f_hard_swish;
    mojo::internal::Pointer<internal::LayerNormalization_Data> f_layer_normalization;
    mojo::internal::Pointer<internal::InstanceNormalization_Data> f_instance_normalization;
    mojo::internal::Pointer<internal::LeakyRelu_Data> f_leaky_relu;
    mojo::internal::Pointer<internal::Linear_Data> f_linear;
    mojo::internal::Pointer<internal::Lstm_Data> f_lstm;
    mojo::internal::Pointer<internal::LstmCell_Data> f_lstm_cell;
    mojo::internal::Pointer<internal::Matmul_Data> f_matmul;
    mojo::internal::Pointer<internal::Pad_Data> f_pad;
    mojo::internal::Pointer<internal::Pool2d_Data> f_pool2d;
    mojo::internal::Pointer<internal::Prelu_Data> f_prelu;
    mojo::internal::Pointer<internal::QuantizeLinear_Data> f_quantize_linear;
    mojo::internal::Pointer<internal::Reduce_Data> f_reduce;
    mojo::internal::Pointer<internal::Relu_Data> f_relu;
    mojo::internal::Pointer<internal::Resample2d_Data> f_resample2d;
    mojo::internal::Pointer<internal::Reshape_Data> f_reshape;
    mojo::internal::Pointer<internal::Reverse_Data> f_reverse;
    mojo::internal::Pointer<internal::ScatterElements_Data> f_scatter_elements;
    mojo::internal::Pointer<internal::ScatterND_Data> f_scatter_nd;
    mojo::internal::Pointer<internal::Sigmoid_Data> f_sigmoid;
    mojo::internal::Pointer<internal::Slice_Data> f_slice;
    mojo::internal::Pointer<internal::Softmax_Data> f_softmax;
    mojo::internal::Pointer<internal::Softplus_Data> f_softplus;
    mojo::internal::Pointer<internal::Softsign_Data> f_softsign;
    mojo::internal::Pointer<internal::Split_Data> f_split;
    mojo::internal::Pointer<internal::Tanh_Data> f_tanh;
    mojo::internal::Pointer<internal::Tile_Data> f_tile;
    mojo::internal::Pointer<internal::Transpose_Data> f_transpose;
    mojo::internal::Pointer<internal::Triangular_Data> f_triangular;
    mojo::internal::Pointer<internal::Where_Data> f_where;
    uint64_t unknown;
  };

  uint32_t size;
  Operation_Tag tag;
  Union_ data;
};
static_assert(sizeof(Operation_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(Operation_Data)");
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) OperandDescriptor_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t data_type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> shape;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> pending_permutation;

 private:
  friend class mojo::internal::MessageFragment<OperandDescriptor_Data>;

  OperandDescriptor_Data();
  ~OperandDescriptor_Data() = delete;
};
static_assert(sizeof(OperandDescriptor_Data) == 32,
              "Bad sizeof(OperandDescriptor_Data)");
// Used by OperandDescriptor::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct OperandDescriptor_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  OperandDescriptor_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~OperandDescriptor_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<OperandDescriptor_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    OperandDescriptor_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) OperandId_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<OperandId_Data>;

  OperandId_Data();
  ~OperandId_Data() = delete;
};
static_assert(sizeof(OperandId_Data) == 16,
              "Bad sizeof(OperandId_Data)");
// Used by OperandId::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct OperandId_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  OperandId_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~OperandId_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<OperandId_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    OperandId_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Operand_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t kind;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::OperandDescriptor_Data> descriptor;
  mojo::internal::Pointer<mojo::internal::String_Data> name;

 private:
  friend class mojo::internal::MessageFragment<Operand_Data>;

  Operand_Data();
  ~Operand_Data() = delete;
};
static_assert(sizeof(Operand_Data) == 32,
              "Bad sizeof(Operand_Data)");
// Used by Operand::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Operand_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Operand_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Operand_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Operand_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Operand_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) ArgMinMax_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t kind;
  uint32_t axis;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  uint8_t keep_dimensions : 1;
  uint8_t pad4_[7];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<ArgMinMax_Data>;

  ArgMinMax_Data();
  ~ArgMinMax_Data() = delete;
};
static_assert(sizeof(ArgMinMax_Data) == 48,
              "Bad sizeof(ArgMinMax_Data)");
// Used by ArgMinMax::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ArgMinMax_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ArgMinMax_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ArgMinMax_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ArgMinMax_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ArgMinMax_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) BatchNormalization_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> mean_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> variance_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> scale_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> bias_operand_id;
  uint32_t axis;
  float epsilon;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<BatchNormalization_Data>;

  BatchNormalization_Data();
  ~BatchNormalization_Data() = delete;
};
static_assert(sizeof(BatchNormalization_Data) == 72,
              "Bad sizeof(BatchNormalization_Data)");
// Used by BatchNormalization::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BatchNormalization_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BatchNormalization_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BatchNormalization_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BatchNormalization_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BatchNormalization_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Clamp_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  internal::Number_Data min_value;
  internal::Number_Data max_value;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Clamp_Data>;

  Clamp_Data();
  ~Clamp_Data() = delete;
};
static_assert(sizeof(Clamp_Data) == 64,
              "Bad sizeof(Clamp_Data)");
// Used by Clamp::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Clamp_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Clamp_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Clamp_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Clamp_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Clamp_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Concat_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::OperandId_Data>>> input_operand_ids;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  uint32_t axis;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Concat_Data>;

  Concat_Data();
  ~Concat_Data() = delete;
};
static_assert(sizeof(Concat_Data) == 40,
              "Bad sizeof(Concat_Data)");
// Used by Concat::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Concat_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Concat_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Concat_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Concat_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Concat_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Size2d_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t height;
  uint32_t width;

 private:
  friend class mojo::internal::MessageFragment<Size2d_Data>;

  Size2d_Data();
  ~Size2d_Data() = delete;
};
static_assert(sizeof(Size2d_Data) == 16,
              "Bad sizeof(Size2d_Data)");
// Used by Size2d::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Size2d_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Size2d_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Size2d_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Size2d_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Size2d_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Padding2d_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::Size2d_Data> beginning;
  mojo::internal::Pointer<internal::Size2d_Data> ending;

 private:
  friend class mojo::internal::MessageFragment<Padding2d_Data>;

  Padding2d_Data();
  ~Padding2d_Data() = delete;
};
static_assert(sizeof(Padding2d_Data) == 24,
              "Bad sizeof(Padding2d_Data)");
// Used by Padding2d::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Padding2d_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Padding2d_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Padding2d_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Padding2d_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Padding2d_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Conv2d_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t kind;
  uint32_t groups;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> filter_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<internal::Padding2d_Data> padding;
  mojo::internal::Pointer<internal::Size2d_Data> strides;
  mojo::internal::Pointer<internal::Size2d_Data> dilations;
  mojo::internal::Pointer<internal::OperandId_Data> bias_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Conv2d_Data>;

  Conv2d_Data();
  ~Conv2d_Data() = delete;
};
static_assert(sizeof(Conv2d_Data) == 80,
              "Bad sizeof(Conv2d_Data)");
// Used by Conv2d::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Conv2d_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Conv2d_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Conv2d_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Conv2d_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Conv2d_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) CumulativeSum_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  uint32_t axis;
  uint8_t exclusive : 1;
  uint8_t reversed : 1;
  uint8_t pad4_[3];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<CumulativeSum_Data>;

  CumulativeSum_Data();
  ~CumulativeSum_Data() = delete;
};
static_assert(sizeof(CumulativeSum_Data) == 40,
              "Bad sizeof(CumulativeSum_Data)");
// Used by CumulativeSum::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CumulativeSum_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CumulativeSum_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CumulativeSum_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CumulativeSum_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CumulativeSum_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) DequantizeLinear_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> scale_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> zero_point_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<DequantizeLinear_Data>;

  DequantizeLinear_Data();
  ~DequantizeLinear_Data() = delete;
};
static_assert(sizeof(DequantizeLinear_Data) == 48,
              "Bad sizeof(DequantizeLinear_Data)");
// Used by DequantizeLinear::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DequantizeLinear_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DequantizeLinear_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DequantizeLinear_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<DequantizeLinear_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DequantizeLinear_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) ElementWiseBinary_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t kind;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::OperandId_Data> lhs_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> rhs_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<ElementWiseBinary_Data>;

  ElementWiseBinary_Data();
  ~ElementWiseBinary_Data() = delete;
};
static_assert(sizeof(ElementWiseBinary_Data) == 48,
              "Bad sizeof(ElementWiseBinary_Data)");
// Used by ElementWiseBinary::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ElementWiseBinary_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ElementWiseBinary_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ElementWiseBinary_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ElementWiseBinary_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ElementWiseBinary_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) ElementWiseUnary_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t kind;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<ElementWiseUnary_Data>;

  ElementWiseUnary_Data();
  ~ElementWiseUnary_Data() = delete;
};
static_assert(sizeof(ElementWiseUnary_Data) == 40,
              "Bad sizeof(ElementWiseUnary_Data)");
// Used by ElementWiseUnary::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ElementWiseUnary_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ElementWiseUnary_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ElementWiseUnary_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ElementWiseUnary_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ElementWiseUnary_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Expand_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Expand_Data>;

  Expand_Data();
  ~Expand_Data() = delete;
};
static_assert(sizeof(Expand_Data) == 32,
              "Bad sizeof(Expand_Data)");
// Used by Expand::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Expand_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Expand_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Expand_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Expand_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Expand_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) ConstantPadding_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::Number_Data value;

 private:
  friend class mojo::internal::MessageFragment<ConstantPadding_Data>;

  ConstantPadding_Data();
  ~ConstantPadding_Data() = delete;
};
static_assert(sizeof(ConstantPadding_Data) == 24,
              "Bad sizeof(ConstantPadding_Data)");
// Used by ConstantPadding::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ConstantPadding_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ConstantPadding_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ConstantPadding_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ConstantPadding_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ConstantPadding_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) EdgePadding_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<EdgePadding_Data>;

  EdgePadding_Data();
  ~EdgePadding_Data() = delete;
};
static_assert(sizeof(EdgePadding_Data) == 8,
              "Bad sizeof(EdgePadding_Data)");
// Used by EdgePadding::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct EdgePadding_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  EdgePadding_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~EdgePadding_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<EdgePadding_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    EdgePadding_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) ReflectionPadding_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<ReflectionPadding_Data>;

  ReflectionPadding_Data();
  ~ReflectionPadding_Data() = delete;
};
static_assert(sizeof(ReflectionPadding_Data) == 8,
              "Bad sizeof(ReflectionPadding_Data)");
// Used by ReflectionPadding::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ReflectionPadding_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ReflectionPadding_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ReflectionPadding_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ReflectionPadding_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ReflectionPadding_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) InstanceNormalization_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> scale_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> bias_operand_id;
  float epsilon;
  uint8_t pad4_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<InstanceNormalization_Data>;

  InstanceNormalization_Data();
  ~InstanceNormalization_Data() = delete;
};
static_assert(sizeof(InstanceNormalization_Data) == 56,
              "Bad sizeof(InstanceNormalization_Data)");
// Used by InstanceNormalization::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct InstanceNormalization_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  InstanceNormalization_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~InstanceNormalization_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<InstanceNormalization_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    InstanceNormalization_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Matmul_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> a_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> b_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Matmul_Data>;

  Matmul_Data();
  ~Matmul_Data() = delete;
};
static_assert(sizeof(Matmul_Data) == 40,
              "Bad sizeof(Matmul_Data)");
// Used by Matmul::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Matmul_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Matmul_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Matmul_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Matmul_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Matmul_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Pad_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> beginning_padding;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> ending_padding;
  internal::PaddingMode_Data mode;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Pad_Data>;

  Pad_Data();
  ~Pad_Data() = delete;
};
static_assert(sizeof(Pad_Data) == 64,
              "Bad sizeof(Pad_Data)");
// Used by Pad::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Pad_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Pad_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Pad_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Pad_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Pad_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Reduce_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t kind;
  uint8_t keep_dimensions : 1;
  uint8_t pad1_[3];
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> axes;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Reduce_Data>;

  Reduce_Data();
  ~Reduce_Data() = delete;
};
static_assert(sizeof(Reduce_Data) == 48,
              "Bad sizeof(Reduce_Data)");
// Used by Reduce::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Reduce_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Reduce_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Reduce_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Reduce_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Reduce_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Pool2d_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t kind;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<internal::Size2d_Data> window_dimensions;
  mojo::internal::Pointer<internal::Padding2d_Data> padding;
  mojo::internal::Pointer<internal::Size2d_Data> strides;
  mojo::internal::Pointer<internal::Size2d_Data> dilations;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Pool2d_Data>;

  Pool2d_Data();
  ~Pool2d_Data() = delete;
};
static_assert(sizeof(Pool2d_Data) == 72,
              "Bad sizeof(Pool2d_Data)");
// Used by Pool2d::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Pool2d_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Pool2d_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Pool2d_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Pool2d_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Pool2d_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Range_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t start;
  uint32_t size;
  uint32_t stride;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Range_Data>;

  Range_Data();
  ~Range_Data() = delete;
};
static_assert(sizeof(Range_Data) == 24,
              "Bad sizeof(Range_Data)");
// Used by Range::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Range_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Range_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Range_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Range_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Range_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Slice_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Range_Data>>> ranges;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Slice_Data>;

  Slice_Data();
  ~Slice_Data() = delete;
};
static_assert(sizeof(Slice_Data) == 40,
              "Bad sizeof(Slice_Data)");
// Used by Slice::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Slice_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Slice_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Slice_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Slice_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Slice_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Elu_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  float alpha;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Elu_Data>;

  Elu_Data();
  ~Elu_Data() = delete;
};
static_assert(sizeof(Elu_Data) == 40,
              "Bad sizeof(Elu_Data)");
// Used by Elu::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Elu_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Elu_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Elu_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Elu_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Elu_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Gather_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> indices_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  uint32_t axis;
  uint8_t pad3_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Gather_Data>;

  Gather_Data();
  ~Gather_Data() = delete;
};
static_assert(sizeof(Gather_Data) == 48,
              "Bad sizeof(Gather_Data)");
// Used by Gather::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Gather_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Gather_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Gather_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Gather_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Gather_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) GatherElements_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> indices_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  uint32_t axis;
  uint8_t pad3_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<GatherElements_Data>;

  GatherElements_Data();
  ~GatherElements_Data() = delete;
};
static_assert(sizeof(GatherElements_Data) == 48,
              "Bad sizeof(GatherElements_Data)");
// Used by GatherElements::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GatherElements_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GatherElements_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GatherElements_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GatherElements_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GatherElements_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) GatherND_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> indices_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<GatherND_Data>;

  GatherND_Data();
  ~GatherND_Data() = delete;
};
static_assert(sizeof(GatherND_Data) == 40,
              "Bad sizeof(GatherND_Data)");
// Used by GatherND::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GatherND_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GatherND_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GatherND_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GatherND_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GatherND_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Gelu_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Gelu_Data>;

  Gelu_Data();
  ~Gelu_Data() = delete;
};
static_assert(sizeof(Gelu_Data) == 32,
              "Bad sizeof(Gelu_Data)");
// Used by Gelu::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Gelu_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Gelu_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Gelu_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Gelu_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Gelu_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Gru_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> weight_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> recurrent_weight_operand_id;
  uint32_t steps;
  uint32_t hidden_size;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::OperandId_Data>>> output_operand_ids;
  mojo::internal::Pointer<internal::OperandId_Data> bias_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> recurrent_bias_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> initial_hidden_state_operand_id;
  uint8_t reset_after : 1;
  uint8_t return_sequence : 1;
  uint8_t pad10_[3];
  int32_t direction;
  int32_t layout;
  uint8_t pad12_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> activations;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Gru_Data>;

  Gru_Data();
  ~Gru_Data() = delete;
};
static_assert(sizeof(Gru_Data) == 104,
              "Bad sizeof(Gru_Data)");
// Used by Gru::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Gru_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Gru_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Gru_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Gru_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Gru_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) GruCell_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> weight_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> recurrent_weight_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> hidden_state_operand_id;
  uint32_t hidden_size;
  uint8_t reset_after : 1;
  uint8_t pad5_[3];
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> bias_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> recurrent_bias_operand_id;
  int32_t layout;
  uint8_t pad9_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> activations;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<GruCell_Data>;

  GruCell_Data();
  ~GruCell_Data() = delete;
};
static_assert(sizeof(GruCell_Data) == 96,
              "Bad sizeof(GruCell_Data)");
// Used by GruCell::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GruCell_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GruCell_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GruCell_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GruCell_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GruCell_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Gemm_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> a_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> b_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> c_operand_id;
  float alpha;
  float beta;
  uint8_t a_transpose : 1;
  uint8_t b_transpose : 1;
  uint8_t pad7_[7];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Gemm_Data>;

  Gemm_Data();
  ~Gemm_Data() = delete;
};
static_assert(sizeof(Gemm_Data) == 64,
              "Bad sizeof(Gemm_Data)");
// Used by Gemm::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Gemm_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Gemm_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Gemm_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Gemm_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Gemm_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) HardSigmoid_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  float alpha;
  float beta;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<HardSigmoid_Data>;

  HardSigmoid_Data();
  ~HardSigmoid_Data() = delete;
};
static_assert(sizeof(HardSigmoid_Data) == 40,
              "Bad sizeof(HardSigmoid_Data)");
// Used by HardSigmoid::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct HardSigmoid_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  HardSigmoid_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~HardSigmoid_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<HardSigmoid_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    HardSigmoid_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) HardSwish_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<HardSwish_Data>;

  HardSwish_Data();
  ~HardSwish_Data() = delete;
};
static_assert(sizeof(HardSwish_Data) == 32,
              "Bad sizeof(HardSwish_Data)");
// Used by HardSwish::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct HardSwish_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  HardSwish_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~HardSwish_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<HardSwish_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    HardSwish_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) LayerNormalization_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> scale_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> bias_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> axes;
  float epsilon;
  uint8_t pad5_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<LayerNormalization_Data>;

  LayerNormalization_Data();
  ~LayerNormalization_Data() = delete;
};
static_assert(sizeof(LayerNormalization_Data) == 64,
              "Bad sizeof(LayerNormalization_Data)");
// Used by LayerNormalization::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct LayerNormalization_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  LayerNormalization_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~LayerNormalization_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<LayerNormalization_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    LayerNormalization_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) LeakyRelu_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  float alpha;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<LeakyRelu_Data>;

  LeakyRelu_Data();
  ~LeakyRelu_Data() = delete;
};
static_assert(sizeof(LeakyRelu_Data) == 40,
              "Bad sizeof(LeakyRelu_Data)");
// Used by LeakyRelu::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct LeakyRelu_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  LeakyRelu_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~LeakyRelu_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<LeakyRelu_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    LeakyRelu_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Linear_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  float alpha;
  float beta;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Linear_Data>;

  Linear_Data();
  ~Linear_Data() = delete;
};
static_assert(sizeof(Linear_Data) == 40,
              "Bad sizeof(Linear_Data)");
// Used by Linear::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Linear_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Linear_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Linear_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Linear_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Linear_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Lstm_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> weight_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> recurrent_weight_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::OperandId_Data>>> output_operand_ids;
  uint32_t steps;
  uint32_t hidden_size;
  mojo::internal::Pointer<internal::OperandId_Data> bias_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> recurrent_bias_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> peephole_weight_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> initial_hidden_state_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> initial_cell_state_operand_id;
  uint8_t return_sequence : 1;
  uint8_t pad11_[3];
  int32_t direction;
  int32_t layout;
  uint8_t pad13_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> activations;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Lstm_Data>;

  Lstm_Data();
  ~Lstm_Data() = delete;
};
static_assert(sizeof(Lstm_Data) == 120,
              "Bad sizeof(Lstm_Data)");
// Used by Lstm::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Lstm_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Lstm_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Lstm_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Lstm_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Lstm_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) LstmCell_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> weight_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> recurrent_weight_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> hidden_state_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> cell_state_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::OperandId_Data>>> output_operand_ids;
  uint32_t hidden_size;
  int32_t layout;
  mojo::internal::Pointer<internal::OperandId_Data> bias_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> recurrent_bias_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> peephole_weight_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> activations;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<LstmCell_Data>;

  LstmCell_Data();
  ~LstmCell_Data() = delete;
};
static_assert(sizeof(LstmCell_Data) == 104,
              "Bad sizeof(LstmCell_Data)");
// Used by LstmCell::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct LstmCell_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  LstmCell_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~LstmCell_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<LstmCell_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    LstmCell_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Prelu_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> slope_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Prelu_Data>;

  Prelu_Data();
  ~Prelu_Data() = delete;
};
static_assert(sizeof(Prelu_Data) == 40,
              "Bad sizeof(Prelu_Data)");
// Used by Prelu::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Prelu_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Prelu_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Prelu_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Prelu_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Prelu_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) QuantizeLinear_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> scale_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> zero_point_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<QuantizeLinear_Data>;

  QuantizeLinear_Data();
  ~QuantizeLinear_Data() = delete;
};
static_assert(sizeof(QuantizeLinear_Data) == 48,
              "Bad sizeof(QuantizeLinear_Data)");
// Used by QuantizeLinear::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct QuantizeLinear_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  QuantizeLinear_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~QuantizeLinear_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<QuantizeLinear_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    QuantizeLinear_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Relu_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Relu_Data>;

  Relu_Data();
  ~Relu_Data() = delete;
};
static_assert(sizeof(Relu_Data) == 32,
              "Bad sizeof(Relu_Data)");
// Used by Relu::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Relu_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Relu_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Relu_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Relu_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Relu_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Reshape_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Reshape_Data>;

  Reshape_Data();
  ~Reshape_Data() = delete;
};
static_assert(sizeof(Reshape_Data) == 32,
              "Bad sizeof(Reshape_Data)");
// Used by Reshape::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Reshape_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Reshape_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Reshape_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Reshape_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Reshape_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Reverse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> axes;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Reverse_Data>;

  Reverse_Data();
  ~Reverse_Data() = delete;
};
static_assert(sizeof(Reverse_Data) == 40,
              "Bad sizeof(Reverse_Data)");
// Used by Reverse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Reverse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Reverse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Reverse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Reverse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Reverse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) ScatterElements_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> indices_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> updates_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  uint32_t axis;
  uint8_t pad4_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<ScatterElements_Data>;

  ScatterElements_Data();
  ~ScatterElements_Data() = delete;
};
static_assert(sizeof(ScatterElements_Data) == 56,
              "Bad sizeof(ScatterElements_Data)");
// Used by ScatterElements::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ScatterElements_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ScatterElements_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ScatterElements_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ScatterElements_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ScatterElements_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) ScatterND_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> indices_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> updates_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<ScatterND_Data>;

  ScatterND_Data();
  ~ScatterND_Data() = delete;
};
static_assert(sizeof(ScatterND_Data) == 48,
              "Bad sizeof(ScatterND_Data)");
// Used by ScatterND::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ScatterND_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ScatterND_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ScatterND_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ScatterND_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ScatterND_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Sigmoid_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Sigmoid_Data>;

  Sigmoid_Data();
  ~Sigmoid_Data() = delete;
};
static_assert(sizeof(Sigmoid_Data) == 32,
              "Bad sizeof(Sigmoid_Data)");
// Used by Sigmoid::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Sigmoid_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Sigmoid_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Sigmoid_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Sigmoid_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Sigmoid_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Softmax_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  uint32_t axis;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Softmax_Data>;

  Softmax_Data();
  ~Softmax_Data() = delete;
};
static_assert(sizeof(Softmax_Data) == 40,
              "Bad sizeof(Softmax_Data)");
// Used by Softmax::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Softmax_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Softmax_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Softmax_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Softmax_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Softmax_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Softplus_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Softplus_Data>;

  Softplus_Data();
  ~Softplus_Data() = delete;
};
static_assert(sizeof(Softplus_Data) == 32,
              "Bad sizeof(Softplus_Data)");
// Used by Softplus::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Softplus_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Softplus_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Softplus_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Softplus_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Softplus_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Softsign_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Softsign_Data>;

  Softsign_Data();
  ~Softsign_Data() = delete;
};
static_assert(sizeof(Softsign_Data) == 32,
              "Bad sizeof(Softsign_Data)");
// Used by Softsign::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Softsign_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Softsign_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Softsign_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Softsign_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Softsign_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Split_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::OperandId_Data>>> output_operand_ids;
  uint32_t axis;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Split_Data>;

  Split_Data();
  ~Split_Data() = delete;
};
static_assert(sizeof(Split_Data) == 40,
              "Bad sizeof(Split_Data)");
// Used by Split::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Split_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Split_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Split_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Split_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Split_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Tanh_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Tanh_Data>;

  Tanh_Data();
  ~Tanh_Data() = delete;
};
static_assert(sizeof(Tanh_Data) == 32,
              "Bad sizeof(Tanh_Data)");
// Used by Tanh::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Tanh_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Tanh_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Tanh_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Tanh_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Tanh_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Tile_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> repetitions;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Tile_Data>;

  Tile_Data();
  ~Tile_Data() = delete;
};
static_assert(sizeof(Tile_Data) == 40,
              "Bad sizeof(Tile_Data)");
// Used by Tile::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Tile_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Tile_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Tile_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Tile_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Tile_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Transpose_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> permutation;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Transpose_Data>;

  Transpose_Data();
  ~Transpose_Data() = delete;
};
static_assert(sizeof(Transpose_Data) == 40,
              "Bad sizeof(Transpose_Data)");
// Used by Transpose::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Transpose_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Transpose_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Transpose_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Transpose_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Transpose_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Triangular_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  uint8_t upper : 1;
  uint8_t pad2_[3];
  int32_t diagonal;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Triangular_Data>;

  Triangular_Data();
  ~Triangular_Data() = delete;
};
static_assert(sizeof(Triangular_Data) == 40,
              "Bad sizeof(Triangular_Data)");
// Used by Triangular::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Triangular_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Triangular_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Triangular_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Triangular_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Triangular_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Resample2d_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> input_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  int32_t mode;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<float>> scales;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> axes;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Resample2d_Data>;

  Resample2d_Data();
  ~Resample2d_Data() = delete;
};
static_assert(sizeof(Resample2d_Data) == 56,
              "Bad sizeof(Resample2d_Data)");
// Used by Resample2d::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Resample2d_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Resample2d_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Resample2d_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Resample2d_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Resample2d_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) Where_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OperandId_Data> condition_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> true_value_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> false_value_operand_id;
  mojo::internal::Pointer<internal::OperandId_Data> output_operand_id;
  mojo::internal::Pointer<mojo::internal::String_Data> label;

 private:
  friend class mojo::internal::MessageFragment<Where_Data>;

  Where_Data();
  ~Where_Data() = delete;
};
static_assert(sizeof(Where_Data) == 48,
              "Bad sizeof(Where_Data)");
// Used by Where::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Where_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Where_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Where_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Where_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Where_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) GraphInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Operand_Data>>> operands;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::OperandId_Data>>> input_operands;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::OperandId_Data>>> output_operands;
  mojo::internal::Pointer<mojo::internal::Array_Data<internal::Operation_Data>> operations;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<internal::OperandId_Data>, mojo::internal::Pointer<::blink::mojom::internal::WebNNPendingConstantToken_Data>>> constant_operand_ids_to_handles;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<internal::OperandId_Data>, mojo::internal::Pointer<::blink::mojom::internal::WebNNTensorToken_Data>>> id_to_constant_tensor_operand_map;

 private:
  friend class mojo::internal::MessageFragment<GraphInfo_Data>;

  GraphInfo_Data();
  ~GraphInfo_Data() = delete;
};
static_assert(sizeof(GraphInfo_Data) == 56,
              "Bad sizeof(GraphInfo_Data)");
// Used by GraphInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GraphInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GraphInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GraphInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GraphInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GraphInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // webnn::mojom

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_GRAPH_MOJOM_SHARED_INTERNAL_H_