// services/webnn/public/mojom/webnn_context_provider.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_SHARED_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_context_provider.mojom-shared-internal.h"
#include "services/webnn/public/mojom/features.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_context.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_device.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/webnn/public/mojom/webnn_context_provider.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::webnn::mojom::CreateContextOptions_PowerPreference>
    : public mojo::internal::EnumHashImpl<::webnn::mojom::CreateContextOptions_PowerPreference> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::CreateContextOptions_PowerPreference, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::webnn::mojom::CreateContextOptions_PowerPreference, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::webnn::mojom::CreateContextOptions_PowerPreference>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::CreateContextOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::CreateContextOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::CreateContextOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::webnn::mojom::Device>(
      Traits::device(input),
      &fragment->device);

    
    mojo::internal::Serialize<::webnn::mojom::CreateContextOptions_PowerPreference>(
      Traits::power_preference(input),
      &fragment->power_preference);
  }

  static bool Deserialize(::webnn::mojom::internal::CreateContextOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::CreateContextOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::CreateContextSuccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::CreateContextSuccessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::CreateContextSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::context_remote(input)) in_context_remote = Traits::context_remote(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::webnn::mojom::WebNNContextInterfaceBase>>(
      in_context_remote,
      &fragment->context_remote,
      &fragment.message());

    decltype(Traits::context_properties(input)) in_context_properties = Traits::context_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->context_properties)::BaseType> context_properties_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::webnn::mojom::ContextPropertiesDataView>(
      in_context_properties,
      context_properties_fragment);

    fragment->context_properties.Set(
        context_properties_fragment.is_null() ? nullptr : context_properties_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->context_properties.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null context_properties in CreateContextSuccess struct");

    decltype(Traits::context_handle(input)) in_context_handle = Traits::context_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->context_handle)::BaseType> context_handle_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WebNNContextTokenDataView>(
      in_context_handle,
      context_handle_fragment);

    fragment->context_handle.Set(
        context_handle_fragment.is_null() ? nullptr : context_handle_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->context_handle.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null context_handle in CreateContextSuccess struct");

    decltype(Traits::write_tensor_producer(input)) in_write_tensor_producer = Traits::write_tensor_producer(input);

    
    mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_write_tensor_producer,
      &fragment->write_tensor_producer,
      &fragment.message());

    decltype(Traits::read_tensor_consumer(input)) in_read_tensor_consumer = Traits::read_tensor_consumer(input);

    
    mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_read_tensor_consumer,
      &fragment->read_tensor_consumer,
      &fragment.message());
  }

  static bool Deserialize(::webnn::mojom::internal::CreateContextSuccess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::CreateContextSuccessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::CreateContextResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::CreateContextResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::CreateContextResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::CreateContextResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::CreateContextSuccessDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in CreateContextResult union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::CreateContextResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ErrorDataView>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in CreateContextResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::webnn::mojom::internal::CreateContextResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::CreateContextResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace webnn::mojom {



inline void CreateContextSuccessDataView::GetContextPropertiesDataView(
    ::webnn::mojom::ContextPropertiesDataView* output) {
  auto pointer = data_->context_properties.Get();
  *output = ::webnn::mojom::ContextPropertiesDataView(pointer, message_);
}
inline void CreateContextSuccessDataView::GetContextHandleDataView(
    ::blink::mojom::WebNNContextTokenDataView* output) {
  auto pointer = data_->context_handle.Get();
  *output = ::blink::mojom::WebNNContextTokenDataView(pointer, message_);
}


inline void CreateContextResultDataView::GetSuccessDataView(
    CreateContextSuccessDataView* output) const {
  CHECK(is_success());
  *output = CreateContextSuccessDataView(data_->data.f_success.Get(), message_);
}
inline void CreateContextResultDataView::GetErrorDataView(
    ::webnn::mojom::ErrorDataView* output) const {
  CHECK(is_error());
  *output = ::webnn::mojom::ErrorDataView(data_->data.f_error.Get(), message_);
}


}  // webnn::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) TraceFormatTraits<::webnn::mojom::CreateContextOptions_PowerPreference> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::webnn::mojom::CreateContextOptions_PowerPreference value);
};

} // namespace perfetto

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_SHARED_H_