// services/viz/public/mojom/compositing/view_transition_request.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/view_transition_request.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var compositor_frame_transition_directive$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom', 'compositor_frame_transition_directive.mojom.js');
  }
  var view_transition_element_resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom', 'view_transition_element_resource_id.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../../../../../third_party/blink/public/mojom/tokens/tokens.mojom.js');
  }



  function ViewTransitionRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ViewTransitionRequest.prototype.initDefaults_ = function() {
    this.type = 0;
    this.maybeCrossFrameSink = false;
    this.transitionToken = null;
    this.sequenceId = 0;
    this.captureResourceIds = null;
  };
  ViewTransitionRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ViewTransitionRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionRequest.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, compositor_frame_transition_directive$.CompositorFrameTransitionDirectiveType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionRequest.transitionToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, tokens$.ViewTransitionToken, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ViewTransitionRequest.captureResourceIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(view_transition_element_resource_id$.ViewTransitionElementResourceId), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ViewTransitionRequest.encodedSize = codec.kStructHeaderSize + 32;

  ViewTransitionRequest.decode = function(decoder) {
    var packed;
    var val = new ViewTransitionRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(compositor_frame_transition_directive$.CompositorFrameTransitionDirectiveType));
    packed = decoder.readUint8();
    val.maybeCrossFrameSink = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.transitionToken =
        decoder.decodeStructPointer(tokens$.ViewTransitionToken);
    val.sequenceId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.captureResourceIds =
        decoder.decodeArrayPointer(new codec.PointerTo(view_transition_element_resource_id$.ViewTransitionElementResourceId));
    return val;
  };

  ViewTransitionRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ViewTransitionRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    packed = 0;
    packed |= (val.maybeCrossFrameSink & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(tokens$.ViewTransitionToken, val.transitionToken);
    encoder.encodeStruct(codec.Uint32, val.sequenceId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(view_transition_element_resource_id$.ViewTransitionElementResourceId), val.captureResourceIds);
  };
  exports.ViewTransitionRequest = ViewTransitionRequest;
})();