// services/viz/public/mojom/compositing/transferable_resource.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/transferable_resource.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var mailbox$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/mailbox.mojom', '../../../../../gpu/ipc/common/mailbox.mojom.js');
  }
  var sync_token$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/sync_token.mojom', '../../../../../gpu/ipc/common/sync_token.mojom.js');
  }
  var vulkan_ycbcr_info$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/vulkan_ycbcr_info.mojom', '../../../../../gpu/ipc/common/vulkan_ycbcr_info.mojom.js');
  }
  var shared_image_format$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/shared_image_format.mojom', 'shared_image_format.mojom.js');
  }
  var resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/resource_id.mojom', 'resource_id.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var color_space$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/color_space.mojom', '../../../../../ui/gfx/mojom/color_space.mojom.js');
  }
  var hdr_metadata$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/hdr_metadata.mojom', '../../../../../ui/gfx/mojom/hdr_metadata.mojom.js');
  }
  var image_info$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/image_info.mojom', '../../../../../skia/public/mojom/image_info.mojom.js');
  }
  var surface_origin$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/surface_origin.mojom', '../../../../../skia/public/mojom/surface_origin.mojom.js');
  }


  var SynchronizationType = {};
  SynchronizationType.kSyncToken = 0;
  SynchronizationType.kGpuCommandsCompleted = 1;
  SynchronizationType.kReleaseFence = 2;
  SynchronizationType.MIN_VALUE = 0;
  SynchronizationType.MAX_VALUE = 2;

  SynchronizationType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SynchronizationType.toKnownEnumValue = function(value) {
    return value;
  };

  SynchronizationType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ResourceSource = {};
  ResourceSource.kUnknown = 0;
  ResourceSource.kAR = 1;
  ResourceSource.kCanvas = 2;
  ResourceSource.kDrawingBuffer = 3;
  ResourceSource.kExoBuffer = 4;
  ResourceSource.kHeadsUpDisplay = 5;
  ResourceSource.kImageLayerBridge = 6;
  ResourceSource.kPPBGraphics3D = 7;
  ResourceSource.kPepperGraphics2D = 8;
  ResourceSource.kViewTransition = 9;
  ResourceSource.kStaleContent = 10;
  ResourceSource.kTest = 11;
  ResourceSource.kTileRasterTask = 12;
  ResourceSource.kUI = 13;
  ResourceSource.kVideo = 14;
  ResourceSource.kWebGPUSwapBuffer = 15;
  ResourceSource.MIN_VALUE = 0;
  ResourceSource.MAX_VALUE = 15;

  ResourceSource.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
      return true;
    }
    return false;
  };

  ResourceSource.toKnownEnumValue = function(value) {
    return value;
  };

  ResourceSource.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function TransferableResource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TransferableResource.prototype.initDefaults_ = function() {
    this.id = null;
    this.format = null;
    this.size = null;
    this.memoryBufferId = null;
    this.syncToken = null;
    this.textureTarget = 0;
    this.synchronizationType = 0;
    this.isSoftware = false;
    this.isOverlayCandidate = false;
    this.isLowLatencyRendering = false;
    this.needsDetiling = false;
    this.origin = 0;
    this.colorSpace = null;
    this.hdrMetadata = null;
    this.alphaType = 0;
    this.resourceSource = 0;
  };
  TransferableResource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TransferableResource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 96}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableResource.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, resource_id$.ResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableResource.format
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, shared_image_format$.SharedImageFormat, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableResource.size
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableResource.memoryBufferId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, mailbox$.Mailbox, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableResource.syncToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, sync_token$.SyncToken, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate TransferableResource.synchronizationType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 52, SynchronizationType);
    if (err !== validator.validationError.NONE)
        return err;





    // validate TransferableResource.colorSpace
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, color_space$.ColorSpace, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableResource.hdrMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, hdr_metadata$.HDRMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate TransferableResource.origin
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 60, surface_origin$.SurfaceOrigin);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableResource.alphaType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 80, image_info$.AlphaType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableResource.resourceSource
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 84, ResourceSource);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TransferableResource.encodedSize = codec.kStructHeaderSize + 88;

  TransferableResource.decode = function(decoder) {
    var packed;
    var val = new TransferableResource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStructPointer(resource_id$.ResourceId);
    val.format =
        decoder.decodeStruct(shared_image_format$.SharedImageFormat);
    val.size =
        decoder.decodeStructPointer(geometry$.Size);
    val.memoryBufferId =
        decoder.decodeStructPointer(mailbox$.Mailbox);
    val.syncToken =
        decoder.decodeStructPointer(sync_token$.SyncToken);
    val.textureTarget =
        decoder.decodeStruct(codec.Uint32);
    val.synchronizationType =
        decoder.decodeStruct(new codec.Enum(SynchronizationType));
    packed = decoder.readUint8();
    val.isSoftware = (packed >> 0) & 1 ? true : false;
    val.isOverlayCandidate = (packed >> 1) & 1 ? true : false;
    val.isLowLatencyRendering = (packed >> 2) & 1 ? true : false;
    val.needsDetiling = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.origin =
        decoder.decodeStruct(new codec.Enum(surface_origin$.SurfaceOrigin));
    val.colorSpace =
        decoder.decodeStructPointer(color_space$.ColorSpace);
    val.hdrMetadata =
        decoder.decodeStructPointer(hdr_metadata$.HDRMetadata);
    val.alphaType =
        decoder.decodeStruct(new codec.Enum(image_info$.AlphaType));
    val.resourceSource =
        decoder.decodeStruct(new codec.Enum(ResourceSource));
    return val;
  };

  TransferableResource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TransferableResource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(resource_id$.ResourceId, val.id);
    encoder.encodeStruct(shared_image_format$.SharedImageFormat, val.format);
    encoder.encodeStructPointer(geometry$.Size, val.size);
    encoder.encodeStructPointer(mailbox$.Mailbox, val.memoryBufferId);
    encoder.encodeStructPointer(sync_token$.SyncToken, val.syncToken);
    encoder.encodeStruct(codec.Uint32, val.textureTarget);
    encoder.encodeStruct(codec.Int32, val.synchronizationType);
    packed = 0;
    packed |= (val.isSoftware & 1) << 0
    packed |= (val.isOverlayCandidate & 1) << 1
    packed |= (val.isLowLatencyRendering & 1) << 2
    packed |= (val.needsDetiling & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.origin);
    encoder.encodeStructPointer(color_space$.ColorSpace, val.colorSpace);
    encoder.encodeStructPointer(hdr_metadata$.HDRMetadata, val.hdrMetadata);
    encoder.encodeStruct(codec.Int32, val.alphaType);
    encoder.encodeStruct(codec.Int32, val.resourceSource);
  };
  exports.SynchronizationType = SynchronizationType;
  exports.ResourceSource = ResourceSource;
  exports.TransferableResource = TransferableResource;
})();