// services/viz/public/mojom/compositing/tiling.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  MissingTileReason as cc_mojom_MissingTileReason,
  MissingTileReasonSpec as cc_mojom_MissingTileReasonSpec
} from '../../../../../cc/mojom/missing_tile_reason.mojom.m.js';

import {
  SkColor4f as skia_mojom_SkColor4f,
  SkColor4fSpec as skia_mojom_SkColor4fSpec
} from '../../../../../skia/public/mojom/skcolor4f.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec,
  Vector2dF as gfx_mojom_Vector2dF,
  Vector2dFSpec as gfx_mojom_Vector2dFSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  TransferableResource as viz_mojom_TransferableResource,
  TransferableResourceSpec as viz_mojom_TransferableResourceSpec
} from './transferable_resource.mojom.m.js';



/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TileResourceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TilingSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const TileContentsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TileResourceSpec.$,
    'TileResource',
    [
      mojo.internal.StructField(
        'resource', 0,
        0,
        viz_mojom_TransferableResourceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isCheckered', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TileResource {
  constructor() {
    /** @type { !viz_mojom_TransferableResource } */
    this.resource;
    /** @type { !boolean } */
    this.isCheckered;
  }
}



mojo.internal.Struct(
    TileSpec.$,
    'Tile',
    [
      mojo.internal.StructField(
        'columnIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rowIndex', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contents', 8,
        0,
        TileContentsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Tile {
  constructor() {
    /** @type { !number } */
    this.columnIndex;
    /** @type { !number } */
    this.rowIndex;
    /** @type { !TileContents } */
    this.contents;
  }
}



mojo.internal.Struct(
    TilingSpec.$,
    'Tiling',
    [
      mojo.internal.StructField(
        'layerId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rasterTranslation', 8,
        0,
        gfx_mojom_Vector2dFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rasterScale', 16,
        0,
        gfx_mojom_Vector2dFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tileSize', 24,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tilingRect', 32,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tiles', 40,
        0,
        mojo.internal.Array(TileSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scaleKey', 48,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isDeleted', 52,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class Tiling {
  constructor() {
    /** @type { !bigint } */
    this.layerId;
    /** @type { !gfx_mojom_Vector2dF } */
    this.rasterTranslation;
    /** @type { !gfx_mojom_Vector2dF } */
    this.rasterScale;
    /** @type { !gfx_mojom_Size } */
    this.tileSize;
    /** @type { !gfx_mojom_Rect } */
    this.tilingRect;
    /** @type { !Array<!Tile> } */
    this.tiles;
    /** @type { !number } */
    this.scaleKey;
    /** @type { !boolean } */
    this.isDeleted;
  }
}

mojo.internal.Union(
    TileContentsSpec.$, 'TileContents',
    {
      'missingReason': {
        'ordinal': 0,
        'type': cc_mojom_MissingTileReasonSpec.$,
      },
      'resource': {
        'ordinal': 1,
        'type': TileResourceSpec.$,
      },
      'solidColor': {
        'ordinal': 2,
        'type': skia_mojom_SkColor4fSpec.$,
      },
    });

/**
 * @typedef { {
 *   missingReason: (!cc_mojom_MissingTileReason|undefined),
 *   resource: (!TileResource|undefined),
 *   solidColor: (!skia_mojom_SkColor4f|undefined),
 * } }
 */
export const TileContents = {};
