// services/viz/public/mojom/compositing/shared_quad_state.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/rrect_f.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "ui/gfx/mojom/mask_filter_info.mojom-shared.h"


namespace viz::mojom {
class SharedQuadStateDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::SharedQuadStateDataView> {
  using Data = ::viz::mojom::internal::SharedQuadState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class SharedQuadStateDataView {
 public:
  SharedQuadStateDataView() = default;

  SharedQuadStateDataView(
      internal::SharedQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetQuadToTargetTransformDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuadToTargetTransform(UserType* output) {
    
    auto* pointer = data_->quad_to_target_transform.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetQuadLayerRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuadLayerRect(UserType* output) {
    
    auto* pointer = data_->quad_layer_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleQuadLayerRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleQuadLayerRect(UserType* output) {
    
    auto* pointer = data_->visible_quad_layer_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetMaskFilterInfoDataView(
      ::gfx::mojom::MaskFilterInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaskFilterInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::MaskFilterInfoDataView, UserType>(),
    "Attempting to read the optional `mask_filter_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMaskFilterInfo` instead "
    "of `ReadMaskFilterInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mask_filter_info.Get();
    return mojo::internal::Deserialize<::gfx::mojom::MaskFilterInfoDataView>(
        pointer, output, message_);
  }
  inline void GetClipRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClipRect(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `clip_rect` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClipRect` instead "
    "of `ReadClipRect if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->clip_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  bool are_contents_opaque() const {
    return data_->are_contents_opaque;
  }
  float opacity() const {
    return data_->opacity;
  }
  uint32_t blend_mode() const {
    return data_->blend_mode;
  }
  int32_t sorting_context_id() const {
    return data_->sorting_context_id;
  }
  uint32_t layer_id() const {
    return data_->layer_id;
  }
  bool is_fast_rounded_corner() const {
    return data_->is_fast_rounded_corner;
  }
  inline void GetOffsetTagDataView(
      ::viz::mojom::OffsetTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffsetTag(UserType* output) {
    
    auto* pointer = data_->offset_tag.Get();
    return mojo::internal::Deserialize<::viz::mojom::OffsetTagDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_DATA_VIEW_H_