// services/viz/public/mojom/compositing/shared_image_format.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/internal/singleplanar_format.mojom-shared.h"


namespace viz::mojom {
class MultiplanarFormatDataView;

class SharedImageFormatDataView;


}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::MultiplanarFormatDataView> {
  using Data = ::viz::mojom::internal::MultiplanarFormat_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::SharedImageFormatDataView> {
  using Data = ::viz::mojom::internal::SharedImageFormat_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class PlaneConfig : int32_t {
  
  kY_U_V = 0,
  
  kY_V_U = 1,
  
  kY_UV = 2,
  
  kY_UV_A = 3,
  
  kY_U_V_A = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, PlaneConfig value);
inline bool IsKnownEnumValue(PlaneConfig value) {
  return internal::PlaneConfig_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Subsampling : int32_t {
  
  k420 = 0,
  
  k422 = 1,
  
  k444 = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, Subsampling value);
inline bool IsKnownEnumValue(Subsampling value) {
  return internal::Subsampling_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ChannelFormat : int32_t {
  
  k8 = 0,
  
  k10 = 1,
  
  k16 = 2,
  
  k16F = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ChannelFormat value);
inline bool IsKnownEnumValue(ChannelFormat value) {
  return internal::ChannelFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class MultiplanarFormatDataView {
 public:
  MultiplanarFormatDataView() = default;

  MultiplanarFormatDataView(
      internal::MultiplanarFormat_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPlaneConfig(UserType* output) const {
    auto data_value = data_->plane_config;
    return mojo::internal::Deserialize<::viz::mojom::PlaneConfig>(
        data_value, output);
  }
  PlaneConfig plane_config() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::PlaneConfig>(data_->plane_config));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSubsampling(UserType* output) const {
    auto data_value = data_->subsampling;
    return mojo::internal::Deserialize<::viz::mojom::Subsampling>(
        data_value, output);
  }
  Subsampling subsampling() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::Subsampling>(data_->subsampling));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadChannelFormat(UserType* output) const {
    auto data_value = data_->channel_format;
    return mojo::internal::Deserialize<::viz::mojom::ChannelFormat>(
        data_value, output);
  }
  ChannelFormat channel_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::ChannelFormat>(data_->channel_format));
  }
 private:
  internal::MultiplanarFormat_Data* data_ = nullptr;
};


class SharedImageFormatDataView {
 public:
  using Tag = internal::SharedImageFormat_Data::SharedImageFormat_Tag;

  SharedImageFormatDataView() = default;

  SharedImageFormatDataView(
      internal::SharedImageFormat_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_singleplanar_format() const { return data_->tag == Tag::kSingleplanarFormat; }
  template <typename UserType>
  [[nodiscard]] bool ReadSingleplanarFormat(UserType* output) const {
    CHECK(is_singleplanar_format());
    return mojo::internal::Deserialize<::viz::mojom::SingleplanarFormat>(
        data_->data.f_singleplanar_format, output);
  }
  ::viz::mojom::SingleplanarFormat singleplanar_format() const {
    CHECK(is_singleplanar_format());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::SingleplanarFormat>(data_->data.f_singleplanar_format));
  }
  bool is_multiplanar_format() const { return data_->tag == Tag::kMultiplanarFormat; }
  inline void GetMultiplanarFormatDataView(
      MultiplanarFormatDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadMultiplanarFormat(UserType* output) const {
    
    CHECK(is_multiplanar_format());
    return mojo::internal::Deserialize<::viz::mojom::MultiplanarFormatDataView>(
        data_->data.f_multiplanar_format.Get(), output, message_);
  }

 private:
  internal::SharedImageFormat_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_DATA_VIEW_H_