// services/viz/public/mojom/compositing/shared_image_format.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/shared_image_format.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/internal/singleplanar_format.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {





class  MultiplanarFormat {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MultiplanarFormat, T>::value>;
  using DataView = MultiplanarFormatDataView;
  using Data_ = internal::MultiplanarFormat_Data;

  template <typename... Args>
  static MultiplanarFormatPtr New(Args&&... args) {
    return MultiplanarFormatPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MultiplanarFormatPtr From(const U& u) {
    return mojo::TypeConverter<MultiplanarFormatPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MultiplanarFormat>::Convert(*this);
  }


  MultiplanarFormat();

  MultiplanarFormat(
      PlaneConfig plane_config,
      Subsampling subsampling,
      ChannelFormat channel_format);


  ~MultiplanarFormat();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MultiplanarFormatPtr>
  MultiplanarFormatPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MultiplanarFormat::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MultiplanarFormat::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MultiplanarFormat::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MultiplanarFormat::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MultiplanarFormat::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MultiplanarFormat::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MultiplanarFormat_UnserializedMessageContext<
            UserType, MultiplanarFormat::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MultiplanarFormat::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MultiplanarFormat::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MultiplanarFormat_UnserializedMessageContext<
            UserType, MultiplanarFormat::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MultiplanarFormat::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PlaneConfig plane_config;
  
  Subsampling subsampling;
  
  ChannelFormat channel_format;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MultiplanarFormat::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MultiplanarFormat::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MultiplanarFormat::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MultiplanarFormat::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SharedImageFormat {
 public:
  using DataView = SharedImageFormatDataView;
  using Data_ = internal::SharedImageFormat_Data;
  using Tag = Data_::SharedImageFormat_Tag;

  template <typename... Args>
  static SharedImageFormatPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |singleplanar_format|.
  static SharedImageFormatPtr NewSingleplanarFormat(
      ::viz::mojom::blink::SingleplanarFormat value);
  // Construct an instance holding |multiplanar_format|.
  static SharedImageFormatPtr NewMultiplanarFormat(
      MultiplanarFormatPtr value);

  template <typename U>
  static SharedImageFormatPtr From(const U& u) {
    return mojo::TypeConverter<SharedImageFormatPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedImageFormat>::Convert(*this);
  }
  ~SharedImageFormat();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SharedImageFormat(const SharedImageFormat& other) = delete;
  SharedImageFormat& operator=(const SharedImageFormat& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SharedImageFormatPtr>
  SharedImageFormatPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SharedImageFormat>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SharedImageFormat>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_singleplanar_format() const { return tag_ == Tag::kSingleplanarFormat; }
  ::viz::mojom::blink::SingleplanarFormat get_singleplanar_format() const {
    CHECK(tag_ == Tag::kSingleplanarFormat);
    return data_.singleplanar_format;
  }
  void set_singleplanar_format(::viz::mojom::blink::SingleplanarFormat singleplanar_format);

  bool is_multiplanar_format() const { return tag_ == Tag::kMultiplanarFormat; }
  const MultiplanarFormatPtr& get_multiplanar_format() const {
    CHECK(tag_ == Tag::kMultiplanarFormat);
    return data_.multiplanar_format;
  }
  MultiplanarFormatPtr& get_multiplanar_format() {
    CHECK(tag_ == Tag::kMultiplanarFormat);
    return data_.multiplanar_format;
  }
  void set_multiplanar_format(MultiplanarFormatPtr multiplanar_format);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedImageFormat::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SharedImageFormat::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSingleplanarFormat)>,
        ::viz::mojom::blink::SingleplanarFormat value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMultiplanarFormat)>,
        MultiplanarFormatPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::viz::mojom::blink::SingleplanarFormat singleplanar_format;
    MultiplanarFormatPtr multiplanar_format;
  };

  SharedImageFormat(
      std::in_place_index_t<static_cast<size_t>(Tag::kSingleplanarFormat)>,
      ::viz::mojom::blink::SingleplanarFormat value);
  SharedImageFormat(
      std::in_place_index_t<static_cast<size_t>(Tag::kMultiplanarFormat)>,
      MultiplanarFormatPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};


template <typename UnionPtrType>
SharedImageFormatPtr SharedImageFormat::Clone() const {
  switch (tag_) {
    case Tag::kSingleplanarFormat:
      return NewSingleplanarFormat(
          mojo::Clone(data_.singleplanar_format));
    case Tag::kMultiplanarFormat:
      return NewMultiplanarFormat(
          mojo::Clone(data_.multiplanar_format));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SharedImageFormat>::value>::type*>
bool SharedImageFormat::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSingleplanarFormat:
      return mojo::Equals(data_.singleplanar_format, other.data_.singleplanar_format);
    case Tag::kMultiplanarFormat:
      return mojo::Equals(data_.multiplanar_format, other.data_.multiplanar_format);
  }

  return false;
}
template <typename StructPtrType>
MultiplanarFormatPtr MultiplanarFormat::Clone() const {
  return New(
      mojo::Clone(plane_config),
      mojo::Clone(subsampling),
      mojo::Clone(channel_format)
  );
}

template <typename T, MultiplanarFormat::EnableIfSame<T>*>
bool MultiplanarFormat::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->plane_config, other_struct.plane_config))
    return false;
  if (!mojo::Equals(this->subsampling, other_struct.subsampling))
    return false;
  if (!mojo::Equals(this->channel_format, other_struct.channel_format))
    return false;
  return true;
}

template <typename T, MultiplanarFormat::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.plane_config < rhs.plane_config)
    return true;
  if (rhs.plane_config < lhs.plane_config)
    return false;
  if (lhs.subsampling < rhs.subsampling)
    return true;
  if (rhs.subsampling < lhs.subsampling)
    return false;
  if (lhs.channel_format < rhs.channel_format)
    return true;
  if (rhs.channel_format < lhs.channel_format)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::blink::MultiplanarFormat::DataView,
                                         ::viz::mojom::blink::MultiplanarFormatPtr> {
  static bool IsNull(const ::viz::mojom::blink::MultiplanarFormatPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::MultiplanarFormatPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::MultiplanarFormat::plane_config) plane_config(
      const ::viz::mojom::blink::MultiplanarFormatPtr& input) {
    return input->plane_config;
  }

  static decltype(::viz::mojom::blink::MultiplanarFormat::subsampling) subsampling(
      const ::viz::mojom::blink::MultiplanarFormatPtr& input) {
    return input->subsampling;
  }

  static decltype(::viz::mojom::blink::MultiplanarFormat::channel_format) channel_format(
      const ::viz::mojom::blink::MultiplanarFormatPtr& input) {
    return input->channel_format;
  }

  static bool Read(::viz::mojom::blink::MultiplanarFormat::DataView input, ::viz::mojom::blink::MultiplanarFormatPtr* output);
};


template <>
struct  UnionTraits<::viz::mojom::blink::SharedImageFormat::DataView,
                                        ::viz::mojom::blink::SharedImageFormatPtr> {
  static bool IsNull(const ::viz::mojom::blink::SharedImageFormatPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::SharedImageFormatPtr* output) { output->reset(); }

  static ::viz::mojom::blink::SharedImageFormat::Tag GetTag(const ::viz::mojom::blink::SharedImageFormatPtr& input) {
    return input->which();
  }

  static  ::viz::mojom::blink::SingleplanarFormat singleplanar_format(const ::viz::mojom::blink::SharedImageFormatPtr& input) {
    return input->get_singleplanar_format();
  }

  static const ::viz::mojom::blink::MultiplanarFormatPtr& multiplanar_format(const ::viz::mojom::blink::SharedImageFormatPtr& input) {
    return input->get_multiplanar_format();
  }

  static bool Read(::viz::mojom::blink::SharedImageFormat::DataView input, ::viz::mojom::blink::SharedImageFormatPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_BLINK_H_