// services/viz/public/mojom/compositing/layer_context.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/layer_context.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/layer_context.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/layer_context.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/layer_context.mojom-blink-import-headers.h"
#include "services/viz/public/mojom/compositing/layer_context.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"


namespace viz::mojom::blink {
TransferableUIResourceRequest::TransferableUIResourceRequest()
    : type(),
      uid(),
      transferable_resource(),
      opaque() {}

TransferableUIResourceRequest::TransferableUIResourceRequest(
    TransferableUIResourceRequest::Type type_in,
    ::cc::mojom::blink::UIResourceIdPtr uid_in,
    ::viz::mojom::blink::TransferableResourcePtr transferable_resource_in,
    bool opaque_in)
    : type(std::move(type_in)),
      uid(std::move(uid_in)),
      transferable_resource(std::move(transferable_resource_in)),
      opaque(std::move(opaque_in)) {}

TransferableUIResourceRequest::~TransferableUIResourceRequest() = default;

void TransferableUIResourceRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TransferableUIResourceRequest::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uid"), this->uid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::mojom::blink::UIResourceIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transferable_resource"), this->transferable_resource,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::TransferableResourcePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opaque"), this->opaque,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TransferableUIResourceRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LayerTreeUpdate::LayerTreeUpdate()
    : begin_frame_args(),
      source_frame_number(),
      trace_id(),
      primary_main_frame_item_sequence_number(),
      selection(),
      page_scale_factor(),
      min_page_scale_factor(),
      max_page_scale_factor(),
      external_page_scale_factor(),
      device_viewport(),
      device_scale_factor(),
      painted_device_scale_factor(),
      display_color_spaces(),
      local_surface_id_from_parent(),
      current_local_surface_id(),
      next_frame_token(),
      send_frame_token_to_embedder(),
      target_local_surface_id(),
      background_color(),
      overscroll_elasticity_transform(),
      page_scale_transform(),
      inner_scroll(),
      outer_clip(),
      outer_scroll(),
      viewport_damage_rect(),
      full_tree_damaged(),
      debug_state(),
      display_transform_hint(),
      max_safe_area_inset_bottom(),
      browser_controls_params(),
      browser_controls_offset_tag_modifications(),
      top_controls_shown_ratio(),
      bottom_controls_shown_ratio(),
      ui_resource_requests(),
      layers(),
      layer_order(),
      transform_tree_update(),
      scroll_tree_update(),
      transform_nodes(),
      clip_nodes(),
      effect_nodes(),
      scroll_nodes(),
      num_transform_nodes(),
      num_clip_nodes(),
      num_effect_nodes(),
      num_scroll_nodes(),
      tilings(),
      surface_ranges(),
      view_transition_requests(),
      animation_timelines(),
      removed_animation_timelines() {}

LayerTreeUpdate::LayerTreeUpdate(
    const ::viz::BeginFrameArgs& begin_frame_args_in,
    int32_t source_frame_number_in,
    uint64_t trace_id_in,
    int64_t primary_main_frame_item_sequence_number_in,
    ::cc::mojom::blink::LayerSelectionPtr selection_in,
    float page_scale_factor_in,
    float min_page_scale_factor_in,
    float max_page_scale_factor_in,
    float external_page_scale_factor_in,
    const ::gfx::Rect& device_viewport_in,
    float device_scale_factor_in,
    float painted_device_scale_factor_in,
    const ::gfx::DisplayColorSpaces& display_color_spaces_in,
    const std::optional<::viz::LocalSurfaceId>& local_surface_id_from_parent_in,
    const ::viz::LocalSurfaceId& current_local_surface_id_in,
    uint32_t next_frame_token_in,
    bool send_frame_token_to_embedder_in,
    const std::optional<::viz::LocalSurfaceId>& target_local_surface_id_in,
    const ::SkColor4f& background_color_in,
    int32_t overscroll_elasticity_transform_in,
    int32_t page_scale_transform_in,
    int32_t inner_scroll_in,
    int32_t outer_clip_in,
    int32_t outer_scroll_in,
    const ::gfx::Rect& viewport_damage_rect_in,
    bool full_tree_damaged_in,
    ::cc::mojom::blink::LayerTreeDebugStatePtr debug_state_in,
    ::gfx::mojom::blink::OverlayTransform display_transform_hint_in,
    float max_safe_area_inset_bottom_in,
    const ::cc::BrowserControlsParams& browser_controls_params_in,
    const ::cc::BrowserControlsOffsetTagModifications& browser_controls_offset_tag_modifications_in,
    float top_controls_shown_ratio_in,
    float bottom_controls_shown_ratio_in,
    ::blink::Vector<TransferableUIResourceRequestPtr> ui_resource_requests_in,
    ::blink::Vector<::viz::mojom::blink::LayerPtr> layers_in,
    std::optional<::blink::Vector<int32_t>> layer_order_in,
    ::viz::mojom::blink::TransformTreeUpdatePtr transform_tree_update_in,
    ::viz::mojom::blink::ScrollTreeUpdatePtr scroll_tree_update_in,
    ::blink::Vector<::viz::mojom::blink::TransformNodePtr> transform_nodes_in,
    ::blink::Vector<::viz::mojom::blink::ClipNodePtr> clip_nodes_in,
    ::blink::Vector<::viz::mojom::blink::EffectNodePtr> effect_nodes_in,
    ::blink::Vector<::viz::mojom::blink::ScrollNodePtr> scroll_nodes_in,
    uint32_t num_transform_nodes_in,
    uint32_t num_clip_nodes_in,
    uint32_t num_effect_nodes_in,
    uint32_t num_scroll_nodes_in,
    ::blink::Vector<::viz::mojom::blink::TilingPtr> tilings_in,
    std::optional<::blink::Vector<::viz::SurfaceRange>> surface_ranges_in,
    std::optional<::blink::Vector<::viz::mojom::blink::ViewTransitionRequestPtr>> view_transition_requests_in,
    std::optional<::blink::Vector<::viz::mojom::blink::AnimationTimelinePtr>> animation_timelines_in,
    std::optional<::blink::Vector<int32_t>> removed_animation_timelines_in)
    : begin_frame_args(std::move(begin_frame_args_in)),
      source_frame_number(std::move(source_frame_number_in)),
      trace_id(std::move(trace_id_in)),
      primary_main_frame_item_sequence_number(std::move(primary_main_frame_item_sequence_number_in)),
      selection(std::move(selection_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      min_page_scale_factor(std::move(min_page_scale_factor_in)),
      max_page_scale_factor(std::move(max_page_scale_factor_in)),
      external_page_scale_factor(std::move(external_page_scale_factor_in)),
      device_viewport(std::move(device_viewport_in)),
      device_scale_factor(std::move(device_scale_factor_in)),
      painted_device_scale_factor(std::move(painted_device_scale_factor_in)),
      display_color_spaces(std::move(display_color_spaces_in)),
      local_surface_id_from_parent(std::move(local_surface_id_from_parent_in)),
      current_local_surface_id(std::move(current_local_surface_id_in)),
      next_frame_token(std::move(next_frame_token_in)),
      send_frame_token_to_embedder(std::move(send_frame_token_to_embedder_in)),
      target_local_surface_id(std::move(target_local_surface_id_in)),
      background_color(std::move(background_color_in)),
      overscroll_elasticity_transform(std::move(overscroll_elasticity_transform_in)),
      page_scale_transform(std::move(page_scale_transform_in)),
      inner_scroll(std::move(inner_scroll_in)),
      outer_clip(std::move(outer_clip_in)),
      outer_scroll(std::move(outer_scroll_in)),
      viewport_damage_rect(std::move(viewport_damage_rect_in)),
      full_tree_damaged(std::move(full_tree_damaged_in)),
      debug_state(std::move(debug_state_in)),
      display_transform_hint(std::move(display_transform_hint_in)),
      max_safe_area_inset_bottom(std::move(max_safe_area_inset_bottom_in)),
      browser_controls_params(std::move(browser_controls_params_in)),
      browser_controls_offset_tag_modifications(std::move(browser_controls_offset_tag_modifications_in)),
      top_controls_shown_ratio(std::move(top_controls_shown_ratio_in)),
      bottom_controls_shown_ratio(std::move(bottom_controls_shown_ratio_in)),
      ui_resource_requests(std::move(ui_resource_requests_in)),
      layers(std::move(layers_in)),
      layer_order(std::move(layer_order_in)),
      transform_tree_update(std::move(transform_tree_update_in)),
      scroll_tree_update(std::move(scroll_tree_update_in)),
      transform_nodes(std::move(transform_nodes_in)),
      clip_nodes(std::move(clip_nodes_in)),
      effect_nodes(std::move(effect_nodes_in)),
      scroll_nodes(std::move(scroll_nodes_in)),
      num_transform_nodes(std::move(num_transform_nodes_in)),
      num_clip_nodes(std::move(num_clip_nodes_in)),
      num_effect_nodes(std::move(num_effect_nodes_in)),
      num_scroll_nodes(std::move(num_scroll_nodes_in)),
      tilings(std::move(tilings_in)),
      surface_ranges(std::move(surface_ranges_in)),
      view_transition_requests(std::move(view_transition_requests_in)),
      animation_timelines(std::move(animation_timelines_in)),
      removed_animation_timelines(std::move(removed_animation_timelines_in)) {}

LayerTreeUpdate::~LayerTreeUpdate() = default;

void LayerTreeUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "begin_frame_args"), this->begin_frame_args,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::BeginFrameArgs&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_frame_number"), this->source_frame_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trace_id"), this->trace_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_main_frame_item_sequence_number"), this->primary_main_frame_item_sequence_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection"), this->selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::mojom::blink::LayerSelectionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_page_scale_factor"), this->min_page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_page_scale_factor"), this->max_page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "external_page_scale_factor"), this->external_page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_viewport"), this->device_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "painted_device_scale_factor"), this->painted_device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_color_spaces"), this->display_color_spaces,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::DisplayColorSpaces&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_surface_id_from_parent"), this->local_surface_id_from_parent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::viz::LocalSurfaceId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_local_surface_id"), this->current_local_surface_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::LocalSurfaceId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "next_frame_token"), this->next_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_frame_token_to_embedder"), this->send_frame_token_to_embedder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_local_surface_id"), this->target_local_surface_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::viz::LocalSurfaceId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overscroll_elasticity_transform"), this->overscroll_elasticity_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_transform"), this->page_scale_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inner_scroll"), this->inner_scroll,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outer_clip"), this->outer_clip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "outer_scroll"), this->outer_scroll,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport_damage_rect"), this->viewport_damage_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "full_tree_damaged"), this->full_tree_damaged,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_state"), this->debug_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::mojom::blink::LayerTreeDebugStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_transform_hint"), this->display_transform_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::mojom::blink::OverlayTransform>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_safe_area_inset_bottom"), this->max_safe_area_inset_bottom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_controls_params"), this->browser_controls_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::cc::BrowserControlsParams&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_controls_offset_tag_modifications"), this->browser_controls_offset_tag_modifications,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::cc::BrowserControlsOffsetTagModifications&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_shown_ratio"), this->top_controls_shown_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom_controls_shown_ratio"), this->bottom_controls_shown_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ui_resource_requests"), this->ui_resource_requests,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<TransferableUIResourceRequestPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layers"), this->layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::viz::mojom::blink::LayerPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_order"), this->layer_order,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<int32_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_tree_update"), this->transform_tree_update,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::TransformTreeUpdatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_tree_update"), this->scroll_tree_update,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::ScrollTreeUpdatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transform_nodes"), this->transform_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::viz::mojom::blink::TransformNodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_nodes"), this->clip_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::viz::mojom::blink::ClipNodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "effect_nodes"), this->effect_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::viz::mojom::blink::EffectNodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_nodes"), this->scroll_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::viz::mojom::blink::ScrollNodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_transform_nodes"), this->num_transform_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_clip_nodes"), this->num_clip_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_effect_nodes"), this->num_effect_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_scroll_nodes"), this->num_scroll_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilings"), this->tilings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::viz::mojom::blink::TilingPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_ranges"), this->surface_ranges,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::viz::SurfaceRange>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_transition_requests"), this->view_transition_requests,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::Vector<::viz::mojom::blink::ViewTransitionRequestPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "animation_timelines"), this->animation_timelines,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::Vector<::viz::mojom::blink::AnimationTimelinePtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "removed_animation_timelines"), this->removed_animation_timelines,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<int32_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LayerTreeUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PendingLayerContext::PendingLayerContext()
    : receiver(),
      client() {}

PendingLayerContext::PendingLayerContext(
    ::mojo::PendingAssociatedReceiver<LayerContext> receiver_in,
    ::mojo::PendingAssociatedRemote<LayerContextClient> client_in)
    : receiver(std::move(receiver_in)),
      client(std::move(client_in)) {}

PendingLayerContext::~PendingLayerContext() = default;

void PendingLayerContext::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receiver"), this->receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<LayerContext>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client"), this->client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<LayerContextClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PendingLayerContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

LayerContext::IPCStableHashFunction LayerContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LayerContext>(message.name())) {
    case messages::LayerContext::kSetVisible: {
      return &LayerContext::SetVisible_Sym::IPCStableHash;
    }
    case messages::LayerContext::kUpdateDisplayTree: {
      return &LayerContext::UpdateDisplayTree_Sym::IPCStableHash;
    }
    case messages::LayerContext::kUpdateDisplayTiling: {
      return &LayerContext::UpdateDisplayTiling_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LayerContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LayerContext>(message.name())) {
      case messages::LayerContext::kSetVisible:
            return "Receive viz::mojom::LayerContext::SetVisible";
      case messages::LayerContext::kUpdateDisplayTree:
            return "Receive viz::mojom::LayerContext::UpdateDisplayTree";
      case messages::LayerContext::kUpdateDisplayTiling:
            return "Receive viz::mojom::LayerContext::UpdateDisplayTiling";
    }
  } else {
    switch (static_cast<messages::LayerContext>(message.name())) {
      case messages::LayerContext::kSetVisible:
            return "Receive reply viz::mojom::LayerContext::SetVisible";
      case messages::LayerContext::kUpdateDisplayTree:
            return "Receive reply viz::mojom::LayerContext::UpdateDisplayTree";
      case messages::LayerContext::kUpdateDisplayTiling:
            return "Receive reply viz::mojom::LayerContext::UpdateDisplayTiling";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LayerContext::SetVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa4b7155f;  // IPCStableHash for viz::mojom::LayerContext::SetVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LayerContext::UpdateDisplayTree_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x22a97fdd;  // IPCStableHash for viz::mojom::LayerContext::UpdateDisplayTree
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LayerContext::UpdateDisplayTiling_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5a5d700;  // IPCStableHash for viz::mojom::LayerContext::UpdateDisplayTiling
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LayerContextProxy::LayerContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LayerContextProxy::SetVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::LayerContext::SetVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LayerContext::kSetVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::LayerContext_SetVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayerContext::Name_);
  message.set_method_name("SetVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LayerContextProxy::UpdateDisplayTree(
    LayerTreeUpdatePtr in_update) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::LayerContext::UpdateDisplayTree", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update"), in_update,
                        "<value of type LayerTreeUpdatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LayerContext::kUpdateDisplayTree), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::LayerContext_UpdateDisplayTree_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->update)::BaseType> update_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::LayerTreeUpdateDataView>(
    in_update,
    update_fragment);

  params->update.Set(
      update_fragment.is_null() ? nullptr : update_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->update.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null update in LayerContext.UpdateDisplayTree request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayerContext::Name_);
  message.set_method_name("UpdateDisplayTree");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LayerContextProxy::UpdateDisplayTiling(
    ::viz::mojom::blink::TilingPtr in_tiling, bool in_update_damage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::LayerContext::UpdateDisplayTiling", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tiling"), in_tiling,
                        "<value of type ::viz::mojom::blink::TilingPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_damage"), in_update_damage,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LayerContext::kUpdateDisplayTiling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::LayerContext_UpdateDisplayTiling_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tiling)::BaseType> tiling_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::TilingDataView>(
    in_tiling,
    tiling_fragment);

  params->tiling.Set(
      tiling_fragment.is_null() ? nullptr : tiling_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tiling.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tiling in LayerContext.UpdateDisplayTiling request");

  params->update_damage = in_update_damage;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayerContext::Name_);
  message.set_method_name("UpdateDisplayTiling");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LayerContextStubDispatch::Accept(
    LayerContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LayerContext>(message->header()->name)) {
    case messages::LayerContext::kSetVisible: {
      DCHECK(message->is_serialized());
      internal::LayerContext_SetVisible_Params_Data* params =
          reinterpret_cast<internal::LayerContext_SetVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LayerContext.0
      bool success = true;
      bool p_visible{};
      LayerContext_SetVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayerContext::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVisible(        
        std::move(p_visible));
      return true;
    }
    case messages::LayerContext::kUpdateDisplayTree: {
      DCHECK(message->is_serialized());
      internal::LayerContext_UpdateDisplayTree_Params_Data* params =
          reinterpret_cast<internal::LayerContext_UpdateDisplayTree_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LayerContext.1
      bool success = true;
      LayerTreeUpdatePtr p_update{};
      LayerContext_UpdateDisplayTree_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdate(&p_update))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayerContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDisplayTree(        
        std::move(p_update));
      return true;
    }
    case messages::LayerContext::kUpdateDisplayTiling: {
      DCHECK(message->is_serialized());
      internal::LayerContext_UpdateDisplayTiling_Params_Data* params =
          reinterpret_cast<internal::LayerContext_UpdateDisplayTiling_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LayerContext.2
      bool success = true;
      ::viz::mojom::blink::TilingPtr p_tiling{};
      bool p_update_damage{};
      LayerContext_UpdateDisplayTiling_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTiling(&p_tiling))
        success = false;
      if (success)
        p_update_damage = input_data_view.update_damage();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayerContext::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDisplayTiling(        
        std::move(p_tiling), 
        std::move(p_update_damage));
      return true;
    }
  }
  return false;
}

// static
bool LayerContextStubDispatch::AcceptWithResponder(
    LayerContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LayerContext>(message->header()->name)) {
    case messages::LayerContext::kSetVisible: {
      break;
    }
    case messages::LayerContext::kUpdateDisplayTree: {
      break;
    }
    case messages::LayerContext::kUpdateDisplayTiling: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLayerContextValidationInfo[] = {
    { &internal::LayerContext_SetVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LayerContext_UpdateDisplayTree_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LayerContext_UpdateDisplayTiling_Params_Data::Validate,
     nullptr /* no response */},
};

bool LayerContextRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::blink::LayerContext::Name_,
    kLayerContextValidationInfo);
}

// The declaration includes the definition on other builds.

LayerContextClient::IPCStableHashFunction LayerContextClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LayerContextClient>(message.name())) {
    case messages::LayerContextClient::kOnRequestCommitForFrame: {
      return &LayerContextClient::OnRequestCommitForFrame_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LayerContextClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LayerContextClient>(message.name())) {
      case messages::LayerContextClient::kOnRequestCommitForFrame:
            return "Receive viz::mojom::LayerContextClient::OnRequestCommitForFrame";
    }
  } else {
    switch (static_cast<messages::LayerContextClient>(message.name())) {
      case messages::LayerContextClient::kOnRequestCommitForFrame:
            return "Receive reply viz::mojom::LayerContextClient::OnRequestCommitForFrame";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LayerContextClient::OnRequestCommitForFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9de76ece;  // IPCStableHash for viz::mojom::LayerContextClient::OnRequestCommitForFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LayerContextClientProxy::LayerContextClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LayerContextClientProxy::OnRequestCommitForFrame(
    const ::viz::BeginFrameArgs& in_args) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::LayerContextClient::OnRequestCommitForFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type const ::viz::BeginFrameArgs&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LayerContextClient::kOnRequestCommitForFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::LayerContextClient_OnRequestCommitForFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView>(
    in_args,
    args_fragment);

  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->args.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null args in LayerContextClient.OnRequestCommitForFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LayerContextClient::Name_);
  message.set_method_name("OnRequestCommitForFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LayerContextClientStubDispatch::Accept(
    LayerContextClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LayerContextClient>(message->header()->name)) {
    case messages::LayerContextClient::kOnRequestCommitForFrame: {
      DCHECK(message->is_serialized());
      internal::LayerContextClient_OnRequestCommitForFrame_Params_Data* params =
          reinterpret_cast<internal::LayerContextClient_OnRequestCommitForFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LayerContextClient.0
      bool success = true;
      ::viz::BeginFrameArgs p_args{};
      LayerContextClient_OnRequestCommitForFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LayerContextClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRequestCommitForFrame(        
        std::move(p_args));
      return true;
    }
  }
  return false;
}

// static
bool LayerContextClientStubDispatch::AcceptWithResponder(
    LayerContextClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LayerContextClient>(message->header()->name)) {
    case messages::LayerContextClient::kOnRequestCommitForFrame: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLayerContextClientValidationInfo[] = {
    { &internal::LayerContextClient_OnRequestCommitForFrame_Params_Data::Validate,
     nullptr /* no response */},
};

bool LayerContextClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::blink::LayerContextClient::Name_,
    kLayerContextClientValidationInfo);
}



}  // viz::mojom::blink


namespace mojo {


// static
bool StructTraits<::viz::mojom::blink::TransferableUIResourceRequest::DataView, ::viz::mojom::blink::TransferableUIResourceRequestPtr>::Read(
    ::viz::mojom::blink::TransferableUIResourceRequest::DataView input,
    ::viz::mojom::blink::TransferableUIResourceRequestPtr* output) {
  bool success = true;
  ::viz::mojom::blink::TransferableUIResourceRequestPtr result(::viz::mojom::blink::TransferableUIResourceRequest::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadUid(&result->uid))
        success = false;
      if (success && !input.ReadTransferableResource(&result->transferable_resource))
        success = false;
      if (success)
        result->opaque = input.opaque();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::LayerTreeUpdate::DataView, ::viz::mojom::blink::LayerTreeUpdatePtr>::Read(
    ::viz::mojom::blink::LayerTreeUpdate::DataView input,
    ::viz::mojom::blink::LayerTreeUpdatePtr* output) {
  bool success = true;
  ::viz::mojom::blink::LayerTreeUpdatePtr result(::viz::mojom::blink::LayerTreeUpdate::New());
  
      if (success && !input.ReadBeginFrameArgs(&result->begin_frame_args))
        success = false;
      if (success)
        result->source_frame_number = input.source_frame_number();
      if (success)
        result->trace_id = input.trace_id();
      if (success)
        result->primary_main_frame_item_sequence_number = input.primary_main_frame_item_sequence_number();
      if (success && !input.ReadSelection(&result->selection))
        success = false;
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success)
        result->min_page_scale_factor = input.min_page_scale_factor();
      if (success)
        result->max_page_scale_factor = input.max_page_scale_factor();
      if (success)
        result->external_page_scale_factor = input.external_page_scale_factor();
      if (success && !input.ReadDeviceViewport(&result->device_viewport))
        success = false;
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success)
        result->painted_device_scale_factor = input.painted_device_scale_factor();
      if (success && !input.ReadDisplayColorSpaces(&result->display_color_spaces))
        success = false;
      if (success && !input.ReadLocalSurfaceIdFromParent(&result->local_surface_id_from_parent))
        success = false;
      if (success && !input.ReadCurrentLocalSurfaceId(&result->current_local_surface_id))
        success = false;
      if (success)
        result->next_frame_token = input.next_frame_token();
      if (success)
        result->send_frame_token_to_embedder = input.send_frame_token_to_embedder();
      if (success && !input.ReadTargetLocalSurfaceId(&result->target_local_surface_id))
        success = false;
      if (success && !input.ReadBackgroundColor(&result->background_color))
        success = false;
      if (success)
        result->overscroll_elasticity_transform = input.overscroll_elasticity_transform();
      if (success)
        result->page_scale_transform = input.page_scale_transform();
      if (success)
        result->inner_scroll = input.inner_scroll();
      if (success)
        result->outer_clip = input.outer_clip();
      if (success)
        result->outer_scroll = input.outer_scroll();
      if (success && !input.ReadViewportDamageRect(&result->viewport_damage_rect))
        success = false;
      if (success)
        result->full_tree_damaged = input.full_tree_damaged();
      if (success && !input.ReadDebugState(&result->debug_state))
        success = false;
      if (success && !input.ReadDisplayTransformHint(&result->display_transform_hint))
        success = false;
      if (success)
        result->max_safe_area_inset_bottom = input.max_safe_area_inset_bottom();
      if (success && !input.ReadBrowserControlsParams(&result->browser_controls_params))
        success = false;
      if (success && !input.ReadBrowserControlsOffsetTagModifications(&result->browser_controls_offset_tag_modifications))
        success = false;
      if (success)
        result->top_controls_shown_ratio = input.top_controls_shown_ratio();
      if (success)
        result->bottom_controls_shown_ratio = input.bottom_controls_shown_ratio();
      if (success && !input.ReadUiResourceRequests(&result->ui_resource_requests))
        success = false;
      if (success && !input.ReadLayers(&result->layers))
        success = false;
      if (success && !input.ReadLayerOrder(&result->layer_order))
        success = false;
      if (success && !input.ReadTransformTreeUpdate(&result->transform_tree_update))
        success = false;
      if (success && !input.ReadScrollTreeUpdate(&result->scroll_tree_update))
        success = false;
      if (success && !input.ReadTransformNodes(&result->transform_nodes))
        success = false;
      if (success && !input.ReadClipNodes(&result->clip_nodes))
        success = false;
      if (success && !input.ReadEffectNodes(&result->effect_nodes))
        success = false;
      if (success && !input.ReadScrollNodes(&result->scroll_nodes))
        success = false;
      if (success)
        result->num_transform_nodes = input.num_transform_nodes();
      if (success)
        result->num_clip_nodes = input.num_clip_nodes();
      if (success)
        result->num_effect_nodes = input.num_effect_nodes();
      if (success)
        result->num_scroll_nodes = input.num_scroll_nodes();
      if (success && !input.ReadTilings(&result->tilings))
        success = false;
      if (success && !input.ReadSurfaceRanges(&result->surface_ranges))
        success = false;
      if (success && !input.ReadViewTransitionRequests(&result->view_transition_requests))
        success = false;
      if (success && !input.ReadAnimationTimelines(&result->animation_timelines))
        success = false;
      if (success && !input.ReadRemovedAnimationTimelines(&result->removed_animation_timelines))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::PendingLayerContext::DataView, ::viz::mojom::blink::PendingLayerContextPtr>::Read(
    ::viz::mojom::blink::PendingLayerContext::DataView input,
    ::viz::mojom::blink::PendingLayerContextPtr* output) {
  bool success = true;
  ::viz::mojom::blink::PendingLayerContextPtr result(::viz::mojom::blink::PendingLayerContext::New());
  
      if (success) {
        result->receiver =
            input.TakeReceiver<decltype(result->receiver)>();
      }
      if (success) {
        result->client =
            input.TakeClient<decltype(result->client)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom::blink {


void LayerContextInterceptorForTesting::SetVisible(bool visible) {
  GetForwardingInterface()->SetVisible(
    std::move(visible)
    );
}
void LayerContextInterceptorForTesting::UpdateDisplayTree(LayerTreeUpdatePtr update) {
  GetForwardingInterface()->UpdateDisplayTree(
    std::move(update)
    );
}
void LayerContextInterceptorForTesting::UpdateDisplayTiling(::viz::mojom::blink::TilingPtr tiling, bool update_damage) {
  GetForwardingInterface()->UpdateDisplayTiling(
    std::move(tiling)
    , 
    std::move(update_damage)
    );
}
LayerContextAsyncWaiter::LayerContextAsyncWaiter(
    LayerContext* proxy) : proxy_(proxy) {}

LayerContextAsyncWaiter::~LayerContextAsyncWaiter() = default;





void LayerContextClientInterceptorForTesting::OnRequestCommitForFrame(const ::viz::BeginFrameArgs& args) {
  GetForwardingInterface()->OnRequestCommitForFrame(
    std::move(args)
    );
}
LayerContextClientAsyncWaiter::LayerContextClientAsyncWaiter(
    LayerContextClient* proxy) : proxy_(proxy) {}

LayerContextClientAsyncWaiter::~LayerContextClientAsyncWaiter() = default;







}  // viz::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif