// services/viz/public/mojom/compositing/frame_sink_bundle.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom-shared.h"
#include "services/viz/public/mojom/compositing/thread.mojom-shared.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared.h"

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::BundledFrameSubmissionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BundledFrameSubmissionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BundledFrameSubmission_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->sink_id = Traits::sink_id(input);

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<decltype(fragment->data)>
          data_fragment(fragment.message());
      data_fragment.Claim(&fragment->data);
      
      mojo::internal::Serialize<::viz::mojom::BundledFrameSubmissionDataDataView, send_validation>(
        in_data,
        data_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in BundledFrameSubmission struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::BundledCompositorFrameDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BundledCompositorFrameDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BundledCompositorFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::local_surface_id(input)) in_local_surface_id = Traits::local_surface_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->local_surface_id)::BaseType> local_surface_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView, send_validation>(
        in_local_surface_id,
        local_surface_id_fragment);

      fragment->local_surface_id.Set(
          local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->local_surface_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null local_surface_id in BundledCompositorFrame struct");

      decltype(Traits::frame(input)) in_frame = Traits::frame(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame)::BaseType> frame_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView, send_validation>(
        in_frame,
        frame_fragment);

      fragment->frame.Set(
          frame_fragment.is_null() ? nullptr : frame_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame in BundledCompositorFrame struct");

      decltype(Traits::hit_test_region_list(input)) in_hit_test_region_list = Traits::hit_test_region_list(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hit_test_region_list)::BaseType> hit_test_region_list_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView, send_validation>(
        in_hit_test_region_list,
        hit_test_region_list_fragment);

      fragment->hit_test_region_list.Set(
          hit_test_region_list_fragment.is_null() ? nullptr : hit_test_region_list_fragment.data());

      fragment->submit_time = Traits::submit_time(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::BundledReturnedResourcesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BundledReturnedResourcesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BundledReturnedResources_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->sink_id = Traits::sink_id(input);

      decltype(Traits::resources(input)) in_resources = Traits::resources(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resources)::BaseType>
          resources_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>, send_validation>(
        in_resources,
        resources_fragment,
        &resources_validate_params);

      fragment->resources.Set(
          resources_fragment.is_null() ? nullptr : resources_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resources.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resources in BundledReturnedResources struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::BeginFrameInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BeginFrameInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BeginFrameInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->sink_id = Traits::sink_id(input);

      decltype(Traits::args(input)) in_args = Traits::args(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->args)::BaseType> args_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView, send_validation>(
        in_args,
        args_fragment);

      fragment->args.Set(
          args_fragment.is_null() ? nullptr : args_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->args.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null args in BeginFrameInfo struct");

      decltype(Traits::details(input)) in_details = Traits::details(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->details)::BaseType>
          details_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>, send_validation>(
        in_details,
        details_fragment,
        &details_validate_params);

      fragment->details.Set(
          details_fragment.is_null() ? nullptr : details_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->details.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null details in BeginFrameInfo struct");

      decltype(Traits::resources(input)) in_resources = Traits::resources(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resources)::BaseType>
          resources_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>, send_validation>(
        in_resources,
        resources_fragment,
        &resources_validate_params);

      fragment->resources.Set(
          resources_fragment.is_null() ? nullptr : resources_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resources.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resources in BeginFrameInfo struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::BundledFrameSubmissionDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::BundledFrameSubmissionDataDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::BundledFrameSubmissionData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::BundledFrameSubmissionDataDataView::Tag::kFrame: {
    decltype(Traits::frame(input))
    in_frame = Traits::frame(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_frame)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::BundledCompositorFrameDataView, send_validation>(
  in_frame,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null frame in BundledFrameSubmissionData union");
    fragment->data.f_frame.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::BundledFrameSubmissionDataDataView::Tag::kDidNotProduceFrame: {
    decltype(Traits::did_not_produce_frame(input))
    in_did_not_produce_frame = Traits::did_not_produce_frame(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_did_not_produce_frame)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::BeginFrameAckDataView, send_validation>(
  in_did_not_produce_frame,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null did_not_produce_frame in BundledFrameSubmissionData union");
    fragment->data.f_did_not_produce_frame.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_SEND_VALIDATION_H_