// services/viz/public/mojom/compositing/frame_interval_inputs.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/frame_interval_inputs.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var ContentFrameIntervalType = {};
  ContentFrameIntervalType.kVideo = 0;
  ContentFrameIntervalType.kAnimatingImage = 1;
  ContentFrameIntervalType.kScrollBarFadeOutAnimation = 2;
  ContentFrameIntervalType.kCompositorScroll = 3;
  ContentFrameIntervalType.MIN_VALUE = 0;
  ContentFrameIntervalType.MAX_VALUE = 3;

  ContentFrameIntervalType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  ContentFrameIntervalType.toKnownEnumValue = function(value) {
    return value;
  };

  ContentFrameIntervalType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ContentFrameIntervalInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ContentFrameIntervalInfo.prototype.initDefaults_ = function() {
    this.type = 0;
    this.duplicateCount = 0;
    this.frameInterval = null;
  };
  ContentFrameIntervalInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ContentFrameIntervalInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentFrameIntervalInfo.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ContentFrameIntervalType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentFrameIntervalInfo.frameInterval
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ContentFrameIntervalInfo.encodedSize = codec.kStructHeaderSize + 16;

  ContentFrameIntervalInfo.decode = function(decoder) {
    var packed;
    var val = new ContentFrameIntervalInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(ContentFrameIntervalType));
    val.duplicateCount =
        decoder.decodeStruct(codec.Uint32);
    val.frameInterval =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  ContentFrameIntervalInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ContentFrameIntervalInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Uint32, val.duplicateCount);
    encoder.encodeStructPointer(time$.TimeDelta, val.frameInterval);
  };
  function FrameIntervalInputs(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameIntervalInputs.prototype.initDefaults_ = function() {
    this.frameTime = null;
    this.hasUserInput = false;
    this.hasInput = false;
    this.hasOnlyContentFrameIntervalUpdates = false;
    this.majorScrollSpeedInPixelsPerSecond = 0;
    this.contentIntervalInfo = null;
  };
  FrameIntervalInputs.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameIntervalInputs.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameIntervalInputs.frameTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate FrameIntervalInputs.contentIntervalInfo
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(ContentFrameIntervalInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FrameIntervalInputs.encodedSize = codec.kStructHeaderSize + 24;

  FrameIntervalInputs.decode = function(decoder) {
    var packed;
    var val = new FrameIntervalInputs();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    packed = decoder.readUint8();
    val.hasUserInput = (packed >> 0) & 1 ? true : false;
    val.hasInput = (packed >> 1) & 1 ? true : false;
    val.hasOnlyContentFrameIntervalUpdates = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.majorScrollSpeedInPixelsPerSecond =
        decoder.decodeStruct(codec.Float);
    val.contentIntervalInfo =
        decoder.decodeArrayPointer(new codec.PointerTo(ContentFrameIntervalInfo));
    return val;
  };

  FrameIntervalInputs.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameIntervalInputs.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeTicks, val.frameTime);
    packed = 0;
    packed |= (val.hasUserInput & 1) << 0
    packed |= (val.hasInput & 1) << 1
    packed |= (val.hasOnlyContentFrameIntervalUpdates & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.majorScrollSpeedInPixelsPerSecond);
    encoder.encodeArrayPointer(new codec.PointerTo(ContentFrameIntervalInfo), val.contentIntervalInfo);
  };
  exports.ContentFrameIntervalType = ContentFrameIntervalType;
  exports.ContentFrameIntervalInfo = ContentFrameIntervalInfo;
  exports.FrameIntervalInputs = FrameIntervalInputs;
})();