// services/viz/public/mojom/compositing/compositor_render_pass.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"
#include "services/viz/public/mojom/compositing/filter_operations.mojom-shared.h"
#include "services/viz/public/mojom/compositing/quads.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "skia/public/mojom/skpath.mojom-shared.h"

#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::CompositorRenderPassDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CompositorRenderPassDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CompositorRenderPass_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::CompositorRenderPassIdDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in CompositorRenderPass struct");

      decltype(Traits::output_rect(input)) in_output_rect = Traits::output_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->output_rect)::BaseType> output_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_output_rect,
        output_rect_fragment);

      fragment->output_rect.Set(
          output_rect_fragment.is_null() ? nullptr : output_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->output_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null output_rect in CompositorRenderPass struct");

      decltype(Traits::damage_rect(input)) in_damage_rect = Traits::damage_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->damage_rect)::BaseType> damage_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_damage_rect,
        damage_rect_fragment);

      fragment->damage_rect.Set(
          damage_rect_fragment.is_null() ? nullptr : damage_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->damage_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null damage_rect in CompositorRenderPass struct");

      decltype(Traits::transform_to_root_target(input)) in_transform_to_root_target = Traits::transform_to_root_target(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transform_to_root_target)::BaseType> transform_to_root_target_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_transform_to_root_target,
        transform_to_root_target_fragment);

      fragment->transform_to_root_target.Set(
          transform_to_root_target_fragment.is_null() ? nullptr : transform_to_root_target_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transform_to_root_target.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transform_to_root_target in CompositorRenderPass struct");

      decltype(Traits::filters(input)) in_filters = Traits::filters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filters)::BaseType> filters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::FilterOperationsDataView, send_validation>(
        in_filters,
        filters_fragment);

      fragment->filters.Set(
          filters_fragment.is_null() ? nullptr : filters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filters in CompositorRenderPass struct");

      decltype(Traits::backdrop_filters(input)) in_backdrop_filters = Traits::backdrop_filters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->backdrop_filters)::BaseType> backdrop_filters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::FilterOperationsDataView, send_validation>(
        in_backdrop_filters,
        backdrop_filters_fragment);

      fragment->backdrop_filters.Set(
          backdrop_filters_fragment.is_null() ? nullptr : backdrop_filters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->backdrop_filters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null backdrop_filters in CompositorRenderPass struct");

      decltype(Traits::backdrop_filter_bounds(input)) in_backdrop_filter_bounds = Traits::backdrop_filter_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->backdrop_filter_bounds)::BaseType> backdrop_filter_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkPathDataView, send_validation>(
        in_backdrop_filter_bounds,
        backdrop_filter_bounds_fragment);

      fragment->backdrop_filter_bounds.Set(
          backdrop_filter_bounds_fragment.is_null() ? nullptr : backdrop_filter_bounds_fragment.data());

      decltype(Traits::subtree_capture_id(input)) in_subtree_capture_id = Traits::subtree_capture_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subtree_capture_id)::BaseType> subtree_capture_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::SubtreeCaptureIdDataView, send_validation>(
        in_subtree_capture_id,
        subtree_capture_id_fragment);

      fragment->subtree_capture_id.Set(
          subtree_capture_id_fragment.is_null() ? nullptr : subtree_capture_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subtree_capture_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subtree_capture_id in CompositorRenderPass struct");

      decltype(Traits::subtree_size(input)) in_subtree_size = Traits::subtree_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subtree_size)::BaseType> subtree_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_subtree_size,
        subtree_size_fragment);

      fragment->subtree_size.Set(
          subtree_size_fragment.is_null() ? nullptr : subtree_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subtree_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subtree_size in CompositorRenderPass struct");

      decltype(Traits::view_transition_element_resource_id(input)) in_view_transition_element_resource_id = Traits::view_transition_element_resource_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->view_transition_element_resource_id)::BaseType> view_transition_element_resource_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::ViewTransitionElementResourceIdDataView, send_validation>(
        in_view_transition_element_resource_id,
        view_transition_element_resource_id_fragment);

      fragment->view_transition_element_resource_id.Set(
          view_transition_element_resource_id_fragment.is_null() ? nullptr : view_transition_element_resource_id_fragment.data());

      fragment->has_transparent_background = Traits::has_transparent_background(input);

      fragment->cache_render_pass = Traits::cache_render_pass(input);

      fragment->has_damage_from_contributing_content = Traits::has_damage_from_contributing_content(input);

      fragment->generate_mipmap = Traits::generate_mipmap(input);

      decltype(Traits::copy_requests(input)) in_copy_requests = Traits::copy_requests(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->copy_requests)::BaseType>
          copy_requests_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& copy_requests_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>, send_validation>(
        in_copy_requests,
        copy_requests_fragment,
        &copy_requests_validate_params);

      fragment->copy_requests.Set(
          copy_requests_fragment.is_null() ? nullptr : copy_requests_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->copy_requests.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null copy_requests in CompositorRenderPass struct");

      decltype(Traits::quad_list(input)) in_quad_list = Traits::quad_list(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->quad_list)::BaseType>
          quad_list_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& quad_list_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::DrawQuadDataView>, send_validation>(
        in_quad_list,
        quad_list_fragment,
        &quad_list_validate_params);

      fragment->quad_list.Set(
          quad_list_fragment.is_null() ? nullptr : quad_list_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->quad_list.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null quad_list in CompositorRenderPass struct");

      fragment->has_per_quad_damage = Traits::has_per_quad_damage(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_SEND_VALIDATION_H_