// services/viz/public/mojom/compositing/compositor_render_pass.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom-blink.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-blink.h"
#include "services/viz/public/mojom/compositing/filter_operations.mojom-blink.h"
#include "services/viz/public/mojom/compositing/quads.mojom-blink.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-blink.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/transform.mojom-blink.h"
#include "skia/public/mojom/skpath.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {








class BLINK_PLATFORM_EXPORT CompositorRenderPass {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CompositorRenderPass, T>::value>;
  using DataView = CompositorRenderPassDataView;
  using Data_ = internal::CompositorRenderPass_Data;

  template <typename... Args>
  static CompositorRenderPassPtr New(Args&&... args) {
    return CompositorRenderPassPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CompositorRenderPassPtr From(const U& u) {
    return mojo::TypeConverter<CompositorRenderPassPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CompositorRenderPass>::Convert(*this);
  }


  CompositorRenderPass();

  CompositorRenderPass(
      ::viz::mojom::blink::CompositorRenderPassIdPtr id,
      const ::gfx::Rect& output_rect,
      const ::gfx::Rect& damage_rect,
      const ::gfx::Transform& transform_to_root_target,
      ::viz::mojom::blink::FilterOperationsPtr filters,
      ::viz::mojom::blink::FilterOperationsPtr backdrop_filters,
      const std::optional<::SkPath>& backdrop_filter_bounds,
      const ::viz::SubtreeCaptureId& subtree_capture_id,
      const ::gfx::Size& subtree_size,
      ::viz::mojom::blink::ViewTransitionElementResourceIdPtr view_transition_element_resource_id,
      bool has_transparent_background,
      bool cache_render_pass,
      bool has_damage_from_contributing_content,
      bool generate_mipmap,
      ::blink::Vector<::viz::mojom::blink::CopyOutputRequestPtr> copy_requests,
      ::blink::Vector<::viz::mojom::blink::DrawQuadPtr> quad_list,
      bool has_per_quad_damage);

CompositorRenderPass(const CompositorRenderPass&) = delete;
CompositorRenderPass& operator=(const CompositorRenderPass&) = delete;

  ~CompositorRenderPass();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CompositorRenderPassPtr>
  CompositorRenderPassPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CompositorRenderPass::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CompositorRenderPass_UnserializedMessageContext<
            UserType, CompositorRenderPass::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CompositorRenderPass::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CompositorRenderPass::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CompositorRenderPass_UnserializedMessageContext<
            UserType, CompositorRenderPass::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CompositorRenderPass::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::mojom::blink::CompositorRenderPassIdPtr id;
  
  ::gfx::Rect output_rect;
  
  ::gfx::Rect damage_rect;
  
  ::gfx::Transform transform_to_root_target;
  
  ::viz::mojom::blink::FilterOperationsPtr filters;
  
  ::viz::mojom::blink::FilterOperationsPtr backdrop_filters;
  
  std::optional<::SkPath> backdrop_filter_bounds;
  
  ::viz::SubtreeCaptureId subtree_capture_id;
  
  ::gfx::Size subtree_size;
  
  ::viz::mojom::blink::ViewTransitionElementResourceIdPtr view_transition_element_resource_id;
  
  bool has_transparent_background;
  
  bool cache_render_pass;
  
  bool has_damage_from_contributing_content;
  
  bool generate_mipmap;
  
  ::blink::Vector<::viz::mojom::blink::CopyOutputRequestPtr> copy_requests;
  
  ::blink::Vector<::viz::mojom::blink::DrawQuadPtr> quad_list;
  
  bool has_per_quad_damage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CompositorRenderPassPtr CompositorRenderPass::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(output_rect),
      mojo::Clone(damage_rect),
      mojo::Clone(transform_to_root_target),
      mojo::Clone(filters),
      mojo::Clone(backdrop_filters),
      mojo::Clone(backdrop_filter_bounds),
      mojo::Clone(subtree_capture_id),
      mojo::Clone(subtree_size),
      mojo::Clone(view_transition_element_resource_id),
      mojo::Clone(has_transparent_background),
      mojo::Clone(cache_render_pass),
      mojo::Clone(has_damage_from_contributing_content),
      mojo::Clone(generate_mipmap),
      mojo::Clone(copy_requests),
      mojo::Clone(quad_list),
      mojo::Clone(has_per_quad_damage)
  );
}

template <typename T, CompositorRenderPass::EnableIfSame<T>*>
bool CompositorRenderPass::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->output_rect, other_struct.output_rect))
    return false;
  if (!mojo::Equals(this->damage_rect, other_struct.damage_rect))
    return false;
  if (!mojo::Equals(this->transform_to_root_target, other_struct.transform_to_root_target))
    return false;
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  if (!mojo::Equals(this->backdrop_filters, other_struct.backdrop_filters))
    return false;
  if (!mojo::Equals(this->backdrop_filter_bounds, other_struct.backdrop_filter_bounds))
    return false;
  if (!mojo::Equals(this->subtree_capture_id, other_struct.subtree_capture_id))
    return false;
  if (!mojo::Equals(this->subtree_size, other_struct.subtree_size))
    return false;
  if (!mojo::Equals(this->view_transition_element_resource_id, other_struct.view_transition_element_resource_id))
    return false;
  if (!mojo::Equals(this->has_transparent_background, other_struct.has_transparent_background))
    return false;
  if (!mojo::Equals(this->cache_render_pass, other_struct.cache_render_pass))
    return false;
  if (!mojo::Equals(this->has_damage_from_contributing_content, other_struct.has_damage_from_contributing_content))
    return false;
  if (!mojo::Equals(this->generate_mipmap, other_struct.generate_mipmap))
    return false;
  if (!mojo::Equals(this->copy_requests, other_struct.copy_requests))
    return false;
  if (!mojo::Equals(this->quad_list, other_struct.quad_list))
    return false;
  if (!mojo::Equals(this->has_per_quad_damage, other_struct.has_per_quad_damage))
    return false;
  return true;
}

template <typename T, CompositorRenderPass::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.output_rect < rhs.output_rect)
    return true;
  if (rhs.output_rect < lhs.output_rect)
    return false;
  if (lhs.damage_rect < rhs.damage_rect)
    return true;
  if (rhs.damage_rect < lhs.damage_rect)
    return false;
  if (lhs.transform_to_root_target < rhs.transform_to_root_target)
    return true;
  if (rhs.transform_to_root_target < lhs.transform_to_root_target)
    return false;
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  if (lhs.backdrop_filters < rhs.backdrop_filters)
    return true;
  if (rhs.backdrop_filters < lhs.backdrop_filters)
    return false;
  if (lhs.backdrop_filter_bounds < rhs.backdrop_filter_bounds)
    return true;
  if (rhs.backdrop_filter_bounds < lhs.backdrop_filter_bounds)
    return false;
  if (lhs.subtree_capture_id < rhs.subtree_capture_id)
    return true;
  if (rhs.subtree_capture_id < lhs.subtree_capture_id)
    return false;
  if (lhs.subtree_size < rhs.subtree_size)
    return true;
  if (rhs.subtree_size < lhs.subtree_size)
    return false;
  if (lhs.view_transition_element_resource_id < rhs.view_transition_element_resource_id)
    return true;
  if (rhs.view_transition_element_resource_id < lhs.view_transition_element_resource_id)
    return false;
  if (lhs.has_transparent_background < rhs.has_transparent_background)
    return true;
  if (rhs.has_transparent_background < lhs.has_transparent_background)
    return false;
  if (lhs.cache_render_pass < rhs.cache_render_pass)
    return true;
  if (rhs.cache_render_pass < lhs.cache_render_pass)
    return false;
  if (lhs.has_damage_from_contributing_content < rhs.has_damage_from_contributing_content)
    return true;
  if (rhs.has_damage_from_contributing_content < lhs.has_damage_from_contributing_content)
    return false;
  if (lhs.generate_mipmap < rhs.generate_mipmap)
    return true;
  if (rhs.generate_mipmap < lhs.generate_mipmap)
    return false;
  if (lhs.copy_requests < rhs.copy_requests)
    return true;
  if (rhs.copy_requests < lhs.copy_requests)
    return false;
  if (lhs.quad_list < rhs.quad_list)
    return true;
  if (rhs.quad_list < lhs.quad_list)
    return false;
  if (lhs.has_per_quad_damage < rhs.has_per_quad_damage)
    return true;
  if (rhs.has_per_quad_damage < lhs.has_per_quad_damage)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::CompositorRenderPass::DataView,
                                         ::viz::mojom::blink::CompositorRenderPassPtr> {
  static bool IsNull(const ::viz::mojom::blink::CompositorRenderPassPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::CompositorRenderPassPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::id)& id(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->id;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::output_rect)& output_rect(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->output_rect;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::damage_rect)& damage_rect(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->damage_rect;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::transform_to_root_target)& transform_to_root_target(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->transform_to_root_target;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::filters)& filters(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->filters;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::backdrop_filters)& backdrop_filters(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->backdrop_filters;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::backdrop_filter_bounds)& backdrop_filter_bounds(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->backdrop_filter_bounds;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::subtree_capture_id)& subtree_capture_id(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->subtree_capture_id;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::subtree_size)& subtree_size(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->subtree_size;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::view_transition_element_resource_id)& view_transition_element_resource_id(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->view_transition_element_resource_id;
  }

  static decltype(::viz::mojom::blink::CompositorRenderPass::has_transparent_background) has_transparent_background(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->has_transparent_background;
  }

  static decltype(::viz::mojom::blink::CompositorRenderPass::cache_render_pass) cache_render_pass(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->cache_render_pass;
  }

  static decltype(::viz::mojom::blink::CompositorRenderPass::has_damage_from_contributing_content) has_damage_from_contributing_content(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->has_damage_from_contributing_content;
  }

  static decltype(::viz::mojom::blink::CompositorRenderPass::generate_mipmap) generate_mipmap(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->generate_mipmap;
  }

  static  decltype(::viz::mojom::blink::CompositorRenderPass::copy_requests)& copy_requests(
       ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->copy_requests;
  }

  static const decltype(::viz::mojom::blink::CompositorRenderPass::quad_list)& quad_list(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->quad_list;
  }

  static decltype(::viz::mojom::blink::CompositorRenderPass::has_per_quad_damage) has_per_quad_damage(
      const ::viz::mojom::blink::CompositorRenderPassPtr& input) {
    return input->has_per_quad_damage;
  }

  static bool Read(::viz::mojom::blink::CompositorRenderPass::DataView input, ::viz::mojom::blink::CompositorRenderPassPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_BLINK_H_