// services/viz/public/mojom/compositing/blit_request.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/blit_request.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var exported_shared_image$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/exported_shared_image.mojom', '../../../../../gpu/ipc/common/exported_shared_image.mojom.js');
  }
  var sync_token$ =
      mojo.internal.exposeNamespace('gpu.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'gpu/ipc/common/sync_token.mojom', '../../../../../gpu/ipc/common/sync_token.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var LetterboxingBehavior = {};
  LetterboxingBehavior.kDoNotLetterbox = 0;
  LetterboxingBehavior.kLetterbox = 1;
  LetterboxingBehavior.MIN_VALUE = 0;
  LetterboxingBehavior.MAX_VALUE = 1;

  LetterboxingBehavior.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  LetterboxingBehavior.toKnownEnumValue = function(value) {
    return value;
  };

  LetterboxingBehavior.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function BlitRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BlitRequest.prototype.initDefaults_ = function() {
    this.destinationRegionOffset = null;
    this.letterboxingBehavior = 0;
    this.populatesGpuMemoryBuffer = false;
    this.sharedImage = null;
    this.syncToken = null;
  };
  BlitRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BlitRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlitRequest.destinationRegionOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlitRequest.letterboxingBehavior
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, LetterboxingBehavior);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlitRequest.sharedImage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, exported_shared_image$.ExportedSharedImage, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlitRequest.syncToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, sync_token$.SyncToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  BlitRequest.encodedSize = codec.kStructHeaderSize + 32;

  BlitRequest.decode = function(decoder) {
    var packed;
    var val = new BlitRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.destinationRegionOffset =
        decoder.decodeStructPointer(geometry$.Point);
    val.letterboxingBehavior =
        decoder.decodeStruct(new codec.Enum(LetterboxingBehavior));
    packed = decoder.readUint8();
    val.populatesGpuMemoryBuffer = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sharedImage =
        decoder.decodeStructPointer(exported_shared_image$.ExportedSharedImage);
    val.syncToken =
        decoder.decodeStructPointer(sync_token$.SyncToken);
    return val;
  };

  BlitRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BlitRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Point, val.destinationRegionOffset);
    encoder.encodeStruct(codec.Int32, val.letterboxingBehavior);
    packed = 0;
    packed |= (val.populatesGpuMemoryBuffer & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(exported_shared_image$.ExportedSharedImage, val.sharedImage);
    encoder.encodeStructPointer(sync_token$.SyncToken, val.syncToken);
  };
  exports.LetterboxingBehavior = LetterboxingBehavior;
  exports.BlitRequest = BlitRequest;
})();