// services/viz/public/mojom/compositing/blit_request.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/blit_request.mojom-shared-internal.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "services/viz/public/mojom/compositing/blit_request.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::LetterboxingBehavior, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::BlitRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BlitRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BlitRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::destination_region_offset(input)) in_destination_region_offset = Traits::destination_region_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->destination_region_offset)::BaseType> destination_region_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_destination_region_offset,
        destination_region_offset_fragment);

      fragment->destination_region_offset.Set(
          destination_region_offset_fragment.is_null() ? nullptr : destination_region_offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->destination_region_offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null destination_region_offset in BlitRequest struct");

      
      mojo::internal::Serialize<::viz::mojom::LetterboxingBehavior>(
        Traits::letterboxing_behavior(input),
        &fragment->letterboxing_behavior);

      decltype(Traits::shared_image(input)) in_shared_image = Traits::shared_image(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shared_image)::BaseType> shared_image_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView, send_validation>(
        in_shared_image,
        shared_image_fragment);

      fragment->shared_image.Set(
          shared_image_fragment.is_null() ? nullptr : shared_image_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->shared_image.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shared_image in BlitRequest struct");

      decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView, send_validation>(
        in_sync_token,
        sync_token_fragment);

      fragment->sync_token.Set(
          sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sync_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token in BlitRequest struct");

      fragment->populates_gpu_memory_buffer = Traits::populates_gpu_memory_buffer(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_SEND_VALIDATION_H_