// services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-import-headers.h"
#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-test-utils.h"
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"


namespace viz::mojom {
// The declaration includes the definition on other builds.

ExternalBeginFrameController::IPCStableHashFunction ExternalBeginFrameController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ExternalBeginFrameController>(message.name())) {
    case messages::ExternalBeginFrameController::kIssueExternalBeginFrame: {
      return &ExternalBeginFrameController::IssueExternalBeginFrame_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ExternalBeginFrameController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ExternalBeginFrameController>(message.name())) {
      case messages::ExternalBeginFrameController::kIssueExternalBeginFrame:
            return "Receive viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrame";
    }
  } else {
    switch (static_cast<messages::ExternalBeginFrameController>(message.name())) {
      case messages::ExternalBeginFrameController::kIssueExternalBeginFrame:
            return "Receive reply viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrame";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ExternalBeginFrameController::IssueExternalBeginFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1adffe2e;  // IPCStableHash for viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback(
      ExternalBeginFrameController::IssueExternalBeginFrameCallback callback
      ) : callback_(std::move(callback)) {
  }

  ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback(const ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback&) = delete;
  ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback& operator=(const ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ExternalBeginFrameController::IssueExternalBeginFrameCallback callback_;
};

ExternalBeginFrameControllerProxy::ExternalBeginFrameControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ExternalBeginFrameControllerProxy::IssueExternalBeginFrame(
    const ::viz::BeginFrameArgs& in_args, bool in_force, IssueExternalBeginFrameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type const ::viz::BeginFrameArgs&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("force"), in_force,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExternalBeginFrameController::kIssueExternalBeginFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::ExternalBeginFrameController_IssueExternalBeginFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView>(
    in_args,
    args_fragment);

  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->args.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null args in ExternalBeginFrameController.IssueExternalBeginFrame request");

  params->force = in_force;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExternalBeginFrameController::Name_);
  message.set_method_name("IssueExternalBeginFrame");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ExternalBeginFrameController::IssueExternalBeginFrameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder> proxy(
        new ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ExternalBeginFrameController::IssueExternalBeginFrameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::viz::BeginFrameAck& in_ack);
};

bool ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ExternalBeginFrameController_IssueExternalBeginFrame_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ExternalBeginFrameController_IssueExternalBeginFrame_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ExternalBeginFrameController.0
  bool success = true;
  ::viz::BeginFrameAck p_ack{};
  ExternalBeginFrameController_IssueExternalBeginFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAck(&p_ack))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ExternalBeginFrameController::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_ack));
  }
  return true;
}

void ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder::Run(
    const ::viz::BeginFrameAck& in_ack) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrame", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ack"), in_ack,
                        "<value of type const ::viz::BeginFrameAck&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExternalBeginFrameController::kIssueExternalBeginFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::ExternalBeginFrameController_IssueExternalBeginFrame_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ack)::BaseType> ack_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::BeginFrameAckDataView>(
    in_ack,
    ack_fragment);

  params->ack.Set(
      ack_fragment.is_null() ? nullptr : ack_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ack.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ack in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExternalBeginFrameController::Name_);
  message.set_method_name("IssueExternalBeginFrame");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ExternalBeginFrameControllerStubDispatch::Accept(
    ExternalBeginFrameController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ExternalBeginFrameController>(message->header()->name)) {
    case messages::ExternalBeginFrameController::kIssueExternalBeginFrame: {
      break;
    }
  }
  return false;
}

// static
bool ExternalBeginFrameControllerStubDispatch::AcceptWithResponder(
    ExternalBeginFrameController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ExternalBeginFrameController>(message->header()->name)) {
    case messages::ExternalBeginFrameController::kIssueExternalBeginFrame: {
      internal::ExternalBeginFrameController_IssueExternalBeginFrame_Params_Data* params =
          reinterpret_cast<
              internal::ExternalBeginFrameController_IssueExternalBeginFrame_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ExternalBeginFrameController.0
      bool success = true;
      ::viz::BeginFrameArgs p_args{};
      bool p_force{};
      ExternalBeginFrameController_IssueExternalBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (success)
        p_force = input_data_view.force();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExternalBeginFrameController::Name_, 0, false);
        return false;
      }
      auto callback =
          ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueExternalBeginFrame(        
        std::move(p_args), 
        std::move(p_force), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kExternalBeginFrameControllerValidationInfo[] = {
    { &internal::ExternalBeginFrameController_IssueExternalBeginFrame_Params_Data::Validate,
     &internal::ExternalBeginFrameController_IssueExternalBeginFrame_ResponseParams_Data::Validate},
};

bool ExternalBeginFrameControllerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::ExternalBeginFrameController::Name_,
    kExternalBeginFrameControllerValidationInfo);
}

bool ExternalBeginFrameControllerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::viz::mojom::ExternalBeginFrameController::Name_,
    kExternalBeginFrameControllerValidationInfo);
}
// The declaration includes the definition on other builds.

ExternalBeginFrameControllerClient::IPCStableHashFunction ExternalBeginFrameControllerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ExternalBeginFrameControllerClient>(message.name())) {
    case messages::ExternalBeginFrameControllerClient::kSetNeedsBeginFrame: {
      return &ExternalBeginFrameControllerClient::SetNeedsBeginFrame_Sym::IPCStableHash;
    }
    case messages::ExternalBeginFrameControllerClient::kSetPreferredInterval: {
      return &ExternalBeginFrameControllerClient::SetPreferredInterval_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ExternalBeginFrameControllerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ExternalBeginFrameControllerClient>(message.name())) {
      case messages::ExternalBeginFrameControllerClient::kSetNeedsBeginFrame:
            return "Receive viz::mojom::ExternalBeginFrameControllerClient::SetNeedsBeginFrame";
      case messages::ExternalBeginFrameControllerClient::kSetPreferredInterval:
            return "Receive viz::mojom::ExternalBeginFrameControllerClient::SetPreferredInterval";
    }
  } else {
    switch (static_cast<messages::ExternalBeginFrameControllerClient>(message.name())) {
      case messages::ExternalBeginFrameControllerClient::kSetNeedsBeginFrame:
            return "Receive reply viz::mojom::ExternalBeginFrameControllerClient::SetNeedsBeginFrame";
      case messages::ExternalBeginFrameControllerClient::kSetPreferredInterval:
            return "Receive reply viz::mojom::ExternalBeginFrameControllerClient::SetPreferredInterval";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ExternalBeginFrameControllerClient::SetNeedsBeginFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd777d150;  // IPCStableHash for viz::mojom::ExternalBeginFrameControllerClient::SetNeedsBeginFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExternalBeginFrameControllerClient::SetPreferredInterval_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed77f3f3;  // IPCStableHash for viz::mojom::ExternalBeginFrameControllerClient::SetPreferredInterval
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ExternalBeginFrameControllerClientProxy::ExternalBeginFrameControllerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ExternalBeginFrameControllerClientProxy::SetNeedsBeginFrame(
    bool in_needs_begin_frames) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::ExternalBeginFrameControllerClient::SetNeedsBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_begin_frames"), in_needs_begin_frames,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExternalBeginFrameControllerClient::kSetNeedsBeginFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::ExternalBeginFrameControllerClient_SetNeedsBeginFrame_Params_Data> params(
          message);
  params.Allocate();

  params->needs_begin_frames = in_needs_begin_frames;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExternalBeginFrameControllerClient::Name_);
  message.set_method_name("SetNeedsBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ExternalBeginFrameControllerClientProxy::SetPreferredInterval(
    ::base::TimeDelta in_interval) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::ExternalBeginFrameControllerClient::SetPreferredInterval", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interval"), in_interval,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExternalBeginFrameControllerClient::kSetPreferredInterval), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::ExternalBeginFrameControllerClient_SetPreferredInterval_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->interval)::BaseType> interval_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_interval,
    interval_fragment);

  params->interval.Set(
      interval_fragment.is_null() ? nullptr : interval_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interval.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interval in ExternalBeginFrameControllerClient.SetPreferredInterval request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExternalBeginFrameControllerClient::Name_);
  message.set_method_name("SetPreferredInterval");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ExternalBeginFrameControllerClientStubDispatch::Accept(
    ExternalBeginFrameControllerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ExternalBeginFrameControllerClient>(message->header()->name)) {
    case messages::ExternalBeginFrameControllerClient::kSetNeedsBeginFrame: {
      DCHECK(message->is_serialized());
      internal::ExternalBeginFrameControllerClient_SetNeedsBeginFrame_Params_Data* params =
          reinterpret_cast<internal::ExternalBeginFrameControllerClient_SetNeedsBeginFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExternalBeginFrameControllerClient.0
      bool success = true;
      bool p_needs_begin_frames{};
      ExternalBeginFrameControllerClient_SetNeedsBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_needs_begin_frames = input_data_view.needs_begin_frames();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExternalBeginFrameControllerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsBeginFrame(        
        std::move(p_needs_begin_frames));
      return true;
    }
    case messages::ExternalBeginFrameControllerClient::kSetPreferredInterval: {
      DCHECK(message->is_serialized());
      internal::ExternalBeginFrameControllerClient_SetPreferredInterval_Params_Data* params =
          reinterpret_cast<internal::ExternalBeginFrameControllerClient_SetPreferredInterval_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExternalBeginFrameControllerClient.1
      bool success = true;
      ::base::TimeDelta p_interval{};
      ExternalBeginFrameControllerClient_SetPreferredInterval_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInterval(&p_interval))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExternalBeginFrameControllerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPreferredInterval(        
        std::move(p_interval));
      return true;
    }
  }
  return false;
}

// static
bool ExternalBeginFrameControllerClientStubDispatch::AcceptWithResponder(
    ExternalBeginFrameControllerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ExternalBeginFrameControllerClient>(message->header()->name)) {
    case messages::ExternalBeginFrameControllerClient::kSetNeedsBeginFrame: {
      break;
    }
    case messages::ExternalBeginFrameControllerClient::kSetPreferredInterval: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kExternalBeginFrameControllerClientValidationInfo[] = {
    { &internal::ExternalBeginFrameControllerClient_SetNeedsBeginFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ExternalBeginFrameControllerClient_SetPreferredInterval_Params_Data::Validate,
     nullptr /* no response */},
};

bool ExternalBeginFrameControllerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::ExternalBeginFrameControllerClient::Name_,
    kExternalBeginFrameControllerClientValidationInfo);
}



}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void ExternalBeginFrameControllerInterceptorForTesting::IssueExternalBeginFrame(const ::viz::BeginFrameArgs& args, bool force, IssueExternalBeginFrameCallback callback) {
  GetForwardingInterface()->IssueExternalBeginFrame(
    std::move(args)
    , 
    std::move(force)
    , std::move(callback));
}
ExternalBeginFrameControllerAsyncWaiter::ExternalBeginFrameControllerAsyncWaiter(
    ExternalBeginFrameController* proxy) : proxy_(proxy) {}

ExternalBeginFrameControllerAsyncWaiter::~ExternalBeginFrameControllerAsyncWaiter() = default;


void ExternalBeginFrameControllerAsyncWaiter::IssueExternalBeginFrame(
    const ::viz::BeginFrameArgs& args, bool force, ::viz::BeginFrameAck* out_ack) {
  base::RunLoop loop;
  proxy_->IssueExternalBeginFrame(
      std::move(args),
      std::move(force),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::viz::BeginFrameAck* out_ack
,
             const ::viz::BeginFrameAck& ack) {*out_ack = std::move(ack);
            loop->Quit();
          },
          &loop,
          out_ack));
  loop.Run();
}

::viz::BeginFrameAck ExternalBeginFrameControllerAsyncWaiter::IssueExternalBeginFrame(
    const ::viz::BeginFrameArgs& args, bool force) {
  ::viz::BeginFrameAck async_wait_result;
  IssueExternalBeginFrame(std::move(args),std::move(force),&async_wait_result);
  return async_wait_result;
}




void ExternalBeginFrameControllerClientInterceptorForTesting::SetNeedsBeginFrame(bool needs_begin_frames) {
  GetForwardingInterface()->SetNeedsBeginFrame(
    std::move(needs_begin_frames)
    );
}
void ExternalBeginFrameControllerClientInterceptorForTesting::SetPreferredInterval(::base::TimeDelta interval) {
  GetForwardingInterface()->SetPreferredInterval(
    std::move(interval)
    );
}
ExternalBeginFrameControllerClientAsyncWaiter::ExternalBeginFrameControllerClientAsyncWaiter(
    ExternalBeginFrameControllerClient* proxy) : proxy_(proxy) {}

ExternalBeginFrameControllerClientAsyncWaiter::~ExternalBeginFrameControllerClientAsyncWaiter() = default;







}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif