// services/tracing/public/mojom/system_tracing_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_SYSTEM_TRACING_SERVICE_MOJOM_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_SYSTEM_TRACING_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/tracing/public/mojom/system_tracing_service.mojom-features.h"  // IWYU pragma: export
#include "services/tracing/public/mojom/system_tracing_service.mojom-shared.h"  // IWYU pragma: export
#include "services/tracing/public/mojom/system_tracing_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"




namespace tracing::mojom {

class SystemTracingServiceProxy;

template <typename ImplRefTraits>
class SystemTracingServiceStub;

class SystemTracingServiceRequestValidator;
class SystemTracingServiceResponseValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) SystemTracingService
    : public SystemTracingServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracing.mojom.SystemTracingService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SystemTracingServiceInterfaceBase;
  using Proxy_ = SystemTracingServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SystemTracingServiceStub<ImplRefTraits>;

  using RequestValidator_ = SystemTracingServiceRequestValidator;
  using ResponseValidator_ = SystemTracingServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOpenProducerSocketMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OpenProducerSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SystemTracingService() = default;

  using OpenProducerSocketCallback = base::OnceCallback<void(::base::File)>;
  using OpenProducerSocketMojoCallback = base::OnceCallback<void(::base::File)>;

  virtual void OpenProducerSocket(OpenProducerSocketCallback callback) = 0;
};



class COMPONENT_EXPORT(TRACING_MOJOM) SystemTracingServiceProxy
    : public SystemTracingService {
 public:
  using InterfaceType = SystemTracingService;

  explicit SystemTracingServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OpenProducerSocket(OpenProducerSocketCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) SystemTracingServiceStubDispatch {
 public:
  static bool Accept(SystemTracingService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SystemTracingService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SystemTracingService>>
class SystemTracingServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SystemTracingServiceStub() = default;
  ~SystemTracingServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SystemTracingServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SystemTracingServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) SystemTracingServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) SystemTracingServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // tracing::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_SYSTEM_TRACING_SERVICE_MOJOM_H_