// services/tracing/public/mojom/perfetto_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "services/tracing/public/mojom/perfetto_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"

#include "services/tracing/public/mojom/perfetto_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::tracing::mojom::ConsoleOutput, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::tracing::mojom::BufferFillPolicy, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::tracing::mojom::TracingClientPriority, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::ChunksToMoveDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ChunksToMoveDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ChunksToMove_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->page = Traits::page(input);

      fragment->chunk = Traits::chunk(input);

      fragment->target_buffer = Traits::target_buffer(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::ChunkPatchDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ChunkPatchDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ChunkPatch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->offset = Traits::offset(input);

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType> data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_data,
        data_fragment);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in ChunkPatch struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::ChunksToPatchDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ChunksToPatchDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ChunksToPatch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->target_buffer = Traits::target_buffer(input);

      fragment->writer_id = Traits::writer_id(input);

      fragment->chunk_id = Traits::chunk_id(input);

      decltype(Traits::patches(input)) in_patches = Traits::patches(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->patches)::BaseType>
          patches_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& patches_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::ChunkPatchDataView>, send_validation>(
        in_patches,
        patches_fragment,
        &patches_validate_params);

      fragment->patches.Set(
          patches_fragment.is_null() ? nullptr : patches_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->patches.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null patches in ChunksToPatch struct");

      fragment->has_more_patches = Traits::has_more_patches(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::CommitDataRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::CommitDataRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::CommitDataRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::chunks_to_move(input)) in_chunks_to_move = Traits::chunks_to_move(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->chunks_to_move)::BaseType>
          chunks_to_move_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& chunks_to_move_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::ChunksToMoveDataView>, send_validation>(
        in_chunks_to_move,
        chunks_to_move_fragment,
        &chunks_to_move_validate_params);

      fragment->chunks_to_move.Set(
          chunks_to_move_fragment.is_null() ? nullptr : chunks_to_move_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->chunks_to_move.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null chunks_to_move in CommitDataRequest struct");

      decltype(Traits::chunks_to_patch(input)) in_chunks_to_patch = Traits::chunks_to_patch(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->chunks_to_patch)::BaseType>
          chunks_to_patch_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& chunks_to_patch_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::ChunksToPatchDataView>, send_validation>(
        in_chunks_to_patch,
        chunks_to_patch_fragment,
        &chunks_to_patch_validate_params);

      fragment->chunks_to_patch.Set(
          chunks_to_patch_fragment.is_null() ? nullptr : chunks_to_patch_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->chunks_to_patch.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null chunks_to_patch in CommitDataRequest struct");

      fragment->flush_request_id = Traits::flush_request_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::ChromeConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ChromeConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ChromeConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::trace_config(input)) in_trace_config = Traits::trace_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trace_config)::BaseType> trace_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_trace_config,
        trace_config_fragment);

      fragment->trace_config.Set(
          trace_config_fragment.is_null() ? nullptr : trace_config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->trace_config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trace_config in ChromeConfig struct");

      fragment->privacy_filtering_enabled = Traits::privacy_filtering_enabled(input);

      fragment->convert_to_legacy_json = Traits::convert_to_legacy_json(input);

      fragment->event_package_name_filter_enabled = Traits::event_package_name_filter_enabled(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::ConsoleConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ConsoleConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ConsoleConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::tracing::mojom::ConsoleOutput>(
        Traits::output(input),
        &fragment->output);

      fragment->enable_colors = Traits::enable_colors(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::InterceptorConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::InterceptorConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::InterceptorConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in InterceptorConfig struct");

      decltype(Traits::console_config(input)) in_console_config = Traits::console_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->console_config)::BaseType> console_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tracing::mojom::ConsoleConfigDataView, send_validation>(
        in_console_config,
        console_config_fragment);

      fragment->console_config.Set(
          console_config_fragment.is_null() ? nullptr : console_config_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::DataSourceConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::DataSourceConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::DataSourceConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in DataSourceConfig struct");

      fragment->target_buffer = Traits::target_buffer(input);

      fragment->trace_duration_ms = Traits::trace_duration_ms(input);

      fragment->tracing_session_id = Traits::tracing_session_id(input);

      decltype(Traits::chrome_config(input)) in_chrome_config = Traits::chrome_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->chrome_config)::BaseType> chrome_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tracing::mojom::ChromeConfigDataView, send_validation>(
        in_chrome_config,
        chrome_config_fragment);

      fragment->chrome_config.Set(
          chrome_config_fragment.is_null() ? nullptr : chrome_config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->chrome_config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null chrome_config in DataSourceConfig struct");

      decltype(Traits::interceptor_config(input)) in_interceptor_config = Traits::interceptor_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->interceptor_config)::BaseType> interceptor_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tracing::mojom::InterceptorConfigDataView, send_validation>(
        in_interceptor_config,
        interceptor_config_fragment);

      fragment->interceptor_config.Set(
          interceptor_config_fragment.is_null() ? nullptr : interceptor_config_fragment.data());

      decltype(Traits::legacy_config(input)) in_legacy_config = Traits::legacy_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->legacy_config)::BaseType> legacy_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_legacy_config,
        legacy_config_fragment);

      fragment->legacy_config.Set(
          legacy_config_fragment.is_null() ? nullptr : legacy_config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->legacy_config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null legacy_config in DataSourceConfig struct");

      decltype(Traits::track_event_config_raw(input)) in_track_event_config_raw = Traits::track_event_config_raw(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->track_event_config_raw)::BaseType> track_event_config_raw_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_track_event_config_raw,
        track_event_config_raw_fragment);

      fragment->track_event_config_raw.Set(
          track_event_config_raw_fragment.is_null() ? nullptr : track_event_config_raw_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->track_event_config_raw.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null track_event_config_raw in DataSourceConfig struct");

      decltype(Traits::etw_config_raw(input)) in_etw_config_raw = Traits::etw_config_raw(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->etw_config_raw)::BaseType> etw_config_raw_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_etw_config_raw,
        etw_config_raw_fragment);

      fragment->etw_config_raw.Set(
          etw_config_raw_fragment.is_null() ? nullptr : etw_config_raw_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->etw_config_raw.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null etw_config_raw in DataSourceConfig struct");

      decltype(Traits::system_metrics_config_raw(input)) in_system_metrics_config_raw = Traits::system_metrics_config_raw(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->system_metrics_config_raw)::BaseType> system_metrics_config_raw_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_system_metrics_config_raw,
        system_metrics_config_raw_fragment);

      fragment->system_metrics_config_raw.Set(
          system_metrics_config_raw_fragment.is_null() ? nullptr : system_metrics_config_raw_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->system_metrics_config_raw.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null system_metrics_config_raw in DataSourceConfig struct");

      decltype(Traits::histogram_samples_config_raw(input)) in_histogram_samples_config_raw = Traits::histogram_samples_config_raw(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->histogram_samples_config_raw)::BaseType> histogram_samples_config_raw_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_histogram_samples_config_raw,
        histogram_samples_config_raw_fragment);

      fragment->histogram_samples_config_raw.Set(
          histogram_samples_config_raw_fragment.is_null() ? nullptr : histogram_samples_config_raw_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->histogram_samples_config_raw.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null histogram_samples_config_raw in DataSourceConfig struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::DataSourceRegistrationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::DataSourceRegistrationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::DataSourceRegistration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in DataSourceRegistration struct");

      fragment->id = Traits::id(input);

      fragment->will_notify_on_start = Traits::will_notify_on_start(input);

      fragment->will_notify_on_stop = Traits::will_notify_on_stop(input);

      fragment->handles_incremental_state_clear = Traits::handles_incremental_state_clear(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::BufferConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::BufferConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::BufferConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->size_kb = Traits::size_kb(input);

      
      mojo::internal::Serialize<::tracing::mojom::BufferFillPolicy>(
        Traits::fill_policy(input),
        &fragment->fill_policy);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::DataSourceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::DataSourceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::DataSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::config(input)) in_config = Traits::config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->config)::BaseType> config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tracing::mojom::DataSourceConfigDataView, send_validation>(
        in_config,
        config_fragment);

      fragment->config.Set(
          config_fragment.is_null() ? nullptr : config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null config in DataSource struct");

      decltype(Traits::producer_name_filter(input)) in_producer_name_filter = Traits::producer_name_filter(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->producer_name_filter)::BaseType>
          producer_name_filter_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& producer_name_filter_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_producer_name_filter,
        producer_name_filter_fragment,
        &producer_name_filter_validate_params);

      fragment->producer_name_filter.Set(
          producer_name_filter_fragment.is_null() ? nullptr : producer_name_filter_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->producer_name_filter.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null producer_name_filter in DataSource struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::PerfettoBuiltinDataSourceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::PerfettoBuiltinDataSourceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::PerfettoBuiltinDataSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->disable_clock_snapshotting = Traits::disable_clock_snapshotting(input);

      fragment->disable_trace_config = Traits::disable_trace_config(input);

      fragment->disable_system_info = Traits::disable_system_info(input);

      fragment->disable_service_events = Traits::disable_service_events(input);

      fragment->primary_trace_clock_id = Traits::primary_trace_clock_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::IncrementalStateConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::IncrementalStateConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::IncrementalStateConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->clear_period_ms = Traits::clear_period_ms(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::tracing::mojom::TraceConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::TraceConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::TraceConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data_sources(input)) in_data_sources = Traits::data_sources(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data_sources)::BaseType>
          data_sources_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& data_sources_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::DataSourceDataView>, send_validation>(
        in_data_sources,
        data_sources_fragment,
        &data_sources_validate_params);

      fragment->data_sources.Set(
          data_sources_fragment.is_null() ? nullptr : data_sources_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data_sources.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data_sources in TraceConfig struct");

      decltype(Traits::perfetto_builtin_data_source(input)) in_perfetto_builtin_data_source = Traits::perfetto_builtin_data_source(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->perfetto_builtin_data_source)::BaseType> perfetto_builtin_data_source_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tracing::mojom::PerfettoBuiltinDataSourceDataView, send_validation>(
        in_perfetto_builtin_data_source,
        perfetto_builtin_data_source_fragment);

      fragment->perfetto_builtin_data_source.Set(
          perfetto_builtin_data_source_fragment.is_null() ? nullptr : perfetto_builtin_data_source_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->perfetto_builtin_data_source.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null perfetto_builtin_data_source in TraceConfig struct");

      decltype(Traits::buffers(input)) in_buffers = Traits::buffers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->buffers)::BaseType>
          buffers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& buffers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::tracing::mojom::BufferConfigDataView>, send_validation>(
        in_buffers,
        buffers_fragment,
        &buffers_validate_params);

      fragment->buffers.Set(
          buffers_fragment.is_null() ? nullptr : buffers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->buffers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buffers in TraceConfig struct");

      decltype(Traits::incremental_state_config(input)) in_incremental_state_config = Traits::incremental_state_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->incremental_state_config)::BaseType> incremental_state_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::tracing::mojom::IncrementalStateConfigDataView, send_validation>(
        in_incremental_state_config,
        incremental_state_config_fragment);

      fragment->incremental_state_config.Set(
          incremental_state_config_fragment.is_null() ? nullptr : incremental_state_config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->incremental_state_config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null incremental_state_config in TraceConfig struct");

      fragment->duration_ms = Traits::duration_ms(input);

      fragment->write_into_file = Traits::write_into_file(input);

      decltype(Traits::trace_uuid(input)) in_trace_uuid = Traits::trace_uuid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trace_uuid)::BaseType> trace_uuid_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TokenDataView, send_validation>(
        in_trace_uuid,
        trace_uuid_fragment);

      fragment->trace_uuid.Set(
          trace_uuid_fragment.is_null() ? nullptr : trace_uuid_fragment.data());

      decltype(Traits::unique_session_name(input)) in_unique_session_name = Traits::unique_session_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->unique_session_name)::BaseType> unique_session_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_unique_session_name,
        unique_session_name_fragment);

      fragment->unique_session_name.Set(
          unique_session_name_fragment.is_null() ? nullptr : unique_session_name_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_SEND_VALIDATION_H_